CONTAINER NoiseTexture
{
    NAME NoiseTexture;
    INCLUDE Mbase;

    GROUP NOISE_SHADER_GRP
    {
        OPEN; DEFAULT 1;
        LONG NOISE_TYPE
        {
            CYCLE
            {
                NOISE_TYPE_PERLIN;
                NOISE_TYPE_TURB;
                NOISE_TYPE_CIRC;
                NOISE_TYPE_CHIPS;
            }
        }

        //----------------------------------------------------------------
        REAL NOISE_OCTAVES {  MIN 1; STEP 1; MAX 16;  CUSTOMGUI OCTNSLIDER; }

        //----------------------------------------------------------------
        REAL    NOISE_OMEGA_FLOAT   { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }

        BOOL 	NOISE_INVERT   {}

        REAL    NOISE_GAMMA    {CUSTOMGUI OCTNSLIDER;  LOGARITMIC 1;  MIN 0.01; STEP 0.01; MAX 100.0; MINSLIDER 0.01; MAXSLIDER 100; }
        REAL    NOISE_CONTRAST  {CUSTOMGUI OCTNSLIDER; LOGARITMIC 1;  MIN 0.001; STEP 0.01; MAXSLIDER 100; MAX 1000;  }

        BUTTON  NOISE_TRANSFORM_BTN {}
        LINK    NOISE_TRANSFORM_LINK { ACCEPT { Transform; }  OPEN; }

        BUTTON  NOISE_PROJECTION_BTN {}
        LINK    NOISE_PROJECTION_LINK { ACCEPT { TextureProjection; }  OPEN; }
    }
}
