/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.sqlHelper.utils;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class SqlUtils {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${spring.database.type}")
    String database;
    @Value(value="${spring.database.package}")
    String packageName;
    @Value(value="${spring.database.print:false}")
    Boolean print;
    @Autowired
    JdbcTemplate jdbcTemplate;
    String separator = System.getProperty("line.separator");

    public String formatSql(String sql) {
        if (StrUtil.isEmpty((CharSequence)sql)) {
            return "";
        }
        if (!this.database.equalsIgnoreCase("mysql")) {
            sql = sql.replace("`", "\"");
        }
        String tab = "\t";
        sql = sql.replace("FROM", this.separator + "FROM").replace("WHERE", this.separator + "WHERE").replace("ORDER", this.separator + "ORDER").replace("LEFT", this.separator + "LEFT").replace("LIMIT", this.separator + "LIMIT").replace("AND", this.separator + tab + "AND").replace("VALUES", this.separator + "VALUES");
        return sql;
    }

    public void checkOrCreateTable(Class<?> clazz) {
        String sql = "CREATE TABLE IF NOT EXISTS `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "` (id VARCHAR(32) NOT NULL PRIMARY KEY)";
        this.logQuery(this.formatSql(sql));
        this.jdbcTemplate.execute(this.formatSql(sql));
    }

    public void logQuery(String sql) {
        this.logQuery(sql, null);
    }

    public void logQuery(String sql, Object[] params) {
        if (this.print.booleanValue()) {
            try {
                if (params != null) {
                    for (Object object : params) {
                        if (object instanceof String) {
                            object = object.toString().replace("$", "RDS_CHAR_DOLLAR");
                            sql = sql.replaceFirst("\\?", "'" + object + "'").replace("RDS_CHAR_DOLLAR", "$");
                            continue;
                        }
                        sql = sql.replaceFirst("\\?", String.valueOf(object));
                    }
                }
                this.logger.info(this.separator + sql);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void checkOrCreateIndex(Class<?> clazz, String name, boolean unique, List<Map<String, Object>> indexs) {
        this.checkOrCreateIndex(clazz, new String[]{name}, unique, indexs);
    }

    public void checkOrCreateIndex(Class<?> clazz, String[] colums, boolean unique, List<Map<String, Object>> indexs) {
        ArrayList<String> columList = new ArrayList<String>();
        for (String colum : colums) {
            columList.add(StrUtil.toUnderlineCase((CharSequence)colum));
        }
        String name = StrUtil.join((CharSequence)"&", (Object[])new Object[]{columList}) + "@" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName());
        Boolean hasIndex = false;
        for (Map<String, Object> map : indexs) {
            if (!StrUtil.toUnderlineCase((CharSequence)name).equalsIgnoreCase((String)map.get("name")) && !StrUtil.toUnderlineCase((CharSequence)name).equalsIgnoreCase((String)map.get("Key_name"))) continue;
            hasIndex = true;
        }
        if (!hasIndex.booleanValue()) {
            String type = unique ? "UNIQUE INDEX" : "INDEX";
            String length = "";
            if (this.database.equals("mysql")) {
                length = "(128)";
            }
            columList = new ArrayList();
            for (String colum : colums) {
                columList.add(StrUtil.toUnderlineCase((CharSequence)("`" + colum + "`" + length)));
            }
            String sql = "CREATE " + type + "  `" + StrUtil.toUnderlineCase((CharSequence)name) + "` ON `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`(" + StrUtil.join((CharSequence)",", (Object[])new Object[]{columList}) + ")";
            this.logQuery(this.formatSql(sql));
            this.jdbcTemplate.execute(this.formatSql(sql));
        }
    }

    public void checkOrCreateColumn(Class<?> clazz, String name, List<Map<String, Object>> columns) {
        Boolean hasColumn = false;
        for (Map<String, Object> map : columns) {
            if (!StrUtil.toUnderlineCase((CharSequence)name).equalsIgnoreCase((String)map.get("name")) && !StrUtil.toUnderlineCase((CharSequence)name).equalsIgnoreCase((String)map.get("Field"))) continue;
            hasColumn = true;
        }
        if (!hasColumn.booleanValue()) {
            String sql = "ALTER TABLE `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "` ADD COLUMN `" + StrUtil.toUnderlineCase((CharSequence)name) + "` TEXT";
            this.logQuery(this.formatSql(sql));
            this.jdbcTemplate.execute(this.formatSql(sql));
        }
    }

    public void updateDefaultValue(Class<?> clazz, String column, String value) {
        String sql = "SELECT COUNT(*) FROM " + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + " WHERE `" + StrUtil.toUnderlineCase((CharSequence)column) + "` IS NULL";
        this.logQuery(this.formatSql(sql));
        Long count = (Long)this.jdbcTemplate.queryForObject(this.formatSql(sql), Long.class);
        if (count > 0L) {
            sql = "UPDATE " + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + " SET `" + StrUtil.toUnderlineCase((CharSequence)column) + "` = ? WHERE `" + StrUtil.toUnderlineCase((CharSequence)column) + "` IS NULL";
            this.logQuery(this.formatSql(sql));
            this.jdbcTemplate.update(this.formatSql(sql), new Object[]{value});
        }
    }
}

