/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.sqlHelper.utils;

import cn.craccd.sqlHelper.config.CompositeIndex;
import cn.craccd.sqlHelper.config.InitValue;
import cn.craccd.sqlHelper.config.SingleIndex;
import cn.craccd.sqlHelper.config.Table;
import cn.craccd.sqlHelper.utils.SqlUtils;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

@Component
@EnableAsync
public class AsyncUtils {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${spring.database.type}")
    String database;
    @Value(value="${spring.database.package}")
    String packageName;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    SqlUtils sqlUtils;

    public void initTableSync(Class<?> clazz) {
        this.initTable(clazz);
    }

    @Async(value="sqlThreadPool")
    public void initTable(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table != null) {
            Field[] fields;
            this.sqlUtils.checkOrCreateTable(clazz);
            String sql = "";
            if (this.database.equals("sqlite")) {
                sql = "PRAGMA TABLE_INFO(`" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`)";
            } else if (this.database.equals("mysql")) {
                sql = "SHOW COLUMNS FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
            } else if (this.database.equals("postgresql")) {
                sql = "SELECT column_name as name FROM information_schema.columns WHERE table_schema='public' AND table_name='" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "'";
            }
            this.sqlUtils.logQuery(this.sqlUtils.formatSql(sql));
            List columns = this.jdbcTemplate.queryForList(this.sqlUtils.formatSql(sql));
            if (this.database.equals("sqlite")) {
                sql = "PRAGMA INDEX_LIST(`" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`)";
            } else if (this.database.equals("mysql")) {
                sql = "SHOW INDEX FROM `" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "`";
            } else if (this.database.equals("postgresql")) {
                sql = "SELECT A.INDEXNAME as name FROM PG_AM B LEFT JOIN PG_CLASS F ON B.OID = F.RELAM LEFT JOIN PG_STAT_ALL_INDEXES E ON F.OID = E.INDEXRELID LEFT JOIN PG_INDEX C ON E.INDEXRELID = C.INDEXRELID LEFT OUTER JOIN PG_DESCRIPTION D ON C.INDEXRELID = D.OBJOID, PG_INDEXES A WHERE A.SCHEMANAME = E.SCHEMANAME AND A.TABLENAME = E.RELNAME AND A.INDEXNAME = E.INDEXRELNAME AND E.SCHEMANAME = 'public' AND E.RELNAME = '" + StrUtil.toUnderlineCase((CharSequence)clazz.getSimpleName()) + "' ";
            }
            this.sqlUtils.logQuery(this.sqlUtils.formatSql(sql));
            List indexs = this.jdbcTemplate.queryForList(this.sqlUtils.formatSql(sql));
            for (Field field : fields = ReflectUtil.getFields(clazz)) {
                InitValue defaultValue;
                if (!field.getName().equals("id")) {
                    this.sqlUtils.checkOrCreateColumn(clazz, field.getName(), columns);
                }
                if (field.isAnnotationPresent(SingleIndex.class)) {
                    SingleIndex singleIndex = field.getAnnotation(SingleIndex.class);
                    this.sqlUtils.checkOrCreateIndex(clazz, field.getName(), singleIndex.unique(), (List<Map<String, Object>>)indexs);
                }
                if (!field.isAnnotationPresent(InitValue.class) || (defaultValue = field.getAnnotation(InitValue.class)).value() == null) continue;
                this.sqlUtils.updateDefaultValue(clazz, field.getName(), defaultValue.value());
            }
            if (clazz.isAnnotationPresent(CompositeIndex.class)) {
                CompositeIndex compositeIndex = clazz.getAnnotation(CompositeIndex.class);
                this.sqlUtils.checkOrCreateIndex(clazz, compositeIndex.colums(), compositeIndex.unique(), (List<Map<String, Object>>)indexs);
            }
        }
    }
}

