/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.sqlHelper.reflection;

import cn.craccd.sqlHelper.reflection.SerializableFunction;
import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ReflectionUtil {
    private static Map<SerializableFunction<?, ?>, Field> cache = new ConcurrentHashMap();

    public static <T, R> String getFieldName(SerializableFunction<T, R> function) {
        Field field = ReflectionUtil.getField(function);
        return field.getName();
    }

    public static Field getField(SerializableFunction<?, ?> function) {
        return cache.computeIfAbsent(function, ReflectionUtil::findField);
    }

    public static Field findField(SerializableFunction<?, ?> function) {
        Field field = null;
        String fieldName = null;
        try {
            Method method = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(function, new Object[0]);
            String implMethodName = serializedLambda.getImplMethodName();
            if (implMethodName.startsWith("get") && implMethodName.length() > 3) {
                fieldName = Introspector.decapitalize(implMethodName.substring(3));
            } else if (implMethodName.startsWith("is") && implMethodName.length() > 2) {
                fieldName = Introspector.decapitalize(implMethodName.substring(2));
            } else {
                if (implMethodName.startsWith("lambda$")) {
                    throw new IllegalArgumentException("SerializableFunction\u4e0d\u80fd\u4f20\u9012lambda\u8868\u8fbe\u5f0f,\u53ea\u80fd\u4f7f\u7528\u65b9\u6cd5\u5f15\u7528");
                }
                throw new IllegalArgumentException(implMethodName + "\u4e0d\u662fGetter\u65b9\u6cd5\u5f15\u7528");
            }
            String declaredClass = serializedLambda.getImplClass().replace("/", ".");
            Class<?> aClass = Class.forName(declaredClass, false, ClassUtils.getDefaultClassLoader());
            field = ReflectionUtils.findField(aClass, (String)fieldName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (field != null) {
            return field;
        }
        throw new NoSuchFieldError(fieldName);
    }
}

