local NameplateCCnTrinket = LibStub("AceAddon-3.0"):GetAddon("NameplateCCnTrinket")
local L = LibStub("AceLocale-3.0"):GetLocale("NameplateCCnTrinket")

local GetAddOnMetadata = GetAddOnMetadata

function NameplateCCnTrinket:Option()
	local AceConfig = {
		name = "NameplateCCnTrinket",
		type = "group",
		childGroups = "tab",
		plugins = { profiles = { profiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.Settings) } },
		args = {
			vers = {
				order = 1,
				type = "description",
				name = "|cffffd700" .. L["Version"] .. "|r " .. GetAddOnMetadata("NameplateCCnTrinket", "Version") .. "\n",
				cmdHidden = true
			},
			desc = {
				order = 2,
				type = "description",
				name = "|cffffd700 " .. L["Author"] .. "|r " .. GetAddOnMetadata("NameplateCCnTrinket", "Author") .. "\n",
				cmdHidden = true
			},
			Description = {
				type = "description",
				name = "|c00008000" .. L["/NCT\n/NameplateCCnTrinket\n"] .. "|r ",
				width = "full",
				order = 3,
			},
			test = {
				type = "execute",
				name = L["Test"],
				desc = L["Test Desc"],
				width = "normal",
				order = 4,
				func = "Test",
				handler = NameplateCCnTrinket,
			},
            sellib = {
                name = L["sellib"],
                desc = L["sellib Desc"],
                type = "select",
                width = "normal",
                order = 9,
                values = {
                    [1] = L["LibClassicDurations"],
                    [2] = L["DRList-1.0"],
                },
                set = function(_, val) self.Settings.profile.sellib = val end,
                get = function(_) return self.Settings.profile.sellib end
            },
			gSetting = {
				type = "group",
				name = "Settings",
				order = 5,
				set = function(info, val) self.Settings.profile.gSetting[info[#info]] = val end,
				get = function(info) return self.Settings.profile.gSetting[info[#info]] end,
				args = {
					ShowFriendlyPlayer = {
						type = "toggle",
						width = "normal",
						order = 1,
						name = L["Show Friendly Player"],
						desc = L["Show Friendly Player Desc"],						
					},
					CCCommonIcon = {
						type = "toggle",
						width = "normal",
						order = 2,
						name = L["CC Common Icon"],
						desc = L["CC Common Icon Desc"],
					},
					CCShowMonster = {
						type = "toggle",
						width = "normal",
						order = 3,
						name = L["CC Show Monster"],
						desc = L["CC Show Monster Desc"],
					},
					CurrentTime = {
						type = "toggle",
						width = "normal",
						order = 4,
						name = L["CurrentTime"],
						desc = L["CurrentTime Desc"],
					},
					CooldownSpiral = {
						type = "toggle",
						width = 2,
						order = 5,
						name = L["CooldownSpiral"],
						desc = L["CooldownSpiral Desc"],
					},
					FrameSize = {
						name = L["FrameSize"],
						desc = L["FrameSize Desc"],
						type = "range",
						width = "normal",
						order = 6,
						isPercent = false,
						min = 10,
						max = 40,
						step = 1,
					},
					LeftxOfs = {
						name = L["Left Frame X"],
						desc = L["Left X Desc"],
						type = "range",
						width = "normal",
						order = 7,
						isPercent = false,
						min = -40,
						max = 40,
						step = 1,
					},
					RightxOfs = {
						name = L["Right Frame X"],
						desc = L["Right X Desc"],
						type = "range",
						width = "normal",
						order = 8,
						isPercent = false,
						min = -40,
						max = 40,
						step = 1,
					},
					yOfs = {
						name = L["Y"],
						desc = L["Y Desc"],
						type = "range",
						width = "normal",
						order = 9,
						isPercent = false,
						min = -40,
						max = 40,
						step = 1,
					},
					TargetAlpha = {
						name = L["TargetAlpha"],
						desc = L["TargetAlpha Desc"],
						type = "range",
						width = "normal",
						order = 10,
						isPercent = true,
						min = 0,
						max = 1,
						step = 0.01,
					},
					OtherAlpha = {
						name = L["OtherAlpha"],
						desc = L["OtherAlpha Desc"],
						type = "range",
						width = "normal",
						order = 11,
						isPercent = true,
						min = 0,
						max = 1,
						step = 0.01,
					},
					OtherScale = {
						name = L["OtherScale"],
						desc = L["OtherScale Desc"],
						type = "range",
						width = "normal",
						order = 12,
						isPercent = true,
						min = 0.5,
						max = 1,
						step = 0.01,
					},				
				}
			},
			Func = {
				name = L["Function"],
				type = "group",
				order = 6,
				set = function(info, val) self.Settings.profile.Func[info[#info]] = val end,
				get = function(info) return self.Settings.profile.Func[info[#info]] end,
				args = {
					Interrupt = {
						type = "toggle",
						width = "normal",
						order = 1,
						name = L["Interrupt"],
						desc = L["Interrupt Desc"],
					},
					Racial = {
						type = "toggle",
						width = "normal",
						order = 2,
						name = L["Racial"],
						desc = L["Racial Desc"],
					},
					Trinket = {
						type = "toggle",
						width = "normal",
						order = 3,
						name = L["Trinket"],
						desc = L["Trinket Desc"],
					},
					CC = {
						type = "toggle",
						width = "normal",
						order = 4,
						name = L["CC"],
						desc = L["CC Desc"],
					},
					Dispel = {
						type = "toggle",
						width = "normal",
						order = 5,
						name = L["Dispel"],
						desc = L["Dispel Desc"],
					},
				},
			},
			Group = {
				name = L["Category"],
				type = "group",					
				order = 7,
				set = function(info, val) self.Settings.profile.Group[info[#info]] = val end,
				get = function(info) return self.Settings.profile.Group[info[#info]] end,
				args = {
					Description = {
						type = "description",
						name = L["Category Desc"],
						width = "full",
						order = 1,
					},
					FEAR = {
						type = "toggle",
						width = "normal",
						order = 2,
						name = L["FEAR"],
						desc = L["FEAR Desc"],
					},
					SILENCE = {
						type = "toggle",
						width = "normal",
						order = 3,
						name = L["SILENCE"],
						desc = L["SILENCE Desc"],
					},
					INCAP = {
						type = "toggle",
						width = "normal",
						order = 4,
						name = L["INCAP"],
						desc = L["INCAP Desc"],
					},
					STUN = {
						type = "toggle",
						width = "normal",
						order = 5,
						name = L["STUN"],
						desc = L["STUN Desc"],
					},
					HORROR = {
						type = "toggle",
						width = "normal",
						order = 6,
						name = L["HORROR"],
						desc = L["HORROR Desc"],
					},
					ROOT = {
						type = "toggle",
						width = "normal",
						order = 7,
						name = L["ROOT"],
						desc = L["ROOT Desc"],
					},
					OPENER_STUN = {
						type = "toggle",
						width = "normal",
						order = 8,
						name = L["OPENER_STUN"],
						desc = L["OPENER_STUN Desc"],
					},
					RANDOM_STUN = {
						type = "toggle",
						width = "normal",
						order = 9,
						name = L["RANDOM_STUN"],
						desc = L["RANDOM_STUN Desc"],
					},
					RANDOM_ROOT = {
						type = "toggle",
						width = "normal",
						order = 10,
						name = L["RANDOM_ROOT"],
						desc = L["RANDOM_ROOT Desc"],
					},
					FROST_SHOCK = {
						type = "toggle",
						width = "normal",
						order = 11,
						name = L["FROST_SHOCK"],
						desc = L["FROST_SHOCK Desc"],
					},
					KIDNEY_SHOT = {
						type = "toggle",
						width = "normal",
						order = 12,
						name = L["KIDNEY_SHOT"],
						desc = L["KIDNEY_SHOT Desc"],
					},
				},
			},
			DRLGroup = {
				name = L["DRLCategory"],
				type = "group",
				order = 8,
				set = function(info, val) self.Settings.profile.DRLGroup[info[#info]] = val end,
				get = function(info) return self.Settings.profile.DRLGroup[info[#info]] end,
				args = {
					Description = {
						type = "description",
						name = L["DRLCategory Desc"],
						width = "full",
						order = 1,
					},
					incapacitate = {
						type = "toggle",
						width = "normal",
						order = 2,
						name = L["incapacitate"],
						desc = L["incapacitate Desc"],
					},
					silence = {
						type = "toggle",
						width = "normal",
						order = 3,
						name = L["silence"],
						desc = L["silence Desc"],
					},
					stun = {
						type = "toggle",
						width = "normal",
						order = 4,
						name = L["stun"],
						desc = L["stun Desc"],
					},
					root = {
						type = "toggle",
						width = "normal",
						order = 5,
						name = L["root"],
						desc = L["root Desc"],
					},
					disarm = {
						type = "toggle",
						width = "normal",
						order = 6,
						name = L["disarm"],
						desc = L["disarm Desc"],
					},
					opener_stun = {
						type = "toggle",
						width = "normal",
						order = 7,
						name = L["opener_stun"],
						desc = L["opener_stun Desc"],
					},
					random_stun = {
						type = "toggle",
						width = "normal",
						order = 8,
						name = L["random_stun"],
						desc = L["random_stun Desc"],
					},
					random_root = {
						type = "toggle",
						width = "normal",
						order = 9,
						name = L["random_root"],
						desc = L["random_root Desc"],
					},
					fear = {
						type = "toggle",
						width = "normal",
						order = 10,
						name = L["fear"],
						desc = L["fear Desc"],
					},
					death_coil = {
						type = "toggle",
						width = "normal",
						order = 11,
						name = L["death_coil"],
						desc = L["death_coil Desc"],
					},
					mind_control = {
						type = "toggle",
						width = "normal",
						order = 12,
						name = L["mind_control"],
						desc = L["mind_control Desc"],
					},
					frost_shock = {
						type = "toggle",
						width = "normal",
						order = 13,
						name = L["frost_shock"],
						desc = L["frost_shock Desc"],
					},
					entrapment = {
						type = "toggle",
						width = "normal",
						order = 14,
						name = L["entrapment"],
						desc = L["entrapment Desc"],
					},
					charge = {
						type = "toggle",
						width = "normal",
						order = 15,
						name = L["charge"],
						desc = L["charge Desc"],
					},
					kidney_shot = {
						type = "toggle",
						width = "normal",
						order = 16,
						name = L["kidney_shot"],
						desc = L["kidney_shot Desc"],
					},
				},
			},
		}
	}
	
	LibStub("AceConfig-3.0"):RegisterOptionsTable("NameplateCCnTrinket", AceConfig)
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("NameplateCCnTrinket", "NameplateCCnTrinket")
end