<div class="line" id="{{$id}}">
    <div class="label">
        {{$label}}:
    </div>
    <div class="field">
        <input type="hidden"
               {{$readonly?'readonly':''}}
               class="form"
               name="{{$name}}"
               placeholder="{{$placeholder}}"
               value="{{$value}}"/>
        <div id="{{$name}}Selector" class="ub-image-selector @if(!empty($value)) has-value @endif">
            <div class="tools">
                <a href="javascript:;" class="action close" data-close><i class="iconfont icon-close"></i></a>
                <a href="javascript:;" class="action preview" data-preview><i class="iconfont icon-eye1"></i></a>
                <a href="javascript:;" class="action add" data-add><i class="iconfont icon-plus1"></i></a>
            </div>
            @if(!empty($value))
                <div class="cover ub-cover-1-1 contain" style="background-image:url({{$value}});"></div>
            @else
                <div class="cover ub-cover-1-1 contain"
                     style="background-image:url(@asset('asset/image/none.png'));"></div>
            @endif
        </div>
        @if(!empty($help))
            <div class="help">{!! $help !!}</div>
        @endif
    </div>
</div>
<script>
    $(function () {
        var $field = $('#{{$id}}');
        var $selector = $('#{{$name}}Selector');
        $selector.find('.tools .add').on('click', function () {
            window.__selectorDialog = new window.api.selectorDialog({
                server: '{{$server}}/image',
                callback: function (items) {
                    if (items.length > 0) {
                        $field.find('[name="{{$name}}"]').val(items[0].path);
                        $selector.find('.cover').css('backgroundImage', "url(" + items[0].path + ")");
                        $selector.addClass('has-value');
                    }
                }
            }).show();
        });
        $selector.find('.tools .close').on('click', function () {
            $field.find('[name="{{$name}}"]').val('');
            $selector.find('.cover').css('backgroundImage', "url(@asset('asset/image/none.png'))");
            $selector.removeClass('has-value');
        });
        $selector.find('.tools .preview').on('click', function () {
            window.api.dialog.preview($field.find('[name="{{$name}}"]').val());
        });
    });
</script>