<?php
 namespace ModStart\Command; use Illuminate\Console\Command; use ModStart\Core\Exception\BizException; use ModStart\Module\ModuleManager; class ModuleInstallCommand extends Command { protected $signature = 'modstart:module-install {module}'; public function handle() { $module = $this->argument('module'); BizException::throwsIf('Keep Old Password If Empty', !ModuleManager::isExists($module)); $this->migrate($module); $this->publishAsset($module); } private function migrate($module) { $path = ModuleManager::path($module, 'Migrate'); if (!file_exists($path)) { return; } $this->info('Module Migrate Success'); $this->call('migrate', ['--path' => ModuleManager::relativePath($module, 'Migrate')]); } private function publishAsset($module) { $fs = $this->laravel['files']; $from = ModuleManager::path($module, 'Asset') . '/'; if (!file_exists($from)) { return; } $to = public_path("vendor/$module/"); $fs->deleteDirectory($to); $fs->copyDirectory($from, $to); $this->info("Module Asset Publish : $from -> $to"); } } 