<?php
 namespace Module\ShortLink\Util; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\Response; use ModStart\Core\Util\NumberUtil; class LinkUtil { public static function delete($id) { ModelUtil::transactionBegin(); ModelUtil::delete('link', $id); ModelUtil::delete('link_dashboard', ['linkId' => $id]); ModelUtil::delete('link_visit_hourly_report', ['linkId' => $id]); ModelUtil::delete('link_visit', ['linkId' => $id]); ModelUtil::transactionCommit(); } public static function getByD62Id($linkId) { $id = @NumberUtil::d62ToDec($linkId); if (empty($id)) { return $id; } return ModelUtil::get('link', $id); } public static function parseNumFromUrl($shortUrl) { if (preg_match('/https?:.*?\\/s([a-zA-Z0-9]+)$/', $shortUrl, $mat)) { return @NumberUtil::d62ToDec($mat[1]); } return 0; } public static function combileLink($urlBase, $num) { $idD62 = NumberUtil::decToD62($num); return $urlBase . '/s' . $idD62; } public static function isExpire($link) { if (empty($link['expire'])) { return false; } if ($link['expire'] > time()) { return false; } return true; } public static function generate($memberUserId, $urlBase, $url, $minutes = 0) { if (strlen($url) > 400) { return Response::generateError('链接最大长度为400'); } $expire = 0; if ($minutes > 0) { $expire = time() + $minutes * 60; } for ($i = 0; $i < 100; $i++) { $num = intval(microtime(true) * 1000) . '' . rand(10, 99); $idD62 = NumberUtil::decToD62($num); $data = [ 'id' => $num, 'memberUserId' => $memberUserId, 'urlBase' => $urlBase, 'url' => $url, 'expire' => $expire, ]; try { ModelUtil::insert('link', $data); $data['_link'] = $urlBase . '/s' . $idD62; return Response::generateSuccessData($data); } catch (\Exception $e) { } } return Response::generateError('生成出现错误'); } }