<?php
 namespace Module\Member\Api\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Facades\Session; use Illuminate\Support\Facades\View; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use Module\Member\Auth\MemberUser; use Module\Member\Auth\MemberVip; use Module\Member\Constant\PayConstant; use Module\Member\Support\MemberLoginCheck; use Module\Member\Util\MemberVipUtil; use Module\Shop\Type\OrderStatus; use Module\Vendor\Oauth\OauthType; use Module\Vendor\Pay\Type\PayType; use Module\Vendor\Pay\Util\PayOrderUtil; use Module\Vendor\Pay\Util\PayUtil; class MemberVipController extends Controller implements MemberLoginCheck { public function all() { return Response::generateSuccessData(MemberVipUtil::all()); } public function buy() { $input = InputPackage::buildFromInput(); $payType = $input->getType('payType', PayType::class, null); $vipId = $input->getInteger('vipId'); if (empty($payType)) { return Response::generateError('支付方式错误'); } if (!PayUtil::isPayEnable($payType)) { return Response::generateError('支付方式未开启'); } if (empty($vipId)) { return Response::generateError('请选择会员类型'); } $memberVip = MemberVipUtil::get($vipId); if (empty($memberVip)) { return Response::generateError('请选择会员类型'); } $priceInfoRet = $this->calc($vipId); if ($priceInfoRet['code']) { return Response::generateError($priceInfoRet['msg']); } $money = $priceInfoRet['data']['price']; if ($money < 0.01) { return Response::generateError('支付金额为空0.01'); } $memberVipOrder = ModelUtil::insert('member_vip_order', [ 'status' => OrderStatus::WAIT_PAY, 'memberUserId' => MemberUser::id(), 'vipId' => $memberVip['id'], 'payFee' => $money, 'expire' => $priceInfoRet['data']['expire'], 'type' => $priceInfoRet['data']['type'], ]); switch ($payType) { case PayType::ALIPAY: $ret = PayOrderUtil::create( PayConstant::MEMBER_VIP, $memberVipOrder['id'], $payType, $memberVipOrder['payFee'], '开通会员-' . $memberVipOrder['id'], '开通会员-' . $memberVipOrder['id'], '/member/vip', ['alipay_wap' => AgentUtil::isMobile() ? true : false] ); if ($ret['code']) { return Response::generateError($ret['msg']); } $data['payRedirect'] = $ret['data']['link']; $data['successRedirect'] = '/member_vip'; return Response::generateSuccessData($data); case PayType::WECHAT_MOBILE: $openId = Session::get('oauthViewOpenId_' . OauthType::WECHAT_MOBILE); if (empty($openId)) { Session::put('autoClickPayType', PayType::WECHAT_MOBILE); return Response::generate( -1, null, null, '/oauth_login_' . OauthType::WECHAT_MOBILE . '?view=true&redirect=' . urlencode(Request::currentPageUrl()) ); } $ret = PayOrderUtil::create( PayConstant::MEMBER_VIP, $memberVipOrder['id'], $payType, $memberVipOrder['payFee'], '开通会员-' . $memberVipOrder['id'], '开通会员-' . $memberVipOrder['id'], '/member/vip', ['openId' => $openId] ); if ($ret['code']) { return Response::generateError($ret['msg']); } $data['json'] = $ret['data']['json']; $data['successRedirect'] = $ret['data']['successRedirect']; return Response::generateSuccessData($data); case PayType::WECHAT: $ret = PayOrderUtil::create( PayConstant::MEMBER_VIP, $memberVipOrder['id'], $payType, $memberVipOrder['payFee'], '开通会员-' . $memberVipOrder['id'], '开通会员-' . $memberVipOrder['id'], '/member_vip', [] ); if ($ret['code']) { return Response::generateError($ret['msg']); } $data['codeUrl'] = $ret['data']['codeUrl']; $data['successRedirect'] = $ret['data']['successRedirect']; $data['watchUrl'] = '/member_vip/watch/' . $memberVipOrder['id']; return Response::generateSuccessData($data); } return Response::generateError('支付方式错误'); } public function calc($vipId = 0) { $input = InputPackage::buildFromInput(); $memberVip = MemberVip::get(); if (empty($vipId)) { $vipId = $input->getInteger('vipId'); } if (empty($vipId)) { return Response::generateError('请选择会员'); } $ret = MemberVipUtil::calcPrice($memberVip ? $memberVip['id'] : 0, MemberUser::get('vipExpire'), $vipId); if ($ret['code']) { return Response::generateError($ret['msg']); } return Response::generateSuccessData($ret['data']); } public function watch($id) { $order = ModelUtil::get('member_vip_order', ['id' => $id, 'memberUserId' => MemberUser::id()]); switch ($order['status']) { case OrderStatus::WAIT_PAY: return Response::generateSuccessData(['status' => 'new']); case OrderStatus::COMPLETED: return Response::generateSuccessData(['status' => 'payed']); case OrderStatus::CANCEL_EXPIRED: return Response::generateSuccessData(['status' => 'expired']); default: return Response::generateError('order status error'); } } }