

function setProxyIcon() {

    var icon = {
        path: "images/off.png",
    }

    chrome.proxy.settings.get(
                {'incognito': false},
        function(config) {
            if (config["value"]["mode"] == "system") {
                chrome.browserAction.setIcon(icon);
            } else if (config["value"]["mode"] == "direct") {
                chrome.browserAction.setIcon(icon);
            } else {
                icon["path"] = "images/on.png";
                chrome.browserAction.setIcon(icon);
            }
        }
    );
}

function gotoPage(url) {

    var fulurl = chrome.extension.getURL(url);
    chrome.tabs.getAllInWindow(undefined, function(tabs) {
        for (var i in tabs) {
            tab = tabs[i];
            if (tab.url == fulurl) {
                chrome.tabs.update(tab.id, { selected: true });
                return;
            }
        }
        chrome.tabs.getSelected(null, function(tab) {
                    chrome.tabs.create({url: url,index: tab.index + 1});
        });
    });
}

function callbackFn(details) {
    var proxySetting = JSON.parse(localStorage.proxySetting);

    if (proxySetting){
        var auth = proxySetting['auth'];
        var username = auth['user'];
        var password = auth['pass'];
    }

    if (proxySetting['auth']['user'] == '' && 
        proxySetting['auth']['pass'] == '')
        return {};

    return details.isProxy === !0 ? {
        authCredentials: {
            username: username,
            password: password
        }
    } : {}
}

chrome.webRequest.onAuthRequired.addListener(
            callbackFn,
            {urls: ["<all_urls>"]},
            ['blocking'] );

var proxySetting = {
    'pac_script_url' : {'http': '', 'https': '', 'file' : ''},
    'pac_type'   : 'file://',
    'http_host'  : '',
    'http_port'  : '',
    'https_host' : '',
    'https_port' : '',
    'socks_host' : '',
    'socks_port' : '',
    'socks_type' : 'socks5',
    'bypasslist' : '<local>,192.168.0.0/16,172.16.0.0/12,169.254.0.0/16,10.0.0.0/8',
    'proxy_rule' : 'singleProxy',
    'internal'   : '',
    'auth'       : {'enable': '', 'user': '', 'pass': ''}
}

var chinaList = ['*.cn', '*chdbits.org', '*bbercn.com', '*4shared.com', '*efeihu.com', '*wanzhongtuan.com', '*sdg-china.com', '*cbnweek.net', '*chinawutong.com', '*100ydy.com', '*24en.com', '*pinnawhite.com', '*77l.com', '*tuhigh.com', '*guomob.com', '*appifan.com', '*worlduc.com', '*tmall.com', '*admob.com', '*qhimg.com', '*7clink.com', '*baiduplayer-img.com', '*819nk.com', '*my7475.com', '*dvbbs.net', '*ddcdn.com', '*sinmert.com', '*hmyzs.com', '*wooyun.org', '*cqmmgo.com', '*beifabook.com', '*blizzard.com', '*131cc.com', '*bathome.net', '*aireader.com', '*i9.cc', '*chinaaet.com', '*168wap.com', '*nyt.com', '*ynesd.com', '*chinaoverseas.org', '*nbongostudio.com', '*ziling.com', '*happy001.com', '*immomo.com', '*zhongso.com', '*shmetro.com', '*alisoft.com', '*gkooo.com', '*weibusi.net', '*zhiziyun.com', '*293.net', '*tianpin.com', '*5vv.cc', '*1diancifa.com', '*hylae.com', '*eacha.com', '*mydigit.net', '*tanx.com', '*woshidazuiba.com', '*ittzz.com', '*ty028.com', '*meadin.com', '*taomoban.com', '*uu.cc', '*xiaoma.com', '*51043.com', '*ringierasia.com', '*nciyuan.com', '*uuyoyo.com', '*0817cg.com', '*lashou.com', '*nipic.com', '*symama.com', '*hotelindigo.com', '*cnfol.com', '*chinasspp.com', '*zombike.com', '*boyaa.com', '*dqdaily.com', '*leho.com', '*hb165.com', '*fuwumi.com', '*emuch.net', '*cdndm5.com', '*bitautoimg.com', '*meihua.info', '*kanbox.com', '*zhangziran.com', '*5d6d.org', '*woshao.com', '*guahao.com', '*lifevccdn.com', '*yiduimg.com', '*noblechinese.com', '*jobbole.net', '*69222.com', '*wunderlist.com', '*tiantian.com', '*pudn.com', '*menglu.com', '*360safe.com', '*ajinga.com', '*5ykj.com', '*pediy.com', '*xudiao.com', '*xvna.com', '*daxia.com', '*lequ.com', '*yupingxiaodi.com', '*buaamba.net', '*jie.pn', '*tieyou.com', '*in2west.com', '*appgz.com', '*778lm.com', '*jsqwfy.com', '*dnspod.com', '*techolics.com', '*carnoc.com', '*iliyu.com', '*7y7.com', '*vgooo.com', '*ctrmi.com', '*tuoke.com', '*ucfly.com', '*bailinsi.net', '*uume.com', '*suntix.com', '*biodiscover.com', '*107cine.com', '*36tr.com', '*wincn.com', '*img-cdn.info', '*bfimg.com', '*travelsky.com', '*laozuo.org', '*baobao88.com', '*sjx888.com', '*jxunicom.net', '*vafox.com', '*upaidui.com', '*wuyou.com', '*csdn.net', '*96911.com', '*shequla.com', '*guifabu.com', '*anzhuo.com', '*gaojie.com', '*bjqyg.com', '*afzhan.com', '*henhaoji.com', '*uiimg.com', '*qjwm.com', '*eidcenter.com', '*thn21.com', '*ktxp.com', '*booksky.org', '*dichan.com', '*5ichecker.com', '*chang-yuan.com', '*tshenbian.com', '*itxinwen.com', '*camera360.com', '*bjmama.com', '*donews.com', '*ty8866.com', '*mydogear.com', '*xesimg.com', '*aswis.net', '*qianzhengdaiban.com', '*uedmq.com', '*toogge.com', '*ufokuaidi.com', '*artintern.net', '*baidustatic.com', '*xoyo.com', '*zhuokearts.com', '*offcn.com', '*anjuke.com', '*sozhen.com', '*wechat.com', '*dukuai.com', '*tvsou.com', '*moeid.com', '*juandou.com', '*xinshipu.com', '*alimiaopu.com', '*nlcpress.com', '*ipaddh.com', '*36kr.com', '*tgfans.com', '*mocartoon.com', '*timll.com', '*meituan.com', '*emland.net', '*8s8s.com', '*springtour.com', '*letao.com', '*superairmedia.com', '*weirenmai002.com', '*819mn.com', '*webacg.com', '*youa.com', '*fclubimg.com', '*91adv.com', '*11w11.com', '*jintoutiao.com', '*127.net', '*ytrss.com', '*wingzstudio.net', '*515345.com', '*alimama.com', '*wsgsoft.net', '*goomoon.com', '*nasboq.com', '*sirenji.com', '*pinyihui.com', '*148com.com', '*3conline.com', '*mysteelcdn.com', '*nodeblog.org', '*kuaishubao.com', '*njyd139.com', '*qichelian.com', '*50qyy.com', '*hdletv.com', '*huxiu.com', '*biquge.com', '*hebcrj.com', '*sinosig.com', '*hbply.com', '*julying.com', '*chuangyejia.com', '*xiaopian.net', '*labsky.com', '*zmdz.com', '*chinawin.net', '*essxd.com', '*gaokao.com', '*phototex.com', '*jinghua.com', '*144gg.com', '*laoluoliuxue.com', '*yybk.com', '*itmini.net', '*123show.com', '*ezhun.com', '*navcloud.net', '*epanshi.com', '*assetswmd.com', '*mingpian8.com', '*soso2.com', '*nlpir.org', '*yes80.net', '*cocoachina.com', '*securestudies.com', '*discuz.net', '*jstv.com', '*bbicn.com', '*jiasule.com', '*xehost.com', '*easymule.com', '*appying.com', '*70man.com', '*iiberry.com', '*dzwww.net', '*baofeng.com', '*datatang.com', '*1133.cc', '*2nike.org', '*sustcmedia.net', '*sino-manager.com', '*climax999.com', '*sznews.com', '*7pk.com', '*lofter.com', '*tv002.com', '*hzvod.com', '*topbiz360.com', '*ads80.com', '*elechome.com', '*olcdn.com', '*kksmg.com', '*tkqlhce.com', '*yinhangxyk.com', '*51youpin.com', '*card.cd', '*fenku.com', '*77u.com', '*xiagun.com', '*cy123.cc', '*luckup.net', '*wealink.com', '*cityhz.com', '*qzoneapp.com', '*phoenixtv.com', '*intel.com', '*q150.com', '*mbatrip.com', '*ekupeng.com', '*tang-consulting.com', '*umivi.net', '*yizhichina.net', '*sxrtv.com', '*levelup.im', '*jxrtv.com', '*eywedu.com', '*fwxgx.com', '*meilishuo.com', '*7do.net', '*xiaosong.org', '*blogbus.com', '*dapenti.com', '*jinchen-cn.com', '*tequ.com', '*1360.com', '*uisdc.com', '*actoys.net', '*fitbbs.com', '*nemofq.com', '*2qqtouxiang.com', '*tmxk.org', '*solidworks888.com', '*2500sz.com', '*ique.com', '*9918edu.com', '*tellapart.com', '*appdown.info', '*suxiazai.com', '*tudun007.com', '*jyeoo.com', '*meshuo.com', '*goletao.com', '*qsiedu.com', '*motel168.com', '*shangxueba.com', '*1dupet.com', '*naadou.com', '*68room.com', '*weico.cc', '*jinncolor.com', '*doumob.com', '*cnepub.com', '*cnliti.com', '*ooyala.com', '*b6yy.com', '*wikipedia.org', '*agenow.com', '*ingentaconnect.com', '*zw97.com', '*41478.com', '*lifesky.com', '*yswl.in', '*xingpai.com', '*hermes.com', '*yt-power.com', '*zdh1909.com', '*acs.org', '*stepday.com', '*pipipan.com', '*freemerce.com', '*com.sg', '*wuyoumobile.com', '*koudai8.com', '*pooway.com', '*5umaimai.com', '*51sole.com', '*dragonair.com', '*88tang.com', '*ymatou.com', '*v-56.com', '*xunbo.cc', '*tenddata.com', '*kuaiyong.com', '*miercn.com', '*tankr.net', '*wowotuan.com', '*aliapp.com', '*ieltschn.com', '*66mp3.com', '*or.th', '*joyyang.com', '*sporttery.com', '*fangyou.com', '*lotour.com', '*rybao.com', '*inhe.net', '*iseeclan.com', '*5068.com', '*tjexh.com', '*nanhutravel.com', '*mxgbook.com', '*yueteng.com', '*deerchao.net', '*shengjoy.com', '*bicyc.com', '*jingdong.com', '*amgbs.com', '*taobaike.com', '*cucimg.com', '*po-soft.com', '*cnshuju.com', '*kejixun.com', '*8da.com', '*igexin.com', '*yuncheng.com', '*51zrm.com', '*v2ex.com', '*laidingba.com', '*kaixian.tv', '*nanadm.com', '*ourats.com', '*bitautotech.com', '*zarkfx.com', '*ibtsat.com', '*sosg.net', '*cztv.com', '*luangh.com', '*wuyou.net', '*ysn.cc', '*gcimg.net', '*ruyile.com', '*souba.org', '*3366img.com', '*zggyxx.com', '*9wee.com', '*geekui.com', '*miaopai.me', '*htinns.com', '*stfile.com', '*hiexpress.com', '*cnphotos.net', '*tcm100.com', '*fatoce.com', '*bao.fm', '*iconpng.com', '*longzhou.cc', '*qihuatong.com', '*zhlzw.com', '*pingshu8.com', '*yy.com', '*q1qq2.com', '*qjherb.com', '*everydo.com', '*piemoment.com', '*dooland.com', '*lvpingphoto.com', '*hackbase.com', '*336.com', '*zgbike.net', '*dmzj.com', '*yiqiv.com', '*gengrenjie.com', '*163.fm', '*citrixonline.com', '*codoon.com', '*bdstatic.com', '*images-amazon.com', '*xiutuan.com', '*1cfun.com', '*12cde.com', '*16789.net', '*baimei.com', '*padhz.com', '*subpig.net', '*feizan.com', '*y5zonechina.net', '*13xw.com', '*variflight.com', '*examda.com', '*dssz.com', '*wqzyt.net', '*l99.com', '*yue365.com', '*wangdian8.com', '*teachercn.com', '*huanqiukexue.com', '*ipinyou.com', '*tiandaoedu.com', '*meiyoubanfa.net', '*banma.com', '*shequan.com', '*icili.com', '*centanet.com', '*acg7.com', '*my147.com', '*butao.com', '*tl163.net', '*54hwz.com', '*zgfznews.com', '*help-doc.com', '*9skb.com', '*zdmimg.com', '*welan.com', '*ftuan.com', '*gushiwen.org', '*mailbus.net', '*meitu.com', '*131.com', '*tao21.org', '*bdchina.com', '*casualgame-down.com', '*2881.com', '*zhuangwang.com', '*hjbook.net', '*zjc365.com', '*autoshanghai.org', '*hao662.com', '*msn.com', '*qiushiqiang.com', '*founderit.com', '*114lm.com', '*linkindomain.com', '*iyaya.info', '*baiducontent.com', '*tsdxb.com', '*deyi.net', '*dotting.me', '*kxshoes.com', '*vonibo.com', '*paipai.fm', '*sinacdn.com', '*tao123.com', '*lvyoumall.com', '*sojiang.com', '*2mdn.net', '*chinatelecomes.com', '*wangyan.org', '*alibado.com', '*mb520.net', '*52suda.com', '*ouravr.com', '*suningshop.com', '*luo7.com', '*islayer.com', '*linuxpk.com', '*tangcha.tc', '*buytong.com', '*xzhuang.com', '*phpwind.com', '*burning.im', '*cioage.com', '*ich8.com', '*xiamentd.com', '*wiiyi.com', '*amazonaws.com', '*baoxila.com', '*aolcdn.com', '*yunyun.com', '*ujian.cc', '*biketo.org', '*cqvip.com', '*21edu8.com', '*100ksw.com', '*10010.com', '*jkjyfashion.com', '*8080kk.com', '*95530.com', '*touclick.com', '*umsns.com', '*winzhong.com', '*cnhubei.com', '*lanou3g.com', '*zhongsou.com', '*duba.net', '*sunnychina.com', '*wuwenhua.com', '*shbear.com', '*0371gt.com', '*ledanji.com', '*sandaha.com', '*glinfo.com', '*javaniu.com', '*yinhangchaxun.com', '*nihaowang.com', '*qq937.com', '*gifshow.com', '*ttpet.com', '*etentec.com', '*tx75.com', '*9med.net', '*gokuai.com', '*zol-img.com', '*juele.org', '*shouxi.net', '*42btc.com', '*cnsec.org', '*qdmama.net', '*7kiwi.com', '*adsmogo.mobi', '*facebook.net', '*doudouguo.com', '*zhigou.com', '*lianyou120.com', '*zhaotie.cc', '*dongwo.net', '*gs307.com', '*ytt.me', '*chinacache.com', '*phpstat.net', '*smejs.com', '*dd.ma', '*ichafen.com', '*miaoximei.com', '*kaifa01.com', '*world68.com', '*crsky.com', '*eda365.com', '*wopaiwo.com', '*18touch.com', '*uctrac.com', '*topchitu.com', '*cp2y.com', '*eflye.com', '*cmidc.com', '*xmswx.net', '*iqiyi.com', '*pk38.com', '*liyi99.com', '*top0514.com', '*xianhuodong.com', '*jueshitangmentoo.com', '*tweakcube.com', '*ichacha.net', '*fir.im', '*0394dk.com', '*dayoo.com', '*shaishufang.com', '*eduu.com', '*diangao.com', '*newmaker.com', '*mediapower.mobi', '*iamsujie.com', '*wzhan.net', '*namipan.com', '*bikehome.net', '*chinahr.com', '*romzhijia.net', '*89178.com', '*classicaldoor.com', '*dianping.com', '*html5dw.com', '*iloveyouxi.com', '*cqzwkj.com', '*vlongbiz.com', '*vcimg.com', '*tigtag.com', '*yytcdn.com', '*qingdi.com', '*ijia360.com', '*kejet.net', '*nu99.com', '*doguo.com', '*4007hao.com', '*3aapp.com', '*jbl.com', '*ihisen.com', '*nbkix.com', '*cctv.com', '*newrelic.com', '*elinkhost.com', '*kuaidi100.com', '*nandu.cc', '*bioon.com', '*dic123.com', '*gwy8.com', '*avrw.com', '*feitian001.com', '*btsmth.org', '*dywg.cc', '*rdcnzz.com', '*hmeili.com', '*gywx.org', '*zdface.com', '*foundertype.com', '*iheima.com', '*libspace.org', '*gaoqing.tv', '*wpbus.com', '*51kaifa.com', '*paywithsns.com', '*economist.com', '*86gudong.com', '*sxbbm.com', '*chinamac.com', '*oooxm.com', '*pztuan.com', '*mockte.com', '*fmate.com', '*56img.com', '*daichuanqing.com', '*live.net', '*jcwcn.com', '*zjoubbs.com', '*kangca.com', '*9588.com', '*yun.io', '*itiexue.net', '*7k7k.com', '*gxsky.com', '*ledu.com', '*yeah.net', '*essaydata.com', '*yi114.com', '*budeyan.com', '*573.com', '*xie-gang.com', '*xitek.com', '*k1om.com', '*g188.net', '*vstartdown.com', '*zjhzjy.com', '*candou.com', '*whcwzl.com', '*loohua.com', '*bke.cc', '*inezha.com', '*52cydia.com', '*ooidea.com', '*lztvnet.com', '*dooo.cc', '*bobcardjf.com', '*zealer.com', '*49ko.com', '*90he.com', '*zhongguosou.com', '*kro-pic.com', '*beijing-fire.com', '*chinataiwan.org', '*51mtb.com', '*lqqm.com', '*ht88.com', '*srzc.com', '*szsky.com', '*9g.com', '*dejiplaza.com', '*topsem.com', '*goodbaby.com', '*echuguo.net', '*wapwat.com', '*51766.com', '*healthoo.net', '*amaomb.com', '*dedecms.com', '*51mdq.com', '*union009.com', '*hubs1.net', '*dreams520.com', '*qianqian.com', '*aicairen.com', '*chinacrumpler.com', '*ku6.com', '*qkzz.net', '*aibai.com', '*alivv.com', '*adunioncode.com', '*guofm.com', '*startssl.com', '*26923.com', '*kuaitv.net', '*5156edu.com', '*7kan.net', '*gstatic.com', '*xiaoangel.com', '*gbtags.com', '*saifutong.com', '*1188.com', '*rolex.com', '*renren.com', '*lanrentuku.com', '*vpsmm.com', '*html5cn.org', '*acfun.tv', '*autonavi.com', '*lc505.com', '*cdnmaster.com', '*37wan.com', '*w3ctech.com', '*8008205555.com', '*xbiao.com', '*c-ps.net', '*koppt.me', '*ifeng.com', '*guokr.com', '*netded.com', '*tietu.com', '*timedg.com', '*m0n0china.org', '*ctex.org', '*imgroad.com', '*hdtmedia.com', '*rrting.com', '*2345.com', '*jumei.com', '*arnetminer.org', '*expcloud.net', '*bingchengwang.com', '*cjdby.net', '*anybi.com', '*vsoh.com', '*bjsxt.com', '*gotoip2.com', '*murenwu.com', '*mianr.com', '*taotaosou.com', '*love21cn.com', '*chebawang.com', '*kexue.com', '*dsmdz.com', '*yimg.com', '*linuxsir.org', '*kabulang.com', '*laixi.com', '*zhshangpin.com', '*chinatat.com', '*luckty.com', '*17u.com', '*mediav.com', '*fastbooking.com', '*21cn.com', '*rockmongo.com', '*365master.com', '*soufunimg.com', '*71training.com', '*naver.net', '*hamob.com', '*sdo-static.com', '*bocomcc.com', '*chofn.com', '*bookfm.com', '*imbugu.com', '*uezhan.com', '*leonsys.com', '*crossmo.com', '*windowsupdate.com', '*job1001.com', '*510599.com', '*dui.lu', '*baixing.net', '*dapenti.org', '*ngacn.cc', '*zhi.la', '*67.com', '*100ksw.net', '*9lwan.com', '*bjsbj.net', '*topcj.com', '*baomihua.com', '*datangcloud.com', '*hiao.com', '*hdstar.org', '*re1d.com', '*ej38.com', '*365jilin.com', '*gzyes.com', '*houhang.com', '*diandian.com', '*chinauma.net', '*appinn.com', '*szjtq.com', '*edodocs.com', '*admin6.com', '*99114.com', '*chaishouji.com', '*yeshj.com', '*yxey.net', '*cenuni.com', '*zbjimg.com', '*sheetoo.com', '*letvimg.com', '*wkimg.com', '*wan789.net', '*ckgsb.com', '*lijiangkezhan.com', '*flyertea.com', '*szltcn.com', '*guangpantuan.com', '*proferochina.com', '*yihu.com', '*91tiger.com', '*pengfu.com', '*99bill.com', '*dajudeng.com', '*iconfans.com', '*visionunion.com', '*6eat.com', '*qingtingfm.com', '*newsmyshop.com', '*yzzj.net', '*patmm.com', '*aaeexpress.com', '*niuza.com', '*php100.com', '*lotuschina.net', '*job592.com', '*1000eb.com', '*tenpay.com', '*51network.com', '*gzdsw.com', '*apple.com', '*dm456.com', '*baigoogledu.com', '*crashlytics.com', '*haoxuee.com', '*letuknowit.com', '*nxnews.net', '*chinacourt.org', '*ggxt.net', '*letuspeed.com', '*zjcomlawyer.com', '*tbmj.net', '*umiwi.com', '*shilehui.com', '*mfcad.com', '*tencent.com', '*qingting.fm', '*okbuycdn.com', '*wordlm.com', '*139site.com', '*c-c.com', '*cnbike.net', '*img18.com', '*knownsec.com', '*boohee.com', '*xnpic.com', '*12530.com', '*adsage.com', '*studa.net', '*punchbox.org', '*alimenhu.com', '*gamerboom.com', '*kakamobi.com', '*92youle.com', '*gucheng.com', '*kgkx.com', '*lehecai.com', '*4399buy.com', '*pinglun.la', '*maxthon.com', '*bjtlss.com', '*wrating.com', '*wgimg.com', '*eeboard.com', '*effectivemeasure.net', '*mier123.com', '*forbeschina.com', '*adyun.com', '*bing.com', '*websbook.com', '*unionpaysecure.com', '*jiankongbao.com', '*573youxi.com', '*sz1001.net', '*y4dg.com', '*zkungfu.com', '*chinadsl.net', '*ireadercity.com', '*wtojob.com', '*51daifu.com', '*dddsp.com', '*baiduyy.com', '*iplaymtg.com', '*yiyou5.com', '*hiido.com', '*chinavalue.net', '*icbc-ltd.com', '*kaba365.com', '*forumimage.org', '*xcy8.com', '*helpton.com', '*itings.com', '*119tw.com', '*alibole.com', '*yanshun.org', '*flvcd.com', '*zjuhz.com', '*hundsun.com', '*dajie.com', '*wordpress.la', '*bibidan.net', '*huawei.com', '*see-say.com', '*6619.net', '*xinzhuzhang.com', '*douban.fm', '*7540.com', '*qvocd.org', '*chinawaiyu.com', '*ranwen.net', '*hnjunlin.com', '*028share.com', '*ppstream.com', '*huiben.cc', '*allworldbuy.com', '*99sushe.com', '*netdna-cdn.com', '*cyanclone.com', '*tibetcul.com', '*i360r.com', '*968hao.com', '*91985.com', '*edu88.com', '*qyacg.com', '*hicloud.com', '*icloud.com', '*sandai.net', '*7068.cc', '*aiyingshi.com', '*vpon.com', '*dzsofts.net', '*emailcar1.com', '*is97.com', '*xiangshenghang.com', '*dianying.fm', '*lamiu.com', '*wacai.com', '*topit.me', '*meqzone.com', '*120ask.com', '*jimdo.com', '*pchome.net', '*hilishi.com', '*6zu.com', '*huitongke.com', '*tujia.com', '*xiami.com', '*46535.com', '*kadaqia.com', '*shopin.net', '*chexie.net', '*wulinyingxiong.net', '*zssirui.com', '*googletagmanager.com', '*bukamanhua.com', '*eastday.com', '*tao3c.com', '*sexqu.cc', '*keede.com', '*liheran.com', '*lkwww.net', '*yfkjy.com', '*mdn2.net', '*reuters.com', '*xiaoenai.com', '*for68.com', '*itao521.com', '*1mall.com', '*yinooo.com', '*ibeike.com', '*kkcapture.com', '*uyan.cc', '*qiyejia.net', '*sodao.me', '*powerlong.com', '*bookinge.com', '*amakings.com', '*llnwd.net', '*hanggao.net', '*htpc1.com', '*sososnap.com', '*adzhub.com', '*newexpo.com', '*zylm.cc', '*xasn.com', '*tudouui.com', '*meican.com', '*doll-zone.com', '*heima8.com', '*vivijk.com', '*3777u.com', '*exam8.com', '*ctdisk.com', '*prosight.me', '*linekong.com', '*shejis.com', '*jsgaokao.net', '*zx110.org', '*chinamobile.com', '*noiseindustries.com', '*humen.com', '*wandoujia.com', '*nibirutech.com', '*jiuxian.com', '*qita.in', '*sanhaostreet.com', '*fs-station.com', '*yxdaily.com', '*cio360.net', '*douguo.net', '*sharewithu.com', '*tianyiyule.com', '*5184.com', '*17kuxun.com', '*leshu.com', '*duote.org', '*bdwm.net', '*shanbay.com', '*meishitui.com', '*17leyi.com', '*cheryhome.net', '*rido.cc', '*aboutcg.net', '*xiaoi.com', '*sjway.com', '*optaim.com', '*yzwb.net', '*jcloud.com', '*dzwww.com', '*changedu.com', '*wotula.com', '*rritw.com', '*zhongguoxijuchang.com', '*lisal.me', '*huobaoliangjiaren.com', '*rutisher.com', '*500cache.com', '*dmdelivery.com', '*77dannya.com', '*chinahighway.com', '*itkes.com', '*immivip.com', '*dfhbike.com', '*jinfuzi.com', '*bjwjwk.com', '*gozap.com', '*jiayuan.com', '*11l11.net', '*zhsc.net', '*sg120.com', '*meishichina.com', '*apple83.com', '*nphoto.net', '*kmbike.net', '*xp510.com', '*youxjia.com', '*yetwo.com', '*or.kr', '*coolshang.com', '*igoex.com', '*chengguocar.com', '*gotoip3.com', '*shouyou.com', '*cdncache.org', '*tianjinwe.com', '*jishantang.org', '*bababian.com', '*sootoo.com', '*zampdsp.com', '*chinaumu.org', '*wosign.com', '*jyoorobot.com', '*m18.com', '*tv189.com', '*nuoshu.com', '*mlt01.com', '*juangua.com', '*eicodesign.com', '*ad1111.com', '*kameng.com', '*jgxfw.com', '*jiapin.com', '*sina.net', '*zhengjicn.com', '*songtaste.com', '*csair.com', '*tiaozhanbei.net', '*xcarimg.com', '*soo-boo.com', '*425300.com', '*daozhou.net', '*avdmg.com', '*kidcomic.net', '*gh730.com', '*funshion.net', '*nz86.com', '*showxiu.com', '*inanbo.com', '*kechengbiao.me', '*333cn.com', '*51mta.com', '*synacast.com', '*myfrfr.com', '*taocx100.com', '*mipangwang.com', '*alibabatech.com', '*my5757.com', '*hupu.com', '*union163.com', '*xj71.com', '*web592.com', '*mn81.com', '*mogujie.com', '*elong.com', '*molifan.net', '*you01.com', '*hack520.org', '*waqiang.com', '*helloarm.com', '*zhenwu.com', '*adsmogo.com', '*51rfb.com', '*shuame.com', '*200.net', '*my399.com', '*8dulm.com', '*joyopiao.com', '*ikoori.com', '*gaibar.com', '*httpcn.com', '*k184.com', '*4891ko.com', '*gewara.com', '*yinxiangma.com', '*aoyou.cc', '*bjxueche.com', '*zaobang.com', '*woleso.com', '*168.sh', '*ts33.com', '*tom.com', '*macgg.com', '*app123.com', '*yjpdf.com', '*alixixi.com', '*chinabyte.com', '*gaosiedu.com', '*5d5d.com', '*unionli.com', '*cdngc.net', '*ihacksoft.com', '*qkankan.com', '*148365.com', '*53kf.com', '*agenda-asia.net', '*snyu.com', '*cachiyeung.com', '*hao123img.com', '*gtimg.com', '*popocy.com', '*bing.net', '*997788.com', '*hc360.com', '*hao311.com', '*star2009.com', '*ku6cdn.com', '*suk100.com', '*hxsd.com', '*superfection.com', '*3366.com', '*fobshanghai.com', '*ailaba.org', '*taokshop.com', '*angeeks.com', '*ss3w.com', '*ydjiao.com', '*ld12.com', '*3lsoft.com', '*yousee.com', '*qqtn.com', '*ikea.com', '*2liang.net', '*hd575.com', '*yiss.com', '*mmbang.com', '*nbweekly.com', '*66wz.com', '*gisall.com', '*hq9988.com', '*kejet.com', '*liuxue86.com', '*missyuan.net', '*eoeandroid.com', '*chemyq.com', '*googletagservices.com', '*tuanweihui.com', '*haiyingsite.com', '*junph.com', '*xiazaiba.com', '*wdjimg.com', '*ezhangdan.com', '*pomoho.com', '*rendb.com', '*imwx.com', '*makepolo.net', '*it168.com', '*szbaws.com', '*wutianqi.com', '*vapee.com', '*whaty.com', '*ele.me', '*0551bike.com', '*douyou100.com', '*zhaoshangbao.com', '*medooo.com', '*ssbbww.com', '*weibo.com', '*hxxland.com', '*88812699.com', '*china-consulate.org', '*kandian.com', '*mobmore.com', '*newssc.org', '*cncad.net', '*netiso.net', '*5d6d.net', '*xuanpg.com', '*360hqb.com', '*tobti.com', '*laochemi.net', '*918kf.com', '*dostor.com', '*netat.net', '*laiwang.com', '*chapianfang.com', '*anybi.net', '*xixik.com', '*show400.com', '*lenovo.com', '*liqwei.com', '*2zx.cc', '*newzealand.com', '*youbianku.com', '*huaxiafengyun.com', '*anti-cnn.com', '*365meeting.net', '*xiaohua001.com', '*52mba.com', '*ddooo.com', '*bjddn.com', '*haozu.com', '*funfungolf.com', '*ctqcp.com', '*duanwenxue.com', '*waimaidan.com', '*dabaima.com', '*123u.com', '*goapk.com', '*qiyou.com', '*cigna-cmc.com', '*snwz.com', '*weliveinbeijing.com', '*bjnandi.com', '*zhihu.com', '*dianru.com', '*kukudm.com', '*adidasevent.com', '*ccvita.com', '*uucin.com', '*china-netwave.com', '*b2cedu.com', '*qianxinet.com', '*eflyetrip.com', '*kabiqi.com', '*911pop.com', '*tuhaihe.com', '*znimg.com', '*replays.net', '*cyol.com', '*techdrafts.com', '*cankaoxiaoxi.com', '*360kad.com', '*doodii.com', '*bestrans.net', '*deyi.com', '*moumentei.com', '*csres.com', '*behe.com', '*126.net', '*gaytaobao.com', '*yuloo.com', '*jobui.com', '*cofco.com', '*51fanli.com', '*pic16.com', '*ucdchina.com', '*2866yx.com', '*kpkpw.com', '*hxen.com', '*zjbdt.com', '*cnfolimg.com', '*feelcss.com', '*xuexun.com', '*divmb.com', '*51ditu.com', '*dxsvr.com', '*phb168.com', '*ca2u.net', '*hy123.com', '*gfan.com', '*royalcaribbean.com', '*qidian.com', '*yunstatic.com', '*alidata.org', '*365zaoshi.com', '*jysq.net', '*zoopda.com', '*qfpay.com', '*360chuguo.com', '*39.net', '*burl.cc', '*mumayi.com', '*dxwxy.com', '*china-sss.com', '*baike.com', '*ctdsb.net', '*ckdvd.cc', '*go007.com', '*wsson.com', '*oadz.com', '*mqw123.com', '*cqsq.com', '*wonadea.com', '*5d6d.com', '*esaipay.com', '*ec80.com', '*nowec.com', '*tamml.com', '*pinggu.name', '*wan123.com', '*kxsj.com', '*flash3.net', '*rrimg.com', '*ishwap.com', '*newsminer.net', '*daohao.net', '*reeoo.com', '*0669.cc', '*bibimai.com', '*gtags.net', '*10086.com', '*p111.net', '*cndizi.com', '*k8008.com', '*doctorcom.com', '*chinaw3c.org', '*egovsum.com', '*nintendowifi.net', '*wangjubao.com', '*aliyuncs.com', '*tugus.com', '*yunshangdian.com', '*36x7.com', '*dabandeng.com', '*baoyeah.com', '*xungou.com', '*operaphoto.com', '*eb99.com', '*v5px.com', '*dropbox.com', '*vlss.com', '*8825.com', '*51jiaxiao.com', '*miui.com', '*7edown.com', '*caishijie.com', '*zz-bike.com', '*xijucn.com', '*himengzhou.com', '*16078.com', '*missyuan.com', '*em-cn.com', '*xinnet.com', '*idcspy.com', '*ycstatic.com', '*imadisonlogic.com', '*yicomm.com', '*datatv.net', '*hnmama.com', '*niunb.com', '*wolai.com', '*yahunet.com', '*skyteam.com', '*niux88.com', '*pt92.com', '*ftimg.net', '*likejuan.com', '*thetvdb.com', '*emacle.com', '*cnaaa3.com', '*3322.org', '*flyert.com', '*bielaiwan.com', '*1717gs.com', '*jinbangqm.com', '*cskczx.com', '*telecomjs.com', '*dangzhi.com', '*safrotto.com', '*peninsula.com', '*ztspeech.com', '*d8wed.com', '*htbresort.com', '*webluker.com', '*vipstore.com', '*17558.net', '*okoooimg.com', '*laruence.com', '*hotelscombined.com', '*17mv.com', '*soopat.com', '*falibao.com', '*unity3d.com', '*xinhuanet.com', '*newwise.com', '*114133.com', '*2tu.cc', '*gispark.com', '*chdtv.com', '*fishyp.net', '*guqu.net', '*36krcnd.com', '*hbshgzx.com', '*snailcolor.com', '*baisuiyi.com', '*evergrande.com', '*cnxad.com', '*cmread.com', '*jj831.com', '*adobe.com', '*wabao.me', '*virscan.org', '*lijigou.com', '*emarbox.com', '*chainlt.com', '*liqucn.com', '*soso.com', '*qq20101.com', '*tgbus.com', '*comodoca.com', '*51edu.com', '*baozoumanhua.com', '*chinakongzi.org', '*ltaaa.com', '*digushow.com', '*dygod.net', '*cnnude.com', '*lengxiaohua.com', '*fangjia.com', '*tianqi321.com', '*wonderad.com', '*68699120.net', '*eistudy.net', '*abc-love.com', '*godiy8.com', '*qqjia.com', '*cailong.net', '*usc.edu', '*61ads.com', '*game3737.com', '*pzoom.com', '*brand-edm.net', '*mygolbs.com', '*ydstatic.com', '*dajiawan.com', '*kuaibo.com', '*ebigear.com', '*ikingyo.com', '*vdisk.me', '*10628106.com', '*net114.com', '*qiaopier.com', '*hhtravel.com', '*classlater.com', '*zgzcw.com', '*cootekservice.com', '*ovi.com', '*dnpns.com', '*peixun360.com', '*xuexila.com', '*manjiusong.net', '*gmgc.info', '*chinesessg.com', '*vanke.com', '*qconhangzhou.com', '*yesmylaw.com', '*weiguan.cc', '*chdtv.net', '*boqii.com', '*mysilu.com', '*lov9.net', '*krxd.net', '*duomiyy.com', '*weliveinchina.com', '*nds99.com', '*chinabike.net', '*hexun.com', '*resgain.net', '*gxg520.com', '*233.com', '*newsmth.net', '*ymfile.com', '*duoxue8.com', '*sungoedu.com', '*wenmi114.com', '*gxcms.com', '*westmov.com', '*zjomo.com', '*hbxt.net', '*54jk.com', '*cppblog.com', '*caixun.com', '*wumii.com', '*titan007.com', '*soomal.com', '*abccod.com', '*tita.com', '*u-om.com', '*dvbcn.com', '*51auto.com', '*francochinois.com', '*cjmx.com', '*archfans.com', '*gezbox.com', '*etao.com', '*hztags.net', '*11qu.com', '*nice3c.com', '*97ls.com', '*517zijiayou.com', '*vcotton.com', '*365jia.com', '*anrdoezrs.net', '*enmajor.com', '*bjgtop.com', '*zhuangbei2012.com', '*anyview.net', '*zhenai.com', '*uyunad.com', '*socialbeta.com', '*qianpincdn.com', '*huatu.com', '*77soho.com', '*dacais.com', '*yzdb.tv', '*wasu.tv', '*bzfxw.com', '*huaban.com', '*zjsight.com', '*ftjcfx.com', '*malshenzu.com', '*itravellive.com', '*188.com', '*longre.com', '*zaiju.com', '*265g.com', '*haodf.com', '*bet007.com', '*vmall.com', '*konglei.com', '*jike.com', '*03964.com', '*moegirl.org', '*kakarott.net', '*hxqu.com', '*donever.com', '*qumaiya.com', '*wwping.com', '*blshe.com', '*wally.in', '*geek-workshop.com', '*zasv.net', '*korirl.com', '*adsame.com', '*xuedi.com', '*xlpu.cc', '*house365.com', '*sagetouch.com', '*gaosu.com', '*hiwifi.com', '*hbzct.com', '*duote.com', '*souyousoft.com', '*anzhi.com', '*51888.com', '*coo8.com', '*youku.com', '*verisign.com', '*weiyun.com', '*conguo.com', '*yinshuazhongguo.com', '*aigou.com', '*chahaoba.com', '*jiancai.com', '*qeeka.com', '*ednchina.com', '*51buy.com', '*dpfile.com', '*fetionpic.com', '*vitkey.com', '*xingbar.com', '*landfu.com', '*55.la', '*tjjoycity.com', '*zhaoka.com', '*showchina.org', '*ttg.im', '*xlpan.com', '*rordo.com', '*hdslb.com', '*memail.net', '*weixin.com', '*blue1000.com', '*ynhanfu.com', '*uzzf.com', '*kaoyanbbs.org', '*dachaocai.com', '*minesage.com', '*bestedm.org', '*kdslife.com', '*rca-hk.com', '*tuodi.com', '*tvmao.com', '*lupaworld.com', '*qqbody.com', '*yiibai.com', '*bliao.com', '*netwinform.com', '*cutt.com', '*70e.com', '*tejiamao.com', '*hoodong.com', '*xypht.com', '*00base.com', '*bokee.com', '*tuicool.com', '*gamebean.com', '*cnzz.cc', '*sucaiw.com', '*sinaedge.com', '*s1976.com', '*dianpufa.com', '*kanimg.com', '*xiaobaixitong.com', '*zopomobile.com', '*umetrip.com', '*hp-ww.com', '*windows.net', '*akdy.com', '*myitit.com', '*yezhanjun.net', '*opdown.com', '*sky-fire.com', '*1688988.com', '*wenkudaquan.com', '*2ccc.com', '*mndsoft.com', '*huodongxing.com', '*eshufa.com', '*mysmth.net', '*tomonline-inc.com', '*js118114.com', '*com.com', '*tutu001.com', '*gg.ma', '*gdnanke.com', '*estrongs.com', '*cnki.net', '*yingyonghui.com', '*rt-thread.org', '*29293.com', '*yunci4.com', '*comsz.com', '*weiphone.com', '*8448.cc', '*njtarena.com', '*bookschina.com', '*0830bbs.com', '*kaiwind.com', '*chachaba.com', '*androidesk.com', '*expreview.com', '*sino-di.com', '*vnet.mobi', '*bitauto.com', '*cutv.com', '*eeworm.com', '*4008517517.com', '*alixueyuan.net', '*morcha.net', '*baifendian.com', '*orstatic.com', '*chinauma.com', '*sina.com', '*leba1.com', '*gicp.net', '*alibuybuy.com', '*aidaicn.com', '*rsleds.com', '*gxp.cc', '*gamecps.com', '*hyedu.com', '*hellolvyou.com', '*51zhangdan.com', '*flyguest.com', '*gongkaocn.com', '*panelook.com', '*hwjyw.com', '*qingdaoculture.com', '*hxsk.net', '*diyifanwen.com', '*renrendanche.com', '*mbscss.com', '*guahao114.com', '*springairlines.com', '*leju.com', '*a12300.net', '*popgo.net', '*6188.net', '*judou123.com', '*uutuu.com', '*mimivo.com', '*elinkvps.com', '*qotom.com', '*hefls.net', '*8864.com', '*htwisdom.com', '*tianjimedia.com', '*qdss.org', '*51nb.com', '*44vs.com', '*guo.fm', '*importnew.com', '*moxtra.com', '*flusherlink.com', '*rologo.com', '*shengejing.com', '*ldbj.com', '*zhituad.com', '*robotide.com', '*51dy.com', '*139shop.com', '*winupon.com', '*meimingteng.com', '*chinaacc.com', '*xywy.com', '*qs199.com', '*eudic.net', '*jolighting.com', '*ganji.com', '*ciotimes.com', '*ncar.cc', '*dgmei.com', '*htky365.com', '*apwifi.com', '*114study.com', '*xinquanedu.com', '*kaoyan001.com', '*cccweb.org', '*travelzoo.com', '*laolinow.com', '*goodoing.com', '*myverydz.com', '*liaocao.com', '*ggmm777.com', '*cxtcfw.com', '*tejiawang.com', '*fzgd.org', '*xinyaoyao.com', '*365rili.com', '*moonbasa.com', '*wwwrenren.com', '*radiotj.com', '*qaohui.com', '*qiwen.lu', '*miliao.com', '*douban.com', '*ssl-images-amazon.com', '*aicai.com', '*priorityclub.com', '*800cdn.com', '*kb.vc', '*chengdesign.net', '*knowsky.com', '*hecaitou.com', '*anjian.com', '*cha138.com', '*ti.com', '*cathaypacific.com', '*feiliks.com', '*welove520.com', '*zxip.com', '*sucaitianxia.com', '*xiamenair.com', '*elongstatic.com', '*huoche.com', '*typeland.com', '*778669.com', '*kfcdn.com', '*pcbeta.com', '*anquan.org', '*stbxx.com', '*yculblog.com', '*daodao.com', '*chinaceot.com', '*xunyou.com', '*infzm.com', '*fenanr.com', '*blueidea.com', '*m9o.net', '*samsung.com', '*joome.net', '*amap.com', '*moji002.com', '*hefei.cc', '*dadao.net', '*mayi.com', '*sqlku.com', '*honssen.com', '*51img1.com', '*wbxia.com', '*xooob.com', '*bilibili.tv', '*hudong.com', '*moliplayer.com', '*tracefact.net', '*heiqu.com', '*xsjk.net', '*saxmcu.com', '*memehu.com', '*56.com', '*ku6vms.com', '*istreamsche.com', '*lifetoy.org', '*sfacg.com', '*waptw.com', '*exetools.com', '*86c.net', '*kimiss.com', '*towords.com', '*boxcdn.net', '*lovebizhi.com', '*huain.com', '*weste.net', '*zhuwang.cc', '*afterdownload.com', '*94994.com', '*daoduoduo.com', '*hnxhdq.com', '*readfree.net', '*rushiwowen.org', '*tmtpost.com', '*icloudpower.com', '*huitu.com', '*bokeccimg.com', '*qinqishuhua.org', '*chinabmx.com', '*oho168.com', '*yccdn.com', '*ctrip.com', '*zjolcdn.com', '*guofenke.com', '*mt30.com', '*xxh.cc', '*nature-museum.net', '*myit365.com', '*apkbus.com', '*wanzao.com', '*anthonos.org', '*junshijia.com', '*static-cisco.com', '*acgvideo.com', '*cdworking.com', '*zhiqiang.org', '*itlily.com', '*84tt.com', '*aiganggu.com', '*500.com', '*tx-power.com', '*vipshop.com', '*fsou.com', '*yy67.com', '*999.cc', '*scbike.net', '*coovee.net', '*cencev.com', '*milier.com', '*weidunewtab.com', '*haha365.com', '*pptv.com', '*9chun.com', '*topsage.com', '*fenzhi.com', '*xgdjx.com', '*ylysny.com', '*aolai.com', '*boxshows.com', '*hainan.net', '*shanghaidaily.com', '*cnbearing.biz', '*ihome99.com', '*gudaovision.com', '*yymax.com', '*qicaise.com', '*idqqimg.com', '*hengzefu.com', '*friendoc.net', '*yiyuanyi.org', '*saraba1st.com', '*ylunion.com', '*xueqiu.com', '*firstmag.net', '*binhuo.com', '*rayfile.org', '*yiinet.net', '*timesafer.com', '*taskcn.com', '*ggyad.com', '*365fenxiang.com', '*cnblogs.com', '*ea3w.com', '*duoge007.com', '*ttmimg.com', '*hp.com', '*155.com', '*pc120.com', '*aameinv.com', '*haliyuya.com', '*nrelate.com', '*yangtse.com', '*qzhi5.com', '*boysky.com', '*pigai.org', '*historicalchina.net', '*ajhdf.com', '*9160.com', '*myapp.com', '*wyn88.com', '*qi678.com', '*33lc.com', '*soft568.com', '*xtube.com', '*51tuofu.com', '*freescaleic.org', '*alipayobjects.com', '*citysbs.com', '*zdhmkq.com', '*alsogood.com', '*bestbai.info', '*gz4u.net', '*luguhusige.com', '*t00y.com', '*qbaobei.com', '*howfile.com', '*bz1111.com', '*333wan.com', '*isv8.com', '*95588.com', '*pop-fashion.com', '*ifensi.com', '*qqdo.com', '*extrabux.com', '*funlon.com', '*try8.info', '*monternet.com', '*cersp.com', '*ubuntusoft.com', '*fltacn.com', '*17v5.com', '*bundpic.com', '*taoshu.com', '*linuxfly.org', '*lashouimg.com', '*xiustatic.com', '*pachiratech.com', '*china-designer.com', '*51yes.com', '*8888fy.com', '*doyouhike.net', '*jpwind.com', '*zhenren.com', '*lanree.com', '*pfspace.com', '*datavlab.org', '*duitang.com', '*rokey.net', '*subaonet.com', '*sf-express.com', '*web887.com', '*kui.cc', '*tx29.com', '*awc618.com', '*socang.com', '*1616.net', '*4399.com', '*fronware.com', '*cskaoyan.com', '*gj510.com', '*mytz.net', '*vicp.net', '*baobeitu.com', '*duose.com', '*guanglun.net', '*061100.com', '*duomai.com', '*zzidc.com', '*webscache.com', '*bianews.com', '*law-lib.com', '*uzaicdn.com', '*08279.com', '*javabloger.com', '*liketuan.com', '*chenkunli.com', '*eastgame.org', '*lydl.net', '*feng91.com', '*qxinxi.com', '*cheyisou.com', '*epaidai.com', '*win4000.com', '*youdao.com', '*aboboo.com', '*intsig.com', '*10010js.com', '*gdyjs.com', '*verifylist.com', '*sc157.com', '*591hx.com', '*geforce.com', '*auctivacommerce.com', '*mingrunad.com', '*ousns.com', '*sgcai.com', '*xinray.com', '*vgoapp.com', '*chinaface.com', '*xincai.com', '*42qu.net', '*sgamer.com', '*boleme.com', '*lwlm.com', '*55.com', '*jobdu.com', '*35.com', '*ckdvd.com', '*fengfei.net', '*moji001.com', '*jdoqocy.com', '*popbook.com', '*sosucai.com', '*phjy.net', '*meipin100.com', '*letvstore.com', '*mipang.com', '*yuhuagu.com', '*luyou8.com', '*worldofwarcraft.com', '*zijidelu.com', '*molei.net', '*siyuefeng.com', '*acg.tv', '*dazhima.com', '*05sun.com', '*163.com', '*laidianduo.com', '*ellll.com', '*5read.com', '*mapabc.com', '*phpwind.net', '*uhuo.org', '*hunt007.com', '*zynews.com', '*baimao.com', '*55tuan.com', '*ttmeiju.com', '*infrastructure', '*hifly.tv', '*join-2008.com', '*5asd.com', '*mjoys.com', '*pagechoice.net', '*ncbike.net', '*duokan.com', '*lc0771.com', '*cttsn.com', '*holdjava.com', '*abcache.com', '*segmentfault.com', '*uedmk.com', '*shenghuomei.com', '*gogomaster.com', '*uspcat.com', '*aikuwan.com', '*mozilla.org', '*longhoo.net', '*ibcde.com', '*berspective.com', '*xmbtn.com', '*yucmedia.com', '*springer.com', '*hiapk.com', '*szhome.com', '*meipai.com', '*qdit.com', '*fenxi001.com', '*06621.com', '*zhiyoujie.com', '*guanzhuyouli.com', '*kukuplay.com', '*goodtp.com', '*20yy.com', '*whtbk.com', '*beifaxian.com', '*doyoo.net', '*microad-cn.com', '*liantu.com', '*tongwenguan.com', '*115.com', '*wochacha.com', '*standardchartered.com', '*cctcct.com', '*dmtrck.com', '*yybox.cc', '*hichinacloud.com', '*dnion.com', '*yiqifa.com', '*xmcdn.com', '*bt5156.com', '*devmate.com', '*baiy.net', '*hitao.com', '*shushao.com', '*qipilv.com', '*aixdev.org', '*sohozj.com', '*hostelcn.com', '*xns315.com', '*thebeijinger.com', '*trip8080.com', '*belugaboost.com', '*izaojiao.com', '*aili.com', '*mykurong.com', '*metroer.com', '*kaoyanbbs.net', '*daotin.com', '*allyes.com', '*ihaveu.net', '*win8ku.com', '*520zc.com', '*sj63.com', '*999d.com', '*a3p4.com', '*uirss.com', '*ouyaoxiazai.com', '*dou.bz', '*southmoney.com', '*hxcdn.net', '*imrworldwide.com', '*muyingzhijia.com', '*chinasic.com', '*kximg.cc', '*12yao.com', '*315che.com', '*dpsson.com', '*8080.net', '*vbuluo.com', '*qcxz.net', '*cr173.com', '*font6.com', '*pstatp.com', '*embedinfo.com', '*6rooms.com', '*futuredm.com', '*shishangqiyi.com', '*91339.com', '*zbgl.net', '*wow8.org', '*cmfchina.com', '*naivix.com', '*migu.tv', '*okdsj.com', '*pinggu.org', '*lisoundearphone.com', '*sqshb.com', '*5173tuan.com', '*qrmbl.com', '*airad.com', '*letv.com', '*99ddd.com', '*xk77.com', '*139js.com', '*jxkp.com', '*ictclas.org', '*d2c-games.com', '*jiaqi5.com', '*ucweb.com', '*qianyuedu.com', '*veryzhun.com', '*ticket2010.com', '*huanlang.com', '*cnepub.net', '*taobeihai.com', '*zhuzhu.cc', '*bjokli.com', '*chinacpc.com', '*huohua.in', '*mini123.com', '*xsu.cc', '*zixia.com', '*fanfou.com', '*cloudbbs.org', '*checkgfw.com', '*wallba.com', '*googleadservices.com', '*qycn.com', '*newwaverewards.com', '*miaoke.org', '*bjmama.net', '*ntjy.net', '*meituan.net', '*tuchong.com', '*vancl.com', '*zaoxue.com', '*uuzu.com', '*cdbike.net', '*toflon.com', '*chinavoa.com', '*tx100.com', '*ssdqfs.com', '*tb210.com', '*cncn.com', '*hrreserve.com', '*4321.la', '*aihuiyin.com', '*aoaob.com', '*ggdxc.com', '*agoniz.net', '*guansoft.com', '*neworiental.org', '*cardcmb.com', '*fun4hi.com', '*mibuo.com', '*0598yu.com', '*shjfilm.com', '*hhjxie.com', '*jackd.mobi', '*cnproxy.com', '*bcttc.com', '*qmango.com', '*wmmmw.com', '*moon-soft.com', '*yzddol.com', '*flash45.com', '*dw2f.com', '*3gfly.net', '*500wancache.com', '*25pp.com', '*macapp.cc', '*shentucao.com', '*gqsip.com', '*51labour.com', '*mydrivers.com', '*bppstore.com', '*upupyoyoyo.net', '*happigo.com', '*iosinspires.me', '*jianshe99.com', '*yyfc.com', '*zhi.hu', '*doitim.com', '*chinalawedu.com', '*bbniu.com', '*bwgame.org', '*ynpxrz.com', '*yxduo.com', '*zxmeili.com', '*jctrans.com', '*chanel.com', '*foxitsoftware.com', '*soupis.com', '*yifan8899.com', '*freehead.com', '*sino-epay.net', '*0512kd.com', '*maidangao.com', '*veryim.com', '*normtm.com', '*goepe.com', '*macworldasia.com', '*88210212.com', '*haodf.org', '*yxdown.com', '*comsenz.com', '*jjtang.com', '*111zph.com', '*zhuanbao.com', '*ipadown.com', '*gbin1.com', '*51f1.com', '*cheletong.com', '*utop.it', '*ningbo18.com', '*55tjk.com', '*koolearn.com', '*zpcdn.com', '*qqyy.com', '*bjbahao.com', '*uxdc.org', '*waerfa.com', '*tianyinsoft.com', '*haodou.com', '*ky211.com', '*wo99.com', '*wper.com', '*x-berry.com', '*tiebaimg.com', '*iwallpaper.me', '*5dmail.net', '*mfdvd.com', '*uoun.cc', '*chbcnet.com', '*iisicp.com', '*iq123.com', '*tk3000.net', '*live800.com', '*taikoyc.com', '*weixintuan.net', '*moke8.com', '*shuitan8.com', '*nexoncn.com', '*zhgpl.com', '*javaweb.cc', '*wm090.com', '*irs01.com', '*taobao.org', '*funshion.com', '*3snews.net', '*cnyu.com', '*51ielts.com', '*zijidelu.org', '*psychcn.com', '*fsjwg.com', '*aaeweb.com', '*thawte.com', '*leexa.com', '*twcczhu.com', '*aliyiyao.com', '*izsxw.com', '*miiee.com', '*mtime.com', '*founder.com', '*gzedupg.com', '*qiannao.com', '*speiyou.com', '*yinghai.net', '*63tuangou.com', '*muhecdn.com', '*kongzhong.com', '*ruby-china.org', '*xiaobians.com', '*qbox.me', '*yueban.com', '*nantaihu.com', '*apmebf.com', '*mbaobao.com', '*3munion.net', '*cdn123.net', '*youmi.net', '*letvcdn.com', '*shenmeshi.com', '*codefans.net', '*ubao.com', '*ofcard.com', '*zwbk.org', '*youxipai.com', '*52rd.com', '*cetv.com', '*gameabc.com', '*woshao.net', '*chinahw.net', '*cthy.com', '*gjgwy.org', '*90qh.com', '*foursquare.com', '*007ok.cc', '*zhangyue.com', '*doubleclick.net', '*k65.com', '*wanlitong.com', '*kan83.com', '*piaochong.com', '*isstudy.com', '*lejianshop.com', '*juntais.com', '*yinyuetai.com', '*ijinshan.com', '*jbguide.me', '*rickyxu.net', '*hjusaexpress.com', '*gsdpw.com', '*7837.com', '*app111.com', '*orsoon.com', '*sdbluepoint.com', '*xluo.com', '*jjzad.com', '*kuakao.com', '*playhaven.com', '*china-fun.net', '*shupeng.com', '*qiyi.com', '*vanclimg.com', '*etpass.com', '*ekan.tv', '*tuidian.net', '*feifeicms.com', '*wefinder.com', '*dianjing.org', '*hichina.com', '*lvren.com', '*alloyteam.com', '*cdndelivery.com', '*bikesky.com', '*126.am', '*mytv365.com', '*120.net', '*bdlrl.com', '*neworldedu.org', '*82a.net', '*xiumu.org', '*uwowo.com', '*mi1.cc', '*m1905.com', '*denglu.cc', '*gamebean.net', '*jywkj.com', '*444mmm.com', '*oiegg.com', '*chinacache.net', '*iciba.com', '*hzbike.com', '*qqride.com', '*losezone.com', '*sosuo.name', '*ddove.com', '*luoxiaoge.com', '*keepc.com', '*iwanpc.com', '*xy9z.com', '*sypopo.com', '*hnweijia.com', '*gotoip55.com', '*woiring.com', '*itpub.net', '*zijieshe.com', '*szonline.net', '*my0511.com', '*lw23.com', '*nuomi.com', '*imglafaso.com', '*ljob.net', '*ziyou.com', '*imyquan.com', '*766.com', '*wotfan-guangzhou.com', '*shendu.com', '*ellechina.com', '*360top.com', '*data.gg', '*yimeiads.com', '*iqilu.com', '*shmeijing.net', '*infinitinb.net', '*htwx.net', '*china-pub.com', '*leaderhero.com', '*suki.so', '*inmobi.com', '*engkoo.com', '*abc68888.com', '*haerbin.org', '*mychinahr.com', '*t3life.com', '*soooner.com', '*nvren3.com', '*yizitong.com', '*yiwatch.net', '*jonahome.net', '*upyun.com', '*ssjpx.com', '*jinti.com', '*fk-union.com', '*nduoa.com', '*jqbyby.com', '*zhijinfc.com', '*itnews001.com', '*anquanbao.com', '*win7china.com', '*microchip.com', '*ccrun.com', '*ykimg.com', '*marriott.com', '*looyu.com', '*lampbo.org', '*51wnl.com', '*wuyou.la', '*devexpresscn.com', '*xdcdn.net', '*linuxeden.com', '*linezing.com', '*tuchong.net', '*ilite.me', '*paowang.net', '*tihu.cc', '*dou00.com', '*1kapp.com', '*chinamusical.net', '*pinshan.com', '*p5w.net', '*intercontinental.com', '*ptbus.com', '*nulmart.com', '*maiyadi.com', '*dy2018.com', '*duoyi.com', '*chinadrtv.com', '*holidayinn.com', '*vista123.com', '*jyeoo.net', '*bwchinese.com', '*xzscd.com', '*suning.com', '*dospy.org', '*googpc.com', '*whlmjy.com', '*meishow.com', '*kdhome.net', '*cngba.com', '*didaimg.com', '*iqshw.com', '*egouz.com', '*razxc.com', '*dtcec.com', '*qinglajiao.net', '*womenwan.com', '*hz0752.com', '*ipinggou.com', '*sanfo.com', '*nikefans.com', '*585.com', '*wauee.com', '*01lm.com', '*lohasus.com', '*xigutang.com', '*pubsage.com', '*tudou.com', '*99read.com', '*breadtrip.com', '*cntgol.com', '*hui800.net', '*yesmyimg.com', '*kandian.net', '*qqttxx.com', '*bokee.net', '*shenyangbus.com', '*robinzhu.com', '*itruelife.com', '*zhouwenyi.com', '*dwstatic.com', '*ali213.net', '*jmstatic.com', '*zdic.net', '*lotpen.com', '*ajiang.net', '*aliued.com', '*pc30.com', '*sheying8.com', '*uservod.com', '*longwiki.net', '*cztour.com', '*sheca.com', '*pzh123.com', '*star8.net', '*yanzheng.com', '*hualongxiang.com', '*soupingguo.com', '*lvping.com', '*gsdwj.com', '*8chuang.com', '*ourtra.com', '*ymail.com', '*bstatic.com', '*ums.bz', '*littlewriter.org', '*tangsuanradio.com', '*jmenren.com', '*xiannixiaozhu.com', '*fulun.org', '*waduanzi.com', '*360buyimg.com', '*yigandci.com', '*aisandi.com', '*2008php.com', '*lti-china.com', '*modxz.com', '*kongfz.com', '*zmdhw.com', '*juedui100.com', '*sogou.com', '*ttmouse.com', '*5sing.com', '*chinaelections.org', '*imshell.com', '*irs01.net', '*hsuho.com', '*yokacdn.com', '*winekee.com', '*egoedu.com', '*denglu.mobi', '*99vk.com', '*ffsky.com', '*ttkuu.com', '*yoqoo.com', '*kqzyfj.com', '*ihanker.com', '*614mm.com', '*hwpan.com', '*nvrenfang.com', '*bjsdfz.com', '*testflightapp.com', '*21ic.com', '*wangyeba.com', '*mianfeiqiang.com', '*17k.com', '*btbbt.com', '*515tv.net', '*autobloglink.com', '*ssgo.com', '*wanwang.com', '*ppurl.com', '*yuexiaodao.com', '*dvdba.cc', '*googlesyndication.com', '*jobbole.com', '*chinatibetnews.com', '*e2.ma', '*sodu.org', '*baiheee.com', '*zypfsc.com', '*18dao.net', '*duiduila.com', '*xsmi.org', '*edutime.net', '*aipai.com', '*jq-school.com', '*gouwula.net', '*66vod.net', '*82623.com', '*aceen.com', '*qiyadeng.com', '*smartisanos.com', '*9610.com', '*yiwad.com', '*9519.net', '*chujian.com', '*029gc.net', '*64365.com', '*theooxx.com', '*ct10000.com', '*dtgt.org', '*fatianxia.com', '*zh-114.com', '*du8.com', '*jueshitangmen.info', '*jxdyf.com', '*cocimg.com', '*wtt365.com', '*cmfu.com', '*168bx.com', '*guoxue123.com', '*ushihui.com', '*zhangguibang.com', '*3gbbs.com', '*hogame.com', '*vgm8.com', '*cpm360.com', '*meile.com', '*xxbh.net', '*wiisocl.com', '*iask.com', '*hoopchina.com', '*8791.com', '*51jobcdn.com', '*eduwo.com', '*renji.com', '*guolun.net', '*my-graphics.net', '*onhoo.com', '*chinapet.com', '*868e.com', '*wontube.com', '*userplane.com', '*madeye.me', '*cngold.org', '*hichinaimg.com', '*sinos.name', '*elpisafe.com', '*sowang.com', '*e1htstatic.com', '*doudou360.com', '*hupan.com', '*iouter.com', '*totoolaw.com', '*111cn.net', '*139001.net', '*hunantv.com', '*citygf.com', '*mxhichina.com', '*zlg.cc', '*ynet.com', '*lifevc.com', '*musiceol.com', '*oobeta.com', '*miaozhen.com', '*et8.net', '*webterren.com', '*400gb.com', '*wanlibo.com', '*51gxqm.com', '*img-cdn.biz', '*lyncplus.net', '*loli.my', '*55522.com', '*chddh.com', '*360doo.com', '*fswzz.com', '*cnchu.com', '*chinaw3.com', '*njlongre.com', '*letao134.com', '*pingan.com', '*95881.com', '*fetion-portal.com', '*taobao.com', '*epweike.com', '*ihushcdn.com', '*wselearning.com', '*triacebike.com', '*hnair.com', '*egreatworld.com', '*ze5.com', '*59n.net', '*mapbar.com', '*263.net', '*btsmth.com', '*cjhospital.com', '*pku-exploit.com', '*xiaoqianbao.com', '*hqdoor.com', '*zastatic.com', '*chinaunix.net', '*cctvpic.com', '*62001188.com', '*chinese-cp.com', '*2345sc.com', '*ztgame.com', '*aixueyou.com', '*62mi.com', '*redocn.com', '*digicert.com', '*wangzhi800.com', '*acs86.com', '*027art.com', '*kanshu.com', '*redekuai.com', '*55bbs.com', '*onease.com', '*mxwz.com', '*qstatic.com', '*tianyayidu.com', '*liuhuadong.com', '*77bike.com', '*danhuaer.com', '*seedit.com', '*26552.com', '*zasv.com', '*e-3lue.com', '*sunhenry.com', '*lezi.com', '*mzstatic.com', '*bhfj.com', '*mideatuan.com', '*ggpht.com', '*djkk.com', '*pgpop.com', '*pinglaoshi.com', '*5khouse.com', '*koxab.com', '*victorykingdom.com', '*maijiago.com', '*waysoo.com', '*pocketres.com', '*chiphell.com', '*channelray.com', '*alibaba-inc.com', '*ybkf999.com', '*dajuyuancn.com', '*ufstone.com', '*gucheng.net', '*icson.com', '*tl100.com', '*tj0573.com', '*815x.com', '*ysedu.org', '*prnasia.com', '*3023.com', '*hellodm.com', '*toutiao.com', '*soiseek.com', '*guohead.com', '*cngoldres.com', '*digtalinfo.com', '*yundasys.com', '*ooxx.com', '*uuzuonline.com', '*8j.com', '*fengniao.com', '*zhizhizhi.com', '*ledabuy.com', '*newhua.com', '*tuigoo.com', '*carschina.com', '*oschina.net', '*nextsee.com', '*wizbag.com', '*admin-cn.com', '*fengyunzhibo.com', '*kuqi.com', '*365hch.net', '*ctrlv.cc', '*dianji007.com', '*uya100.com', '*tuku.com', '*applex.net', '*9133.cc', '*xifuquan.com', '*starming.com', '*china.com', '*qq.com', '*baotime.com', '*fengbao.com', '*yaziwu.com', '*pimei.com', '*is686.com', '*yintai.com', '*lakala.com', '*koudai.com', '*gouhaokan.com', '*dangzhi.net', '*aicdn.com', '*dianjoy.com', '*yoyi.tv', '*s-msn.com', '*roxcdn.com', '*sinastorage.com', '*recordjapan.net', '*yunio.com', '*fitnesity.com', '*xn--4xuw73h.com', '*hp009.com', '*u17.com', '*beitaichufang.com', '*pb89.com', '*chadongche.com', '*jbedu.net', '*zoossoft.com', '*ceair.com', '*gameee.net', '*hoolo.tv', '*yundaex.com', '*haozip.com', '*artron.net', '*xapcn.com', '*lm-pk.com', '*codante.org', '*sun0816.com', '*chunyuyisheng.com', '*zhzzx.com', '*sxslyxx.net', '*ourcrack.com', '*foyuan.net', '*t88u.com', '*weico.net', '*271234.com', '*misbuy.com', '*llfzgs.com', '*fairchildsemi.com', '*dictall.com', '*viglink.com', '*waipojia.com', '*uc123.com', '*9buo.com', '*wygl.net', '*016788.com', '*rxwan.com', '*hacow.me', '*stvba.com', '*5q.com', '*jinjiangsoft.com', '*renren.it', '*piaohua.com', '*edancing.net', '*communicatte.com', '*1g1g.com', '*dprktimes.com', '*banggo.com', '*pingwest.com', '*killman.net', '*phpchina.com', '*gamecomb.com', '*tbhelper.com', '*ku6img.com', '*nongmin86.com', '*ebaystatic.com', '*kdnet.net', '*yunfeida.com', '*junshishu.com', '*zhuansoo.com', '*yieldmanager.net', '*ttkvod.com', '*duowan.com', '*auto98.com', '*beta3pro.com', '*haoring03.com', '*colourhill.com', '*51you.com', '*jiai-sh.com', '*luxst.com', '*fumanhua.com', '*pku-hall.com', '*sojump.com', '*tsmil.com', '*dfcfw.com', '*ad51.net', '*beihai365.com', '*zbjd.net', '*meizu.com', '*jbxue.com', '*yougou.com', '*imanhua.com', '*setways.com', '*papa.me', '*kouchou.com', '*aee.com', '*easternmiles.com', '*zsbike.net', '*hqbcdn.com', '*asktu.com', '*aibang.com', '*eecer.com', '*tehuiju.com', '*cmdn.net', '*easou.com', '*imgii.com', '*staticsdo.com', '*airasia.com', '*tuniucdn.com', '*cric.com', '*made-in-china.com', '*madserving.com', '*bohaishibei.com', '*paopaoche.net', '*xabpo.com', '*ppseek.com', '*s1979.com', '*xyj.im', '*china-cycle.com', '*qdmm.cc', '*theutlab.com', '*shuiliwai.com', '*dospy.com', '*52fuqing.com', '*yesky.com', '*kanvcd.cc', '*iboxpay.com', '*jiaren.org', '*yohobuy.com', '*pinggu.com', '*1shangyu.com', '*weibo008.com', '*guao.cc', '*ikeepu.com', '*geekpark.net', '*020883.com', '*ichotelsgroup.com', '*baicizhan.com', '*ihg.com', '*chinacrane.net', '*huoxingyu.com', '*21cbh.com', '*kk98.com', '*fnms.tv', '*8wss.com', '*lesmiz.net', '*517zjy.com', '*vmvps.com', '*shanghai-air.com', '*zhujiangroad.com', '*xzk.me', '*ibeipai.com', '*hdslb.org', '*babytreeimg.com', '*pc841.com', '*liketry.com', '*avfline.com', '*chinajci.com', '*mojichina.com', '*miaozhenjiang.com', '*cooguo.com', '*iqsuperman.net', '*1lo0.net', '*ebiaoegou.com', '*fadu.cc', '*bjjgyy.com', '*qplus.com', '*zhibo8.cc', '*gzmama.com', '*3444.cc', '*dongfangshenyun.com', '*myqqface.net', '*redvi.com', '*eeloves.com', '*handyui.com', '*facejoking.com', '*haha.mx', '*hommk.com', '*qqread.com', '*paidai.com', '*open-open.com', '*ppnba.net', '*zj123.com', '*mimiduo.com', '*xici.net', '*zgoff.com', '*ftp', '*chinese-luxury.com', '*mmonly.com', '*tbjfw.com', '*line0.com', '*livefilestore.com', '*taoxiaobao.net', '*272768.com', '*ttmeishi.com', '*cairot.com', '*cnwest.com', '*raiyi.com', '*artemisbuzz.com', '*beisen.com', '*ccgslb.net', '*601819.com', '*fx678.com', '*btui.it', '*congweng.com', '*asiamiles.com', '*u17i.com', '*weibolook.com', '*inews.io', '*ps123.net', '*sijimishu.com', '*lianzidi.com', '*epubook.com', '*shu0.net', '*designtotalk.com', '*bjjgnk.com', '*7890dy.com', '*dongshizhongyi.com', '*hd2pt.com', '*googleusercontent.com', '*3gsha.com', '*lccz.com', '*0931007.com', '*camgle.com', '*amazon.com', '*yunpdf.com', '*jakrooshop.com', '*airasiago.com', '*jxedt.com', '*ptrss.com', '*zhiwo.com', '*zhaogepu.com', '*storagechina.net', '*dx888.com', '*qvod.com', '*quanzhi.com', '*51lunwen.com', '*meiliworks.com', '*piaoliang.com', '*founderbn.com', '*ktwxchina.com', '*5432168.com', '*tomipad.com', '*2000tuan.com', '*newsmy.com', '*yolk7.com', '*china360.org', '*entitlenow.com', '*haobao.com', '*infothinker.com', '*dm08.com', '*tqlkg.com', '*189share.com', '*jinjianginns.com', '*linuxdeepin.com', '*exbib.net', '*jxcycling.com', '*ixpub.net', '*ntalker.com', '*zhaopin.com', '*53shop.com', '*csbew.com', '*pcbeta.net', '*arpun.com', '*blogjava.net', '*windsad.com', '*freehao123.com', '*178.com', '*suorang.com', '*0577bike.com', '*optimizely.com', '*woxihuan.com', '*0-6.com', '*haodianpu.com', '*duomi.com', '*qqtv123.com', '*tdpress.com', '*fanhuai.com', '*rexsong.com', '*ibeidou.net', '*titan24.com', '*dipan.com', '*114la.com', '*samboc.com', '*huaweidevice.com', '*14696.com', '*historykingdom.com', '*chinaefu.net', '*9see.com', '*haodics.com', '*xlobo.com', '*mycolorway.com', '*ccluxy.com', '*3987.com', '*ktvc8.com', '*u148.net', '*zqgame.com', '*yxlady.com', '*168sucai.com', '*91town.com', '*998.com', '*chinaitlab.com', '*cjxtv.com', '*kang3.com', '*maijiatang.net', '*fantong.com', '*gzcycling.com', '*hflash.com', '*byox.org', '*adsmogo.org', '*bankofchina.com', '*tuijian.tv', '*soku.com', '*supplyframe.com', '*venusveil.com', '*sobey.com', '*bznx.net', '*pp.cc', '*dssg.net', '*xiaomishu.com', '*examw.com', '*tblfans.com', '*chm-pdf.com', '*versusio.com', '*yxcpm.com', '*idlphone.com', '*amobbs.com', '*li.vc', '*zbii.com', '*itezhop.com', '*jocgreatwall.com', '*eduzhai.net', '*3e008.com', '*chinabreed.com', '*blogcdn.com', '*gdcrj.com', '*mukkyu.com', '*colorweekly.com', '*q88j.net', '*zyue.com', '*superboss.cc', '*qixingquan.com', '*99manga.com', '*tv365.cc', '*ffdy.cc', '*flash8.net', '*ekoooo.com', '*changba.com', '*blogbuscdn.com', '*bjbtg.net', '*linkchic.com', '*muduobt.com', '*woshipm.com', '*ivsky.com', '*51test.net', '*goalchina.net', '*xmf4.com', '*porntube.com', '*tigercity.net', '*intsig.net', '*arsenalcn.com', '*digi-uniclick.net', '*brassring.com', '*chinaren.com', '*flyertea.net', '*uodoo.com', '*56imgs.com', '*taodianzhang.net', '*ifengimg.com', '*movshow.com', '*minshengnet.com', '*ld160.com', '*showall.me', '*haodic.com', '*youxitui.net', '*guofs.com', '*51youwei.com', '*statickksmg.com', '*babidou.com', '*igoodsoft.net', '*kiwi66.com', '*as-doll.com', '*uwen.com', '*bohe.com', '*cfind.com', '*shgjj.com', '*hubike.com', '*cnielts.com', '*rongshuxia.com', '*fanli7.net', '*aqioo.com', '*spermwindow.com', '*battle.net', '*danlan.org', '*shentime.com', '*greencompute.org', '*tao30.com', '*58pic.com', '*kkkmh.com', '*soufun.com', '*anhuinews.com', '*kugou.com', '*wobo.tv', '*3393.com', '*erke.com', '*njupco.com', '*gasshow.com', '*singaporeair.com', '*hkzhan.net', '*dajieimg.com', '*cndns.com', '*jianfei.com', '*cdc.im', '*gooseeker.com', '*wei2008.com', '*sfbest.com', '*51piaobo.com', '*ushi.com', '*xiecheng.com', '*liba.com', '*kekenet.com', '*chenxudong.com', '*alipay.com', '*xa01.cc', '*456.net', '*kongfz.cc', '*ppsdy.com', '*4738.com', '*tankeyouxi.com', '*idcquan.com', '*ithaowai.com', '*vistachinese.com', '*52liunian.com', '*usousou.com', '*bjwj2y.com', '*jd-bbs.com', '*qqzz0.com', '*epac.to', '*dopa.com', '*meetinware.com', '*qzoner.net', '*niunu.com', '*googleapis.com', '*china-ef.com', '*to360.com', '*bjsubway.com', '*opengit.org', '*cdnzz.com', '*ajkcdn.com', '*mdayday.com', '*uzai.com', '*abaxhw.com', '*flacai.com', '*ihush.com', '*aibangjuxin.com', '*cook100.com', '*ncigou.com', '*whdafei.com', '*chinaz.com', '*yazuo.com', '*keaiju.com', '*china-weiwei.com', '*wswire.com', '*nvidia.com', '*xc158.com', '*jindouyun.com', '*feeyo.com', '*zgsflt.com', '*njdfwb.com', '*cc222.com', '*wm-it.com', '*cy.com', '*ducms.com', '*4px.com', '*jarford.com', '*tuyansuo.com', '*lanfw.com', '*pkueap.com', '*xiaojukeji.com', '*wayoulegal.com', '*itugo.com', '*aliexpress.com', '*qiqibudy.com', '*rigodesign.com', '*tuhao.cc', '*kuaiwan.com', '*zg-sj.com', '*themex.net', '*anywlan.com', '*longene.org', '*songshubnb.com', '*ehappystudy.com', '*giant.so', '*norislam.com', '*daqi.com', '*kanglu.com', '*xmfish.com', '*169hao.com', '*witsee.com', '*topcased.org', '*billwang.net', '*qunar.com', '*cfl.org', '*ncxhw.com', '*zhiyue.me', '*zhaojiaxiao.com', '*cjolimg.com', '*fashiontrenddigest.com', '*ppren.com', '*linsports.com', '*ceshiguang.com', '*leexa.org', '*42qu.com', '*sysujwxt.com', '*ci123.com', '*usvisadream.com', '*doc88.com', '*qzoner.com', '*kwvdp.com', '*0592sl.com', '*shiwan.com', '*aoyou.com', '*southcn.com', '*yszyz.com', '*guoku.com', '*folkw.com', '*xphlxj.com', '*xjquc.com', '*jtmm.com', '*caxit.com', '*babycenter.com', '*8264.com', '*05wan.com', '*qyer.com', '*gao7.com', '*jjlg.net', '*cbgnews.com', '*mbsimg.com', '*newmov.com', '*xueleku.com', '*wanmei.com', '*mangocity.com', '*thunderex.com', '*azpan.com', '*oeeee.com', '*tower.im', '*kingdee.com', '*cdndm.com', '*cbn.me', '*shahejiuye.com', '*bendibao.com', '*gzeeu.com', '*cnconfucius.com', '*upaiyun.com', '*rayche.cc', '*666ccc.com', '*buy2046.com', '*feichang.com', '*sopopo.com', '*ing2ing.com', '*tuanimg.com', '*chasedream.com', '*cisco.com', '*chinanetcenter.com', '*elecfans.com', '*htsec.com', '*kkkwww.com', '*chinaunionpay.com', '*baidu.com', '*zeda100.com', '*gaopeng.com', '*xiaomi.net', '*xp911.com', '*qqfacebox.com', '*esqimg.com', '*657.com', '*973.com', '*yingjiesheng.net', '*dm5.com', '*younet.com', '*fengyx.com', '*tuzhan.com', '*buyfine.net', '*cnzjqi.com', '*lawtimeimg.com', '*cnhan.com', '*ibangkf.com', '*wopti.net', '*baidu-tech.com', '*126.fm', '*lxdns.com', '*86qt.com', '*bibi168.com', '*mtimeimg.com', '*114piaowu.com', '*tctd.net', '*ithome.com', '*haogongju.net', '*taotantan.org', '*idc8888.com', '*stockstar.com', '*51.la', '*cndw.com', '*elemecdn.com', '*36kr.net', '*miaov.com', '*qdcdn.com', '*lady8844.com', '*5lux.com', '*1198.com', '*shoujipc.net', '*weixueyuan.net', '*journeyformac.com', '*yixieshi.com', '*s-msft.com', '*donews.net', '*yqdown.com', '*cebbank.com', '*0532gc.com', '*hustonline.net', '*all.my', '*babyfamily.com', '*chinaevent.org', '*vrbrothers.com', '*amazingstore.org', '*youboy.com', '*zghtpc.com', '*9yls.net', '*busiphi.com', '*pipicms.info', '*139life.com', '*ruixuesoft.com', '*cjol.com', '*thmz.com', '*deppon.com', '*mangdian.com', '*chinaui.com', '*gkstk.com', '*hyj.com', '*adminzu.com', '*talkyun.com', '*qqgameapp.com', '*haosucai.com', '*alibaba.com', '*xd.com', '*shyuou.com', '*yanghuaren.com', '*99ys.com', '*vsharing.com', '*welefen.com', '*bz55.com', '*xiyanghui.com', '*8684.com', '*newclasses.org', '*55haitao.com', '*puata.info', '*daningdaning.com', '*jjsop.com', '*2975.com', '*bzbao.com', '*qqmail.com', '*50mk.com', '*fs-mall.com', '*koolbao.com', '*ttjk.com', '*sanguosha.com', '*kshot.com', '*yingjiesheng.com', '*maijsoft.com', '*17donghua8.com', '*yimuhe.net', '*023dg.com', '*wpxap.com', '*58cn.com', '*123cha.com', '*registermsg.com', '*openxid.com', '*huzhulu.com', '*5211game.com', '*powerrsoft.com', '*solaridc.com', '*globalmi.com', '*360zebra.com', '*qd-mh.com', '*centrmus.com', '*1t1t.com', '*dongxi.net', '*imageaimer.com', '*aixie.org', '*deviantart.net', '*sinaapp.com', '*img-space.com', '*chinesehotels.org', '*ximalaya.com', '*blogcn.com', '*cwddd.com', '*68design.net', '*gwxdn.com', '*yixiao.net', '*ulink.cc', '*pc6.com', '*taobaombaobao.com', '*gotocdn.com', '*12dian.com', '*tetimes.com', '*pv.cc', '*iphonespirit.com', '*lecai.com', '*500wan.com', '*ilitu.com', '*sonkwo.com', '*digieq.com', '*amznz.com', '*12580.com', '*shusp.com', '*becoding.com', '*25renti.com', '*51gugu.com', '*wangpiao.com', '*haogo365.com', '*ppaaol.com', '*gucunpark.net', '*6dad.com', '*ihao.net', '*567ys.com', '*dbs01.net', '*51gongsi.net', '*fanmanhua.com', '*52miji.com', '*amlady.com', '*tjj.com', '*yododo.com', '*mbalib.com', '*bengou.com', '*162cm.com', '*fcchbj.com', '*yinsha.com', '*ptshow.net', '*ganniu.com', '*penbbs.com', '*wulian.cc', '*wjwcn.com', '*emaildaquan.com', '*321tq.com', '*zzhtm.com', '*staybridge.com', '*qiche8.net', '*xjktarena.com', '*silverlightchina.net', '*scorecardresearch.com', '*admin5.com', '*liangao.com', '*gotoip4.com', '*edu24ol.com', '*3g3h.com', '*qianlong.com', '*njgydz.com', '*weathercn.com', '*feedsky.com', '*51xiyy.com', '*readself.com', '*ksyun.com', '*rdtarena.com', '*fushipifa.com', '*kaibei.com', '*88dev.com', '*zhaoii.com', '*ttout.com', '*wasu-umedia.net', '*4yt.net', '*windowsphone.com', '*tx8cdn.com', '*imnettle.net', '*gridsumdissector.com', '*tuanjiebao.com', '*wechatapp.com', '*ik22.com', '*imuyang.com', '*chinawlan.net', '*atmami.com', '*maybellinechina.com', '*onetad.com', '*tw-17.com', '*ziyuan5.com', '*so.com', '*tongbu.com', '*azureblu.net', '*61658.com', '*dzsc.com', '*xixianad.com', '*54whr.com', '*weico.com', '*chedingjia.com', '*fx120.net', '*98766.org', '*qire123.com', '*yeedou.com', '*likeface.com', '*j1.com', '*xiaoshoubang.org', '*panghufei.com', '*webkaka.com', '*jiuyan.info', '*chinagba.com', '*book118.com', '*discuz.org', '*37cs.com', '*cat898.com', '*ankangwang.com', '*bulaoge.net', '*xhby.net', '*dianpu360.net', '*gvod.net', '*qqmom.com', '*kvov.org', '*btstatic.com', '*ourgame.com', '*52digital.com', '*hi-pda.com', '*optimix.asia', '*630mm.com', '*linuxtone.org', '*zidiantong.com', '*taoecshop.com', '*kdweibo.com', '*yeswan.com', '*artsbj.com', '*huaxi100.com', '*oy66.com', '*hujiang.com', '*qinyegc.com', '*ksstjxx.com', '*cunan.com', '*ooxxnow.com', '*jiepang.com', '*officefans.net', '*do93.com', '*depela.com', '*west369.com', '*zhongliangwomai.com', '*aoshitang.com', '*erji.com', '*koubei.com', '*3608.com', '*kankanews.com', '*cm-analysis.com', '*glzy8.com', '*ebookcn.com', '*woshihaizeimi.com', '*ganjistatic1.com', '*139qh.com', '*24mijie.com', '*wowsai.com', '*lingshi.com', '*19lou.com', '*elvxing.net', '*yanghua.net', '*jjwxc.net', '*quanmama.com', '*265.com', '*bd365.net', '*high-hope.com', '*otomedream.com', '*readnovel.com', '*sdo.com', '*720pmovie.com', '*yhachina.com', '*szhk.com', '*0713hb.com', '*airchina.com', '*waveshare.net', '*lyina.com', '*chinaiiss.com', '*yadian.cc', '*fanren8.com', '*tedabike.com', '*guomii.com', '*furuise.com', '*ninikan.com', '*ixiqi.com', '*c9cc.com', '*takungpao.com', '*muzhiwan.com', '*cy1990.com', '*fireemblem.net', '*chinaaudio.net', '*houxue.com', '*cs090.com', '*jfdaily.com', '*shcwhj.com', '*chromeplus.info', '*pmume.com', '*whjxw.com', '*scdxs.net', '*marila.net', '*sbnation.com', '*daysmatter.com', '*bdimg.com', '*c-ctrip.com', '*100ye.com', '*gkcity.com', '*e393.com', '*5cs5.com', '*alicdn.com', '*xueersi.org', '*zoeou.com', '*8877.cc', '*dxycdn.com', '*bjjgfk.com', '*takstar.com', '*ecqun.com', '*ccidnet.com', '*hx9999.com', '*tingchina.com', '*fancdn.com', '*med126.com', '*taoche.com', '*apesk.com', '*52pk.com', '*whwd.com', '*ucren.com', '*csjci.com', '*excelhome.net', '*kk7kk.com', '*bbk.com', '*shaibaoj.com', '*198958.com', '*qukk8.com', '*yiyi.cc', '*yeeyan.com', '*che168.com', '*tuan800.net', '*javaeye.com', '*21cbr.com', '*njtarena.net', '*isoyes.com', '*element14.com', '*9158.com', '*17446.com', '*lncdc.com', '*97775.com', '*5imx.com', '*plealife.com', '*007.mx', '*ob178.com', '*imagchina.com', '*yximgs.com', '*xmhouse.com', '*metroerimg.com', '*xianguo.com', '*gridsum.com', '*zhangku.com', '*ylimg.com', '*taoxtao.com', '*chinayigou.com', '*125p.com', '*cugala.com', '*ottnt.com', '*51yala.com', '*ckd8.com', '*kd1000.com', '*img-cdn.com', '*269.net', '*tianping.com', '*redhat.com', '*hftogo.com', '*iyiyun.com', '*rrcheck.com', '*chinaqos.com', '*pianzi8.com', '*aifreedom.com', '*fjce.com', '*kaoyan.com', '*ccpittex.com', '*appleifan.com', '*tkurl.com', '*fangce.net', '*4q8q.com', '*qiandaohu.cc', '*ml90.com', '*fimmu.com', '*qunarzz.com', '*cootek.com', '*freebsdchina.org', '*meizu.net', '*lekan.com', '*hao2018.com', '*jimu.tv', '*wowoj.com', '*tutuapp.com', '*52hxw.com', '*gamersky.com', '*myzcm.com', '*shenzhenair.com', '*lvse.com', '*108du.com', '*chinanews.com', '*taotantan.com', '*pandafan.org', '*xindou.com', '*demohour.com', '*wiwide.com', '*jz5u.com', '*3361.com', '*guaguapic.com', '*xitek.net', '*k1982.com', '*leeang.com', '*hytool.net', '*belle8.com', '*cqjy.com', '*pps.tv', '*8l8e.com', '*fangtoo.com', '*pbcdn.com', '*iyaya.com', '*dbank.com', '*hbtvtswc.com', '*dddddd.net', '*sjjia.com', '*weihepan.com', '*77vcd.com', '*ingping.com', '*leiphone.com', '*a9vg.com', '*monteamor.com', '*lmmob.com', '*wj-hospital.com', '*5251.net', '*emjcd.com', '*youxiaxiazai.com', '*coudoudou.com', '*tulezijia.com', '*jiathis.com', '*fenxi.org', '*hrloo.com', '*8le8le.com', '*staticflickr.com', '*fenghaibin.com', '*youtx.com', '*ename.net', '*800pharm.com', '*uusee.com', '*u17t.com', '*bladechina.net', '*ugoooo.com', '*upai.com', '*tdimg.com', '*motiancity.com', '*digitalchina.com', '*ilepai.com', '*qiewo.com', '*diudou.com', '*33wan.com', '*dewen.org', '*novel-supertv.com', '*kaifu.com', '*yyyqc.com', '*aliyuncdn.com', '*yoloho.com', '*kuqin.com', '*haha168.com', '*cnzyzw.net', '*vmiandan.com', '*paixie.net', '*daddymugs.com', '*twimg.com', '*angelcrunch.com', '*haizhangs.com', '*51g3.com', '*jk365.cc', '*emoilife.com', '*gd560.com', '*biketo.com', '*taisha.org', '*hkzhan.com', '*ruyi.com', '*yeeaoobox.com', '*szyljkw.com', '*tangshi.org', '*tpooo.com', '*17mh.com', '*365ta.com', '*7fgame.com', '*dedeadmin.com', '*jsinfo.net', '*w3help.org', '*daizhicun.com', '*lbs8.com', '*sh3f.com', '*jdunion.com', '*tgljw.com', '*wolfgo.com', '*kandajia.com', '*tiaohao.com', '*eduuu.com', '*chinaticket.com', '*erji.net', '*neubt.com', '*9yao.com', '*989game.com', '*pplive.com', '*manmanbuy.com', '*app-sage.com', '*wenwo.com', '*51voa.com', '*easyicon.net', '*dgtle.com', '*81999999.com', '*pkurc.com', '*kylin-os.com', '*0577net.com', '*gamebar.com', '*jing.fm', '*sosohaha.com', '*51php.com', '*piaowudawang.com', '*luren.cc', '*nanren8.com', '*apinpai.com', '*duobei.com', '*sodao.com', '*rrhjz.org', '*piao.com', '*jsharer.com', '*naver.com', '*koowo.com', '*bjhd.org', '*hclfm.com', '*ufrun.com', '*joyinwise.com', '*cangbaotu.org', '*aobi.com', '*pengyou.com', '*tgfcer.com', '*huanleguang.com', '*cmbchina.com', '*zampda.net', '*yjbys.com', '*jmvod.com', '*xunzai.com', '*triace768.com', '*idclicks.com', '*xiaomi.com', '*piaobuy.com', '*qiyou.in', '*luo.bo', '*55tuanimg.com', '*agrantsem.com', '*hsdcw.com', '*youbo.cc', '*gezila.com', '*ycwb.com', '*mftp.info', '*52831.com', '*html5china.com', '*6885.com', '*51honest.org', '*cnrdn.com', '*lidroid.com', '*egooad.com', '*easytimetv.com', '*okbuy.com', '*nba.com', '*qsanguosha.org', '*daxi123.com', '*igao7.com', '*facishare.com', '*veryapps.com', '*yidianda.com', '*lduhtrp.net', '*huochepiao.com', '*huohua.tv', '*91.com', '*gangker.com', '*ipc.me', '*qianpin.com', '*xizi.com', '*gzlm.net', '*shuangtv.net', '*yninfo.com', '*ycool.com', '*anjia365.com', '*cdn-apple.com', '*365exam.com', '*manyou.com', '*chexun.net', '*apphope.com', '*zjhyad.com', '*wnc8.com', '*yoox.biz', '*ayawawa.com', '*chinavip8.com', '*unishoot.com', '*lawyersky.net', '*axis.com', '*qu114.com', '*tech-food.com', '*yykc.com', '*gzonet.com', '*y5zone.net', '*kfcyouhui.com', '*zolsky.com', '*image-gmkt.com', '*mackong.com', '*cnrepair.com', '*uedmo.com', '*mingdao.com', '*hificat.com', '*webppd.com', '*g365.net', '*52blackberry.com', '*dfdaily.com', '*hou.im', '*aqee.net', '*588885.com', '*tdzyw.com', '*eywedu.org', '*dh911.com', '*jtfk365.com', '*huotu.com', '*handuyishe.com', '*910game.com', '*jianguoyun.com', '*dxy.com', '*x5858.com', '*coolapk.com', '*55joo.com', '*taizhou.name', '*egaobo.com', '*the9.com', '*uuu9.com', '*7794lm.com', '*9you.com', '*reutersnext.com', '*diytrade.com', '*ehaier.com', '*sd173.com', '*liuweispace.com', '*dayeteng.com', '*566game.com', '*expo2013.net', '*xiu.com', '*gongchang.com', '*bankofshanghai.com', '*win8china.com', '*51wan.com', '*chana-mazda.com', '*tweetmarker.net', '*12306.com', '*openedv.com', '*imocha.com', '*romzj.com', '*findlawimg.com', '*cikuapp.com', '*zssns.com', '*hdtdxp.com', '*057s.com', '*fei580.com', '*tuniu.com', '*1688.com', '*kuboluo.com', '*utourworld.com', '*cnzz.net', '*totoo.org', '*591wed.com', '*cnerent.com', '*lqualyn.com', '*myzaker.com', '*ttpod.com', '*hotof.com', '*coolxap.com', '*51wcity.com', '*usportnews.com', '*zjgzx.com', '*neusoft.com', '*qiushibaike.com', '*zuibaike.com', '*hibbers.com', '*yktworld.com', '*51app.com', '*csdt.net', '*beiwaionline.com', '*ys168.com', '*liuxue360.com', '*gc73.com', '*17u.net', '*snsfun.cc', '*90hu.com', '*makepic.net', '*go2eu.com', '*beifangjiaxiao.com', '*yxwang.me', '*anqu.com', '*mmstat.com', '*dvdspring.com', '*66ys.cc', '*99mh.com', '*nvsheng.com', '*luzhou.net', '*huaxia.com', '*pkugym.com', '*csdn.com', '*lusongsong.com', '*hbzkw.com', '*bubukua.com', '*qqywf.com', '*lieguo.com', '*fei580.net', '*gdstudent.com', '*cjbyby.net', '*cxdq.com', '*83000000.com', '*photo0086.com', '*funet8.com', '*239buy.com', '*yunkeji.com', '*icouple.com', '*tiexinbuy.com', '*ballpure.com', '*juqi.com', '*mangafiles.com', '*youxi115.com', '*jinbeifang.com', '*yizhedian.com', '*yaohonglou.com', '*yongyibook.com', '*shuishuier.com', '*zorpia.com', '*am-img.com', '*thethirdmedia.com', '*cheshi.com', '*soudianhua.com', '*ttsunion.com', '*appchina.com', '*mysteel.com', '*haoting.com', '*jnmama.com', '*foodmate.net', '*21tx.com', '*yobai.net', '*adkongjian.com', '*zwads.com', '*iwatch365.net', '*2cto.com', '*lenovomobile.com', '*jcxinxi.com', '*libdd.com', '*bookuu.com', '*jmsyzj.com', '*chinalawinfo.com', '*copyvalue.com', '*baofan.org', '*langtaojin.com', '*elong.net', '*xp9365.com', '*yodo1.com', '*usashopcn.com', '*bs008.com', '*989web.com', '*laiercn.com', '*goodyule.com', '*htexam.net', '*dolphin-browser.com', '*ddmapimg.com', '*288idc.com', '*yntsti.com', '*fansimg.com', '*114dns.com', '*zikker.com', '*soperson.com', '*huanqiu.com', '*ehaoyao.com', '*qiyun.org', '*open.cd', '*tooopen.com', '*serverspeeder.com', '*ihelpoo.com', '*54kefu.net', '*52hardware.com', '*51job.com', '*fushiying.com', '*wifigx.com', '*codesky.net', '*tclm36.com', '*imchao.net', '*netbig.com', '*stcn.com', '*nhzy.org', '*baijob.com', '*cehuan.com', '*sxmingjiu.com', '*cgjoy.com', '*shangpin.com', '*mop.com', '*600.la', '*yousheng8.com', '*smartshe.com', '*sanyuyb.com', '*xingzuoqu.com', '*lccsky.com', '*willerce.com', '*egou.com', '*wyx678.com', '*url7.me', '*homevv.com', '*aomy.com', '*bokecc.com', '*wangyueblog.com', '*gksww.com', '*nokia.com', '*hdroad.org', '*ddvip.com', '*wuxi.cd', '*ostools.net', '*bjiff.com', '*chinababy365.com', '*139.com', '*jutuangoo.com', '*mopimg.com', '*eoemarket.com', '*1bu2bu.net', '*3renseo.com', '*loveyd.com', '*yigao.com', '*irising.me', '*longbuluo.com', '*ttc009.com', '*zscaomei.com', '*rrfmn.com', '*kuaiyongbbs.com', '*qcydia.com', '*vipcareer.com', '*shaoerkeji.com', '*discuz.com', '*diaochapai.com', '*chinapay.com', '*sicnu.org', '*aliyun.com', '*mafengwo.net', '*nosqlfan.com', '*yixia.com', '*kyamaki.com', '*117go.com', '*orca.io', '*kbcool.com', '*c185.com', '*4m6m.com', '*jiaoyou8.com', '*dgzx.net', '*albinworld.com', '*baofeng.net', '*jandan.net', '*nike.com', '*fql.cc', '*ddmap.com', '*fengbuy.com', '*menkr.com', '*linkwan.com', '*sdsgsyj.com', '*3464.com', '*3lian.com', '*uedma.com', '*huacolor.com', '*xhunion.com', '*funinput.com', '*outfit7.com', '*uibia.com', '*xdowns.com', '*726.com', '*iqbug.com', '*taobaocdn.com', '*mobilegz.com', '*5551go.com', '*aoaola.com', '*chewen.com', '*028search.com', '*merida.so', '*bmff.net', '*williamlong.info', '*sxcm.net', '*tzoo-img.com', '*263em.com', '*1ting.com', '*btv.org', '*follow5.com', '*xiachufang.com', '*51testing.com', '*filmphoto.org', '*51bi.com', '*union178.com', '*chncpa.org', '*insenz.com', '*58.com', '*bbsour.net', '*23728.com', '*vjia.com', '*cmguocai.com', '*noo-noo.org', '*lettv.com', '*henanci.com', '*starcorcn.com', '*atpanel.com', '*wuji.com', '*1sus.com', '*emailcar.net', '*zhubajie.com', '*qiushid.com', '*toodaylab.com', '*tzhledu.net', '*jingju.cc', '*qiangpao.com', '*didatuan.com', '*yile.tv', '*th369.com', '*xigua110.com', '*urbandictionary.com', '*tttejia8.com', '*iqiubo.com', '*zocai.com', '*025tata.com', '*abchina.com', '*mebi9t.com', '*abang.com', '*pbs.org', '*57dj.com', '*zhanzhang.net', '*digusync.com', '*feiyien.com', '*iemate.com', '*paipai.com', '*92shequ.com', '*tingclass.net', '*drivergenius.com', '*21dnn.com', '*yeardear.com', '*tesoon.com', '*xiyuit.com', '*ccb.com', '*bhgbox.org', '*zhangshang.mobi', '*letvcloud.com', '*bailitop.com', '*17oh.com', '*imgo.tv', '*jyimg.com', '*jsbc.com', '*000wan.com', '*baidupcs.com', '*appads.com', '*xda-china.com', '*d8.cm', '*gkz6.net', '*ximgs.net', '*starandroid.com', '*cnzz.com', '*hlgnet.com', '*wdjcdn.com', '*halv.com', '*haiyigd.com', '*z-fan.com', '*iwmgh.com', '*onlinedown.net', '*infomous.com', '*img168.net', '*cyacc.com', '*wali.com', '*paipaiimg.com', '*dayainfo.com', '*ooopic.com', '*aikao.com', '*chinaamc.com', '*deishuo.com', '*linuxdiyf.com', '*qiushibaike.cc', '*app111.org', '*newbalance8.com', '*corel.com', '*xuxule.com', '*cdairport.com', '*17lp.com', '*qinsmoon.com', '*ppsimg.com', '*360doc.com', '*taihainet.com', '*pfcexpress.com', '*cnmo.com', '*gzmr.net', '*cncsj.net', '*xici800.com', '*xiaomei.cc', '*verycd.com', '*43gz.com', '*120askimages.com', '*xungle.com', '*pic9382.com', '*tiexue.net', '*sohuns.com', '*ol-img.com', '*sasa.com', '*ttkvod.net', '*paipaitxt.com', '*zbinfo.net', '*reflib.org', '*cmgame.com', '*t0574.com', '*niurenw.com', '*beutu.com', '*etuan.com', '*evernote.com', '*lefeng.com', '*voole.com', '*city8.com', '*yp900.com', '*codinglabs.org', '*mosa86.com', '*news18a.com', '*hotmail.com', '*kekeapp.com', '*maxpda.com', '*tenoad.com', '*xidesheng.com', '*4816.com', '*philips.com', '*cedock.com', '*iapps.im', '*mosesenglish.com', '*dytt8.net', '*aisixiang.com', '*chinatsp.com', '*pocc.cc', '*shishang71.com', '*babytree.com', '*xinwanbiao.com', '*galaxeed.com', '*host700.com', '*codesoso.net', '*codesoso.com', '*ls034.com', '*ishowtu.com', '*tbp.bz', '*sootuu.com', '*gitcafe.com', '*aoshu.com', '*3dmgame.com', '*100yue.com', '*hongxiutuan.net', '*wjsszzx.com', '*chinaunicom.com', '*dancewithnet.com', '*jobyun.com', '*veryhuo.com', '*bigdebussy.com', '*cofool.com', '*jb51.net', '*70.com', '*92youx.com', '*mbajyz.com', '*39test.com', '*cnssssl.com', '*xiaochuncnjp.com', '*wkdyw.com', '*weiyingyong.com', '*cncorpus.org', '*0737mp.com', '*macidea.com', '*kunlun.com', '*arpg2.com', '*impencil.org', '*baifubao.com', '*17usoft.com', '*yyets.com', '*da-mai.com', '*cqnews.net', '*wangxiaofeng.net', '*jx-camera.com', '*91cdn.com', '*xinniangjie.com', '*9wg.com', '*mi-img.com', '*fastyermail.com', '*qushimeiti.com', '*hjenglish.com', '*yicai.com', '*programfan.com', '*dfrdjt.com', '*meitudata.com', '*okhqb.com', '*sieschool.org', '*ifanr.com', '*ysheen.com', '*csto.com', '*cestcupcake.com', '*okooo.com', '*eamonning.com', '*routerclub.com', '*sddcp.com', '*itouchchina.com', '*5i5j.com', '*duxiu.com', '*macgood.com', '*normteam.com', '*tnbz.com', '*yupoo.com', '*022show.com', '*taofen8.com', '*wuhuaizai.com', '*chinagwy.org', '*baofoo.com', '*oabt.org', '*114chn.com', '*cndns.net', '*smweekly.com', '*taobaz.com', '*irs09.com', '*zlcool.com', '*englishtown.com', '*2110000.com', '*i8i8.cc', '*haoyisheng.com', '*solidot.org', '*banmamedia.com', '*okbmf.com', '*chn5000.org', '*kuaipandata.com', '*walizip.com', '*zhibo.cc', '*jiakaobaodian.com', '*100tm.com', '*yinxiang.com', '*91rb.com', '*jznj.com', '*xinli001.com', '*aijiake.com', '*qqai.net', '*cndsi.com', '*5iplaynow.com', '*qianzhan.com', '*wz0hk.com', '*kangkang360.com', '*hdfimg.com', '*koubao.net', '*gyhj.org', '*js165.com', '*wzdsb.net', '*0532gcw.com', '*bankcomm.com', '*kuaiche.com', '*xiziwang.net', '*nbdacheng.com', '*hkjsh.com', '*oplinux.com', '*zoosnet.net', '*bitscn.com', '*db9db.com', '*largesubtle.pro', '*9lianmeng.com', '*eduglobal.com', '*sohu.net', '*jd.com', '*zjicity.com', '*qiniutek.com', '*iafbbs.com', '*airizu.com', '*wormonitor.com', '*xueau.com', '*dianxinos.com', '*cjphr.com', '*qconbeijing.com', '*sz-jlc.com', '*mizhe.com', '*jitu5.com', '*hnzqw.com', '*scanv.com', '*womai.com', '*wosku.com', '*pc175.com', '*tradeprince.com', '*1314zb.com', '*yizimg.com', '*ppios.com', '*getqujing.com', '*eastmoney.com', '*mailjet.com', '*zhanzuo.com', '*kele8.com', '*wangjinzhan.com', '*buildjob.net', '*iqianduan.org', '*btcman.com', '*ruoren.com', '*jtimg.com', '*360kxr.com', '*126.com', '*ni.com', '*ablesky.com', '*aliimg.com', '*cloudfront.net', '*hytrip.net', '*zhimg.com', '*hb91.com', '*flurry.com', '*robotplayer.com', '*buzzopt.com', '*wtianx.com', '*iluopan.com', '*yeyou.com', '*youbian.com', '*huitao.net', '*173.com', '*whcn.org', '*haoshiku.com', '*baixing.com', '*yn16.com', '*pin5i.com', '*wxrb.com', '*yangtai.com', '*adwo.com', '*weiligongshe.com', '*nsmovie.com', '*mdvget.com', '*50bang.org', '*job5156.com', '*ppstv.com', '*mbachina.com', '*zeipo.com', '*go2map.com', '*flvxz.com', '*tingmei.cc', '*sxmdmj.com', '*wefiler.com', '*21cnimg.com', '*apptao.com', '*bestooxx.com', '*kaf9.com', '*fangxiemi.com', '*winxuan.com', '*gougou.com', '*onlylady.com', '*51netu.com', '*yingzheng.com', '*geilicdn.com', '*gad.cc', '*bjzs120.net', '*eccn.com', '*ywhqs.com', '*udika.com', '*likeneng.com', '*newxue.com', '*chinaielts.org', '*linuxidc.com', '*yunos.com', '*rayfile.com', '*cnodejs.org', '*cjdby.com', '*yesku.net', '*gongheshengshi.com', '*000dn.com', '*wal8.com', '*tuan800.com', '*jayproxy.com', '*cccu.cc', '*webapptrend.com', '*qgkjlw.com', '*lijingquan.net', '*580114.com', '*uifish.com', '*hao123.com', '*livnj.com', '*imofan.com', '*udashi.com', '*ipodcast.me', '*taobaoimages.com', '*ceairgroup.com', '*rushplayer.com', '*5577.com', '*ihu.im', '*taohua.com', '*w3cplus.com', '*srmeme.com', '*guolairen.com', '*downcc.com', '*189hd.com', '*jiatx.com', '*1o26.com', '*htc.com', '*baihui.com', '*jumeifu.com', '*yodao.com', '*95572.com', '*klm.com', '*running8.com', '*chenluwenxue.com', '*tompda.com', '*east.net', '*pai13.com', '*chuizios.com', '*ragbear.com', '*himigame.com', '*yihaodianimg.com', '*xskz.net', '*5iucn.com', '*dinolanton.com', '*snda.com', '*sibye.com', '*hyb.im', '*31star.com', '*7794.com', '*17caifu.com', '*thunlp.org', '*dangdangdz.com', '*tu265.com', '*51.com', '*51la.net', '*lvrenpic.com', '*vipcnzz.com', '*tech2ipo.com', '*xheditor.com', '*6637.com', '*yiqifei.com', '*youbibi.com', '*fanjian.net', '*aboutfree.me', '*huox.in', '*gk114.com', '*yeeshou.net', '*520hunjia.com', '*21ccom.net', '*jiayuanedm002.com', '*anytimetomail.com', '*cnool.net', '*szpichappy.com', '*umei.cc', '*meilishuo.net', '*xiexingcun.com', '*code4app.com', '*winenice.com', '*imp3.net', '*sanygroup.com', '*15yule.com', '*feedsportal.com', '*songshuhui.net', '*lmwlove.com',  'icyif.com', '*candlewoodsuites.com', '*iev8.com', '*aicaicdn.com', '*ttkdex.com', '*frdic.com', '*8box.com', '*coodao.com', '*sdgame.com', '*dangdang.com', '*ababee.com', '*pplock.com', '*xinketang.org', '*yoka.com', '*down12.com', '*china-up.com', '*yoyoweb.net', '*51cto.com', '*jomodns.com', '*pvontek.com', '*cnbeta.com', '*18lehu.com', '*feidee.com', '*artxun.com', '*getbbs.com', '*tpzj.com', '*jsrc.com', '*digu.com', '*netease.com', '*sooopu.com', '*517huwai.com', '*qudao.com', '*aliway.com', '*smzdm.com', '*nnjncl.org', '*flipboard.com', '*pudongstamps.com', '*bbapp.net', '*aliloan.com', '*banyuetan.org', '*netnoease.com', '*jxw100.com', '*i3v.cc', '*fontke.com', '*115img.com', '*455sj.com', '*0569.com', '*bjsgnk.com', '*gantuan.com', '*mmiw.net', '*hnol.net', '*360wzb.com', '*toodou.com', '*myitrade.com', '*yifan.cc', '*rlyljj.com', '*51ipa.com', '*usb-mp3.com', '*justyle.com', '*dezhi.com', '*dopool.com', '*hualvtu.com', '*dzdoll.com', '*lottedfs.com', '*photochance.com', '*eqie.com', '*toolsba.com', '*haosc.com', '*qisuu.com', '*szvr.com', '*luckcart.com', '*images9999.com', '*baihr.com', '*wiseks.net', '*c114.net', '*ycul.com', '*xiami.net', '*taskcity.com', '*huofar.com', '*jaeger-lecoultre.com', '*game0592.com', '*teapic.com', '*serving-sys.com', '*starwoodhotels.com', '*chapm.com', '*xiaopian.com', '*staybridgesuites.com', '*lostarray.com', '*accorhotels.com', '*ff84.com', '*dedecms08.com', '*ewtang.com', '*jdzhouse.com', '*09dy.com', '*wonbao.net', '*dili360.com', '*baobeituan.cc', '*962.net', '*99166.com', '*my-dahon.com', '*iiyibbs.com', '*che-piao.com', '*53bs.com', '*gemsr.com', '*fjsen.com', '*paopaoxin.com', '*51yys.com', '*ku112.com', '*nciku.com', '*opera-mini.net', '*iplaysoft.com', '*guoxue.com', '*google-analytics.com', '*yidouphoto.com', '*damndigital.com', '*lvhezi.com', '*unikaixin.com', '*popwan.com', '*psycofe.com', '*xiangshu.com', '*discoverhongkong.com', '*xlzx.com', '*800best.com', '*cqjj.net', '*hqbpc.com', '*mphzp.com', '*moko.cc', '*applm.com', '*nap-cafe.com', '*grcbank.com', '*xpcha.com', '*fzengine.com', '*qq66699.com', '*yeeyan.org', '*j1m1.com', '*ppsrc.com', '*ee4kdushuba.com', '*myxiequ.com', '*baihe.com', '*kankan.com', '*quwan.com', '*7711.com', '*xunlei.com', '*njuftp.org', '*hwstatic.com', '*unionpay.com', '*nongli.com', '*buyjk.com', '*unionbig.com', '*52z.com', '*qihoo.com', '*siluhd.com', '*565882.com', '*tianyablog.com', '*mecoxlane.com', '*hxsyzz.com', '*hongname.com', '*zhongzhihui.com', '*aliunicorn.com', '*263.com', '*yahooapis.com', '*imghb.com', '*tianqi.com', '*vshoucang.com', '*shengyikong.com', '*77town.com', '*huisou.com', '*aiting.me', '*aimi.com', '*jinglunhotel.com', '*zhima.net', '*360buy.com', '*maxthonimg.com', '*kaikai001.com', '*imeigu.com', '*iapppay.com', '*goalhi.com', '*haoxiyou.com', '*hn1c.com', '*xp3366.com', '*91ysjk.com', '*awltovhc.com', '*user-website5.com', '*laonanren.com', '*mycos.org', '*taou.com', '*oray.com', '*1lou.com', '*kk3g.net', '*cool80.com', '*nuandao.com', '*gigya.com', '*yunpan.com', '*chinabaike.com', '*tangdou.com', '*houdao.com', '*chotee.com', '*szxfysj.com', '*suimeng.com', '*ok2ok.com', '*gdhaoma.com', '*leyou.com', '*shanting.mobi', '*chazidian.com', '*5721.net', '*dichan001.com', '*52ch.net', '*shanghaining.com', '*woiyu.com', '*afchine.org', '*hwxnet.com', '*wrbfg.com', '*newasp.net', '*ewsos.com', '*tongbupan.com', '*pkucada.org', '*qksz.net', '*zhangxinxu.com', '*icipku.org', '*scenecn.com', '*umtrack.com', '*umeng.com', '*37wanwan.com', '*37youyou.com', '*14yaa.com', '*qqhead.com', '*mybook66.com', '*srccom.com', '*yameigroup.com', '*caixin.com', '*hongxiu.com', '*chinaeservice.com', '*1point3acres.com', '*kaixin001.com', '*yuyue.com', '*szooo.com', '*unjs.com', '*dell.com', '*jiaodong.net', '*gk99.com', '*ihaveu.com', '*shengjinlan.com', '*roschina.net', '*xgres.com', '*shopping3c.com', '*gangtai.org', '*duoshuo.com', '*liuzhou520.com', '*baoruan.com', '*ejingxi.com', '*jiaodui.com', '*kutongji.com', '*lvmama.com', '*265zy.com', '*martincl2.me', '*chinaec.com', '*yksuit.com', '*minitiao.com', '*orientware.org', '*tmd.cc', '*yihaodian.com', '*pctowap.com', '*websnap123.com', '*qingdaoport.net', '*sinasws.com', '*ymall.com', '*qiyipic.com', '*kl688.com', '*lunwen519.com', '*megajoy.com', '*tz100.com', '*skycn.com', '*gter.net', '*phoer.net', '*slrbs.com', '*mysticalcard.com', '*homeinns.com', '*manzuo.com', '*dygod.com', '*ecitic.com', '*cnitblog.com', '*qupu123.com', '*110.com', '*uc108.com', '*gotoip1.com', '*xdwan.com', '*517fh.com', '*keaku.com', '*yutianedu.com', '*byf.com', '*21cake.com', '*yunfile.com', '*bamuyu.com', '*t3nlink.com', '*snssdk.com', '*eefocus.com', '*appletreebooks.com', '*9ku.com', '*doudou365.com', '*luoshihao.com', '*zhulong.com', '*fangtuwang.com', '*chujingyou.com', '*37cu.com', '*wangyuehd.com', '*aihuishou.com', '*2fz1.com', '*iteye.com', '*appcheers.com', '*artemisprojects.org', '*ip138.com', '*ruanmei.com', '*chinaculture.org', '*vs-time.com', '*fanbang.cc', '*chnmedia.com', '*rtbidder.net', '*89qw.com', '*onegreen.org', '*dongting.com', '*eawan.com', '*xiaonei.com', '*asia525.com', '*dikeauto.com', '*hotchanson.com', '*a135.net', '*wanzhi.cc', '*52kmh.com', '*nowmac.com', '*joit.com', '*daf-rs.com', '*139cm.com', '*pkubbs.net', '*anxish.com', '*22859.com', '*ta80.com', '*tukeq.com', '*okmk.com', '*beianx.com', '*netcoretec.com', '*appsina.com', '*2133.com', '*myzcm.net', '*zongheng.com', '*stdyun.com', '*360bike.net', '*douguo.com', '*cinomail.com', '*9969668.com', '*kandy.cc', '*dpbolvw.net', '*msdn.com', '*godic.net', '*90hao.com', '*zjcnt.com', '*bbzhi.com', '*x6868.com', '*zhiye.com', '*eng24.com', '*sdinfo.net', '*01hr.com', '*yeeunion.com', '*tg-vision.com', '*zh-hz.com', '*taoosoft.com', '*pcpop.com', '*winfang.com', '*ciming.com', '*zdy.cc', '*white-collar.com', '*qzone.com', '*watchstor.com', '*76mi.com', '*china-shufajia.com', '*nnton.com', '*chofn.net', '*chouti.com', '*mingxing.com', '*yesmywine.com', '*qiniudn.com', '*nbbidding.com', '*lbesec.com', '*sohu.com', '*moutaichina.com', '*02753.com', '*stackoverflow.com', '*hdbird.com', '*zhugou.com', '*duapp.com', '*cardbaobao.com', '*2667.com', '*djyzfcg.net', '*ok3w.net', '*hantinghotels.com', '*elementfresh.com', '*winning11cn.com', '*real.com', '*shangdu.com', '*banzhu.com', '*goupiaotong.com', '*byecity.com', '*vmanhua.com', '*appgame.com', '*hztbc.com', '*hijiangxi.com', '*5220.net', '*doujiao.com', '*bookinlife.net', '*adsmogo.net', '*17173.com', '*ppjmlp.com', '*cbook.org', '*best-living.net', '*changyou.com', '*zhenpin.com', '*makepolo.com', '*bf99.com', '*hdmeiju.com', '*yaolan.com', '*jingoal.com', '*2800v.net', '*ztcjl.com', '*hao-shengyi.com', '*vips100.com', '*ourxun.com', '*lalilawai.com', '*mnwan.com', '*juhuasuan.com', '*cutecrm.net', '*tianyaui.com', '*lafaso.com', '*onccc.com', '*game3896.com', '*lakecn.com', '*vnetone.com', '*zhongsou.net', '*ougei.com', '*youshang.com', '*cheshi-img.com', '*lecake.com', '*shangri-la.com', '*win7soft.com', '*anhuixiqu.com', '*33.la', '*diglog.com', '*sanjiaoli.com', '*sjjob88.com', '*qweyy.com', '*beile.com', '*lnok.net', '*wshang.com', '*scene7.com', '*wwfchina.org', '*ikafan.com', '*docin.com', '*mmbang.info', '*fxxw.net', '*evget.com', '*benlai.com', '*narrowad.com'];

function getBypass() {
    var req = new XMLHttpRequest();
    var url = "https://raw.github.com/henices/Chrome-proxy-helper/master/data/cn.bypasslist";
    req.open('GET', url, true);
    req.onreadystatechange = processResponse;
    req.send(null);

    function processResponse() {
        if (req.readyState == 4 &&
            req.status == 200) {
            localStorage.chinaList = JSON.stringify(req.responseText.split(','));
        } else
            localStorage.chinaList = JSON.stringify(chinaList);
    }
}

chrome.runtime.onInstalled.addListener(function(details){
    if(details.reason == "install") {
        //localStorage.proxySetting = JSON.stringify(proxySetting);
        //gotoPage('options.html');
    }
    else if(details.reason == "update"){
        //gotoPage('CHANGELOG');
    }
});


chrome.commands.onCommand.addListener(function(command) {
  if (command == 'open-option')
      gotoPage('options.html');
});

// sync extension settings from google cloud
chrome.storage.sync.get('proxySetting', function(val) {
    if (typeof val.proxySetting !== "undefined")
        localStorage.proxySetting = val.proxySetting;
});

//alert('00');
localStorage.proxySetting='peizhiwenben1';
localStorage.proxyInfo='peizhiwenben2';
localStorage.chinaList='["*.cn","*chdbits.org","*bbercn.com","*4shared.com","*efeihu.com","*wanzhongtuan.com","*sdg-china.com","*cbnweek.net","*chinawutong.com","*100ydy.com","*24en.com","*pinnawhite.com","*77l.com","*tuhigh.com","*guomob.com","*appifan.com","*worlduc.com","*tmall.com","*admob.com","*qhimg.com","*7clink.com","*baiduplayer-img.com","*819nk.com","*my7475.com","*dvbbs.net","*ddcdn.com","*sinmert.com","*hmyzs.com","*wooyun.org","*cqmmgo.com","*beifabook.com","*blizzard.com","*131cc.com","*bathome.net","*aireader.com","*i9.cc","*chinaaet.com","*168wap.com","*nyt.com","*ynesd.com","*chinaoverseas.org","*nbongostudio.com","*ziling.com","*happy001.com","*immomo.com","*zhongso.com","*shmetro.com","*alisoft.com","*gkooo.com","*weibusi.net","*zhiziyun.com","*293.net","*tianpin.com","*5vv.cc","*1diancifa.com","*hylae.com","*eacha.com","*mydigit.net","*tanx.com","*woshidazuiba.com","*ittzz.com","*ty028.com","*meadin.com","*taomoban.com","*uu.cc","*xiaoma.com","*51043.com","*ringierasia.com","*nciyuan.com","*uuyoyo.com","*0817cg.com","*lashou.com","*nipic.com","*symama.com","*hotelindigo.com","*cnfol.com","*chinasspp.com","*zombike.com","*boyaa.com","*dqdaily.com","*leho.com","*hb165.com","*fuwumi.com","*emuch.net","*cdndm5.com","*bitautoimg.com","*meihua.info","*kanbox.com","*zhangziran.com","*5d6d.org","*woshao.com","*guahao.com","*lifevccdn.com","*yiduimg.com","*noblechinese.com","*jobbole.net","*69222.com","*wunderlist.com","*tiantian.com","*pudn.com","*menglu.com","*360safe.com","*ajinga.com","*5ykj.com","*pediy.com","*xudiao.com","*xvna.com","*daxia.com","*lequ.com","*yupingxiaodi.com","*buaamba.net","*jie.pn","*tieyou.com","*in2west.com","*appgz.com","*778lm.com","*jsqwfy.com","*dnspod.com","*techolics.com","*carnoc.com","*iliyu.com","*7y7.com","*vgooo.com","*ctrmi.com","*tuoke.com","*ucfly.com","*bailinsi.net","*uume.com","*suntix.com","*biodiscover.com","*107cine.com","*36tr.com","*wincn.com","*img-cdn.info","*bfimg.com","*travelsky.com","*laozuo.org","*baobao88.com","*sjx888.com","*jxunicom.net","*vafox.com","*upaidui.com","*wuyou.com","*csdn.net","*96911.com","*shequla.com","*guifabu.com","*anzhuo.com","*gaojie.com","*bjqyg.com","*afzhan.com","*henhaoji.com","*uiimg.com","*qjwm.com","*eidcenter.com","*thn21.com","*ktxp.com","*booksky.org","*dichan.com","*5ichecker.com","*chang-yuan.com","*tshenbian.com","*itxinwen.com","*camera360.com","*bjmama.com","*donews.com","*ty8866.com","*mydogear.com","*xesimg.com","*aswis.net","*qianzhengdaiban.com","*uedmq.com","*toogge.com","*ufokuaidi.com","*artintern.net","*baidustatic.com","*xoyo.com","*zhuokearts.com","*offcn.com","*anjuke.com","*sozhen.com","*wechat.com","*dukuai.com","*tvsou.com","*moeid.com","*juandou.com","*xinshipu.com","*alimiaopu.com","*nlcpress.com","*ipaddh.com","*36kr.com","*tgfans.com","*mocartoon.com","*timll.com","*meituan.com","*emland.net","*8s8s.com","*springtour.com","*letao.com","*superairmedia.com","*weirenmai002.com","*819mn.com","*webacg.com","*youa.com","*fclubimg.com","*91adv.com","*11w11.com","*jintoutiao.com","*127.net","*ytrss.com","*wingzstudio.net","*515345.com","*alimama.com","*wsgsoft.net","*goomoon.com","*nasboq.com","*sirenji.com","*pinyihui.com","*148com.com","*3conline.com","*mysteelcdn.com","*nodeblog.org","*kuaishubao.com","*njyd139.com","*qichelian.com","*50qyy.com","*hdletv.com","*huxiu.com","*biquge.com","*hebcrj.com","*sinosig.com","*hbply.com","*julying.com","*chuangyejia.com","*xiaopian.net","*labsky.com","*zmdz.com","*chinawin.net","*essxd.com","*gaokao.com","*phototex.com","*jinghua.com","*144gg.com","*laoluoliuxue.com","*yybk.com","*itmini.net","*123show.com","*ezhun.com","*navcloud.net","*epanshi.com","*assetswmd.com","*mingpian8.com","*soso2.com","*nlpir.org","*yes80.net","*cocoachina.com","*securestudies.com","*discuz.net","*jstv.com","*bbicn.com","*jiasule.com","*xehost.com","*easymule.com","*appying.com","*70man.com","*iiberry.com","*dzwww.net","*baofeng.com","*datatang.com","*1133.cc","*2nike.org","*sustcmedia.net","*sino-manager.com","*climax999.com","*sznews.com","*7pk.com","*lofter.com","*tv002.com","*hzvod.com","*topbiz360.com","*ads80.com","*elechome.com","*olcdn.com","*kksmg.com","*tkqlhce.com","*yinhangxyk.com","*51youpin.com","*card.cd","*fenku.com","*77u.com","*xiagun.com","*cy123.cc","*luckup.net","*wealink.com","*cityhz.com","*qzoneapp.com","*phoenixtv.com","*intel.com","*q150.com","*mbatrip.com","*ekupeng.com","*tang-consulting.com","*umivi.net","*yizhichina.net","*sxrtv.com","*levelup.im","*jxrtv.com","*eywedu.com","*fwxgx.com","*meilishuo.com","*7do.net","*xiaosong.org","*blogbus.com","*dapenti.com","*jinchen-cn.com","*tequ.com","*1360.com","*uisdc.com","*actoys.net","*fitbbs.com","*nemofq.com","*2qqtouxiang.com","*tmxk.org","*solidworks888.com","*2500sz.com","*ique.com","*9918edu.com","*tellapart.com","*appdown.info","*suxiazai.com","*tudun007.com","*jyeoo.com","*meshuo.com","*goletao.com","*qsiedu.com","*motel168.com","*shangxueba.com","*1dupet.com","*naadou.com","*68room.com","*weico.cc","*jinncolor.com","*doumob.com","*cnepub.com","*cnliti.com","*ooyala.com","*b6yy.com","*wikipedia.org","*agenow.com","*ingentaconnect.com","*zw97.com","*41478.com","*lifesky.com","*yswl.in","*xingpai.com","*hermes.com","*yt-power.com","*zdh1909.com","*acs.org","*stepday.com","*pipipan.com","*freemerce.com","*com.sg","*wuyoumobile.com","*koudai8.com","*pooway.com","*5umaimai.com","*51sole.com","*dragonair.com","*88tang.com","*ymatou.com","*v-56.com","*xunbo.cc","*tenddata.com","*kuaiyong.com","*miercn.com","*tankr.net","*wowotuan.com","*aliapp.com","*ieltschn.com","*66mp3.com","*or.th","*joyyang.com","*sporttery.com","*fangyou.com","*lotour.com","*rybao.com","*inhe.net","*iseeclan.com","*5068.com","*tjexh.com","*nanhutravel.com","*mxgbook.com","*yueteng.com","*deerchao.net","*shengjoy.com","*bicyc.com","*jingdong.com","*amgbs.com","*taobaike.com","*cucimg.com","*po-soft.com","*cnshuju.com","*kejixun.com","*8da.com","*igexin.com","*yuncheng.com","*51zrm.com","*v2ex.com","*laidingba.com","*kaixian.tv","*nanadm.com","*ourats.com","*bitautotech.com","*zarkfx.com","*ibtsat.com","*sosg.net","*cztv.com","*luangh.com","*wuyou.net","*ysn.cc","*gcimg.net","*ruyile.com","*souba.org","*3366img.com","*zggyxx.com","*9wee.com","*geekui.com","*miaopai.me","*htinns.com","*stfile.com","*hiexpress.com","*cnphotos.net","*tcm100.com","*fatoce.com","*bao.fm","*iconpng.com","*longzhou.cc","*qihuatong.com","*zhlzw.com","*pingshu8.com","*yy.com","*q1qq2.com","*qjherb.com","*everydo.com","*piemoment.com","*dooland.com","*lvpingphoto.com","*hackbase.com","*336.com","*zgbike.net","*dmzj.com","*yiqiv.com","*gengrenjie.com","*163.fm","*citrixonline.com","*codoon.com","*bdstatic.com","*images-amazon.com","*xiutuan.com","*1cfun.com","*12cde.com","*16789.net","*baimei.com","*padhz.com","*subpig.net","*feizan.com","*y5zonechina.net","*13xw.com","*variflight.com","*examda.com","*dssz.com","*wqzyt.net","*l99.com","*yue365.com","*wangdian8.com","*teachercn.com","*huanqiukexue.com","*ipinyou.com","*tiandaoedu.com","*meiyoubanfa.net","*banma.com","*shequan.com","*icili.com","*centanet.com","*acg7.com","*my147.com","*butao.com","*tl163.net","*54hwz.com","*zgfznews.com","*help-doc.com","*9skb.com","*zdmimg.com","*welan.com","*ftuan.com","*gushiwen.org","*mailbus.net","*meitu.com","*131.com","*tao21.org","*bdchina.com","*casualgame-down.com","*2881.com","*zhuangwang.com","*hjbook.net","*zjc365.com","*autoshanghai.org","*hao662.com","*msn.com","*qiushiqiang.com","*founderit.com","*114lm.com","*linkindomain.com","*iyaya.info","*baiducontent.com","*tsdxb.com","*deyi.net","*dotting.me","*kxshoes.com","*vonibo.com","*paipai.fm","*sinacdn.com","*tao123.com","*lvyoumall.com","*sojiang.com","*2mdn.net","*chinatelecomes.com","*wangyan.org","*alibado.com","*mb520.net","*52suda.com","*ouravr.com","*suningshop.com","*luo7.com","*islayer.com","*linuxpk.com","*tangcha.tc","*buytong.com","*xzhuang.com","*phpwind.com","*burning.im","*cioage.com","*ich8.com","*xiamentd.com","*wiiyi.com","*amazonaws.com","*baoxila.com","*aolcdn.com","*yunyun.com","*ujian.cc","*biketo.org","*cqvip.com","*21edu8.com","*100ksw.com","*10010.com","*jkjyfashion.com","*8080kk.com","*95530.com","*touclick.com","*umsns.com","*winzhong.com","*cnhubei.com","*lanou3g.com","*zhongsou.com","*duba.net","*sunnychina.com","*wuwenhua.com","*shbear.com","*0371gt.com","*ledanji.com","*sandaha.com","*glinfo.com","*javaniu.com","*yinhangchaxun.com","*nihaowang.com","*qq937.com","*gifshow.com","*ttpet.com","*etentec.com","*tx75.com","*9med.net","*gokuai.com","*zol-img.com","*juele.org","*shouxi.net","*42btc.com","*cnsec.org","*qdmama.net","*7kiwi.com","*adsmogo.mobi","*facebook.net","*doudouguo.com","*zhigou.com","*lianyou120.com","*zhaotie.cc","*dongwo.net","*gs307.com","*ytt.me","*chinacache.com","*phpstat.net","*smejs.com","*dd.ma","*ichafen.com","*miaoximei.com","*kaifa01.com","*world68.com","*crsky.com","*eda365.com","*wopaiwo.com","*18touch.com","*uctrac.com","*topchitu.com","*cp2y.com","*eflye.com","*cmidc.com","*xmswx.net","*iqiyi.com","*pk38.com","*liyi99.com","*top0514.com","*xianhuodong.com","*jueshitangmentoo.com","*tweakcube.com","*ichacha.net","*fir.im","*0394dk.com","*dayoo.com","*shaishufang.com","*eduu.com","*diangao.com","*newmaker.com","*mediapower.mobi","*iamsujie.com","*wzhan.net","*namipan.com","*bikehome.net","*chinahr.com","*romzhijia.net","*89178.com","*classicaldoor.com","*dianping.com","*html5dw.com","*iloveyouxi.com","*cqzwkj.com","*vlongbiz.com","*vcimg.com","*tigtag.com","*yytcdn.com","*qingdi.com","*ijia360.com","*kejet.net","*nu99.com","*doguo.com","*4007hao.com","*3aapp.com","*jbl.com","*ihisen.com","*nbkix.com","*cctv.com","*newrelic.com","*elinkhost.com","*kuaidi100.com","*nandu.cc","*bioon.com","*dic123.com","*gwy8.com","*avrw.com","*feitian001.com","*btsmth.org","*dywg.cc","*rdcnzz.com","*hmeili.com","*gywx.org","*zdface.com","*foundertype.com","*iheima.com","*libspace.org","*gaoqing.tv","*wpbus.com","*51kaifa.com","*paywithsns.com","*economist.com","*86gudong.com","*sxbbm.com","*chinamac.com","*oooxm.com","*pztuan.com","*mockte.com","*fmate.com","*56img.com","*daichuanqing.com","*live.net","*jcwcn.com","*zjoubbs.com","*kangca.com","*9588.com","*yun.io","*itiexue.net","*7k7k.com","*gxsky.com","*ledu.com","*yeah.net","*essaydata.com","*yi114.com","*budeyan.com","*573.com","*xie-gang.com","*xitek.com","*k1om.com","*g188.net","*vstartdown.com","*zjhzjy.com","*candou.com","*whcwzl.com","*loohua.com","*bke.cc","*inezha.com","*52cydia.com","*ooidea.com","*lztvnet.com","*dooo.cc","*bobcardjf.com","*zealer.com","*49ko.com","*90he.com","*zhongguosou.com","*kro-pic.com","*beijing-fire.com","*chinataiwan.org","*51mtb.com","*lqqm.com","*ht88.com","*srzc.com","*szsky.com","*9g.com","*dejiplaza.com","*topsem.com","*goodbaby.com","*echuguo.net","*wapwat.com","*51766.com","*healthoo.net","*amaomb.com","*dedecms.com","*51mdq.com","*union009.com","*hubs1.net","*dreams520.com","*qianqian.com","*aicairen.com","*chinacrumpler.com","*ku6.com","*qkzz.net","*aibai.com","*alivv.com","*adunioncode.com","*guofm.com","*startssl.com","*26923.com","*kuaitv.net","*5156edu.com","*7kan.net","*gstatic.com","*xiaoangel.com","*gbtags.com","*saifutong.com","*1188.com","*rolex.com","*renren.com","*lanrentuku.com","*vpsmm.com","*html5cn.org","*acfun.tv","*autonavi.com","*lc505.com","*cdnmaster.com","*37wan.com","*w3ctech.com","*8008205555.com","*xbiao.com","*c-ps.net","*koppt.me","*ifeng.com","*guokr.com","*netded.com","*tietu.com","*timedg.com","*m0n0china.org","*ctex.org","*imgroad.com","*hdtmedia.com","*rrting.com","*2345.com","*jumei.com","*arnetminer.org","*expcloud.net","*bingchengwang.com","*cjdby.net","*anybi.com","*vsoh.com","*bjsxt.com","*gotoip2.com","*murenwu.com","*mianr.com","*taotaosou.com","*love21cn.com","*chebawang.com","*kexue.com","*dsmdz.com","*yimg.com","*linuxsir.org","*kabulang.com","*laixi.com","*zhshangpin.com","*chinatat.com","*luckty.com","*17u.com","*mediav.com","*fastbooking.com","*21cn.com","*rockmongo.com","*365master.com","*soufunimg.com","*71training.com","*naver.net","*hamob.com","*sdo-static.com","*bocomcc.com","*chofn.com","*bookfm.com","*imbugu.com","*uezhan.com","*leonsys.com","*crossmo.com","*windowsupdate.com","*job1001.com","*510599.com","*dui.lu","*baixing.net","*dapenti.org","*ngacn.cc","*zhi.la","*67.com","*100ksw.net","*9lwan.com","*bjsbj.net","*topcj.com","*baomihua.com","*datangcloud.com","*hiao.com","*hdstar.org","*re1d.com","*ej38.com","*365jilin.com","*gzyes.com","*houhang.com","*diandian.com","*chinauma.net","*appinn.com","*szjtq.com","*edodocs.com","*admin6.com","*99114.com","*chaishouji.com","*yeshj.com","*yxey.net","*cenuni.com","*zbjimg.com","*sheetoo.com","*letvimg.com","*wkimg.com","*wan789.net","*ckgsb.com","*lijiangkezhan.com","*flyertea.com","*szltcn.com","*guangpantuan.com","*proferochina.com","*yihu.com","*91tiger.com","*pengfu.com","*99bill.com","*dajudeng.com","*iconfans.com","*visionunion.com","*6eat.com","*qingtingfm.com","*newsmyshop.com","*yzzj.net","*patmm.com","*aaeexpress.com","*niuza.com","*php100.com","*lotuschina.net","*job592.com","*1000eb.com","*tenpay.com","*51network.com","*gzdsw.com","*apple.com","*dm456.com","*baigoogledu.com","*crashlytics.com","*haoxuee.com","*letuknowit.com","*nxnews.net","*chinacourt.org","*ggxt.net","*letuspeed.com","*zjcomlawyer.com","*tbmj.net","*umiwi.com","*shilehui.com","*mfcad.com","*tencent.com","*qingting.fm","*okbuycdn.com","*wordlm.com","*139site.com","*c-c.com","*cnbike.net","*img18.com","*knownsec.com","*boohee.com","*xnpic.com","*12530.com","*adsage.com","*studa.net","*punchbox.org","*alimenhu.com","*gamerboom.com","*kakamobi.com","*92youle.com","*gucheng.com","*kgkx.com","*lehecai.com","*4399buy.com","*pinglun.la","*maxthon.com","*bjtlss.com","*wrating.com","*wgimg.com","*eeboard.com","*effectivemeasure.net","*mier123.com","*forbeschina.com","*adyun.com","*bing.com","*websbook.com","*unionpaysecure.com","*jiankongbao.com","*573youxi.com","*sz1001.net","*y4dg.com","*zkungfu.com","*chinadsl.net","*ireadercity.com","*wtojob.com","*51daifu.com","*dddsp.com","*baiduyy.com","*iplaymtg.com","*yiyou5.com","*hiido.com","*chinavalue.net","*icbc-ltd.com","*kaba365.com","*forumimage.org","*xcy8.com","*helpton.com","*itings.com","*119tw.com","*alibole.com","*yanshun.org","*flvcd.com","*zjuhz.com","*hundsun.com","*dajie.com","*wordpress.la","*bibidan.net","*huawei.com","*see-say.com","*6619.net","*xinzhuzhang.com","*douban.fm","*7540.com","*qvocd.org","*chinawaiyu.com","*ranwen.net","*hnjunlin.com","*028share.com","*ppstream.com","*huiben.cc","*allworldbuy.com","*99sushe.com","*netdna-cdn.com","*cyanclone.com","*tibetcul.com","*i360r.com","*968hao.com","*91985.com","*edu88.com","*qyacg.com","*hicloud.com","*icloud.com","*sandai.net","*7068.cc","*aiyingshi.com","*vpon.com","*dzsofts.net","*emailcar1.com","*is97.com","*xiangshenghang.com","*dianying.fm","*lamiu.com","*wacai.com","*topit.me","*meqzone.com","*120ask.com","*jimdo.com","*pchome.net","*hilishi.com","*6zu.com","*huitongke.com","*tujia.com","*xiami.com","*46535.com","*kadaqia.com","*shopin.net","*chexie.net","*wulinyingxiong.net","*zssirui.com","*googletagmanager.com","*bukamanhua.com","*eastday.com","*tao3c.com","*sexqu.cc","*keede.com","*liheran.com","*lkwww.net","*yfkjy.com","*mdn2.net","*reuters.com","*xiaoenai.com","*for68.com","*itao521.com","*1mall.com","*yinooo.com","*ibeike.com","*kkcapture.com","*uyan.cc","*qiyejia.net","*sodao.me","*powerlong.com","*bookinge.com","*amakings.com","*llnwd.net","*hanggao.net","*htpc1.com","*sososnap.com","*adzhub.com","*newexpo.com","*zylm.cc","*xasn.com","*tudouui.com","*meican.com","*doll-zone.com","*heima8.com","*vivijk.com","*3777u.com","*exam8.com","*ctdisk.com","*prosight.me","*linekong.com","*shejis.com","*jsgaokao.net","*zx110.org","*chinamobile.com","*noiseindustries.com","*humen.com","*wandoujia.com","*nibirutech.com","*jiuxian.com","*qita.in","*sanhaostreet.com","*fs-station.com","*yxdaily.com","*cio360.net","*douguo.net","*sharewithu.com","*tianyiyule.com","*5184.com","*17kuxun.com","*leshu.com","*duote.org","*bdwm.net","*shanbay.com","*meishitui.com","*17leyi.com","*cheryhome.net","*rido.cc","*aboutcg.net","*xiaoi.com","*sjway.com","*optaim.com","*yzwb.net","*jcloud.com","*dzwww.com","*changedu.com","*wotula.com","*rritw.com","*zhongguoxijuchang.com","*lisal.me","*huobaoliangjiaren.com","*rutisher.com","*500cache.com","*dmdelivery.com","*77dannya.com","*chinahighway.com","*itkes.com","*immivip.com","*dfhbike.com","*jinfuzi.com","*bjwjwk.com","*gozap.com","*jiayuan.com","*11l11.net","*zhsc.net","*sg120.com","*meishichina.com","*apple83.com","*nphoto.net","*kmbike.net","*xp510.com","*youxjia.com","*yetwo.com","*or.kr","*coolshang.com","*igoex.com","*chengguocar.com","*gotoip3.com","*shouyou.com","*cdncache.org","*tianjinwe.com","*jishantang.org","*bababian.com","*sootoo.com","*zampdsp.com","*chinaumu.org","*wosign.com","*jyoorobot.com","*m18.com","*tv189.com","*nuoshu.com","*mlt01.com","*juangua.com","*eicodesign.com","*ad1111.com","*kameng.com","*jgxfw.com","*jiapin.com","*sina.net","*zhengjicn.com","*songtaste.com","*csair.com","*tiaozhanbei.net","*xcarimg.com","*soo-boo.com","*425300.com","*daozhou.net","*avdmg.com","*kidcomic.net","*gh730.com","*funshion.net","*nz86.com","*showxiu.com","*inanbo.com","*kechengbiao.me","*333cn.com","*51mta.com","*synacast.com","*myfrfr.com","*taocx100.com","*mipangwang.com","*alibabatech.com","*my5757.com","*hupu.com","*union163.com","*xj71.com","*web592.com","*mn81.com","*mogujie.com","*elong.com","*molifan.net","*you01.com","*hack520.org","*waqiang.com","*helloarm.com","*zhenwu.com","*adsmogo.com","*51rfb.com","*shuame.com","*200.net","*my399.com","*8dulm.com","*joyopiao.com","*ikoori.com","*gaibar.com","*httpcn.com","*k184.com","*4891ko.com","*gewara.com","*yinxiangma.com","*aoyou.cc","*bjxueche.com","*zaobang.com","*woleso.com","*168.sh","*ts33.com","*tom.com","*macgg.com","*app123.com","*yjpdf.com","*alixixi.com","*chinabyte.com","*gaosiedu.com","*5d5d.com","*unionli.com","*cdngc.net","*ihacksoft.com","*qkankan.com","*148365.com","*53kf.com","*agenda-asia.net","*snyu.com","*cachiyeung.com","*hao123img.com","*gtimg.com","*popocy.com","*bing.net","*997788.com","*hc360.com","*hao311.com","*star2009.com","*ku6cdn.com","*suk100.com","*hxsd.com","*superfection.com","*3366.com","*fobshanghai.com","*ailaba.org","*taokshop.com","*angeeks.com","*ss3w.com","*ydjiao.com","*ld12.com","*3lsoft.com","*yousee.com","*qqtn.com","*ikea.com","*2liang.net","*hd575.com","*yiss.com","*mmbang.com","*nbweekly.com","*66wz.com","*gisall.com","*hq9988.com","*kejet.com","*liuxue86.com","*missyuan.net","*eoeandroid.com","*chemyq.com","*googletagservices.com","*tuanweihui.com","*haiyingsite.com","*junph.com","*xiazaiba.com","*wdjimg.com","*ezhangdan.com","*pomoho.com","*rendb.com","*imwx.com","*makepolo.net","*it168.com","*szbaws.com","*wutianqi.com","*vapee.com","*whaty.com","*ele.me","*0551bike.com","*douyou100.com","*zhaoshangbao.com","*medooo.com","*ssbbww.com","*weibo.com","*hxxland.com","*88812699.com","*china-consulate.org","*kandian.com","*mobmore.com","*newssc.org","*cncad.net","*netiso.net","*5d6d.net","*xuanpg.com","*360hqb.com","*tobti.com","*laochemi.net","*918kf.com","*dostor.com","*netat.net","*laiwang.com","*chapianfang.com","*anybi.net","*xixik.com","*show400.com","*lenovo.com","*liqwei.com","*2zx.cc","*newzealand.com","*youbianku.com","*huaxiafengyun.com","*anti-cnn.com","*365meeting.net","*xiaohua001.com","*52mba.com","*ddooo.com","*bjddn.com","*haozu.com","*funfungolf.com","*ctqcp.com","*duanwenxue.com","*waimaidan.com","*dabaima.com","*123u.com","*goapk.com","*qiyou.com","*cigna-cmc.com","*snwz.com","*weliveinbeijing.com","*bjnandi.com","*zhihu.com","*dianru.com","*kukudm.com","*adidasevent.com","*ccvita.com","*uucin.com","*china-netwave.com","*b2cedu.com","*qianxinet.com","*eflyetrip.com","*kabiqi.com","*911pop.com","*tuhaihe.com","*znimg.com","*replays.net","*cyol.com","*techdrafts.com","*cankaoxiaoxi.com","*360kad.com","*doodii.com","*bestrans.net","*deyi.com","*moumentei.com","*csres.com","*behe.com","*126.net","*gaytaobao.com","*yuloo.com","*jobui.com","*cofco.com","*51fanli.com","*pic16.com","*ucdchina.com","*2866yx.com","*kpkpw.com","*hxen.com","*zjbdt.com","*cnfolimg.com","*feelcss.com","*xuexun.com","*divmb.com","*51ditu.com","*dxsvr.com","*phb168.com","*ca2u.net","*hy123.com","*gfan.com","*royalcaribbean.com","*qidian.com","*yunstatic.com","*alidata.org","*365zaoshi.com","*jysq.net","*zoopda.com","*qfpay.com","*360chuguo.com","*39.net","*burl.cc","*mumayi.com","*dxwxy.com","*china-sss.com","*baike.com","*ctdsb.net","*ckdvd.cc","*go007.com","*wsson.com","*oadz.com","*mqw123.com","*cqsq.com","*wonadea.com","*5d6d.com","*esaipay.com","*ec80.com","*nowec.com","*tamml.com","*pinggu.name","*wan123.com","*kxsj.com","*flash3.net","*rrimg.com","*ishwap.com","*newsminer.net","*daohao.net","*reeoo.com","*0669.cc","*bibimai.com","*gtags.net","*10086.com","*p111.net","*cndizi.com","*k8008.com","*doctorcom.com","*chinaw3c.org","*egovsum.com","*nintendowifi.net","*wangjubao.com","*aliyuncs.com","*tugus.com","*yunshangdian.com","*36x7.com","*dabandeng.com","*baoyeah.com","*xungou.com","*operaphoto.com","*eb99.com","*v5px.com","*dropbox.com","*vlss.com","*8825.com","*51jiaxiao.com","*miui.com","*7edown.com","*caishijie.com","*zz-bike.com","*xijucn.com","*himengzhou.com","*16078.com","*missyuan.com","*em-cn.com","*xinnet.com","*idcspy.com","*ycstatic.com","*imadisonlogic.com","*yicomm.com","*datatv.net","*hnmama.com","*niunb.com","*wolai.com","*yahunet.com","*skyteam.com","*niux88.com","*pt92.com","*ftimg.net","*likejuan.com","*thetvdb.com","*emacle.com","*cnaaa3.com","*3322.org","*flyert.com","*bielaiwan.com","*1717gs.com","*jinbangqm.com","*cskczx.com","*telecomjs.com","*dangzhi.com","*safrotto.com","*peninsula.com","*ztspeech.com","*d8wed.com","*htbresort.com","*webluker.com","*vipstore.com","*17558.net","*okoooimg.com","*laruence.com","*hotelscombined.com","*17mv.com","*soopat.com","*falibao.com","*unity3d.com","*xinhuanet.com","*newwise.com","*114133.com","*2tu.cc","*gispark.com","*chdtv.com","*fishyp.net","*guqu.net","*36krcnd.com","*hbshgzx.com","*snailcolor.com","*baisuiyi.com","*evergrande.com","*cnxad.com","*cmread.com","*jj831.com","*adobe.com","*wabao.me","*virscan.org","*lijigou.com","*emarbox.com","*chainlt.com","*liqucn.com","*soso.com","*qq20101.com","*tgbus.com","*comodoca.com","*51edu.com","*baozoumanhua.com","*chinakongzi.org","*ltaaa.com","*digushow.com","*dygod.net","*cnnude.com","*lengxiaohua.com","*fangjia.com","*tianqi321.com","*wonderad.com","*68699120.net","*eistudy.net","*abc-love.com","*godiy8.com","*qqjia.com","*cailong.net","*usc.edu","*61ads.com","*game3737.com","*pzoom.com","*brand-edm.net","*mygolbs.com","*ydstatic.com","*dajiawan.com","*kuaibo.com","*ebigear.com","*ikingyo.com","*vdisk.me","*10628106.com","*net114.com","*qiaopier.com","*hhtravel.com","*classlater.com","*zgzcw.com","*cootekservice.com","*ovi.com","*dnpns.com","*peixun360.com","*xuexila.com","*manjiusong.net","*gmgc.info","*chinesessg.com","*vanke.com","*qconhangzhou.com","*yesmylaw.com","*weiguan.cc","*chdtv.net","*boqii.com","*mysilu.com","*lov9.net","*krxd.net","*duomiyy.com","*weliveinchina.com","*nds99.com","*chinabike.net","*hexun.com","*resgain.net","*gxg520.com","*233.com","*newsmth.net","*ymfile.com","*duoxue8.com","*sungoedu.com","*wenmi114.com","*gxcms.com","*westmov.com","*zjomo.com","*hbxt.net","*54jk.com","*cppblog.com","*caixun.com","*wumii.com","*titan007.com","*soomal.com","*abccod.com","*tita.com","*u-om.com","*dvbcn.com","*51auto.com","*francochinois.com","*cjmx.com","*archfans.com","*gezbox.com","*etao.com","*hztags.net","*11qu.com","*nice3c.com","*97ls.com","*517zijiayou.com","*vcotton.com","*365jia.com","*anrdoezrs.net","*enmajor.com","*bjgtop.com","*zhuangbei2012.com","*anyview.net","*zhenai.com","*uyunad.com","*socialbeta.com","*qianpincdn.com","*huatu.com","*77soho.com","*dacais.com","*yzdb.tv","*wasu.tv","*bzfxw.com","*huaban.com","*zjsight.com","*ftjcfx.com","*malshenzu.com","*itravellive.com","*188.com","*longre.com","*zaiju.com","*265g.com","*haodf.com","*bet007.com","*vmall.com","*konglei.com","*jike.com","*03964.com","*moegirl.org","*kakarott.net","*hxqu.com","*donever.com","*qumaiya.com","*wwping.com","*blshe.com","*wally.in","*geek-workshop.com","*zasv.net","*korirl.com","*adsame.com","*xuedi.com","*xlpu.cc","*house365.com","*sagetouch.com","*gaosu.com","*hiwifi.com","*hbzct.com","*duote.com","*souyousoft.com","*anzhi.com","*51888.com","*coo8.com","*youku.com","*verisign.com","*weiyun.com","*conguo.com","*yinshuazhongguo.com","*aigou.com","*chahaoba.com","*jiancai.com","*qeeka.com","*ednchina.com","*51buy.com","*dpfile.com","*fetionpic.com","*vitkey.com","*xingbar.com","*landfu.com","*55.la","*tjjoycity.com","*zhaoka.com","*showchina.org","*ttg.im","*xlpan.com","*rordo.com","*hdslb.com","*memail.net","*weixin.com","*blue1000.com","*ynhanfu.com","*uzzf.com","*kaoyanbbs.org","*dachaocai.com","*minesage.com","*bestedm.org","*kdslife.com","*rca-hk.com","*tuodi.com","*tvmao.com","*lupaworld.com","*qqbody.com","*yiibai.com","*bliao.com","*netwinform.com","*cutt.com","*70e.com","*tejiamao.com","*hoodong.com","*xypht.com","*00base.com","*bokee.com","*tuicool.com","*gamebean.com","*cnzz.cc","*sucaiw.com","*sinaedge.com","*s1976.com","*dianpufa.com","*kanimg.com","*xiaobaixitong.com","*zopomobile.com","*umetrip.com","*hp-ww.com","*windows.net","*akdy.com","*myitit.com","*yezhanjun.net","*opdown.com","*sky-fire.com","*1688988.com","*wenkudaquan.com","*2ccc.com","*mndsoft.com","*huodongxing.com","*eshufa.com","*mysmth.net","*tomonline-inc.com","*js118114.com","*com.com","*tutu001.com","*gg.ma","*gdnanke.com","*estrongs.com","*cnki.net","*yingyonghui.com","*rt-thread.org","*29293.com","*yunci4.com","*comsz.com","*weiphone.com","*8448.cc","*njtarena.com","*bookschina.com","*0830bbs.com","*kaiwind.com","*chachaba.com","*androidesk.com","*expreview.com","*sino-di.com","*vnet.mobi","*bitauto.com","*cutv.com","*eeworm.com","*4008517517.com","*alixueyuan.net","*morcha.net","*baifendian.com","*orstatic.com","*chinauma.com","*sina.com","*leba1.com","*gicp.net","*alibuybuy.com","*aidaicn.com","*rsleds.com","*gxp.cc","*gamecps.com","*hyedu.com","*hellolvyou.com","*51zhangdan.com","*flyguest.com","*gongkaocn.com","*panelook.com","*hwjyw.com","*qingdaoculture.com","*hxsk.net","*diyifanwen.com","*renrendanche.com","*mbscss.com","*guahao114.com","*springairlines.com","*leju.com","*a12300.net","*popgo.net","*6188.net","*judou123.com","*uutuu.com","*mimivo.com","*elinkvps.com","*qotom.com","*hefls.net","*8864.com","*htwisdom.com","*tianjimedia.com","*qdss.org","*51nb.com","*44vs.com","*guo.fm","*importnew.com","*moxtra.com","*flusherlink.com","*rologo.com","*shengejing.com","*ldbj.com","*zhituad.com","*robotide.com","*51dy.com","*139shop.com","*winupon.com","*meimingteng.com","*chinaacc.com","*xywy.com","*qs199.com","*eudic.net","*jolighting.com","*ganji.com","*ciotimes.com","*ncar.cc","*dgmei.com","*htky365.com","*apwifi.com","*114study.com","*xinquanedu.com","*kaoyan001.com","*cccweb.org","*travelzoo.com","*laolinow.com","*goodoing.com","*myverydz.com","*liaocao.com","*ggmm777.com","*cxtcfw.com","*tejiawang.com","*fzgd.org","*xinyaoyao.com","*365rili.com","*moonbasa.com","*wwwrenren.com","*radiotj.com","*qaohui.com","*qiwen.lu","*miliao.com","*douban.com","*ssl-images-amazon.com","*aicai.com","*priorityclub.com","*800cdn.com","*kb.vc","*chengdesign.net","*knowsky.com","*hecaitou.com","*anjian.com","*cha138.com","*ti.com","*cathaypacific.com","*feiliks.com","*welove520.com","*zxip.com","*sucaitianxia.com","*xiamenair.com","*elongstatic.com","*huoche.com","*typeland.com","*778669.com","*kfcdn.com","*pcbeta.com","*anquan.org","*stbxx.com","*yculblog.com","*daodao.com","*chinaceot.com","*xunyou.com","*infzm.com","*fenanr.com","*blueidea.com","*m9o.net","*samsung.com","*joome.net","*amap.com","*moji002.com","*hefei.cc","*dadao.net","*mayi.com","*sqlku.com","*honssen.com","*51img1.com","*wbxia.com","*xooob.com","*bilibili.tv","*hudong.com","*moliplayer.com","*tracefact.net","*heiqu.com","*xsjk.net","*saxmcu.com","*memehu.com","*56.com","*ku6vms.com","*istreamsche.com","*lifetoy.org","*sfacg.com","*waptw.com","*exetools.com","*86c.net","*kimiss.com","*towords.com","*boxcdn.net","*lovebizhi.com","*huain.com","*weste.net","*zhuwang.cc","*afterdownload.com","*94994.com","*daoduoduo.com","*hnxhdq.com","*readfree.net","*rushiwowen.org","*tmtpost.com","*icloudpower.com","*huitu.com","*bokeccimg.com","*qinqishuhua.org","*chinabmx.com","*oho168.com","*yccdn.com","*ctrip.com","*zjolcdn.com","*guofenke.com","*mt30.com","*xxh.cc","*nature-museum.net","*myit365.com","*apkbus.com","*wanzao.com","*anthonos.org","*junshijia.com","*static-cisco.com","*acgvideo.com","*cdworking.com","*zhiqiang.org","*itlily.com","*84tt.com","*aiganggu.com","*500.com","*tx-power.com","*vipshop.com","*fsou.com","*yy67.com","*999.cc","*scbike.net","*coovee.net","*cencev.com","*milier.com","*weidunewtab.com","*haha365.com","*pptv.com","*9chun.com","*topsage.com","*fenzhi.com","*xgdjx.com","*ylysny.com","*aolai.com","*boxshows.com","*hainan.net","*shanghaidaily.com","*cnbearing.biz","*ihome99.com","*gudaovision.com","*yymax.com","*qicaise.com","*idqqimg.com","*hengzefu.com","*friendoc.net","*yiyuanyi.org","*saraba1st.com","*ylunion.com","*xueqiu.com","*firstmag.net","*binhuo.com","*rayfile.org","*yiinet.net","*timesafer.com","*taskcn.com","*ggyad.com","*365fenxiang.com","*cnblogs.com","*ea3w.com","*duoge007.com","*ttmimg.com","*hp.com","*155.com","*pc120.com","*aameinv.com","*haliyuya.com","*nrelate.com","*yangtse.com","*qzhi5.com","*boysky.com","*pigai.org","*historicalchina.net","*ajhdf.com","*9160.com","*myapp.com","*wyn88.com","*qi678.com","*33lc.com","*soft568.com","*xtube.com","*51tuofu.com","*freescaleic.org","*alipayobjects.com","*citysbs.com","*zdhmkq.com","*alsogood.com","*bestbai.info","*gz4u.net","*luguhusige.com","*t00y.com","*qbaobei.com","*howfile.com","*bz1111.com","*333wan.com","*isv8.com","*95588.com","*pop-fashion.com","*ifensi.com","*qqdo.com","*extrabux.com","*funlon.com","*try8.info","*monternet.com","*cersp.com","*ubuntusoft.com","*fltacn.com","*17v5.com","*bundpic.com","*taoshu.com","*linuxfly.org","*lashouimg.com","*xiustatic.com","*pachiratech.com","*china-designer.com","*51yes.com","*8888fy.com","*doyouhike.net","*jpwind.com","*zhenren.com","*lanree.com","*pfspace.com","*datavlab.org","*duitang.com","*rokey.net","*subaonet.com","*sf-express.com","*web887.com","*kui.cc","*tx29.com","*awc618.com","*socang.com","*1616.net","*4399.com","*fronware.com","*cskaoyan.com","*gj510.com","*mytz.net","*vicp.net","*baobeitu.com","*duose.com","*guanglun.net","*061100.com","*duomai.com","*zzidc.com","*webscache.com","*bianews.com","*law-lib.com","*uzaicdn.com","*08279.com","*javabloger.com","*liketuan.com","*chenkunli.com","*eastgame.org","*lydl.net","*feng91.com","*qxinxi.com","*cheyisou.com","*epaidai.com","*win4000.com","*youdao.com","*aboboo.com","*intsig.com","*10010js.com","*gdyjs.com","*verifylist.com","*sc157.com","*591hx.com","*geforce.com","*auctivacommerce.com","*mingrunad.com","*ousns.com","*sgcai.com","*xinray.com","*vgoapp.com","*chinaface.com","*xincai.com","*42qu.net","*sgamer.com","*boleme.com","*lwlm.com","*55.com","*jobdu.com","*35.com","*ckdvd.com","*fengfei.net","*moji001.com","*jdoqocy.com","*popbook.com","*sosucai.com","*phjy.net","*meipin100.com","*letvstore.com","*mipang.com","*yuhuagu.com","*luyou8.com","*worldofwarcraft.com","*zijidelu.com","*molei.net","*siyuefeng.com","*acg.tv","*dazhima.com","*05sun.com","*163.com","*laidianduo.com","*ellll.com","*5read.com","*mapabc.com","*phpwind.net","*uhuo.org","*hunt007.com","*zynews.com","*baimao.com","*55tuan.com","*ttmeiju.com","*infrastructure","*hifly.tv","*join-2008.com","*5asd.com","*mjoys.com","*pagechoice.net","*ncbike.net","*duokan.com","*lc0771.com","*cttsn.com","*holdjava.com","*abcache.com","*segmentfault.com","*uedmk.com","*shenghuomei.com","*gogomaster.com","*uspcat.com","*aikuwan.com","*mozilla.org","*longhoo.net","*ibcde.com","*berspective.com","*xmbtn.com","*yucmedia.com","*springer.com","*hiapk.com","*szhome.com","*meipai.com","*qdit.com","*fenxi001.com","*06621.com","*zhiyoujie.com","*guanzhuyouli.com","*kukuplay.com","*goodtp.com","*20yy.com","*whtbk.com","*beifaxian.com","*doyoo.net","*microad-cn.com","*liantu.com","*tongwenguan.com","*115.com","*wochacha.com","*standardchartered.com","*cctcct.com","*dmtrck.com","*yybox.cc","*hichinacloud.com","*dnion.com","*yiqifa.com","*xmcdn.com","*bt5156.com","*devmate.com","*baiy.net","*hitao.com","*shushao.com","*qipilv.com","*aixdev.org","*sohozj.com","*hostelcn.com","*xns315.com","*thebeijinger.com","*trip8080.com","*belugaboost.com","*izaojiao.com","*aili.com","*mykurong.com","*metroer.com","*kaoyanbbs.net","*daotin.com","*allyes.com","*ihaveu.net","*win8ku.com","*520zc.com","*sj63.com","*999d.com","*a3p4.com","*uirss.com","*ouyaoxiazai.com","*dou.bz","*southmoney.com","*hxcdn.net","*imrworldwide.com","*muyingzhijia.com","*chinasic.com","*kximg.cc","*12yao.com","*315che.com","*dpsson.com","*8080.net","*vbuluo.com","*qcxz.net","*cr173.com","*font6.com","*pstatp.com","*embedinfo.com","*6rooms.com","*futuredm.com","*shishangqiyi.com","*91339.com","*zbgl.net","*wow8.org","*cmfchina.com","*naivix.com","*migu.tv","*okdsj.com","*pinggu.org","*lisoundearphone.com","*sqshb.com","*5173tuan.com","*qrmbl.com","*airad.com","*letv.com","*99ddd.com","*xk77.com","*139js.com","*jxkp.com","*ictclas.org","*d2c-games.com","*jiaqi5.com","*ucweb.com","*qianyuedu.com","*veryzhun.com","*ticket2010.com","*huanlang.com","*cnepub.net","*taobeihai.com","*zhuzhu.cc","*bjokli.com","*chinacpc.com","*huohua.in","*mini123.com","*xsu.cc","*zixia.com","*fanfou.com","*cloudbbs.org","*checkgfw.com","*wallba.com","*googleadservices.com","*qycn.com","*newwaverewards.com","*miaoke.org","*bjmama.net","*ntjy.net","*meituan.net","*tuchong.com","*vancl.com","*zaoxue.com","*uuzu.com","*cdbike.net","*toflon.com","*chinavoa.com","*tx100.com","*ssdqfs.com","*tb210.com","*cncn.com","*hrreserve.com","*4321.la","*aihuiyin.com","*aoaob.com","*ggdxc.com","*agoniz.net","*guansoft.com","*neworiental.org","*cardcmb.com","*fun4hi.com","*mibuo.com","*0598yu.com","*shjfilm.com","*hhjxie.com","*jackd.mobi","*cnproxy.com","*bcttc.com","*qmango.com","*wmmmw.com","*moon-soft.com","*yzddol.com","*flash45.com","*dw2f.com","*3gfly.net","*500wancache.com","*25pp.com","*macapp.cc","*shentucao.com","*gqsip.com","*51labour.com","*mydrivers.com","*bppstore.com","*upupyoyoyo.net","*happigo.com","*iosinspires.me","*jianshe99.com","*yyfc.com","*zhi.hu","*doitim.com","*chinalawedu.com","*bbniu.com","*bwgame.org","*ynpxrz.com","*yxduo.com","*zxmeili.com","*jctrans.com","*chanel.com","*foxitsoftware.com","*soupis.com","*yifan8899.com","*freehead.com","*sino-epay.net","*0512kd.com","*maidangao.com","*veryim.com","*normtm.com","*goepe.com","*macworldasia.com","*88210212.com","*haodf.org","*yxdown.com","*comsenz.com","*jjtang.com","*111zph.com","*zhuanbao.com","*ipadown.com","*gbin1.com","*51f1.com","*cheletong.com","*utop.it","*ningbo18.com","*55tjk.com","*koolearn.com","*zpcdn.com","*qqyy.com","*bjbahao.com","*uxdc.org","*waerfa.com","*tianyinsoft.com","*haodou.com","*ky211.com","*wo99.com","*wper.com","*x-berry.com","*tiebaimg.com","*iwallpaper.me","*5dmail.net","*mfdvd.com","*uoun.cc","*chbcnet.com","*iisicp.com","*iq123.com","*tk3000.net","*live800.com","*taikoyc.com","*weixintuan.net","*moke8.com","*shuitan8.com","*nexoncn.com","*zhgpl.com","*javaweb.cc","*wm090.com","*irs01.com","*taobao.org","*funshion.com","*3snews.net","*cnyu.com","*51ielts.com","*zijidelu.org","*psychcn.com","*fsjwg.com","*aaeweb.com","*thawte.com","*leexa.com","*twcczhu.com","*aliyiyao.com","*izsxw.com","*miiee.com","*mtime.com","*founder.com","*gzedupg.com","*qiannao.com","*speiyou.com","*yinghai.net","*63tuangou.com","*muhecdn.com","*kongzhong.com","*ruby-china.org","*xiaobians.com","*qbox.me","*yueban.com","*nantaihu.com","*apmebf.com","*mbaobao.com","*3munion.net","*cdn123.net","*youmi.net","*letvcdn.com","*shenmeshi.com","*codefans.net","*ubao.com","*ofcard.com","*zwbk.org","*youxipai.com","*52rd.com","*cetv.com","*gameabc.com","*woshao.net","*chinahw.net","*cthy.com","*gjgwy.org","*90qh.com","*foursquare.com","*007ok.cc","*zhangyue.com","*doubleclick.net","*k65.com","*wanlitong.com","*kan83.com","*piaochong.com","*isstudy.com","*lejianshop.com","*juntais.com","*yinyuetai.com","*ijinshan.com","*jbguide.me","*rickyxu.net","*hjusaexpress.com","*gsdpw.com","*7837.com","*app111.com","*orsoon.com","*sdbluepoint.com","*xluo.com","*jjzad.com","*kuakao.com","*playhaven.com","*china-fun.net","*shupeng.com","*qiyi.com","*vanclimg.com","*etpass.com","*ekan.tv","*tuidian.net","*feifeicms.com","*wefinder.com","*dianjing.org","*hichina.com","*lvren.com","*alloyteam.com","*cdndelivery.com","*bikesky.com","*126.am","*mytv365.com","*120.net","*bdlrl.com","*neworldedu.org","*82a.net","*xiumu.org","*uwowo.com","*mi1.cc","*m1905.com","*denglu.cc","*gamebean.net","*jywkj.com","*444mmm.com","*oiegg.com","*chinacache.net","*iciba.com","*hzbike.com","*qqride.com","*losezone.com","*sosuo.name","*ddove.com","*luoxiaoge.com","*keepc.com","*iwanpc.com","*xy9z.com","*sypopo.com","*hnweijia.com","*gotoip55.com","*woiring.com","*itpub.net","*zijieshe.com","*szonline.net","*my0511.com","*lw23.com","*nuomi.com","*imglafaso.com","*ljob.net","*ziyou.com","*imyquan.com","*766.com","*wotfan-guangzhou.com","*shendu.com","*ellechina.com","*360top.com","*data.gg","*yimeiads.com","*iqilu.com","*shmeijing.net","*infinitinb.net","*htwx.net","*china-pub.com","*leaderhero.com","*suki.so","*inmobi.com","*engkoo.com","*abc68888.com","*haerbin.org","*mychinahr.com","*t3life.com","*soooner.com","*nvren3.com","*yizitong.com","*yiwatch.net","*jonahome.net","*upyun.com","*ssjpx.com","*jinti.com","*fk-union.com","*nduoa.com","*jqbyby.com","*zhijinfc.com","*itnews001.com","*anquanbao.com","*win7china.com","*microchip.com","*ccrun.com","*ykimg.com","*marriott.com","*looyu.com","*lampbo.org","*51wnl.com","*wuyou.la","*devexpresscn.com","*xdcdn.net","*linuxeden.com","*linezing.com","*tuchong.net","*ilite.me","*paowang.net","*tihu.cc","*dou00.com","*1kapp.com","*chinamusical.net","*pinshan.com","*p5w.net","*intercontinental.com","*ptbus.com","*nulmart.com","*maiyadi.com","*dy2018.com","*duoyi.com","*chinadrtv.com","*holidayinn.com","*vista123.com","*jyeoo.net","*bwchinese.com","*xzscd.com","*suning.com","*dospy.org","*googpc.com","*whlmjy.com","*meishow.com","*kdhome.net","*cngba.com","*didaimg.com","*iqshw.com","*egouz.com","*razxc.com","*dtcec.com","*qinglajiao.net","*womenwan.com","*hz0752.com","*ipinggou.com","*sanfo.com","*nikefans.com","*585.com","*wauee.com","*01lm.com","*lohasus.com","*xigutang.com","*pubsage.com","*tudou.com","*99read.com","*breadtrip.com","*cntgol.com","*hui800.net","*yesmyimg.com","*kandian.net","*qqttxx.com","*bokee.net","*shenyangbus.com","*robinzhu.com","*itruelife.com","*zhouwenyi.com","*dwstatic.com","*ali213.net","*jmstatic.com","*zdic.net","*lotpen.com","*ajiang.net","*aliued.com","*pc30.com","*sheying8.com","*uservod.com","*longwiki.net","*cztour.com","*sheca.com","*pzh123.com","*star8.net","*yanzheng.com","*hualongxiang.com","*soupingguo.com","*lvping.com","*gsdwj.com","*8chuang.com","*ourtra.com","*ymail.com","*bstatic.com","*ums.bz","*littlewriter.org","*tangsuanradio.com","*jmenren.com","*xiannixiaozhu.com","*fulun.org","*waduanzi.com","*360buyimg.com","*yigandci.com","*aisandi.com","*2008php.com","*lti-china.com","*modxz.com","*kongfz.com","*zmdhw.com","*juedui100.com","*sogou.com","*ttmouse.com","*5sing.com","*chinaelections.org","*imshell.com","*irs01.net","*hsuho.com","*yokacdn.com","*winekee.com","*egoedu.com","*denglu.mobi","*99vk.com","*ffsky.com","*ttkuu.com","*yoqoo.com","*kqzyfj.com","*ihanker.com","*614mm.com","*hwpan.com","*nvrenfang.com","*bjsdfz.com","*testflightapp.com","*21ic.com","*wangyeba.com","*mianfeiqiang.com","*17k.com","*btbbt.com","*515tv.net","*autobloglink.com","*ssgo.com","*wanwang.com","*ppurl.com","*yuexiaodao.com","*dvdba.cc","*googlesyndication.com","*jobbole.com","*chinatibetnews.com","*e2.ma","*sodu.org","*baiheee.com","*zypfsc.com","*18dao.net","*duiduila.com","*xsmi.org","*edutime.net","*aipai.com","*jq-school.com","*gouwula.net","*66vod.net","*82623.com","*aceen.com","*qiyadeng.com","*smartisanos.com","*9610.com","*yiwad.com","*9519.net","*chujian.com","*029gc.net","*64365.com","*theooxx.com","*ct10000.com","*dtgt.org","*fatianxia.com","*zh-114.com","*du8.com","*jueshitangmen.info","*jxdyf.com","*cocimg.com","*wtt365.com","*cmfu.com","*168bx.com","*guoxue123.com","*ushihui.com","*zhangguibang.com","*3gbbs.com","*hogame.com","*vgm8.com","*cpm360.com","*meile.com","*xxbh.net","*wiisocl.com","*iask.com","*hoopchina.com","*8791.com","*51jobcdn.com","*eduwo.com","*renji.com","*guolun.net","*my-graphics.net","*onhoo.com","*chinapet.com","*868e.com","*wontube.com","*userplane.com","*madeye.me","*cngold.org","*hichinaimg.com","*sinos.name","*elpisafe.com","*sowang.com","*e1htstatic.com","*doudou360.com","*hupan.com","*iouter.com","*totoolaw.com","*111cn.net","*139001.net","*hunantv.com","*citygf.com","*mxhichina.com","*zlg.cc","*ynet.com","*lifevc.com","*musiceol.com","*oobeta.com","*miaozhen.com","*et8.net","*webterren.com","*400gb.com","*wanlibo.com","*51gxqm.com","*img-cdn.biz","*lyncplus.net","*loli.my","*55522.com","*chddh.com","*360doo.com","*fswzz.com","*cnchu.com","*chinaw3.com","*njlongre.com","*letao134.com","*pingan.com","*95881.com","*fetion-portal.com","*taobao.com","*epweike.com","*ihushcdn.com","*wselearning.com","*triacebike.com","*hnair.com","*egreatworld.com","*ze5.com","*59n.net","*mapbar.com","*263.net","*btsmth.com","*cjhospital.com","*pku-exploit.com","*xiaoqianbao.com","*hqdoor.com","*zastatic.com","*chinaunix.net","*cctvpic.com","*62001188.com","*chinese-cp.com","*2345sc.com","*ztgame.com","*aixueyou.com","*62mi.com","*redocn.com","*digicert.com","*wangzhi800.com","*acs86.com","*027art.com","*kanshu.com","*redekuai.com","*55bbs.com","*onease.com","*mxwz.com","*qstatic.com","*tianyayidu.com","*liuhuadong.com","*77bike.com","*danhuaer.com","*seedit.com","*26552.com","*zasv.com","*e-3lue.com","*sunhenry.com","*lezi.com","*mzstatic.com","*bhfj.com","*mideatuan.com","*ggpht.com","*djkk.com","*pgpop.com","*pinglaoshi.com","*5khouse.com","*koxab.com","*victorykingdom.com","*maijiago.com","*waysoo.com","*pocketres.com","*chiphell.com","*channelray.com","*alibaba-inc.com","*ybkf999.com","*dajuyuancn.com","*ufstone.com","*gucheng.net","*icson.com","*tl100.com","*tj0573.com","*815x.com","*ysedu.org","*prnasia.com","*3023.com","*hellodm.com","*toutiao.com","*soiseek.com","*guohead.com","*cngoldres.com","*digtalinfo.com","*yundasys.com","*ooxx.com","*uuzuonline.com","*8j.com","*fengniao.com","*zhizhizhi.com","*ledabuy.com","*newhua.com","*tuigoo.com","*carschina.com","*oschina.net","*nextsee.com","*wizbag.com","*admin-cn.com","*fengyunzhibo.com","*kuqi.com","*365hch.net","*ctrlv.cc","*dianji007.com","*uya100.com","*tuku.com","*applex.net","*9133.cc","*xifuquan.com","*starming.com","*china.com","*qq.com","*baotime.com","*fengbao.com","*yaziwu.com","*pimei.com","*is686.com","*yintai.com","*lakala.com","*koudai.com","*gouhaokan.com","*dangzhi.net","*aicdn.com","*dianjoy.com","*yoyi.tv","*s-msn.com","*roxcdn.com","*sinastorage.com","*recordjapan.net","*yunio.com","*fitnesity.com","*xn--4xuw73h.com","*hp009.com","*u17.com","*beitaichufang.com","*pb89.com","*chadongche.com","*jbedu.net","*zoossoft.com","*ceair.com","*gameee.net","*hoolo.tv","*yundaex.com","*haozip.com","*artron.net","*xapcn.com","*lm-pk.com","*codante.org","*sun0816.com","*chunyuyisheng.com","*zhzzx.com","*sxslyxx.net","*ourcrack.com","*foyuan.net","*t88u.com","*weico.net","*271234.com","*misbuy.com","*llfzgs.com","*fairchildsemi.com","*dictall.com","*viglink.com","*waipojia.com","*uc123.com","*9buo.com","*wygl.net","*016788.com","*rxwan.com","*hacow.me","*stvba.com","*5q.com","*jinjiangsoft.com","*renren.it","*piaohua.com","*edancing.net","*communicatte.com","*1g1g.com","*dprktimes.com","*banggo.com","*pingwest.com","*killman.net","*phpchina.com","*gamecomb.com","*tbhelper.com","*ku6img.com","*nongmin86.com","*ebaystatic.com","*kdnet.net","*yunfeida.com","*junshishu.com","*zhuansoo.com","*yieldmanager.net","*ttkvod.com","*duowan.com","*auto98.com","*beta3pro.com","*haoring03.com","*colourhill.com","*51you.com","*jiai-sh.com","*luxst.com","*fumanhua.com","*pku-hall.com","*sojump.com","*tsmil.com","*dfcfw.com","*ad51.net","*beihai365.com","*zbjd.net","*meizu.com","*jbxue.com","*yougou.com","*imanhua.com","*setways.com","*papa.me","*kouchou.com","*aee.com","*easternmiles.com","*zsbike.net","*hqbcdn.com","*asktu.com","*aibang.com","*eecer.com","*tehuiju.com","*cmdn.net","*easou.com","*imgii.com","*staticsdo.com","*airasia.com","*tuniucdn.com","*cric.com","*made-in-china.com","*madserving.com","*bohaishibei.com","*paopaoche.net","*xabpo.com","*ppseek.com","*s1979.com","*xyj.im","*china-cycle.com","*qdmm.cc","*theutlab.com","*shuiliwai.com","*dospy.com","*52fuqing.com","*yesky.com","*kanvcd.cc","*iboxpay.com","*jiaren.org","*yohobuy.com","*pinggu.com","*1shangyu.com","*weibo008.com","*guao.cc","*ikeepu.com","*geekpark.net","*020883.com","*ichotelsgroup.com","*baicizhan.com","*ihg.com","*chinacrane.net","*huoxingyu.com","*21cbh.com","*kk98.com","*fnms.tv","*8wss.com","*lesmiz.net","*517zjy.com","*vmvps.com","*shanghai-air.com","*zhujiangroad.com","*xzk.me","*ibeipai.com","*hdslb.org","*babytreeimg.com","*pc841.com","*liketry.com","*avfline.com","*chinajci.com","*mojichina.com","*miaozhenjiang.com","*cooguo.com","*iqsuperman.net","*1lo0.net","*ebiaoegou.com","*fadu.cc","*bjjgyy.com","*qplus.com","*zhibo8.cc","*gzmama.com","*3444.cc","*dongfangshenyun.com","*myqqface.net","*redvi.com","*eeloves.com","*handyui.com","*facejoking.com","*haha.mx","*hommk.com","*qqread.com","*paidai.com","*open-open.com","*ppnba.net","*zj123.com","*mimiduo.com","*xici.net","*zgoff.com","*ftp","*chinese-luxury.com","*mmonly.com","*tbjfw.com","*line0.com","*livefilestore.com","*taoxiaobao.net","*272768.com","*ttmeishi.com","*cairot.com","*cnwest.com","*raiyi.com","*artemisbuzz.com","*beisen.com","*ccgslb.net","*601819.com","*fx678.com","*btui.it","*congweng.com","*asiamiles.com","*u17i.com","*weibolook.com","*inews.io","*ps123.net","*sijimishu.com","*lianzidi.com","*epubook.com","*shu0.net","*designtotalk.com","*bjjgnk.com","*7890dy.com","*dongshizhongyi.com","*hd2pt.com","*googleusercontent.com","*3gsha.com","*lccz.com","*0931007.com","*camgle.com","*amazon.com","*yunpdf.com","*jakrooshop.com","*airasiago.com","*jxedt.com","*ptrss.com","*zhiwo.com","*zhaogepu.com","*storagechina.net","*dx888.com","*qvod.com","*quanzhi.com","*51lunwen.com","*meiliworks.com","*piaoliang.com","*founderbn.com","*ktwxchina.com","*5432168.com","*tomipad.com","*2000tuan.com","*newsmy.com","*yolk7.com","*china360.org","*entitlenow.com","*haobao.com","*infothinker.com","*dm08.com","*tqlkg.com","*189share.com","*jinjianginns.com","*linuxdeepin.com","*exbib.net","*jxcycling.com","*ixpub.net","*ntalker.com","*zhaopin.com","*53shop.com","*csbew.com","*pcbeta.net","*arpun.com","*blogjava.net","*windsad.com","*freehao123.com","*178.com","*suorang.com","*0577bike.com","*optimizely.com","*woxihuan.com","*0-6.com","*haodianpu.com","*duomi.com","*qqtv123.com","*tdpress.com","*fanhuai.com","*rexsong.com","*ibeidou.net","*titan24.com","*dipan.com","*114la.com","*samboc.com","*huaweidevice.com","*14696.com","*historykingdom.com","*chinaefu.net","*9see.com","*haodics.com","*xlobo.com","*mycolorway.com","*ccluxy.com","*3987.com","*ktvc8.com","*u148.net","*zqgame.com","*yxlady.com","*168sucai.com","*91town.com","*998.com","*chinaitlab.com","*cjxtv.com","*kang3.com","*maijiatang.net","*fantong.com","*gzcycling.com","*hflash.com","*byox.org","*adsmogo.org","*bankofchina.com","*tuijian.tv","*soku.com","*supplyframe.com","*venusveil.com","*sobey.com","*bznx.net","*pp.cc","*dssg.net","*xiaomishu.com","*examw.com","*tblfans.com","*chm-pdf.com","*versusio.com","*yxcpm.com","*idlphone.com","*amobbs.com","*li.vc","*zbii.com","*itezhop.com","*jocgreatwall.com","*eduzhai.net","*3e008.com","*chinabreed.com","*blogcdn.com","*gdcrj.com","*mukkyu.com","*colorweekly.com","*q88j.net","*zyue.com","*superboss.cc","*qixingquan.com","*99manga.com","*tv365.cc","*ffdy.cc","*flash8.net","*ekoooo.com","*changba.com","*blogbuscdn.com","*bjbtg.net","*linkchic.com","*muduobt.com","*woshipm.com","*ivsky.com","*51test.net","*goalchina.net","*xmf4.com","*porntube.com","*tigercity.net","*intsig.net","*arsenalcn.com","*digi-uniclick.net","*brassring.com","*chinaren.com","*flyertea.net","*uodoo.com","*56imgs.com","*taodianzhang.net","*ifengimg.com","*movshow.com","*minshengnet.com","*ld160.com","*showall.me","*haodic.com","*youxitui.net","*guofs.com","*51youwei.com","*statickksmg.com","*babidou.com","*igoodsoft.net","*kiwi66.com","*as-doll.com","*uwen.com","*bohe.com","*cfind.com","*shgjj.com","*hubike.com","*cnielts.com","*rongshuxia.com","*fanli7.net","*aqioo.com","*spermwindow.com","*battle.net","*danlan.org","*shentime.com","*greencompute.org","*tao30.com","*58pic.com","*kkkmh.com","*soufun.com","*anhuinews.com","*kugou.com","*wobo.tv","*3393.com","*erke.com","*njupco.com","*gasshow.com","*singaporeair.com","*hkzhan.net","*dajieimg.com","*cndns.com","*jianfei.com","*cdc.im","*gooseeker.com","*wei2008.com","*sfbest.com","*51piaobo.com","*ushi.com","*xiecheng.com","*liba.com","*kekenet.com","*chenxudong.com","*alipay.com","*xa01.cc","*456.net","*kongfz.cc","*ppsdy.com","*4738.com","*tankeyouxi.com","*idcquan.com","*ithaowai.com","*vistachinese.com","*52liunian.com","*usousou.com","*bjwj2y.com","*jd-bbs.com","*qqzz0.com","*epac.to","*dopa.com","*meetinware.com","*qzoner.net","*niunu.com","*googleapis.com","*china-ef.com","*to360.com","*bjsubway.com","*opengit.org","*cdnzz.com","*ajkcdn.com","*mdayday.com","*uzai.com","*abaxhw.com","*flacai.com","*ihush.com","*aibangjuxin.com","*cook100.com","*ncigou.com","*whdafei.com","*chinaz.com","*yazuo.com","*keaiju.com","*china-weiwei.com","*wswire.com","*nvidia.com","*xc158.com","*jindouyun.com","*feeyo.com","*zgsflt.com","*njdfwb.com","*cc222.com","*wm-it.com","*cy.com","*ducms.com","*4px.com","*jarford.com","*tuyansuo.com","*lanfw.com","*pkueap.com","*xiaojukeji.com","*wayoulegal.com","*itugo.com","*aliexpress.com","*qiqibudy.com","*rigodesign.com","*tuhao.cc","*kuaiwan.com","*zg-sj.com","*themex.net","*anywlan.com","*longene.org","*songshubnb.com","*ehappystudy.com","*giant.so","*norislam.com","*daqi.com","*kanglu.com","*xmfish.com","*169hao.com","*witsee.com","*topcased.org","*billwang.net","*qunar.com","*cfl.org","*ncxhw.com","*zhiyue.me","*zhaojiaxiao.com","*cjolimg.com","*fashiontrenddigest.com","*ppren.com","*linsports.com","*ceshiguang.com","*leexa.org","*42qu.com","*sysujwxt.com","*ci123.com","*usvisadream.com","*doc88.com","*qzoner.com","*kwvdp.com","*0592sl.com","*shiwan.com","*aoyou.com","*southcn.com","*yszyz.com","*guoku.com","*folkw.com","*xphlxj.com","*xjquc.com","*jtmm.com","*caxit.com","*babycenter.com","*8264.com","*05wan.com","*qyer.com","*gao7.com","*jjlg.net","*cbgnews.com","*mbsimg.com","*newmov.com","*xueleku.com","*wanmei.com","*mangocity.com","*thunderex.com","*azpan.com","*oeeee.com","*tower.im","*kingdee.com","*cdndm.com","*cbn.me","*shahejiuye.com","*bendibao.com","*gzeeu.com","*cnconfucius.com","*upaiyun.com","*rayche.cc","*666ccc.com","*buy2046.com","*feichang.com","*sopopo.com","*ing2ing.com","*tuanimg.com","*chasedream.com","*cisco.com","*chinanetcenter.com","*elecfans.com","*htsec.com","*kkkwww.com","*chinaunionpay.com","*baidu.com","*zeda100.com","*gaopeng.com","*xiaomi.net","*xp911.com","*qqfacebox.com","*esqimg.com","*657.com","*973.com","*yingjiesheng.net","*dm5.com","*younet.com","*fengyx.com","*tuzhan.com","*buyfine.net","*cnzjqi.com","*lawtimeimg.com","*cnhan.com","*ibangkf.com","*wopti.net","*baidu-tech.com","*126.fm","*lxdns.com","*86qt.com","*bibi168.com","*mtimeimg.com","*114piaowu.com","*tctd.net","*ithome.com","*haogongju.net","*taotantan.org","*idc8888.com","*stockstar.com","*51.la","*cndw.com","*elemecdn.com","*36kr.net","*miaov.com","*qdcdn.com","*lady8844.com","*5lux.com","*1198.com","*shoujipc.net","*weixueyuan.net","*journeyformac.com","*yixieshi.com","*s-msft.com","*donews.net","*yqdown.com","*cebbank.com","*0532gc.com","*hustonline.net","*all.my","*babyfamily.com","*chinaevent.org","*vrbrothers.com","*amazingstore.org","*youboy.com","*zghtpc.com","*9yls.net","*busiphi.com","*pipicms.info","*139life.com","*ruixuesoft.com","*cjol.com","*thmz.com","*deppon.com","*mangdian.com","*chinaui.com","*gkstk.com","*hyj.com","*adminzu.com","*talkyun.com","*qqgameapp.com","*haosucai.com","*alibaba.com","*xd.com","*shyuou.com","*yanghuaren.com","*99ys.com","*vsharing.com","*welefen.com","*bz55.com","*xiyanghui.com","*8684.com","*newclasses.org","*55haitao.com","*puata.info","*daningdaning.com","*jjsop.com","*2975.com","*bzbao.com","*qqmail.com","*50mk.com","*fs-mall.com","*koolbao.com","*ttjk.com","*sanguosha.com","*kshot.com","*yingjiesheng.com","*maijsoft.com","*17donghua8.com","*yimuhe.net","*023dg.com","*wpxap.com","*58cn.com","*123cha.com","*registermsg.com","*openxid.com","*huzhulu.com","*5211game.com","*powerrsoft.com","*solaridc.com","*globalmi.com","*360zebra.com","*qd-mh.com","*centrmus.com","*1t1t.com","*dongxi.net","*imageaimer.com","*aixie.org","*deviantart.net","*sinaapp.com","*img-space.com","*chinesehotels.org","*ximalaya.com","*blogcn.com","*cwddd.com","*68design.net","*gwxdn.com","*yixiao.net","*ulink.cc","*pc6.com","*taobaombaobao.com","*gotocdn.com","*12dian.com","*tetimes.com","*pv.cc","*iphonespirit.com","*lecai.com","*500wan.com","*ilitu.com","*sonkwo.com","*digieq.com","*amznz.com","*12580.com","*shusp.com","*becoding.com","*25renti.com","*51gugu.com","*wangpiao.com","*haogo365.com","*ppaaol.com","*gucunpark.net","*6dad.com","*ihao.net","*567ys.com","*dbs01.net","*51gongsi.net","*fanmanhua.com","*52miji.com","*amlady.com","*tjj.com","*yododo.com","*mbalib.com","*bengou.com","*162cm.com","*fcchbj.com","*yinsha.com","*ptshow.net","*ganniu.com","*penbbs.com","*wulian.cc","*wjwcn.com","*emaildaquan.com","*321tq.com","*zzhtm.com","*staybridge.com","*qiche8.net","*xjktarena.com","*silverlightchina.net","*scorecardresearch.com","*admin5.com","*liangao.com","*gotoip4.com","*edu24ol.com","*3g3h.com","*qianlong.com","*njgydz.com","*weathercn.com","*feedsky.com","*51xiyy.com","*readself.com","*ksyun.com","*rdtarena.com","*fushipifa.com","*kaibei.com","*88dev.com","*zhaoii.com","*ttout.com","*wasu-umedia.net","*4yt.net","*windowsphone.com","*tx8cdn.com","*imnettle.net","*gridsumdissector.com","*tuanjiebao.com","*wechatapp.com","*ik22.com","*imuyang.com","*chinawlan.net","*atmami.com","*maybellinechina.com","*onetad.com","*tw-17.com","*ziyuan5.com","*so.com","*tongbu.com","*azureblu.net","*61658.com","*dzsc.com","*xixianad.com","*54whr.com","*weico.com","*chedingjia.com","*fx120.net","*98766.org","*qire123.com","*yeedou.com","*likeface.com","*j1.com","*xiaoshoubang.org","*panghufei.com","*webkaka.com","*jiuyan.info","*chinagba.com","*book118.com","*discuz.org","*37cs.com","*cat898.com","*ankangwang.com","*bulaoge.net","*xhby.net","*dianpu360.net","*gvod.net","*qqmom.com","*kvov.org","*btstatic.com","*ourgame.com","*52digital.com","*hi-pda.com","*optimix.asia","*630mm.com","*linuxtone.org","*zidiantong.com","*taoecshop.com","*kdweibo.com","*yeswan.com","*artsbj.com","*huaxi100.com","*oy66.com","*hujiang.com","*qinyegc.com","*ksstjxx.com","*cunan.com","*ooxxnow.com","*jiepang.com","*officefans.net","*do93.com","*depela.com","*west369.com","*zhongliangwomai.com","*aoshitang.com","*erji.com","*koubei.com","*3608.com","*kankanews.com","*cm-analysis.com","*glzy8.com","*ebookcn.com","*woshihaizeimi.com","*ganjistatic1.com","*139qh.com","*24mijie.com","*wowsai.com","*lingshi.com","*19lou.com","*elvxing.net","*yanghua.net","*jjwxc.net","*quanmama.com","*265.com","*bd365.net","*high-hope.com","*otomedream.com","*readnovel.com","*sdo.com","*720pmovie.com","*yhachina.com","*szhk.com","*0713hb.com","*airchina.com","*waveshare.net","*lyina.com","*chinaiiss.com","*yadian.cc","*fanren8.com","*tedabike.com","*guomii.com","*furuise.com","*ninikan.com","*ixiqi.com","*c9cc.com","*takungpao.com","*muzhiwan.com","*cy1990.com","*fireemblem.net","*chinaaudio.net","*houxue.com","*cs090.com","*jfdaily.com","*shcwhj.com","*chromeplus.info","*pmume.com","*whjxw.com","*scdxs.net","*marila.net","*sbnation.com","*daysmatter.com","*bdimg.com","*c-ctrip.com","*100ye.com","*gkcity.com","*e393.com","*5cs5.com","*alicdn.com","*xueersi.org","*zoeou.com","*8877.cc","*dxycdn.com","*bjjgfk.com","*takstar.com","*ecqun.com","*ccidnet.com","*hx9999.com","*tingchina.com","*fancdn.com","*med126.com","*taoche.com","*apesk.com","*52pk.com","*whwd.com","*ucren.com","*csjci.com","*excelhome.net","*kk7kk.com","*bbk.com","*shaibaoj.com","*198958.com","*qukk8.com","*yiyi.cc","*yeeyan.com","*che168.com","*tuan800.net","*javaeye.com","*21cbr.com","*njtarena.net","*isoyes.com","*element14.com","*9158.com","*17446.com","*lncdc.com","*97775.com","*5imx.com","*plealife.com","*007.mx","*ob178.com","*imagchina.com","*yximgs.com","*xmhouse.com","*metroerimg.com","*xianguo.com","*gridsum.com","*zhangku.com","*ylimg.com","*taoxtao.com","*chinayigou.com","*125p.com","*cugala.com","*ottnt.com","*51yala.com","*ckd8.com","*kd1000.com","*img-cdn.com","*269.net","*tianping.com","*redhat.com","*hftogo.com","*iyiyun.com","*rrcheck.com","*chinaqos.com","*pianzi8.com","*aifreedom.com","*fjce.com","*kaoyan.com","*ccpittex.com","*appleifan.com","*tkurl.com","*fangce.net","*4q8q.com","*qiandaohu.cc","*ml90.com","*fimmu.com","*qunarzz.com","*cootek.com","*freebsdchina.org","*meizu.net","*lekan.com","*hao2018.com","*jimu.tv","*wowoj.com","*tutuapp.com","*52hxw.com","*gamersky.com","*myzcm.com","*shenzhenair.com","*lvse.com","*108du.com","*chinanews.com","*taotantan.com","*pandafan.org","*xindou.com","*demohour.com","*wiwide.com","*jz5u.com","*3361.com","*guaguapic.com","*xitek.net","*k1982.com","*leeang.com","*hytool.net","*belle8.com","*cqjy.com","*pps.tv","*8l8e.com","*fangtoo.com","*pbcdn.com","*iyaya.com","*dbank.com","*hbtvtswc.com","*dddddd.net","*sjjia.com","*weihepan.com","*77vcd.com","*ingping.com","*leiphone.com","*a9vg.com","*monteamor.com","*lmmob.com","*wj-hospital.com","*5251.net","*emjcd.com","*youxiaxiazai.com","*coudoudou.com","*tulezijia.com","*jiathis.com","*fenxi.org","*hrloo.com","*8le8le.com","*staticflickr.com","*fenghaibin.com","*youtx.com","*ename.net","*800pharm.com","*uusee.com","*u17t.com","*bladechina.net","*ugoooo.com","*upai.com","*tdimg.com","*motiancity.com","*digitalchina.com","*ilepai.com","*qiewo.com","*diudou.com","*33wan.com","*dewen.org","*novel-supertv.com","*kaifu.com","*yyyqc.com","*aliyuncdn.com","*yoloho.com","*kuqin.com","*haha168.com","*cnzyzw.net","*vmiandan.com","*paixie.net","*daddymugs.com","*twimg.com","*angelcrunch.com","*haizhangs.com","*51g3.com","*jk365.cc","*emoilife.com","*gd560.com","*biketo.com","*taisha.org","*hkzhan.com","*ruyi.com","*yeeaoobox.com","*szyljkw.com","*tangshi.org","*tpooo.com","*17mh.com","*365ta.com","*7fgame.com","*dedeadmin.com","*jsinfo.net","*w3help.org","*daizhicun.com","*lbs8.com","*sh3f.com","*jdunion.com","*tgljw.com","*wolfgo.com","*kandajia.com","*tiaohao.com","*eduuu.com","*chinaticket.com","*erji.net","*neubt.com","*9yao.com","*989game.com","*pplive.com","*manmanbuy.com","*app-sage.com","*wenwo.com","*51voa.com","*easyicon.net","*dgtle.com","*81999999.com","*pkurc.com","*kylin-os.com","*0577net.com","*gamebar.com","*jing.fm","*sosohaha.com","*51php.com","*piaowudawang.com","*luren.cc","*nanren8.com","*apinpai.com","*duobei.com","*sodao.com","*rrhjz.org","*piao.com","*jsharer.com","*naver.com","*koowo.com","*bjhd.org","*hclfm.com","*ufrun.com","*joyinwise.com","*cangbaotu.org","*aobi.com","*pengyou.com","*tgfcer.com","*huanleguang.com","*cmbchina.com","*zampda.net","*yjbys.com","*jmvod.com","*xunzai.com","*triace768.com","*idclicks.com","*xiaomi.com","*piaobuy.com","*qiyou.in","*luo.bo","*55tuanimg.com","*agrantsem.com","*hsdcw.com","*youbo.cc","*gezila.com","*ycwb.com","*mftp.info","*52831.com","*html5china.com","*6885.com","*51honest.org","*cnrdn.com","*lidroid.com","*egooad.com","*easytimetv.com","*okbuy.com","*nba.com","*qsanguosha.org","*daxi123.com","*igao7.com","*facishare.com","*veryapps.com","*yidianda.com","*lduhtrp.net","*huochepiao.com","*huohua.tv","*91.com","*gangker.com","*ipc.me","*qianpin.com","*xizi.com","*gzlm.net","*shuangtv.net","*yninfo.com","*ycool.com","*anjia365.com","*cdn-apple.com","*365exam.com","*manyou.com","*chexun.net","*apphope.com","*zjhyad.com","*wnc8.com","*yoox.biz","*ayawawa.com","*chinavip8.com","*unishoot.com","*lawyersky.net","*axis.com","*qu114.com","*tech-food.com","*yykc.com","*gzonet.com","*y5zone.net","*kfcyouhui.com","*zolsky.com","*image-gmkt.com","*mackong.com","*cnrepair.com","*uedmo.com","*mingdao.com","*hificat.com","*webppd.com","*g365.net","*52blackberry.com","*dfdaily.com","*hou.im","*aqee.net","*588885.com","*tdzyw.com","*eywedu.org","*dh911.com","*jtfk365.com","*huotu.com","*handuyishe.com","*910game.com","*jianguoyun.com","*dxy.com","*x5858.com","*coolapk.com","*55joo.com","*taizhou.name","*egaobo.com","*the9.com","*uuu9.com","*7794lm.com","*9you.com","*reutersnext.com","*diytrade.com","*ehaier.com","*sd173.com","*liuweispace.com","*dayeteng.com","*566game.com","*expo2013.net","*xiu.com","*gongchang.com","*bankofshanghai.com","*win8china.com","*51wan.com","*chana-mazda.com","*tweetmarker.net","*12306.com","*openedv.com","*imocha.com","*romzj.com","*findlawimg.com","*cikuapp.com","*zssns.com","*hdtdxp.com","*057s.com","*fei580.com","*tuniu.com","*1688.com","*kuboluo.com","*utourworld.com","*cnzz.net","*totoo.org","*591wed.com","*cnerent.com","*lqualyn.com","*myzaker.com","*ttpod.com","*hotof.com","*coolxap.com","*51wcity.com","*usportnews.com","*zjgzx.com","*neusoft.com","*qiushibaike.com","*zuibaike.com","*hibbers.com","*yktworld.com","*51app.com","*csdt.net","*beiwaionline.com","*ys168.com","*liuxue360.com","*gc73.com","*17u.net","*snsfun.cc","*90hu.com","*makepic.net","*go2eu.com","*beifangjiaxiao.com","*yxwang.me","*anqu.com","*mmstat.com","*dvdspring.com","*66ys.cc","*99mh.com","*nvsheng.com","*luzhou.net","*huaxia.com","*pkugym.com","*csdn.com","*lusongsong.com","*hbzkw.com","*bubukua.com","*qqywf.com","*lieguo.com","*fei580.net","*gdstudent.com","*cjbyby.net","*cxdq.com","*83000000.com","*photo0086.com","*funet8.com","*239buy.com","*yunkeji.com","*icouple.com","*tiexinbuy.com","*ballpure.com","*juqi.com","*mangafiles.com","*youxi115.com","*jinbeifang.com","*yizhedian.com","*yaohonglou.com","*yongyibook.com","*shuishuier.com","*zorpia.com","*am-img.com","*thethirdmedia.com","*cheshi.com","*soudianhua.com","*ttsunion.com","*appchina.com","*mysteel.com","*haoting.com","*jnmama.com","*foodmate.net","*21tx.com","*yobai.net","*adkongjian.com","*zwads.com","*iwatch365.net","*2cto.com","*lenovomobile.com","*jcxinxi.com","*libdd.com","*bookuu.com","*jmsyzj.com","*chinalawinfo.com","*copyvalue.com","*baofan.org","*langtaojin.com","*elong.net","*xp9365.com","*yodo1.com","*usashopcn.com","*bs008.com","*989web.com","*laiercn.com","*goodyule.com","*htexam.net","*dolphin-browser.com","*ddmapimg.com","*288idc.com","*yntsti.com","*fansimg.com","*114dns.com","*zikker.com","*soperson.com","*huanqiu.com","*ehaoyao.com","*qiyun.org","*open.cd","*tooopen.com","*serverspeeder.com","*ihelpoo.com","*54kefu.net","*52hardware.com","*51job.com","*fushiying.com","*wifigx.com","*codesky.net","*tclm36.com","*imchao.net","*netbig.com","*stcn.com","*nhzy.org","*baijob.com","*cehuan.com","*sxmingjiu.com","*cgjoy.com","*shangpin.com","*mop.com","*600.la","*yousheng8.com","*smartshe.com","*sanyuyb.com","*xingzuoqu.com","*lccsky.com","*willerce.com","*egou.com","*wyx678.com","*url7.me","*homevv.com","*aomy.com","*bokecc.com","*wangyueblog.com","*gksww.com","*nokia.com","*hdroad.org","*ddvip.com","*wuxi.cd","*ostools.net","*bjiff.com","*chinababy365.com","*139.com","*jutuangoo.com","*mopimg.com","*eoemarket.com","*1bu2bu.net","*3renseo.com","*loveyd.com","*yigao.com","*irising.me","*longbuluo.com","*ttc009.com","*zscaomei.com","*rrfmn.com","*kuaiyongbbs.com","*qcydia.com","*vipcareer.com","*shaoerkeji.com","*discuz.com","*diaochapai.com","*chinapay.com","*sicnu.org","*aliyun.com","*mafengwo.net","*nosqlfan.com","*yixia.com","*kyamaki.com","*117go.com","*orca.io","*kbcool.com","*c185.com","*4m6m.com","*jiaoyou8.com","*dgzx.net","*albinworld.com","*baofeng.net","*jandan.net","*nike.com","*fql.cc","*ddmap.com","*fengbuy.com","*menkr.com","*linkwan.com","*sdsgsyj.com","*3464.com","*3lian.com","*uedma.com","*huacolor.com","*xhunion.com","*funinput.com","*outfit7.com","*uibia.com","*xdowns.com","*726.com","*iqbug.com","*taobaocdn.com","*mobilegz.com","*5551go.com","*aoaola.com","*chewen.com","*028search.com","*merida.so","*bmff.net","*williamlong.info","*sxcm.net","*tzoo-img.com","*263em.com","*1ting.com","*btv.org","*follow5.com","*xiachufang.com","*51testing.com","*filmphoto.org","*51bi.com","*union178.com","*chncpa.org","*insenz.com","*58.com","*bbsour.net","*23728.com","*vjia.com","*cmguocai.com","*noo-noo.org","*lettv.com","*henanci.com","*starcorcn.com","*atpanel.com","*wuji.com","*1sus.com","*emailcar.net","*zhubajie.com","*qiushid.com","*toodaylab.com","*tzhledu.net","*jingju.cc","*qiangpao.com","*didatuan.com","*yile.tv","*th369.com","*xigua110.com","*urbandictionary.com","*tttejia8.com","*iqiubo.com","*zocai.com","*025tata.com","*abchina.com","*mebi9t.com","*abang.com","*pbs.org","*57dj.com","*zhanzhang.net","*digusync.com","*feiyien.com","*iemate.com","*paipai.com","*92shequ.com","*tingclass.net","*drivergenius.com","*21dnn.com","*yeardear.com","*tesoon.com","*xiyuit.com","*ccb.com","*bhgbox.org","*zhangshang.mobi","*letvcloud.com","*bailitop.com","*17oh.com","*imgo.tv","*jyimg.com","*jsbc.com","*000wan.com","*baidupcs.com","*appads.com","*xda-china.com","*d8.cm","*gkz6.net","*ximgs.net","*starandroid.com","*cnzz.com","*hlgnet.com","*wdjcdn.com","*halv.com","*haiyigd.com","*z-fan.com","*iwmgh.com","*onlinedown.net","*infomous.com","*img168.net","*cyacc.com","*wali.com","*paipaiimg.com","*dayainfo.com","*ooopic.com","*aikao.com","*chinaamc.com","*deishuo.com","*linuxdiyf.com","*qiushibaike.cc","*app111.org","*newbalance8.com","*corel.com","*xuxule.com","*cdairport.com","*17lp.com","*qinsmoon.com","*ppsimg.com","*360doc.com","*taihainet.com","*pfcexpress.com","*cnmo.com","*gzmr.net","*cncsj.net","*xici800.com","*xiaomei.cc","*verycd.com","*43gz.com","*120askimages.com","*xungle.com","*pic9382.com","*tiexue.net","*sohuns.com","*ol-img.com","*sasa.com","*ttkvod.net","*paipaitxt.com","*zbinfo.net","*reflib.org","*cmgame.com","*t0574.com","*niurenw.com","*beutu.com","*etuan.com","*evernote.com","*lefeng.com","*voole.com","*city8.com","*yp900.com","*codinglabs.org","*mosa86.com","*news18a.com","*hotmail.com","*kekeapp.com","*maxpda.com","*tenoad.com","*xidesheng.com","*4816.com","*philips.com","*cedock.com","*iapps.im","*mosesenglish.com","*dytt8.net","*aisixiang.com","*chinatsp.com","*pocc.cc","*shishang71.com","*babytree.com","*xinwanbiao.com","*galaxeed.com","*host700.com","*codesoso.net","*codesoso.com","*ls034.com","*ishowtu.com","*tbp.bz","*sootuu.com","*gitcafe.com","*aoshu.com","*3dmgame.com","*100yue.com","*hongxiutuan.net","*wjsszzx.com","*chinaunicom.com","*dancewithnet.com","*jobyun.com","*veryhuo.com","*bigdebussy.com","*cofool.com","*jb51.net","*70.com","*92youx.com","*mbajyz.com","*39test.com","*cnssssl.com","*xiaochuncnjp.com","*wkdyw.com","*weiyingyong.com","*cncorpus.org","*0737mp.com","*macidea.com","*kunlun.com","*arpg2.com","*impencil.org","*baifubao.com","*17usoft.com","*yyets.com","*da-mai.com","*cqnews.net","*wangxiaofeng.net","*jx-camera.com","*91cdn.com","*xinniangjie.com","*9wg.com","*mi-img.com","*fastyermail.com","*qushimeiti.com","*hjenglish.com","*yicai.com","*programfan.com","*dfrdjt.com","*meitudata.com","*okhqb.com","*sieschool.org","*ifanr.com","*ysheen.com","*csto.com","*cestcupcake.com","*okooo.com","*eamonning.com","*routerclub.com","*sddcp.com","*itouchchina.com","*5i5j.com","*duxiu.com","*macgood.com","*normteam.com","*tnbz.com","*yupoo.com","*022show.com","*taofen8.com","*wuhuaizai.com","*chinagwy.org","*baofoo.com","*oabt.org","*114chn.com","*cndns.net","*smweekly.com","*taobaz.com","*irs09.com","*zlcool.com","*englishtown.com","*2110000.com","*i8i8.cc","*haoyisheng.com","*solidot.org","*banmamedia.com","*okbmf.com","*chn5000.org","*kuaipandata.com","*walizip.com","*zhibo.cc","*jiakaobaodian.com","*100tm.com","*yinxiang.com","*91rb.com","*jznj.com","*xinli001.com","*aijiake.com","*qqai.net","*cndsi.com","*5iplaynow.com","*qianzhan.com","*wz0hk.com","*kangkang360.com","*hdfimg.com","*koubao.net","*gyhj.org","*js165.com","*wzdsb.net","*0532gcw.com","*bankcomm.com","*kuaiche.com","*xiziwang.net","*nbdacheng.com","*hkjsh.com","*oplinux.com","*zoosnet.net","*bitscn.com","*db9db.com","*largesubtle.pro","*9lianmeng.com","*eduglobal.com","*sohu.net","*jd.com","*zjicity.com","*qiniutek.com","*iafbbs.com","*airizu.com","*wormonitor.com","*xueau.com","*dianxinos.com","*cjphr.com","*qconbeijing.com","*sz-jlc.com","*mizhe.com","*jitu5.com","*hnzqw.com","*scanv.com","*womai.com","*wosku.com","*pc175.com","*tradeprince.com","*1314zb.com","*yizimg.com","*ppios.com","*getqujing.com","*eastmoney.com","*mailjet.com","*zhanzuo.com","*kele8.com","*wangjinzhan.com","*buildjob.net","*iqianduan.org","*btcman.com","*ruoren.com","*jtimg.com","*360kxr.com","*126.com","*ni.com","*ablesky.com","*aliimg.com","*cloudfront.net","*hytrip.net","*zhimg.com","*hb91.com","*flurry.com","*robotplayer.com","*buzzopt.com","*wtianx.com","*iluopan.com","*yeyou.com","*youbian.com","*huitao.net","*173.com","*whcn.org","*haoshiku.com","*baixing.com","*yn16.com","*pin5i.com","*wxrb.com","*yangtai.com","*adwo.com","*weiligongshe.com","*nsmovie.com","*mdvget.com","*50bang.org","*job5156.com","*ppstv.com","*mbachina.com","*zeipo.com","*go2map.com","*flvxz.com","*tingmei.cc","*sxmdmj.com","*wefiler.com","*21cnimg.com","*apptao.com","*bestooxx.com","*kaf9.com","*fangxiemi.com","*winxuan.com","*gougou.com","*onlylady.com","*51netu.com","*yingzheng.com","*geilicdn.com","*gad.cc","*bjzs120.net","*eccn.com","*ywhqs.com","*udika.com","*likeneng.com","*newxue.com","*chinaielts.org","*linuxidc.com","*yunos.com","*rayfile.com","*cnodejs.org","*cjdby.com","*yesku.net","*gongheshengshi.com","*000dn.com","*wal8.com","*tuan800.com","*jayproxy.com","*cccu.cc","*webapptrend.com","*qgkjlw.com","*lijingquan.net","*580114.com","*uifish.com","*hao123.com","*livnj.com","*imofan.com","*udashi.com","*ipodcast.me","*taobaoimages.com","*ceairgroup.com","*rushplayer.com","*5577.com","*ihu.im","*taohua.com","*w3cplus.com","*srmeme.com","*guolairen.com","*downcc.com","*189hd.com","*jiatx.com","*1o26.com","*htc.com","*baihui.com","*jumeifu.com","*yodao.com","*95572.com","*klm.com","*running8.com","*chenluwenxue.com","*tompda.com","*east.net","*pai13.com","*chuizios.com","*ragbear.com","*himigame.com","*yihaodianimg.com","*xskz.net","*5iucn.com","*dinolanton.com","*snda.com","*sibye.com","*hyb.im","*31star.com","*7794.com","*17caifu.com","*thunlp.org","*dangdangdz.com","*tu265.com","*51.com","*51la.net","*lvrenpic.com","*vipcnzz.com","*tech2ipo.com","*xheditor.com","*6637.com","*yiqifei.com","*youbibi.com","*fanjian.net","*aboutfree.me","*huox.in","*gk114.com","*yeeshou.net","*520hunjia.com","*21ccom.net","*jiayuanedm002.com","*anytimetomail.com","*cnool.net","*szpichappy.com","*umei.cc","*meilishuo.net","*xiexingcun.com","*code4app.com","*winenice.com","*imp3.net","*sanygroup.com","*15yule.com","*feedsportal.com","*songshuhui.net","*lmwlove.com","icyif.com","*candlewoodsuites.com","*iev8.com","*aicaicdn.com","*ttkdex.com","*frdic.com","*8box.com","*coodao.com","*sdgame.com","*dangdang.com","*ababee.com","*pplock.com","*xinketang.org","*yoka.com","*down12.com","*china-up.com","*yoyoweb.net","*51cto.com","*jomodns.com","*pvontek.com","*cnbeta.com","*18lehu.com","*feidee.com","*artxun.com","*getbbs.com","*tpzj.com","*jsrc.com","*digu.com","*netease.com","*sooopu.com","*517huwai.com","*qudao.com","*aliway.com","*smzdm.com","*nnjncl.org","*flipboard.com","*pudongstamps.com","*bbapp.net","*aliloan.com","*banyuetan.org","*netnoease.com","*jxw100.com","*i3v.cc","*fontke.com","*115img.com","*455sj.com","*0569.com","*bjsgnk.com","*gantuan.com","*mmiw.net","*hnol.net","*360wzb.com","*toodou.com","*myitrade.com","*yifan.cc","*rlyljj.com","*51ipa.com","*usb-mp3.com","*justyle.com","*dezhi.com","*dopool.com","*hualvtu.com","*dzdoll.com","*lottedfs.com","*photochance.com","*eqie.com","*toolsba.com","*haosc.com","*qisuu.com","*szvr.com","*luckcart.com","*images9999.com","*baihr.com","*wiseks.net","*c114.net","*ycul.com","*xiami.net","*taskcity.com","*huofar.com","*jaeger-lecoultre.com","*game0592.com","*teapic.com","*serving-sys.com","*starwoodhotels.com","*chapm.com","*xiaopian.com","*staybridgesuites.com","*lostarray.com","*accorhotels.com","*ff84.com","*dedecms08.com","*ewtang.com","*jdzhouse.com","*09dy.com","*wonbao.net","*dili360.com","*baobeituan.cc","*962.net","*99166.com","*my-dahon.com","*iiyibbs.com","*che-piao.com","*53bs.com","*gemsr.com","*fjsen.com","*paopaoxin.com","*51yys.com","*ku112.com","*nciku.com","*opera-mini.net","*iplaysoft.com","*guoxue.com","*google-analytics.com","*yidouphoto.com","*damndigital.com","*lvhezi.com","*unikaixin.com","*popwan.com","*psycofe.com","*xiangshu.com","*discoverhongkong.com","*xlzx.com","*800best.com","*cqjj.net","*hqbpc.com","*mphzp.com","*moko.cc","*applm.com","*nap-cafe.com","*grcbank.com","*xpcha.com","*fzengine.com","*qq66699.com","*yeeyan.org","*j1m1.com","*ppsrc.com","*ee4kdushuba.com","*myxiequ.com","*baihe.com","*kankan.com","*quwan.com","*7711.com","*xunlei.com","*njuftp.org","*hwstatic.com","*unionpay.com","*nongli.com","*buyjk.com","*unionbig.com","*52z.com","*qihoo.com","*siluhd.com","*565882.com","*tianyablog.com","*mecoxlane.com","*hxsyzz.com","*hongname.com","*zhongzhihui.com","*aliunicorn.com","*263.com","*yahooapis.com","*imghb.com","*tianqi.com","*vshoucang.com","*shengyikong.com","*77town.com","*huisou.com","*aiting.me","*aimi.com","*jinglunhotel.com","*zhima.net","*360buy.com","*maxthonimg.com","*kaikai001.com","*imeigu.com","*iapppay.com","*goalhi.com","*haoxiyou.com","*hn1c.com","*xp3366.com","*91ysjk.com","*awltovhc.com","*user-website5.com","*laonanren.com","*mycos.org","*taou.com","*oray.com","*1lou.com","*kk3g.net","*cool80.com","*nuandao.com","*gigya.com","*yunpan.com","*chinabaike.com","*tangdou.com","*houdao.com","*chotee.com","*szxfysj.com","*suimeng.com","*ok2ok.com","*gdhaoma.com","*leyou.com","*shanting.mobi","*chazidian.com","*5721.net","*dichan001.com","*52ch.net","*shanghaining.com","*woiyu.com","*afchine.org","*hwxnet.com","*wrbfg.com","*newasp.net","*ewsos.com","*tongbupan.com","*pkucada.org","*qksz.net","*zhangxinxu.com","*icipku.org","*scenecn.com","*umtrack.com","*umeng.com","*37wanwan.com","*37youyou.com","*14yaa.com","*qqhead.com","*mybook66.com","*srccom.com","*yameigroup.com","*caixin.com","*hongxiu.com","*chinaeservice.com","*1point3acres.com","*kaixin001.com","*yuyue.com","*szooo.com","*unjs.com","*dell.com","*jiaodong.net","*gk99.com","*ihaveu.com","*shengjinlan.com","*roschina.net","*xgres.com","*shopping3c.com","*gangtai.org","*duoshuo.com","*liuzhou520.com","*baoruan.com","*ejingxi.com","*jiaodui.com","*kutongji.com","*lvmama.com","*265zy.com","*martincl2.me","*chinaec.com","*yksuit.com","*minitiao.com","*orientware.org","*tmd.cc","*yihaodian.com","*pctowap.com","*websnap123.com","*qingdaoport.net","*sinasws.com","*ymall.com","*qiyipic.com","*kl688.com","*lunwen519.com","*megajoy.com","*tz100.com","*skycn.com","*gter.net","*phoer.net","*slrbs.com","*mysticalcard.com","*homeinns.com","*manzuo.com","*dygod.com","*ecitic.com","*cnitblog.com","*qupu123.com","*110.com","*uc108.com","*gotoip1.com","*xdwan.com","*517fh.com","*keaku.com","*yutianedu.com","*byf.com","*21cake.com","*yunfile.com","*bamuyu.com","*t3nlink.com","*snssdk.com","*eefocus.com","*appletreebooks.com","*9ku.com","*doudou365.com","*luoshihao.com","*zhulong.com","*fangtuwang.com","*chujingyou.com","*37cu.com","*wangyuehd.com","*aihuishou.com","*2fz1.com","*iteye.com","*appcheers.com","*artemisprojects.org","*ip138.com","*ruanmei.com","*chinaculture.org","*vs-time.com","*fanbang.cc","*chnmedia.com","*rtbidder.net","*89qw.com","*onegreen.org","*dongting.com","*eawan.com","*xiaonei.com","*asia525.com","*dikeauto.com","*hotchanson.com","*a135.net","*wanzhi.cc","*52kmh.com","*nowmac.com","*joit.com","*daf-rs.com","*139cm.com","*pkubbs.net","*anxish.com","*22859.com","*ta80.com","*tukeq.com","*okmk.com","*beianx.com","*netcoretec.com","*appsina.com","*2133.com","*myzcm.net","*zongheng.com","*stdyun.com","*360bike.net","*douguo.com","*cinomail.com","*9969668.com","*kandy.cc","*dpbolvw.net","*msdn.com","*godic.net","*90hao.com","*zjcnt.com","*bbzhi.com","*x6868.com","*zhiye.com","*eng24.com","*sdinfo.net","*01hr.com","*yeeunion.com","*tg-vision.com","*zh-hz.com","*taoosoft.com","*pcpop.com","*winfang.com","*ciming.com","*zdy.cc","*white-collar.com","*qzone.com","*watchstor.com","*76mi.com","*china-shufajia.com","*nnton.com","*chofn.net","*chouti.com","*mingxing.com","*yesmywine.com","*qiniudn.com","*nbbidding.com","*lbesec.com","*sohu.com","*moutaichina.com","*02753.com","*stackoverflow.com","*hdbird.com","*zhugou.com","*duapp.com","*cardbaobao.com","*2667.com","*djyzfcg.net","*ok3w.net","*hantinghotels.com","*elementfresh.com","*winning11cn.com","*real.com","*shangdu.com","*banzhu.com","*goupiaotong.com","*byecity.com","*vmanhua.com","*appgame.com","*hztbc.com","*hijiangxi.com","*5220.net","*doujiao.com","*bookinlife.net","*adsmogo.net","*17173.com","*ppjmlp.com","*cbook.org","*best-living.net","*changyou.com","*zhenpin.com","*makepolo.com","*bf99.com","*hdmeiju.com","*yaolan.com","*jingoal.com","*2800v.net","*ztcjl.com","*hao-shengyi.com","*vips100.com","*ourxun.com","*lalilawai.com","*mnwan.com","*juhuasuan.com","*cutecrm.net","*tianyaui.com","*lafaso.com","*onccc.com","*game3896.com","*lakecn.com","*vnetone.com","*zhongsou.net","*ougei.com","*youshang.com","*cheshi-img.com","*lecake.com","*shangri-la.com","*win7soft.com","*anhuixiqu.com","*33.la","*diglog.com","*sanjiaoli.com","*sjjob88.com","*qweyy.com","*beile.com","*lnok.net","*wshang.com","*scene7.com","*wwfchina.org","*ikafan.com","*docin.com","*mmbang.info","*fxxw.net","*evget.com","*benlai.com","*narrowad.com"]';
reloadProxy2();

setProxyIcon();

// sync bypass list from github.com
//getBypass();
//var interval = 1000 * 60 * 60;
//setInterval(function() { getBypass(); }, interval);


function reloadProxy2() {
//console.log(proxySetting);
//alert(localStorage.proxySetting);
    var type, auto, arrayString;
    var proxy = {type: '', host: '', port: ''};
    var config = {
        mode: '',
        pacScript: {},
        rules: {}
    };

    var proxySetting = JSON.parse(localStorage.proxySetting);
var info=localStorage.proxyInfo


        if (typeof info === 'undefined' ||
           info == 'direct' || info == 'system' ) {
			  
            return;
        }

        if (info == 'pac_url') {
            var pacType = proxySetting['pac_type'];
            var proto = pacType.split(':')[0];

            config.mode = 'pac_script';
            config["pacScript"]["url"] = pacType +
                proxySetting['pac_script_url'][proto];

        } else {

            switch(info) {

            case 'http':
                proxy.type = 'http';
                proxy.host = proxySetting['http_host'];
                proxy.port = parseInt(proxySetting['http_port']);
				//alert('33');
                break;

            case 'https':
                proxy.type = 'https';
                proxy.host = proxySetting['https_host'];
                proxy.port = parseInt(proxySetting['https_port']);
                break;

            case 'socks4':
                proxy.type = 'socks4';
                proxy.host = proxySetting['socks_host'];
                proxy.port = parseInt(proxySetting['socks_port']);
                break;

            case 'socks5':
                proxy.type = 'socks5';
                proxy.host = proxySetting['socks_host'];
                proxy.port = parseInt(proxySetting['socks_port']);
                break;
            }
//alert('1');
            var rule = proxySetting['proxy_rule'];
            var chinaList = JSON.parse(localStorage.chinaList);
            var bypasslist = proxySetting['bypasslist'];
//alert('dfj5d');
            if (proxySetting['internal'] == 'china') {
				//alert('58d');
                bypasslist = chinaList.concat(bypasslist.split(','));
            } else {
				//alert('4357cvn');
                bypasslist = 
                  bypasslist ? bypasslist.split(',') : ['<local>'];
            }

            config.mode = "fixed_servers";
            config.rules.bypassList = uniqueArray(bypasslist);
			//alert(JSON.stringify(config));
            config["rules"][rule] = {
                scheme: proxy.type,
                host: proxy.host,
                port: parseInt(proxy.port)
            };
			//alert('0');
        }

        //alert(JSON.stringify(config));

        chrome.proxy.settings.set({
            value: config,
            scope: 'regular'}, function() {})


}

function uniqueArray(arr) {
    var hash = {}, result = [];
    for (var i = 0, l = arr.length; i < l; ++i) {
        if (!hash.hasOwnProperty(arr[i])) {
            hash[arr[i]] = true;
            result.push(arr[i]);
        }
    }
    return result;
}