/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util.unsafe;

import java.util.Iterator;
import rx.internal.util.unsafe.ConcurrentCircularArrayQueueL0Pad;
import rx.internal.util.unsafe.UnsafeAccess;

public abstract class ConcurrentCircularArrayQueue<E>
extends ConcurrentCircularArrayQueueL0Pad<E> {
    protected static final int SPARSE_SHIFT = Integer.getInteger("sparse.shift", 0);
    protected static final int BUFFER_PAD = 32;
    private static final long REF_ARRAY_BASE;
    private static final int REF_ELEMENT_SHIFT;
    protected final long mask;
    protected final E[] buffer;

    public ConcurrentCircularArrayQueue(int capacity) {
        int actualCapacity = abg.a(capacity);
        this.mask = actualCapacity - 1;
        this.buffer = new Object[(actualCapacity << SPARSE_SHIFT) + 64];
    }

    protected final long calcElementOffset(long index) {
        return this.calcElementOffset(index, this.mask);
    }

    protected final long calcElementOffset(long index, long mask) {
        return REF_ARRAY_BASE + ((index & mask) << REF_ELEMENT_SHIFT);
    }

    protected final void spElement(long offset, E e2) {
        this.spElement(this.buffer, offset, e2);
    }

    protected final void spElement(E[] buffer, long offset, E e2) {
        UnsafeAccess.UNSAFE.putObject(buffer, offset, e2);
    }

    protected final void soElement(long offset, E e2) {
        this.soElement(this.buffer, offset, e2);
    }

    protected final void soElement(E[] buffer, long offset, E e2) {
        UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset, e2);
    }

    protected final E lpElement(long offset) {
        return this.lpElement(this.buffer, offset);
    }

    protected final E lpElement(E[] buffer, long offset) {
        return (E)UnsafeAccess.UNSAFE.getObject(buffer, offset);
    }

    protected final E lvElement(long offset) {
        return this.lvElement(this.buffer, offset);
    }

    protected final E lvElement(E[] buffer, long offset) {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(buffer, offset);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    static {
        int scale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == scale) {
            REF_ELEMENT_SHIFT = 2 + SPARSE_SHIFT;
        } else if (8 == scale) {
            REF_ELEMENT_SHIFT = 3 + SPARSE_SHIFT;
        } else {
            throw new IllegalStateException("Unknown pointer size");
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class) + (32 << REF_ELEMENT_SHIFT - SPARSE_SHIFT);
    }
}

