/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.sqlite.ExtendedCommand;
import org.sqlite.ExtendedCommand$SQLExtension;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CoreDatabaseMetaData;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;

public abstract class JDBC3Statement
extends CoreStatement {
    protected JDBC3Statement(SQLiteConnection conn) {
        super(conn);
    }

    public void close() {
        if (this.metadata != null) {
            --this.metadata.refCount;
            this.metadata.close();
            this.metadata = null;
        }
        this.internalClose();
    }

    protected void finalize() {
        this.close();
    }

    public boolean execute(String sql) {
        this.internalClose();
        ExtendedCommand$SQLExtension ext = ExtendedCommand.parse(sql);
        if (ext != null) {
            ext.execute(this.db);
            return false;
        }
        this.sql = sql;
        this.db.prepare(this);
        return this.exec();
    }

    @Override
    public ResultSet executeQuery(String sql, boolean closeStmt) {
        this.rs.closeStmt = closeStmt;
        return this.executeQuery(sql);
    }

    public ResultSet executeQuery(String sql) {
        this.internalClose();
        this.sql = sql;
        this.db.prepare(this);
        if (!this.exec()) {
            this.internalClose();
            throw new SQLException("query does not return ResultSet", "SQLITE_DONE", 101);
        }
        return this.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) {
        this.internalClose();
        this.sql = sql;
        int changes = 0;
        ExtendedCommand$SQLExtension ext = ExtendedCommand.parse(sql);
        if (ext != null) {
            ext.execute(this.db);
        } else {
            try {
                changes = this.db.total_changes();
                int statusCode = this.db._exec(sql);
                if (statusCode != 0) {
                    throw DB.newSQLException(statusCode, "");
                }
                changes = this.db.total_changes() - changes;
            }
            finally {
                this.internalClose();
            }
        }
        return changes;
    }

    public ResultSet getResultSet() {
        this.checkOpen();
        if (this.rs.isOpen()) {
            throw new SQLException("ResultSet already requested");
        }
        if (this.db.column_count(this.pointer) == 0) {
            return null;
        }
        if (this.rs.colsMeta == null) {
            this.rs.colsMeta = this.db.column_names(this.pointer);
        }
        this.rs.cols = this.rs.colsMeta;
        this.rs.open = this.resultsWaiting;
        this.resultsWaiting = false;
        return (ResultSet)((Object)this.rs);
    }

    public int getUpdateCount() {
        if (this.pointer != 0L && !this.rs.isOpen() && !this.resultsWaiting && this.db.column_count(this.pointer) == 0) {
            return this.db.changes();
        }
        return -1;
    }

    public void addBatch(String sql) {
        this.internalClose();
        if (this.batch == null || this.batchPos + 1 >= this.batch.length) {
            Object[] nb2 = new Object[Math.max(10, this.batchPos * 2)];
            if (this.batch != null) {
                System.arraycopy(this.batch, 0, nb2, 0, this.batch.length);
            }
            this.batch = nb2;
        }
        this.batch[this.batchPos++] = sql;
    }

    public void clearBatch() {
        this.batchPos = 0;
        if (this.batch != null) {
            for (int i2 = 0; i2 < this.batch.length; ++i2) {
                this.batch[i2] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() {
        this.internalClose();
        if (this.batch == null || this.batchPos == 0) {
            return new int[0];
        }
        int[] changes = new int[this.batchPos];
        DB dB2 = this.db;
        synchronized (dB2) {
            try {
                for (int i2 = 0; i2 < changes.length; ++i2) {
                    try {
                        this.sql = (String)this.batch[i2];
                        this.db.prepare(this);
                        changes[i2] = this.db.executeUpdate(this, null);
                        continue;
                    }
                    catch (SQLException e2) {
                        throw new BatchUpdateException("batch entry " + i2 + ": " + e2.getMessage(), changes);
                    }
                    finally {
                        this.db.finalize(this);
                    }
                }
            }
            finally {
                this.clearBatch();
            }
        }
        return changes;
    }

    public void setCursorName(String name) {
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void cancel() {
        this.db.interrupt();
    }

    public int getQueryTimeout() {
        return this.conn.getBusyTimeout();
    }

    public void setQueryTimeout(int seconds) {
        if (seconds < 0) {
            throw new SQLException("query timeout must be >= 0");
        }
        this.conn.setBusyTimeout(1000 * seconds);
    }

    public int getMaxRows() {
        return this.rs.maxRows;
    }

    public void setMaxRows(int max) {
        if (max < 0) {
            throw new SQLException("max row count must be >= 0");
        }
        this.rs.maxRows = max;
    }

    public int getMaxFieldSize() {
        return 0;
    }

    public void setMaxFieldSize(int max) {
        if (max < 0) {
            throw new SQLException("max field size " + max + " cannot be negative");
        }
    }

    public int getFetchSize() {
        return ((ResultSet)((Object)this.rs)).getFetchSize();
    }

    public void setFetchSize(int r2) {
        ((ResultSet)((Object)this.rs)).setFetchSize(r2);
    }

    public int getFetchDirection() {
        return ((ResultSet)((Object)this.rs)).getFetchDirection();
    }

    public void setFetchDirection(int d2) {
        ((ResultSet)((Object)this.rs)).setFetchDirection(d2);
    }

    public ResultSet getGeneratedKeys() {
        if (this.metadata == null) {
            this.metadata = (CoreDatabaseMetaData)((Object)this.conn.getMetaData());
            ++this.metadata.refCount;
        }
        return this.metadata.getGeneratedKeys();
    }

    public boolean getMoreResults() {
        return this.getMoreResults(0);
    }

    public boolean getMoreResults(int c2) {
        this.checkOpen();
        this.internalClose();
        return false;
    }

    public int getResultSetConcurrency() {
        return 1007;
    }

    public int getResultSetHoldability() {
        return 2;
    }

    public int getResultSetType() {
        return 1003;
    }

    public void setEscapeProcessing(boolean enable) {
        if (enable) {
            throw this.unused();
        }
    }

    protected SQLException unused() {
        return new SQLException("not implemented by SQLite JDBC driver");
    }

    public boolean execute(String sql, int[] colinds) {
        throw this.unused();
    }

    public boolean execute(String sql, String[] colnames) {
        throw this.unused();
    }

    public int executeUpdate(String sql, int autoKeys) {
        throw this.unused();
    }

    public int executeUpdate(String sql, int[] colinds) {
        throw this.unused();
    }

    public int executeUpdate(String sql, String[] cols) {
        throw this.unused();
    }

    public boolean execute(String sql, int autokeys) {
        throw this.unused();
    }
}

