/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CorePreparedStatement;

public abstract class JDBC3PreparedStatement
extends CorePreparedStatement {
    protected JDBC3PreparedStatement(SQLiteConnection conn, String sql) {
        super(conn, sql);
    }

    public void clearParameters() {
        this.checkOpen();
        this.db.clear_bindings(this.pointer);
        this.batch = null;
    }

    public boolean execute() {
        this.checkOpen();
        this.rs.close();
        this.db.reset(this.pointer);
        this.checkParameters();
        boolean success = false;
        try {
            this.resultsWaiting = this.db.execute(this, this.batch);
            success = true;
            boolean bl2 = this.columnCount != 0;
            return bl2;
        }
        finally {
            if (!success && this.pointer != 0L) {
                this.db.reset(this.pointer);
            }
        }
    }

    public ResultSet executeQuery() {
        this.checkOpen();
        if (this.columnCount == 0) {
            throw new SQLException("Query does not return results");
        }
        this.rs.close();
        this.db.reset(this.pointer);
        this.checkParameters();
        boolean success = false;
        try {
            this.resultsWaiting = this.db.execute(this, this.batch);
            success = true;
        }
        finally {
            if (!success && this.pointer != 0L) {
                this.db.reset(this.pointer);
            }
        }
        return this.getResultSet();
    }

    public int executeUpdate() {
        this.checkOpen();
        if (this.columnCount != 0) {
            throw new SQLException("Query returns results");
        }
        this.rs.close();
        this.db.reset(this.pointer);
        this.checkParameters();
        return this.db.executeUpdate(this, this.batch);
    }

    public void addBatch() {
        this.checkOpen();
        this.batchPos += this.paramCount;
        ++this.batchQueryCount;
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
        }
        if (this.batchPos + this.paramCount > this.batch.length) {
            Object[] nb2 = new Object[this.batch.length * 2];
            System.arraycopy(this.batch, 0, nb2, 0, this.batch.length);
            this.batch = nb2;
        }
        System.arraycopy(this.batch, this.batchPos - this.paramCount, this.batch, this.batchPos, this.paramCount);
    }

    public ParameterMetaData getParameterMetaData() {
        return (ParameterMetaData)((Object)this);
    }

    public int getParameterCount() {
        this.checkOpen();
        return this.paramCount;
    }

    public String getParameterClassName(int param) {
        this.checkOpen();
        return "java.lang.String";
    }

    public String getParameterTypeName(int pos) {
        return "VARCHAR";
    }

    public int getParameterType(int pos) {
        return 12;
    }

    public int getParameterMode(int pos) {
        return 1;
    }

    public int getPrecision(int pos) {
        return 0;
    }

    public int getScale(int pos) {
        return 0;
    }

    public int isNullable(int pos) {
        return 1;
    }

    public boolean isSigned(int pos) {
        return true;
    }

    public void setBigDecimal(int pos, BigDecimal value) {
        this.batch(pos, value == null ? null : value.toString());
    }

    private byte[] readBytes(InputStream istream, int length) {
        if (length < 0) {
            SQLException exception = new SQLException("Error reading stream. Length should be non-negative");
            throw exception;
        }
        byte[] bytes = new byte[length];
        try {
            int bytesRead;
            for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
                bytesRead = istream.read(bytes, totalBytesRead, length - totalBytesRead);
                if (bytesRead != -1) continue;
                throw new IOException("End of stream has been reached");
            }
            return bytes;
        }
        catch (IOException cause) {
            SQLException exception = new SQLException("Error reading stream");
            exception.initCause(cause);
            throw exception;
        }
    }

    public void setBinaryStream(int pos, InputStream istream, int length) {
        if (istream == null && length == 0) {
            this.setBytes(pos, null);
        }
        this.setBytes(pos, this.readBytes(istream, length));
    }

    public void setAsciiStream(int pos, InputStream istream, int length) {
        this.setUnicodeStream(pos, istream, length);
    }

    public void setUnicodeStream(int pos, InputStream istream, int length) {
        if (istream == null && length == 0) {
            this.setString(pos, null);
        }
        try {
            this.setString(pos, new String(this.readBytes(istream, length), "UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            SQLException exception = new SQLException("UTF-8 is not supported");
            exception.initCause(e2);
            throw exception;
        }
    }

    public void setBoolean(int pos, boolean value) {
        this.setInt(pos, value ? 1 : 0);
    }

    public void setByte(int pos, byte value) {
        this.setInt(pos, value);
    }

    public void setBytes(int pos, byte[] value) {
        this.batch(pos, value);
    }

    public void setDouble(int pos, double value) {
        this.batch(pos, new Double(value));
    }

    public void setFloat(int pos, float value) {
        this.batch(pos, new Float(value));
    }

    public void setInt(int pos, int value) {
        this.batch(pos, new Integer(value));
    }

    public void setLong(int pos, long value) {
        this.batch(pos, new Long(value));
    }

    public void setNull(int pos, int u1) {
        this.setNull(pos, u1, null);
    }

    public void setNull(int pos, int u1, String u2) {
        this.batch(pos, null);
    }

    public void setObject(int pos, Object value) {
        if (value == null) {
            this.batch(pos, null);
        } else if (value instanceof java.util.Date) {
            this.setDateByMilliseconds(pos, ((java.util.Date)value).getTime());
        } else if (value instanceof Date) {
            this.setDateByMilliseconds(pos, new Long(((Date)value).getTime()));
        } else if (value instanceof Time) {
            this.setDateByMilliseconds(pos, new Long(((Time)value).getTime()));
        } else if (value instanceof Timestamp) {
            this.setDateByMilliseconds(pos, new Long(((Timestamp)value).getTime()));
        } else if (value instanceof Long) {
            this.batch(pos, value);
        } else if (value instanceof Integer) {
            this.batch(pos, value);
        } else if (value instanceof Short) {
            this.batch(pos, new Integer(((Short)value).intValue()));
        } else if (value instanceof Float) {
            this.batch(pos, value);
        } else if (value instanceof Double) {
            this.batch(pos, value);
        } else if (value instanceof Boolean) {
            this.setBoolean(pos, (Boolean)value);
        } else if (value instanceof byte[]) {
            this.batch(pos, value);
        } else if (value instanceof BigDecimal) {
            this.setBigDecimal(pos, (BigDecimal)value);
        } else {
            this.batch(pos, value.toString());
        }
    }

    public void setObject(int p2, Object v2, int t2) {
        this.setObject(p2, v2);
    }

    public void setObject(int p2, Object v2, int t2, int s2) {
        this.setObject(p2, v2);
    }

    public void setShort(int pos, short value) {
        this.setInt(pos, value);
    }

    public void setString(int pos, String value) {
        this.batch(pos, value);
    }

    public void setCharacterStream(int pos, Reader reader, int length) {
        try {
            int cnt;
            StringBuffer sb2 = new StringBuffer();
            char[] cbuf = new char[8192];
            while ((cnt = reader.read(cbuf)) > 0) {
                sb2.append(cbuf, 0, cnt);
            }
            this.setString(pos, sb2.toString());
        }
        catch (IOException e2) {
            throw new SQLException("Cannot read from character stream, exception message: " + e2.getMessage());
        }
    }

    public void setDate(int pos, Date x2) {
        this.setObject(pos, x2);
    }

    public void setDate(int pos, Date x2, Calendar cal) {
        this.setObject(pos, x2);
    }

    public void setTime(int pos, Time x2) {
        this.setObject(pos, x2);
    }

    public void setTime(int pos, Time x2, Calendar cal) {
        this.setObject(pos, x2);
    }

    public void setTimestamp(int pos, Timestamp x2) {
        this.setObject(pos, x2);
    }

    public void setTimestamp(int pos, Timestamp x2, Calendar cal) {
        this.setObject(pos, x2);
    }

    public ResultSetMetaData getMetaData() {
        this.checkOpen();
        return (ResultSetMetaData)((Object)this.rs);
    }

    @Override
    protected SQLException unused() {
        return new SQLException("not implemented by SQLite JDBC driver");
    }

    public void setArray(int i2, Array x2) {
        throw this.unused();
    }

    public void setBlob(int i2, Blob x2) {
        throw this.unused();
    }

    public void setClob(int i2, Clob x2) {
        throw this.unused();
    }

    public void setRef(int i2, Ref x2) {
        throw this.unused();
    }

    public void setURL(int pos, URL x2) {
        throw this.unused();
    }

    @Override
    public boolean execute(String sql) {
        throw this.unused();
    }

    @Override
    public int executeUpdate(String sql) {
        throw this.unused();
    }

    @Override
    public ResultSet executeQuery(String sql) {
        throw this.unused();
    }

    @Override
    public void addBatch(String sql) {
        throw this.unused();
    }
}

