/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.jdbc3.JDBC3DatabaseMetaData;
import org.sqlite.jdbc3.JDBC3DatabaseMetaData$ImportedKeyFinder$ForeignKey;

class JDBC3DatabaseMetaData$ImportedKeyFinder {
    private final Pattern FK_NAMED_PATTERN = Pattern.compile("CONSTRAINT\\s*([A-Za-z_][A-Za-z\\d_]*)?\\s*FOREIGN\\s+KEY\\s*\\((.*?)\\)", 34);
    private String fkTableName;
    private List<JDBC3DatabaseMetaData$ImportedKeyFinder$ForeignKey> fkList = new ArrayList<JDBC3DatabaseMetaData$ImportedKeyFinder$ForeignKey>();
    final /* synthetic */ JDBC3DatabaseMetaData this$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBC3DatabaseMetaData$ImportedKeyFinder(JDBC3DatabaseMetaData this$0, String table) {
        this.this$0 = this$0;
        if (table == null || table.trim().length() == 0) {
            throw new SQLException("Invalid table name: '" + table + "'");
        }
        this.fkTableName = table;
        List<String> fkNames = this.getForeignKeyNames(this.fkTableName);
        Statement stat = null;
        ResultSet rs2 = null;
        try {
            stat = JDBC3DatabaseMetaData.access$500(this$0).createStatement();
            rs2 = stat.executeQuery("pragma foreign_key_list('" + this.fkTableName.toLowerCase() + "')");
            int prevFkId = -1;
            int count = 0;
            JDBC3DatabaseMetaData$ImportedKeyFinder$ForeignKey fk2 = null;
            while (rs2.next()) {
                int fkId = rs2.getInt(1);
                int colSeq = rs2.getInt(2);
                String pkTableName = rs2.getString(3);
                String fkColName = rs2.getString(4);
                String pkColName = rs2.getString(5);
                String onUpdate = rs2.getString(6);
                String onDelete = rs2.getString(7);
                String match = rs2.getString(8);
                String fkName = null;
                if (fkNames.size() > count) {
                    fkName = fkNames.get(count);
                }
                if (fkId != prevFkId) {
                    fk2 = new JDBC3DatabaseMetaData$ImportedKeyFinder$ForeignKey(this, fkName, pkTableName, this.fkTableName, onUpdate, onDelete, match);
                    this.fkList.add(fk2);
                    prevFkId = fkId;
                    ++count;
                }
                fk2.addColumnMapping(fkColName, pkColName);
            }
        }
        finally {
            try {
                if (rs2 != null) {
                    rs2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getForeignKeyNames(String tbl) {
        ArrayList<String> fkNames = new ArrayList<String>();
        if (tbl == null) {
            return fkNames;
        }
        Statement stat2 = null;
        ResultSet rs2 = null;
        try {
            stat2 = JDBC3DatabaseMetaData.access$600(this.this$0).createStatement();
            rs2 = stat2.executeQuery("select sql from sqlite_master where lower(name) = lower('" + JDBC3DatabaseMetaData.access$700(this.this$0, tbl) + "')");
            if (rs2.next()) {
                Matcher matcher = this.FK_NAMED_PATTERN.matcher(rs2.getString(1));
                while (matcher.find()) {
                    fkNames.add(matcher.group(1));
                }
            }
        }
        finally {
            try {
                if (rs2 != null) {
                    rs2.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (stat2 != null) {
                    stat2.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        Collections.reverse(fkNames);
        return fkNames;
    }

    public List<JDBC3DatabaseMetaData$ImportedKeyFinder$ForeignKey> getFkList() {
        return this.fkList;
    }
}

