/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sqlite.date.DatePrinter;
import org.sqlite.date.FastDatePrinter$CharacterLiteral;
import org.sqlite.date.FastDatePrinter$Iso8601_Rule;
import org.sqlite.date.FastDatePrinter$NumberRule;
import org.sqlite.date.FastDatePrinter$PaddedNumberField;
import org.sqlite.date.FastDatePrinter$Rule;
import org.sqlite.date.FastDatePrinter$StringLiteral;
import org.sqlite.date.FastDatePrinter$TextField;
import org.sqlite.date.FastDatePrinter$TimeZoneDisplayKey;
import org.sqlite.date.FastDatePrinter$TimeZoneNameRule;
import org.sqlite.date.FastDatePrinter$TimeZoneNumberRule;
import org.sqlite.date.FastDatePrinter$TwelveHourField;
import org.sqlite.date.FastDatePrinter$TwentyFourHourField;
import org.sqlite.date.FastDatePrinter$TwoDigitMonthField;
import org.sqlite.date.FastDatePrinter$TwoDigitNumberField;
import org.sqlite.date.FastDatePrinter$TwoDigitYearField;
import org.sqlite.date.FastDatePrinter$UnpaddedMonthField;
import org.sqlite.date.FastDatePrinter$UnpaddedNumberField;

public class FastDatePrinter
implements Serializable,
DatePrinter {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private transient FastDatePrinter$Rule[] mRules;
    private transient int mMaxLengthEstimate;
    private static final ConcurrentMap<FastDatePrinter$TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<FastDatePrinter$TimeZoneDisplayKey, String>(7);

    protected FastDatePrinter(String pattern, TimeZone timeZone, Locale locale) {
        this.mPattern = pattern;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private void init() {
        List<FastDatePrinter$Rule> rulesList = this.parsePattern();
        this.mRules = rulesList.toArray(new FastDatePrinter$Rule[rulesList.size()]);
        int len = 0;
        int i2 = this.mRules.length;
        while (--i2 >= 0) {
            len += this.mRules[i2].estimateLength();
        }
        this.mMaxLengthEstimate = len;
    }

    protected List<FastDatePrinter$Rule> parsePattern() {
        DateFormatSymbols symbols = new DateFormatSymbols(this.mLocale);
        ArrayList<FastDatePrinter$Rule> rules = new ArrayList<FastDatePrinter$Rule>();
        String[] ERAs = symbols.getEras();
        String[] months = symbols.getMonths();
        String[] shortMonths = symbols.getShortMonths();
        String[] weekdays = symbols.getWeekdays();
        String[] shortWeekdays = symbols.getShortWeekdays();
        String[] AmPmStrings = symbols.getAmPmStrings();
        int length = this.mPattern.length();
        int[] indexRef = new int[1];
        for (int i2 = 0; i2 < length; ++i2) {
            FastDatePrinter$Rule rule;
            indexRef[0] = i2;
            String token = this.parseToken(this.mPattern, indexRef);
            i2 = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c2 = token.charAt(0);
            switch (c2) {
                case 'G': {
                    rule = new FastDatePrinter$TextField(0, ERAs);
                    break;
                }
                case 'y': {
                    if (tokenLen == 2) {
                        rule = FastDatePrinter$TwoDigitYearField.INSTANCE;
                        break;
                    }
                    rule = this.selectNumberRule(1, tokenLen < 4 ? 4 : tokenLen);
                    break;
                }
                case 'M': {
                    if (tokenLen >= 4) {
                        rule = new FastDatePrinter$TextField(2, months);
                        break;
                    }
                    if (tokenLen == 3) {
                        rule = new FastDatePrinter$TextField(2, shortMonths);
                        break;
                    }
                    if (tokenLen == 2) {
                        rule = FastDatePrinter$TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    rule = FastDatePrinter$UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    rule = this.selectNumberRule(5, tokenLen);
                    break;
                }
                case 'h': {
                    rule = new FastDatePrinter$TwelveHourField(this.selectNumberRule(10, tokenLen));
                    break;
                }
                case 'H': {
                    rule = this.selectNumberRule(11, tokenLen);
                    break;
                }
                case 'm': {
                    rule = this.selectNumberRule(12, tokenLen);
                    break;
                }
                case 's': {
                    rule = this.selectNumberRule(13, tokenLen);
                    break;
                }
                case 'S': {
                    rule = this.selectNumberRule(14, tokenLen);
                    break;
                }
                case 'E': {
                    rule = new FastDatePrinter$TextField(7, tokenLen < 4 ? shortWeekdays : weekdays);
                    break;
                }
                case 'D': {
                    rule = this.selectNumberRule(6, tokenLen);
                    break;
                }
                case 'F': {
                    rule = this.selectNumberRule(8, tokenLen);
                    break;
                }
                case 'w': {
                    rule = this.selectNumberRule(3, tokenLen);
                    break;
                }
                case 'W': {
                    rule = this.selectNumberRule(4, tokenLen);
                    break;
                }
                case 'a': {
                    rule = new FastDatePrinter$TextField(9, AmPmStrings);
                    break;
                }
                case 'k': {
                    rule = new FastDatePrinter$TwentyFourHourField(this.selectNumberRule(11, tokenLen));
                    break;
                }
                case 'K': {
                    rule = this.selectNumberRule(10, tokenLen);
                    break;
                }
                case 'X': {
                    rule = FastDatePrinter$Iso8601_Rule.getRule(tokenLen);
                    break;
                }
                case 'z': {
                    if (tokenLen >= 4) {
                        rule = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 1);
                        break;
                    }
                    rule = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (tokenLen == 1) {
                        rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (tokenLen == 2) {
                        rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_ISO_8601;
                        break;
                    }
                    rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String sub = token.substring(1);
                    if (sub.length() == 1) {
                        rule = new FastDatePrinter$CharacterLiteral(sub.charAt(0));
                        break;
                    }
                    rule = new FastDatePrinter$StringLiteral(sub);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + token);
                }
            }
            rules.add(rule);
        }
        return rules;
    }

    protected String parseToken(String pattern, int[] indexRef) {
        int i2;
        StringBuilder buf = new StringBuilder();
        int length = pattern.length();
        char c2 = pattern.charAt(i2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char peek;
            buf.append(c2);
            while (i2 + 1 < length && (peek = pattern.charAt(i2 + 1)) == c2) {
                buf.append(c2);
                ++i2;
            }
        } else {
            buf.append('\'');
            boolean inLiteral = false;
            for (i2 = indexRef[0]; i2 < length; ++i2) {
                c2 = pattern.charAt(i2);
                if (c2 == '\'') {
                    if (i2 + 1 < length && pattern.charAt(i2 + 1) == '\'') {
                        ++i2;
                        buf.append(c2);
                        continue;
                    }
                    inLiteral = !inLiteral;
                    continue;
                }
                if (inLiteral || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    buf.append(c2);
                    continue;
                }
                break;
            }
        }
        indexRef[0] = --i2;
        return buf.toString();
    }

    protected FastDatePrinter$NumberRule selectNumberRule(int field, int padding) {
        switch (padding) {
            case 1: {
                return new FastDatePrinter$UnpaddedNumberField(field);
            }
            case 2: {
                return new FastDatePrinter$TwoDigitNumberField(field);
            }
        }
        return new FastDatePrinter$PaddedNumberField(field, padding);
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Date) {
            return this.format((Date)obj, toAppendTo);
        }
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj, toAppendTo);
        }
        if (obj instanceof Long) {
            return this.format((Long)obj, toAppendTo);
        }
        throw new IllegalArgumentException("Unknown class: " + (obj == null ? "<null>" : obj.getClass().getName()));
    }

    public String format(long millis) {
        GregorianCalendar c2 = this.newCalendar();
        c2.setTimeInMillis(millis);
        return this.applyRulesToString(c2);
    }

    private String applyRulesToString(Calendar c2) {
        return this.applyRules(c2, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    private GregorianCalendar newCalendar() {
        return new GregorianCalendar(this.mTimeZone, this.mLocale);
    }

    public String format(Date date) {
        GregorianCalendar c2 = this.newCalendar();
        c2.setTime(date);
        return this.applyRulesToString(c2);
    }

    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    public StringBuffer format(long millis, StringBuffer buf) {
        return this.format(new Date(millis), buf);
    }

    public StringBuffer format(Date date, StringBuffer buf) {
        GregorianCalendar c2 = this.newCalendar();
        c2.setTime(date);
        return this.applyRules(c2, buf);
    }

    public StringBuffer format(Calendar calendar, StringBuffer buf) {
        return this.applyRules(calendar, buf);
    }

    protected StringBuffer applyRules(Calendar calendar, StringBuffer buf) {
        for (FastDatePrinter$Rule rule : this.mRules) {
            rule.appendTo(buf, calendar);
        }
        return buf;
    }

    public String getPattern() {
        return this.mPattern;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FastDatePrinter)) {
            return false;
        }
        FastDatePrinter other = (FastDatePrinter)obj;
        return this.mPattern.equals(other.mPattern) && this.mTimeZone.equals(other.mTimeZone) && this.mLocale.equals(other.mLocale);
    }

    public int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    public String toString() {
        return "FastDatePrinter[" + this.mPattern + "," + this.mLocale + "," + this.mTimeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream in2) {
        in2.defaultReadObject();
        this.init();
    }

    private static void appendDigits(StringBuffer buffer, int value) {
        buffer.append((char)(value / 10 + 48));
        buffer.append((char)(value % 10 + 48));
    }

    static String getTimeZoneDisplay(TimeZone tz2, boolean daylight, int style, Locale locale) {
        String prior;
        FastDatePrinter$TimeZoneDisplayKey key = new FastDatePrinter$TimeZoneDisplayKey(tz2, daylight, style, locale);
        String value = (String)cTimeZoneDisplayCache.get(key);
        if (value == null && (prior = cTimeZoneDisplayCache.putIfAbsent(key, value = tz2.getDisplayName(daylight, style, locale))) != null) {
            value = prior;
        }
        return value;
    }

    static /* synthetic */ void access$000(StringBuffer x0, int x1) {
        FastDatePrinter.appendDigits(x0, x1);
    }
}

