/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.util.Calendar;
import org.sqlite.date.FastDatePrinter;
import org.sqlite.date.FastDatePrinter$Rule;

class FastDatePrinter$TimeZoneNumberRule
implements FastDatePrinter$Rule {
    static final FastDatePrinter$TimeZoneNumberRule INSTANCE_COLON = new FastDatePrinter$TimeZoneNumberRule(true, false);
    static final FastDatePrinter$TimeZoneNumberRule INSTANCE_NO_COLON = new FastDatePrinter$TimeZoneNumberRule(false, false);
    static final FastDatePrinter$TimeZoneNumberRule INSTANCE_ISO_8601 = new FastDatePrinter$TimeZoneNumberRule(true, true);
    final boolean mColon;
    final boolean mISO8601;

    FastDatePrinter$TimeZoneNumberRule(boolean colon, boolean iso8601) {
        this.mColon = colon;
        this.mISO8601 = iso8601;
    }

    @Override
    public int estimateLength() {
        return 5;
    }

    @Override
    public void appendTo(StringBuffer buffer, Calendar calendar) {
        if (this.mISO8601 && calendar.getTimeZone().getID().equals("UTC")) {
            buffer.append("Z");
            return;
        }
        int offset = calendar.get(15) + calendar.get(16);
        if (offset < 0) {
            buffer.append('-');
            offset = -offset;
        } else {
            buffer.append('+');
        }
        int hours = offset / 3600000;
        FastDatePrinter.access$000(buffer, hours);
        if (this.mColon) {
            buffer.append(':');
        }
        int minutes = offset / 60000 - 60 * hours;
        FastDatePrinter.access$000(buffer, minutes);
    }
}

