/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.util.Calendar;
import org.sqlite.date.FastDatePrinter;
import org.sqlite.date.FastDatePrinter$Rule;

class FastDatePrinter$Iso8601_Rule
implements FastDatePrinter$Rule {
    static final FastDatePrinter$Iso8601_Rule ISO8601_HOURS = new FastDatePrinter$Iso8601_Rule(3);
    static final FastDatePrinter$Iso8601_Rule ISO8601_HOURS_MINUTES = new FastDatePrinter$Iso8601_Rule(5);
    static final FastDatePrinter$Iso8601_Rule ISO8601_HOURS_COLON_MINUTES = new FastDatePrinter$Iso8601_Rule(6);
    final int length;

    static FastDatePrinter$Iso8601_Rule getRule(int tokenLen) {
        switch (tokenLen) {
            case 1: {
                return ISO8601_HOURS;
            }
            case 2: {
                return ISO8601_HOURS_MINUTES;
            }
            case 3: {
                return ISO8601_HOURS_COLON_MINUTES;
            }
        }
        throw new IllegalArgumentException("invalid number of X");
    }

    FastDatePrinter$Iso8601_Rule(int length) {
        this.length = length;
    }

    @Override
    public int estimateLength() {
        return this.length;
    }

    @Override
    public void appendTo(StringBuffer buffer, Calendar calendar) {
        int zoneOffset = calendar.get(15);
        if (zoneOffset == 0) {
            buffer.append("Z");
            return;
        }
        int offset = zoneOffset + calendar.get(16);
        if (offset < 0) {
            buffer.append('-');
            offset = -offset;
        } else {
            buffer.append('+');
        }
        int hours = offset / 3600000;
        FastDatePrinter.access$000(buffer, hours);
        if (this.length < 5) {
            return;
        }
        if (this.length == 6) {
            buffer.append(':');
        }
        int minutes = offset / 60000 - 60 * hours;
        FastDatePrinter.access$000(buffer, minutes);
    }
}

