/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.date.DateParser;
import org.sqlite.date.FastDateParser$1;
import org.sqlite.date.FastDateParser$2;
import org.sqlite.date.FastDateParser$3;
import org.sqlite.date.FastDateParser$4;
import org.sqlite.date.FastDateParser$CaseInsensitiveTextStrategy;
import org.sqlite.date.FastDateParser$CopyQuotedStrategy;
import org.sqlite.date.FastDateParser$ISO8601TimeZoneStrategy;
import org.sqlite.date.FastDateParser$NumberStrategy;
import org.sqlite.date.FastDateParser$Strategy;
import org.sqlite.date.FastDateParser$TimeZoneStrategy;

public class FastDateParser
implements Serializable,
DateParser {
    private static final long serialVersionUID = 2L;
    static final Locale JAPANESE_IMPERIAL = new Locale("ja", "JP", "JP");
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private final int century;
    private final int startYear;
    private transient Pattern parsePattern;
    private transient FastDateParser$Strategy[] strategies;
    private transient String currentFormatField;
    private transient FastDateParser$Strategy nextStrategy;
    private static final Pattern formatPattern = Pattern.compile("D+|E+|F+|G+|H+|K+|M+|S+|W+|X+|Z+|a+|d+|h+|k+|m+|s+|w+|y+|z+|''|'[^']++(''[^']*+)*+'|[^'A-Za-z]++");
    private static final ConcurrentMap<Locale, FastDateParser$Strategy>[] caches = new ConcurrentMap[17];
    private static final FastDateParser$Strategy ABBREVIATED_YEAR_STRATEGY = new FastDateParser$1(1);
    private static final FastDateParser$Strategy NUMBER_MONTH_STRATEGY = new FastDateParser$2(2);
    private static final FastDateParser$Strategy LITERAL_YEAR_STRATEGY = new FastDateParser$NumberStrategy(1);
    private static final FastDateParser$Strategy WEEK_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(3);
    private static final FastDateParser$Strategy WEEK_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(4);
    private static final FastDateParser$Strategy DAY_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(6);
    private static final FastDateParser$Strategy DAY_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(5);
    private static final FastDateParser$Strategy DAY_OF_WEEK_IN_MONTH_STRATEGY = new FastDateParser$NumberStrategy(8);
    private static final FastDateParser$Strategy HOUR_OF_DAY_STRATEGY = new FastDateParser$NumberStrategy(11);
    private static final FastDateParser$Strategy HOUR24_OF_DAY_STRATEGY = new FastDateParser$3(11);
    private static final FastDateParser$Strategy HOUR12_STRATEGY = new FastDateParser$4(10);
    private static final FastDateParser$Strategy HOUR_STRATEGY = new FastDateParser$NumberStrategy(10);
    private static final FastDateParser$Strategy MINUTE_STRATEGY = new FastDateParser$NumberStrategy(12);
    private static final FastDateParser$Strategy SECOND_STRATEGY = new FastDateParser$NumberStrategy(13);
    private static final FastDateParser$Strategy MILLISECOND_STRATEGY = new FastDateParser$NumberStrategy(14);
    private static final FastDateParser$Strategy ISO_8601_STRATEGY = new FastDateParser$ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}(?::?\\d{2})?))");

    protected FastDateParser(String pattern, TimeZone timeZone, Locale locale) {
        this(pattern, timeZone, locale, null);
    }

    protected FastDateParser(String pattern, TimeZone timeZone, Locale locale, Date centuryStart) {
        int centuryStartYear;
        this.pattern = pattern;
        this.timeZone = timeZone;
        this.locale = locale;
        Calendar definingCalendar = Calendar.getInstance(timeZone, locale);
        if (centuryStart != null) {
            definingCalendar.setTime(centuryStart);
            centuryStartYear = definingCalendar.get(1);
        } else if (locale.equals(JAPANESE_IMPERIAL)) {
            centuryStartYear = 0;
        } else {
            definingCalendar.setTime(new Date());
            centuryStartYear = definingCalendar.get(1) - 80;
        }
        this.century = centuryStartYear / 100 * 100;
        this.startYear = centuryStartYear - this.century;
        this.init(definingCalendar);
    }

    private void init(Calendar definingCalendar) {
        StringBuilder regex = new StringBuilder();
        ArrayList<FastDateParser$Strategy> collector = new ArrayList<FastDateParser$Strategy>();
        Matcher patternMatcher = formatPattern.matcher(this.pattern);
        if (!patternMatcher.lookingAt()) {
            throw new IllegalArgumentException("Illegal pattern character '" + this.pattern.charAt(patternMatcher.regionStart()) + "'");
        }
        this.currentFormatField = patternMatcher.group();
        FastDateParser$Strategy currentStrategy = this.getStrategy(this.currentFormatField, definingCalendar);
        while (true) {
            patternMatcher.region(patternMatcher.end(), patternMatcher.regionEnd());
            if (!patternMatcher.lookingAt()) break;
            String nextFormatField = patternMatcher.group();
            this.nextStrategy = this.getStrategy(nextFormatField, definingCalendar);
            if (currentStrategy.addRegex(this, regex)) {
                collector.add(currentStrategy);
            }
            this.currentFormatField = nextFormatField;
            currentStrategy = this.nextStrategy;
        }
        this.nextStrategy = null;
        if (patternMatcher.regionStart() != patternMatcher.regionEnd()) {
            throw new IllegalArgumentException("Failed to parse \"" + this.pattern + "\" ; gave up at index " + patternMatcher.regionStart());
        }
        if (currentStrategy.addRegex(this, regex)) {
            collector.add(currentStrategy);
        }
        this.currentFormatField = null;
        this.strategies = collector.toArray(new FastDateParser$Strategy[collector.size()]);
        this.parsePattern = Pattern.compile(regex.toString());
    }

    public String getPattern() {
        return this.pattern;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    Pattern getParsePattern() {
        return this.parsePattern;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FastDateParser)) {
            return false;
        }
        FastDateParser other = (FastDateParser)obj;
        return this.pattern.equals(other.pattern) && this.timeZone.equals(other.timeZone) && this.locale.equals(other.locale);
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    public String toString() {
        return "FastDateParser[" + this.pattern + "," + this.locale + "," + this.timeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream in2) {
        in2.defaultReadObject();
        Calendar definingCalendar = Calendar.getInstance(this.timeZone, this.locale);
        this.init(definingCalendar);
    }

    public Object parseObject(String source) {
        return this.parse(source);
    }

    public Date parse(String source) {
        Date date = this.parse(source, new ParsePosition(0));
        if (date == null) {
            if (this.locale.equals(JAPANESE_IMPERIAL)) {
                throw new ParseException("(The " + this.locale + " locale does not support dates before 1868 AD)\nUnparseable date: \"" + source + "\" does not match " + this.parsePattern.pattern(), 0);
            }
            throw new ParseException("Unparseable date: \"" + source + "\" does not match " + this.parsePattern.pattern(), 0);
        }
        return date;
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public Date parse(String source, ParsePosition pos) {
        int offset = pos.getIndex();
        Matcher matcher = this.parsePattern.matcher(source.substring(offset));
        if (!matcher.lookingAt()) {
            return null;
        }
        Calendar cal = Calendar.getInstance(this.timeZone, this.locale);
        cal.clear();
        int i2 = 0;
        while (i2 < this.strategies.length) {
            FastDateParser$Strategy strategy = this.strategies[i2++];
            strategy.setCalendar(this, cal, matcher.group(i2));
        }
        pos.setIndex(offset + matcher.end());
        return cal.getTime();
    }

    private static StringBuilder escapeRegex(StringBuilder regex, String value, boolean unquote) {
        regex.append("\\Q");
        for (int i2 = 0; i2 < value.length(); ++i2) {
            int c2 = value.charAt(i2);
            switch (c2) {
                case 39: {
                    if (!unquote) break;
                    if (++i2 == value.length()) {
                        return regex;
                    }
                    c2 = value.charAt(i2);
                    break;
                }
                case 92: {
                    if (++i2 == value.length()) break;
                    regex.append((char)c2);
                    c2 = value.charAt(i2);
                    if (c2 != 69) break;
                    regex.append("E\\\\E\\");
                    c2 = 81;
                    break;
                }
            }
            regex.append((char)c2);
        }
        regex.append("\\E");
        return regex;
    }

    private static Map<String, Integer> getDisplayNames(int field, Calendar definingCalendar, Locale locale) {
        return definingCalendar.getDisplayNames(field, 0, locale);
    }

    private int adjustYear(int twoDigitYear) {
        int trial = this.century + twoDigitYear;
        return twoDigitYear >= this.startYear ? trial : trial + 100;
    }

    boolean isNextNumber() {
        return this.nextStrategy != null && this.nextStrategy.isNumber();
    }

    int getFieldWidth() {
        return this.currentFormatField.length();
    }

    private FastDateParser$Strategy getStrategy(String formatField, Calendar definingCalendar) {
        switch (formatField.charAt(0)) {
            case '\'': {
                if (formatField.length() > 2) {
                    return new FastDateParser$CopyQuotedStrategy(formatField.substring(1, formatField.length() - 1));
                }
            }
            default: {
                return new FastDateParser$CopyQuotedStrategy(formatField);
            }
            case 'D': {
                return DAY_OF_YEAR_STRATEGY;
            }
            case 'E': {
                return this.getLocaleSpecificStrategy(7, definingCalendar);
            }
            case 'F': {
                return DAY_OF_WEEK_IN_MONTH_STRATEGY;
            }
            case 'G': {
                return this.getLocaleSpecificStrategy(0, definingCalendar);
            }
            case 'H': {
                return HOUR_OF_DAY_STRATEGY;
            }
            case 'K': {
                return HOUR_STRATEGY;
            }
            case 'M': {
                return formatField.length() >= 3 ? this.getLocaleSpecificStrategy(2, definingCalendar) : NUMBER_MONTH_STRATEGY;
            }
            case 'S': {
                return MILLISECOND_STRATEGY;
            }
            case 'W': {
                return WEEK_OF_MONTH_STRATEGY;
            }
            case 'a': {
                return this.getLocaleSpecificStrategy(9, definingCalendar);
            }
            case 'd': {
                return DAY_OF_MONTH_STRATEGY;
            }
            case 'h': {
                return HOUR12_STRATEGY;
            }
            case 'k': {
                return HOUR24_OF_DAY_STRATEGY;
            }
            case 'm': {
                return MINUTE_STRATEGY;
            }
            case 's': {
                return SECOND_STRATEGY;
            }
            case 'w': {
                return WEEK_OF_YEAR_STRATEGY;
            }
            case 'y': {
                return formatField.length() > 2 ? LITERAL_YEAR_STRATEGY : ABBREVIATED_YEAR_STRATEGY;
            }
            case 'X': {
                return FastDateParser$ISO8601TimeZoneStrategy.getStrategy(formatField.length());
            }
            case 'Z': {
                if (!formatField.equals("ZZ")) break;
                return ISO_8601_STRATEGY;
            }
            case 'z': 
        }
        return this.getLocaleSpecificStrategy(15, definingCalendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<Locale, FastDateParser$Strategy> getCache(int field) {
        ConcurrentMap<Locale, FastDateParser$Strategy>[] concurrentMapArray = caches;
        synchronized (caches) {
            if (caches[field] == null) {
                FastDateParser.caches[field] = new ConcurrentHashMap<Locale, FastDateParser$Strategy>(3);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return caches[field];
        }
    }

    private FastDateParser$Strategy getLocaleSpecificStrategy(int field, Calendar definingCalendar) {
        FastDateParser$Strategy inCache;
        ConcurrentMap<Locale, FastDateParser$Strategy> cache = FastDateParser.getCache(field);
        FastDateParser$Strategy strategy = (FastDateParser$Strategy)cache.get(this.locale);
        if (strategy == null && (inCache = cache.putIfAbsent(this.locale, strategy = field == 15 ? new FastDateParser$TimeZoneStrategy(this.locale) : new FastDateParser$CaseInsensitiveTextStrategy(field, definingCalendar, this.locale))) != null) {
            return inCache;
        }
        return strategy;
    }

    static /* synthetic */ StringBuilder access$100(StringBuilder x0, String x1, boolean x2) {
        return FastDateParser.escapeRegex(x0, x1, x2);
    }

    static /* synthetic */ Map access$200(int x0, Calendar x1, Locale x2) {
        return FastDateParser.getDisplayNames(x0, x1, x2);
    }

    static /* synthetic */ int access$300(FastDateParser x0, int x1) {
        return x0.adjustYear(x1);
    }
}

