/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.sqlite.date.FastDateParser;
import org.sqlite.date.FastDateParser$Strategy;

class FastDateParser$TimeZoneStrategy
extends FastDateParser$Strategy {
    private final String validTimeZoneChars;
    private final SortedMap<String, TimeZone> tzNames = new TreeMap<String, TimeZone>(String.CASE_INSENSITIVE_ORDER);

    FastDateParser$TimeZoneStrategy(Locale locale) {
        super(null);
        String[][] zones;
        for (String[] zone : zones = DateFormatSymbols.getInstance(locale).getZoneStrings()) {
            if (zone[0].startsWith("GMT")) continue;
            TimeZone tz2 = TimeZone.getTimeZone(zone[0]);
            if (!this.tzNames.containsKey(zone[1])) {
                this.tzNames.put(zone[1], tz2);
            }
            if (!this.tzNames.containsKey(zone[2])) {
                this.tzNames.put(zone[2], tz2);
            }
            if (!tz2.useDaylightTime()) continue;
            if (!this.tzNames.containsKey(zone[3])) {
                this.tzNames.put(zone[3], tz2);
            }
            if (this.tzNames.containsKey(zone[4])) continue;
            this.tzNames.put(zone[4], tz2);
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append("(GMT[+-]\\d{1,2}:\\d{2}").append('|');
        sb2.append("[+-]\\d{4}").append('|');
        for (String id2 : this.tzNames.keySet()) {
            FastDateParser.access$100(sb2, id2, false).append('|');
        }
        sb2.setCharAt(sb2.length() - 1, ')');
        this.validTimeZoneChars = sb2.toString();
    }

    @Override
    boolean addRegex(FastDateParser parser, StringBuilder regex) {
        regex.append(this.validTimeZoneChars);
        return true;
    }

    @Override
    void setCalendar(FastDateParser parser, Calendar cal, String value) {
        TimeZone tz2;
        if (value.charAt(0) == '+' || value.charAt(0) == '-') {
            tz2 = TimeZone.getTimeZone("GMT" + value);
        } else if (value.startsWith("GMT")) {
            tz2 = TimeZone.getTimeZone(value);
        } else {
            tz2 = (TimeZone)this.tzNames.get(value);
            if (tz2 == null) {
                throw new IllegalArgumentException(value + " is not a supported timezone name");
            }
        }
        cal.setTimeZone(tz2);
    }
}

