/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.util.Calendar;
import java.util.TimeZone;
import org.sqlite.date.FastDateParser;
import org.sqlite.date.FastDateParser$Strategy;

class FastDateParser$ISO8601TimeZoneStrategy
extends FastDateParser$Strategy {
    private final String pattern;
    private static final FastDateParser$Strategy ISO_8601_1_STRATEGY = new FastDateParser$ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}))");
    private static final FastDateParser$Strategy ISO_8601_2_STRATEGY = new FastDateParser$ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}\\d{2}))");
    private static final FastDateParser$Strategy ISO_8601_3_STRATEGY = new FastDateParser$ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}(?::)\\d{2}))");

    FastDateParser$ISO8601TimeZoneStrategy(String pattern) {
        super(null);
        this.pattern = pattern;
    }

    @Override
    boolean addRegex(FastDateParser parser, StringBuilder regex) {
        regex.append(this.pattern);
        return true;
    }

    @Override
    void setCalendar(FastDateParser parser, Calendar cal, String value) {
        if (value.equals("Z")) {
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            cal.setTimeZone(TimeZone.getTimeZone("GMT" + value));
        }
    }

    static FastDateParser$Strategy getStrategy(int tokenLen) {
        switch (tokenLen) {
            case 1: {
                return ISO_8601_1_STRATEGY;
            }
            case 2: {
                return ISO_8601_2_STRATEGY;
            }
            case 3: {
                return ISO_8601_3_STRATEGY;
            }
        }
        throw new IllegalArgumentException("invalid number of X");
    }
}

