/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sqlite.BusyHandler;
import org.sqlite.Function;
import org.sqlite.ProgressHandler;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteErrorCode;
import org.sqlite.SQLiteException;
import org.sqlite.core.Codes;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;

public abstract class DB
implements Codes {
    SQLiteConnection conn = null;
    long begin = 0L;
    long commit = 0L;
    private final Map<Long, CoreStatement> stmts = new HashMap<Long, CoreStatement>();

    public abstract void interrupt();

    public abstract void busy_timeout(int var1);

    public abstract void busy_handler(BusyHandler var1);

    abstract String errmsg();

    public abstract String libversion();

    public abstract int changes();

    public abstract int total_changes();

    public abstract int shared_cache(boolean var1);

    public abstract int enable_load_extension(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void exec(String sql) {
        long pointer = 0L;
        try {
            pointer = this.prepare(sql);
            int rc2 = this.step(pointer);
            switch (rc2) {
                case 101: {
                    this.ensureAutoCommit();
                    return;
                }
                case 100: {
                    return;
                }
            }
            this.throwex(rc2);
        }
        finally {
            this.finalize(pointer);
        }
    }

    public final synchronized void open(SQLiteConnection conn, String file, int openFlags) {
        this.conn = conn;
        this._open(file, openFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void close() {
        Map<Long, CoreStatement> map = this.stmts;
        synchronized (map) {
            Iterator<Map.Entry<Long, CoreStatement>> i2 = this.stmts.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry<Long, CoreStatement> entry = i2.next();
                CoreStatement stmt = entry.getValue();
                this.finalize(entry.getKey());
                if (stmt != null) {
                    stmt.pointer = 0L;
                }
                i2.remove();
            }
        }
        this.free_functions();
        if (this.begin != 0L) {
            this.finalize(this.begin);
            this.begin = 0L;
        }
        if (this.commit != 0L) {
            this.finalize(this.commit);
            this.commit = 0L;
        }
        this._close();
    }

    public final synchronized void prepare(CoreStatement stmt) {
        if (stmt.sql == null) {
            throw new NullPointerException();
        }
        if (stmt.pointer != 0L) {
            this.finalize(stmt);
        }
        stmt.pointer = this.prepare(stmt.sql);
        this.stmts.put(new Long(stmt.pointer), stmt);
    }

    public final synchronized int finalize(CoreStatement stmt) {
        if (stmt.pointer == 0L) {
            return 0;
        }
        int rc2 = 1;
        try {
            rc2 = this.finalize(stmt.pointer);
        }
        finally {
            this.stmts.remove(new Long(stmt.pointer));
            stmt.pointer = 0L;
        }
        return rc2;
    }

    protected abstract void _open(String var1, int var2);

    protected abstract void _close();

    public abstract int _exec(String var1);

    protected abstract long prepare(String var1);

    protected abstract int finalize(long var1);

    public abstract int step(long var1);

    public abstract int reset(long var1);

    public abstract int clear_bindings(long var1);

    abstract int bind_parameter_count(long var1);

    public abstract int column_count(long var1);

    public abstract int column_type(long var1, int var3);

    public abstract String column_decltype(long var1, int var3);

    public abstract String column_table_name(long var1, int var3);

    public abstract String column_name(long var1, int var3);

    public abstract String column_text(long var1, int var3);

    public abstract byte[] column_blob(long var1, int var3);

    public abstract double column_double(long var1, int var3);

    public abstract long column_long(long var1, int var3);

    public abstract int column_int(long var1, int var3);

    abstract int bind_null(long var1, int var3);

    abstract int bind_int(long var1, int var3, int var4);

    abstract int bind_long(long var1, int var3, long var4);

    abstract int bind_double(long var1, int var3, double var4);

    abstract int bind_text(long var1, int var3, String var4);

    abstract int bind_blob(long var1, int var3, byte[] var4);

    public abstract void result_null(long var1);

    public abstract void result_text(long var1, String var3);

    public abstract void result_blob(long var1, byte[] var3);

    public abstract void result_double(long var1, double var3);

    public abstract void result_long(long var1, long var3);

    public abstract void result_int(long var1, int var3);

    public abstract void result_error(long var1, String var3);

    public abstract String value_text(Function var1, int var2);

    public abstract byte[] value_blob(Function var1, int var2);

    public abstract double value_double(Function var1, int var2);

    public abstract long value_long(Function var1, int var2);

    public abstract int value_int(Function var1, int var2);

    public abstract int value_type(Function var1, int var2);

    public abstract int create_function(String var1, Function var2);

    public abstract int destroy_function(String var1);

    abstract void free_functions();

    public abstract int backup(String var1, String var2, ProgressObserver var3);

    public abstract int restore(String var1, String var2, ProgressObserver var3);

    public abstract void register_progress_handler(int var1, ProgressHandler var2);

    public abstract void clear_progress_handler();

    abstract boolean[][] column_metadata(long var1);

    public final synchronized String[] column_names(long stmt) {
        String[] names = new String[this.column_count(stmt)];
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = this.column_name(stmt, i2);
        }
        return names;
    }

    final synchronized int sqlbind(long stmt, int pos, Object v2) {
        ++pos;
        if (v2 == null) {
            return this.bind_null(stmt, pos);
        }
        if (v2 instanceof Integer) {
            return this.bind_int(stmt, pos, (Integer)v2);
        }
        if (v2 instanceof Short) {
            return this.bind_int(stmt, pos, ((Short)v2).intValue());
        }
        if (v2 instanceof Long) {
            return this.bind_long(stmt, pos, (Long)v2);
        }
        if (v2 instanceof Float) {
            return this.bind_double(stmt, pos, ((Float)v2).doubleValue());
        }
        if (v2 instanceof Double) {
            return this.bind_double(stmt, pos, (Double)v2);
        }
        if (v2 instanceof String) {
            return this.bind_text(stmt, pos, (String)v2);
        }
        if (v2 instanceof byte[]) {
            return this.bind_blob(stmt, pos, (byte[])v2);
        }
        throw new SQLException("unexpected param type: " + v2.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized int[] executeBatch(long stmt, int count, Object[] vals) {
        if (count < 1) {
            throw new SQLException("count (" + count + ") < 1");
        }
        int params = this.bind_parameter_count(stmt);
        int[] changes = new int[count];
        try {
            for (int i2 = 0; i2 < count; ++i2) {
                int rc2;
                this.reset(stmt);
                for (int j2 = 0; j2 < params; ++j2) {
                    rc2 = this.sqlbind(stmt, j2, vals[i2 * params + j2]);
                    if (rc2 == 0) continue;
                    this.throwex(rc2);
                }
                rc2 = this.step(stmt);
                if (rc2 != 101) {
                    this.reset(stmt);
                    if (rc2 == 100) {
                        throw new BatchUpdateException("batch entry " + i2 + ": query returns results", changes);
                    }
                    this.throwex(rc2);
                }
                changes[i2] = this.changes();
            }
        }
        finally {
            this.ensureAutoCommit();
        }
        this.reset(stmt);
        return changes;
    }

    public final synchronized boolean execute(CoreStatement stmt, Object[] vals) {
        if (vals != null) {
            int params = this.bind_parameter_count(stmt.pointer);
            if (params != vals.length) {
                throw new SQLException("assertion failure: param count (" + params + ") != value count (" + vals.length + ")");
            }
            for (int i2 = 0; i2 < params; ++i2) {
                int rc2 = this.sqlbind(stmt.pointer, i2, vals[i2]);
                if (rc2 == 0) continue;
                this.throwex(rc2);
            }
        }
        int statusCode = this.step(stmt.pointer);
        switch (statusCode) {
            case 101: {
                this.reset(stmt.pointer);
                this.ensureAutoCommit();
                return false;
            }
            case 100: {
                return true;
            }
            case 5: 
            case 6: 
            case 21: {
                throw this.newSQLException(statusCode);
            }
        }
        this.finalize(stmt);
        throw this.newSQLException(statusCode);
    }

    final synchronized boolean execute(String sql) {
        int statusCode = this._exec(sql);
        switch (statusCode) {
            case 0: {
                return false;
            }
            case 101: {
                this.ensureAutoCommit();
                return false;
            }
            case 100: {
                return true;
            }
        }
        throw this.newSQLException(statusCode);
    }

    public final synchronized int executeUpdate(CoreStatement stmt, Object[] vals) {
        try {
            if (this.execute(stmt, vals)) {
                throw new SQLException("query returns results");
            }
        }
        finally {
            if (stmt.pointer != 0L) {
                this.reset(stmt.pointer);
            }
        }
        return this.changes();
    }

    final void throwex() {
        throw new SQLException(this.errmsg());
    }

    public final void throwex(int errorCode) {
        throw this.newSQLException(errorCode);
    }

    static final void throwex(int errorCode, String errorMessage) {
        throw DB.newSQLException(errorCode, errorMessage);
    }

    public static SQLiteException newSQLException(int errorCode, String errorMessage) {
        SQLiteErrorCode code = SQLiteErrorCode.getErrorCode(errorCode);
        SQLiteException e2 = new SQLiteException(String.format("%s (%s)", new Object[]{code, errorMessage}), code);
        return e2;
    }

    private SQLiteException newSQLException(int errorCode) {
        return DB.newSQLException(errorCode, this.errmsg());
    }

    final void ensureAutoCommit() {
        if (!this.conn.getAutoCommit()) {
            return;
        }
        if (this.begin == 0L) {
            this.begin = this.prepare("begin;");
        }
        if (this.commit == 0L) {
            this.commit = this.prepare("commit;");
        }
        try {
            if (this.step(this.begin) != 101) {
                return;
            }
            int rc2 = this.step(this.commit);
            if (rc2 != 101) {
                this.reset(this.commit);
                this.throwex(rc2);
            }
        }
        finally {
            this.reset(this.begin);
            this.reset(this.commit);
        }
    }
}

