/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.sqlite.JDBC;
import org.sqlite.SQLiteConfig;

public class SQLiteDataSource
implements DataSource {
    private SQLiteConfig config = new SQLiteConfig();
    private transient PrintWriter logger;
    private int loginTimeout = 1;
    private String url = "jdbc:sqlite:";
    private String databaseName = "";

    @Override
    public Connection getConnection() {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) {
        Properties p2 = this.config.toProperties();
        if (username != null) {
            p2.put("user", username);
        }
        if (password != null) {
            p2.put("pass", password);
        }
        return JDBC.createConnection(this.url, p2);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logger;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() {
        throw new SQLFeatureNotSupportedException("getParentLogger");
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logger = out;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return (T)this;
    }
}

