/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import org.sqlite.SQLiteConfig$DateClass;
import org.sqlite.SQLiteConfig$DatePrecision;
import org.sqlite.SQLiteConfig$HexKeyMode;
import org.sqlite.SQLiteConfig$Pragma;
import org.sqlite.SQLiteConfig$PragmaValue;
import org.sqlite.SQLiteConfig$TransactionMode;
import org.sqlite.SQLiteOpenMode;

public class SQLiteConfig {
    private final Properties pragmaTable;
    private int openModeFlag = 0;
    private SQLiteConfig$TransactionMode transactionMode;
    public final int busyTimeout;
    public SQLiteConfig$DateClass dateClass;
    public SQLiteConfig$DatePrecision datePrecision;
    public long dateMultiplier;
    public String dateStringFormat;
    private static final String[] OnOff = new String[]{"true", "false"};

    public SQLiteConfig() {
        this(new Properties());
    }

    public SQLiteConfig(Properties prop) {
        this.pragmaTable = prop;
        String openMode = this.pragmaTable.getProperty(SQLiteConfig$Pragma.OPEN_MODE.pragmaName);
        if (openMode != null) {
            this.openModeFlag = Integer.parseInt(openMode);
        } else {
            this.setOpenMode(SQLiteOpenMode.READWRITE);
            this.setOpenMode(SQLiteOpenMode.CREATE);
        }
        openMode = this.pragmaTable.getProperty(SQLiteConfig$Pragma.SHARED_CACHE.pragmaName);
        this.setOpenMode(SQLiteOpenMode.OPEN_URI);
        this.transactionMode = SQLiteConfig$TransactionMode.getMode(this.pragmaTable.getProperty(SQLiteConfig$Pragma.TRANSACTION_MODE.pragmaName, SQLiteConfig$TransactionMode.DEFFERED.name()));
        this.dateClass = SQLiteConfig$DateClass.getDateClass(this.pragmaTable.getProperty(SQLiteConfig$Pragma.DATE_CLASS.pragmaName, SQLiteConfig$DateClass.INTEGER.name()));
        this.datePrecision = SQLiteConfig$DatePrecision.getPrecision(this.pragmaTable.getProperty(SQLiteConfig$Pragma.DATE_PRECISION.pragmaName, SQLiteConfig$DatePrecision.MILLISECONDS.name()));
        this.dateMultiplier = this.datePrecision == SQLiteConfig$DatePrecision.MILLISECONDS ? 1L : 1000L;
        this.dateStringFormat = this.pragmaTable.getProperty(SQLiteConfig$Pragma.DATE_STRING_FORMAT.pragmaName, "yyyy-MM-dd HH:mm:ss.SSS");
        this.busyTimeout = Integer.parseInt(this.pragmaTable.getProperty(SQLiteConfig$Pragma.BUSY_TIMEOUT.pragmaName, "3000"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Connection conn) {
        HashSet<String> pragmaParams = new HashSet<String>();
        for (SQLiteConfig$Pragma each : SQLiteConfig$Pragma.values()) {
            pragmaParams.add(each.pragmaName);
        }
        pragmaParams.remove(SQLiteConfig$Pragma.OPEN_MODE.pragmaName);
        pragmaParams.remove(SQLiteConfig$Pragma.SHARED_CACHE.pragmaName);
        pragmaParams.remove(SQLiteConfig$Pragma.LOAD_EXTENSION.pragmaName);
        pragmaParams.remove(SQLiteConfig$Pragma.DATE_PRECISION.pragmaName);
        pragmaParams.remove(SQLiteConfig$Pragma.DATE_CLASS.pragmaName);
        pragmaParams.remove(SQLiteConfig$Pragma.DATE_STRING_FORMAT.pragmaName);
        pragmaParams.remove(SQLiteConfig$Pragma.PASSWORD.pragmaName);
        pragmaParams.remove(SQLiteConfig$Pragma.HEXKEY_MODE.pragmaName);
        try (Statement stat = conn.createStatement();){
            String password;
            if (this.pragmaTable.containsKey(SQLiteConfig$Pragma.PASSWORD.pragmaName) && (password = this.pragmaTable.getProperty(SQLiteConfig$Pragma.PASSWORD.pragmaName)) != null && !password.isEmpty()) {
                String hexkeyMode = this.pragmaTable.getProperty(SQLiteConfig$Pragma.HEXKEY_MODE.pragmaName);
                String passwordPragma = SQLiteConfig$HexKeyMode.SSE.name().equalsIgnoreCase(hexkeyMode) ? "pragma hexkey = '%s'" : (SQLiteConfig$HexKeyMode.SQLCIPHER.name().equalsIgnoreCase(hexkeyMode) ? "pragma key = \"x'%s'\"" : "pragma key = '%s'");
                stat.execute(String.format(passwordPragma, password.replace("'", "''")));
                stat.execute("select 1 from sqlite_master");
            }
            for (Object each : this.pragmaTable.keySet()) {
                String value;
                String key = each.toString();
                if (!pragmaParams.contains(key) || (value = this.pragmaTable.getProperty(key)) == null) continue;
                stat.execute(String.format("pragma %s=%s", key, value));
            }
        }
    }

    private boolean getBoolean(SQLiteConfig$Pragma pragma, String defaultValue) {
        return Boolean.parseBoolean(this.pragmaTable.getProperty(pragma.pragmaName, defaultValue));
    }

    public boolean isEnabledSharedCache() {
        return this.getBoolean(SQLiteConfig$Pragma.SHARED_CACHE, "false");
    }

    public boolean isEnabledLoadExtension() {
        return this.getBoolean(SQLiteConfig$Pragma.LOAD_EXTENSION, "false");
    }

    public int getOpenModeFlags() {
        return this.openModeFlag;
    }

    public Properties toProperties() {
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.OPEN_MODE.pragmaName, Integer.toString(this.openModeFlag));
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.TRANSACTION_MODE.pragmaName, this.transactionMode.getValue());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.DATE_CLASS.pragmaName, this.dateClass.getValue());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.DATE_PRECISION.pragmaName, this.datePrecision.getValue());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.DATE_STRING_FORMAT.pragmaName, this.dateStringFormat);
        return this.pragmaTable;
    }

    static DriverPropertyInfo[] getDriverPropertyInfo() {
        SQLiteConfig$Pragma[] pragma = SQLiteConfig$Pragma.values();
        DriverPropertyInfo[] result = new DriverPropertyInfo[pragma.length];
        int index = 0;
        for (SQLiteConfig$Pragma p2 : SQLiteConfig$Pragma.values()) {
            DriverPropertyInfo di2 = new DriverPropertyInfo(p2.pragmaName, null);
            di2.choices = p2.choices;
            di2.description = p2.description;
            di2.required = false;
            result[index++] = di2;
        }
        return result;
    }

    public void setOpenMode(SQLiteOpenMode mode) {
        this.openModeFlag |= mode.flag;
    }

    private static String[] toStringArray(SQLiteConfig$PragmaValue[] list) {
        String[] result = new String[list.length];
        for (int i2 = 0; i2 < list.length; ++i2) {
            result[i2] = list[i2].getValue();
        }
        return result;
    }

    public SQLiteConfig$TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    static /* synthetic */ String[] access$000() {
        return OnOff;
    }

    static /* synthetic */ String[] access$100(SQLiteConfig$PragmaValue[] x0) {
        return SQLiteConfig.toStringArray(x0);
    }
}

