/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.ExtendedCommand;
import org.sqlite.ExtendedCommand$SQLExtension;
import org.sqlite.core.DB;

public class ExtendedCommand$BackupCommand
implements ExtendedCommand$SQLExtension {
    public final String srcDB;
    public final String destFile;
    private static Pattern backupCmd = Pattern.compile("backup(\\s+(\"[^\"]*\"|'[^']*'|\\S+))?\\s+to\\s+(\"[^\"]*\"|'[^']*'|\\S+)");

    public ExtendedCommand$BackupCommand(String srcDB, String destFile) {
        this.srcDB = srcDB;
        this.destFile = destFile;
    }

    public static ExtendedCommand$BackupCommand parse(String sql) {
        Matcher m2;
        if (sql != null && (m2 = backupCmd.matcher(sql)).matches()) {
            String dbName = ExtendedCommand.removeQuotation(m2.group(2));
            String dest = ExtendedCommand.removeQuotation(m2.group(3));
            if (dbName == null || dbName.length() == 0) {
                dbName = "main";
            }
            return new ExtendedCommand$BackupCommand(dbName, dest);
        }
        throw new SQLException("syntax error: " + sql);
    }

    @Override
    public void execute(DB db2) {
        db2.backup(this.srcDB, this.destFile, null);
    }
}

