/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public final class TSimpleFileTransport
extends TTransport {
    private RandomAccessFile file = null;
    private boolean readable;
    private boolean writable;
    private String path_;

    public TSimpleFileTransport(String path, boolean read, boolean write, boolean openFile) {
        if (path.length() <= 0) {
            throw new TTransportException("No path specified");
        }
        if (!read && !write) {
            throw new TTransportException("Neither READ nor WRITE specified");
        }
        this.readable = read;
        this.writable = write;
        this.path_ = path;
        if (openFile) {
            this.open();
        }
    }

    public TSimpleFileTransport(String path, boolean read, boolean write) {
        this(path, read, write, true);
    }

    public TSimpleFileTransport(String path) {
        this(path, true, false, true);
    }

    @Override
    public boolean isOpen() {
        return this.file != null;
    }

    @Override
    public void open() {
        if (this.file == null) {
            try {
                String access = "r";
                if (this.writable) {
                    access = access + "w";
                }
                this.file = new RandomAccessFile(this.path_, access);
            }
            catch (IOException ioe) {
                this.file = null;
                throw new TTransportException(ioe.getMessage());
            }
        }
    }

    @Override
    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.file = null;
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) {
        if (!this.readable) {
            throw new TTransportException("Read operation on write only file");
        }
        int iBytesRead = 0;
        try {
            iBytesRead = this.file.read(buf, off, len);
        }
        catch (IOException ioe) {
            this.file = null;
            throw new TTransportException(ioe.getMessage());
        }
        return iBytesRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            this.file.write(buf, off, len);
        }
        catch (IOException ioe) {
            this.file = null;
            throw new TTransportException(ioe.getMessage());
        }
    }

    public void seek(long offset) {
        try {
            this.file.seek(offset);
        }
        catch (IOException ex2) {
            throw new TTransportException(ex2.getMessage());
        }
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException ex2) {
            throw new TTransportException(ex2.getMessage());
        }
    }

    public long getFilePointer() {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException ex2) {
            throw new TTransportException(ex2.getMessage());
        }
    }
}

