/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.UnsupportedEncodingException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TSaslTransport$NegotiationStatus;
import org.apache.thrift.transport.TSaslTransport$SaslParticipant;
import org.apache.thrift.transport.TSaslTransport$SaslResponse;
import org.apache.thrift.transport.TSaslTransport$SaslRole;
import org.apache.thrift.transport.TSaslTransportException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

abstract class TSaslTransport
extends TTransport {
    private static final YA LOGGER = YB.a(TSaslTransport.class);
    protected static final int DEFAULT_MAX_LENGTH = Integer.MAX_VALUE;
    protected static final int MECHANISM_NAME_BYTES = 1;
    protected static final int STATUS_BYTES = 1;
    protected static final int PAYLOAD_LENGTH_BYTES = 4;
    protected TTransport underlyingTransport;
    private TSaslTransport$SaslParticipant sasl;
    private boolean shouldWrap = false;
    private TMemoryInputTransport readBuffer = new TMemoryInputTransport();
    private final TByteArrayOutputStream writeBuffer = new TByteArrayOutputStream(1024);
    private final byte[] messageHeader = new byte[5];

    protected TSaslTransport(TTransport underlyingTransport) {
        this.underlyingTransport = underlyingTransport;
    }

    protected TSaslTransport(SaslClient saslClient, TTransport underlyingTransport) {
        this.sasl = new TSaslTransport$SaslParticipant(saslClient);
        this.underlyingTransport = underlyingTransport;
    }

    protected void setSaslServer(SaslServer saslServer) {
        this.sasl = new TSaslTransport$SaslParticipant(saslServer);
    }

    protected void sendSaslMessage(TSaslTransport$NegotiationStatus status, byte[] payload) {
        if (payload == null) {
            payload = new byte[]{};
        }
        this.messageHeader[0] = status.getValue();
        EncodingUtils.encodeBigEndian(payload.length, this.messageHeader, 1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)((Object)this.getRole()) + ": Writing message with status {} and payload length {}", (Object)status, (Object)payload.length);
        }
        this.underlyingTransport.write(this.messageHeader);
        this.underlyingTransport.write(payload);
        this.underlyingTransport.flush();
    }

    protected TSaslTransport$SaslResponse receiveSaslMessage() {
        this.underlyingTransport.readAll(this.messageHeader, 0, this.messageHeader.length);
        byte statusByte = this.messageHeader[0];
        TSaslTransport$NegotiationStatus status = TSaslTransport$NegotiationStatus.byValue(statusByte);
        if (status == null) {
            throw this.sendAndThrowMessage(TSaslTransport$NegotiationStatus.ERROR, "Invalid status " + statusByte);
        }
        int payloadBytes = EncodingUtils.decodeBigEndian(this.messageHeader, 1);
        if (payloadBytes < 0 || payloadBytes > 0x6400000) {
            throw this.sendAndThrowMessage(TSaslTransport$NegotiationStatus.ERROR, "Invalid payload header length: " + payloadBytes);
        }
        byte[] payload = new byte[payloadBytes];
        this.underlyingTransport.readAll(payload, 0, payload.length);
        if (status == TSaslTransport$NegotiationStatus.BAD || status == TSaslTransport$NegotiationStatus.ERROR) {
            try {
                String remoteMessage = new String(payload, "UTF-8");
                throw new TTransportException("Peer indicated failure: " + remoteMessage);
            }
            catch (UnsupportedEncodingException e2) {
                throw new TTransportException(e2);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)((Object)this.getRole()) + ": Received message with status {} and payload length {}", (Object)status, (Object)payload.length);
        }
        return new TSaslTransport$SaslResponse(status, payload);
    }

    protected TTransportException sendAndThrowMessage(TSaslTransport$NegotiationStatus status, String message) {
        try {
            this.sendSaslMessage(status, message.getBytes("UTF-8"));
        }
        catch (Exception e2) {
            LOGGER.warn("Could not send failure response", e2);
            message = message + "\nAlso, could not send response: " + e2.toString();
        }
        throw new TTransportException(message);
    }

    protected abstract void handleSaslStartMessage();

    protected abstract TSaslTransport$SaslRole getRole();

    @Override
    public void open() {
        boolean readSaslHeader = false;
        LOGGER.debug("opening transport {}", (Object)this);
        if (this.sasl != null && this.sasl.isComplete()) {
            throw new TTransportException("SASL transport already open");
        }
        if (!this.underlyingTransport.isOpen()) {
            this.underlyingTransport.open();
        }
        try {
            this.handleSaslStartMessage();
            readSaslHeader = true;
            LOGGER.debug("{}: Start message handled", (Object)this.getRole());
            TSaslTransport$SaslResponse message = null;
            while (!this.sasl.isComplete()) {
                message = this.receiveSaslMessage();
                if (message.status != TSaslTransport$NegotiationStatus.COMPLETE && message.status != TSaslTransport$NegotiationStatus.OK) {
                    throw new TTransportException("Expected COMPLETE or OK, got " + (Object)((Object)message.status));
                }
                byte[] challenge = this.sasl.evaluateChallengeOrResponse(message.payload);
                if (message.status == TSaslTransport$NegotiationStatus.COMPLETE && this.getRole() == TSaslTransport$SaslRole.CLIENT) {
                    LOGGER.debug("{}: All done!", (Object)this.getRole());
                    break;
                }
                this.sendSaslMessage(this.sasl.isComplete() ? TSaslTransport$NegotiationStatus.COMPLETE : TSaslTransport$NegotiationStatus.OK, challenge);
            }
            LOGGER.debug("{}: Main negotiation loop complete", (Object)this.getRole());
            assert (this.sasl.isComplete());
            if (this.getRole() == TSaslTransport$SaslRole.CLIENT && (message == null || message.status == TSaslTransport$NegotiationStatus.OK)) {
                LOGGER.debug("{}: SASL Client receiving last message", (Object)this.getRole());
                message = this.receiveSaslMessage();
                if (message.status != TSaslTransport$NegotiationStatus.COMPLETE) {
                    throw new TTransportException("Expected SASL COMPLETE, but got " + (Object)((Object)message.status));
                }
            }
        }
        catch (SaslException e2) {
            try {
                LOGGER.error("SASL negotiation failure", e2);
                throw this.sendAndThrowMessage(TSaslTransport$NegotiationStatus.BAD, e2.getMessage());
            }
            catch (Throwable throwable) {
                this.underlyingTransport.close();
                throw throwable;
            }
        }
        catch (TTransportException e3) {
            if (!readSaslHeader && e3.getType() == 4) {
                this.underlyingTransport.close();
                LOGGER.debug("No data or no sasl data in the stream");
                throw new TSaslTransportException("No data or no sasl data in the stream");
            }
            throw e3;
        }
        String qop = (String)this.sasl.getNegotiatedProperty("javax.security.sasl.qop");
        if (qop != null && !qop.equalsIgnoreCase("auth")) {
            this.shouldWrap = true;
        }
    }

    public SaslClient getSaslClient() {
        return this.sasl.saslClient;
    }

    public TTransport getUnderlyingTransport() {
        return this.underlyingTransport;
    }

    public SaslServer getSaslServer() {
        return this.sasl.saslServer;
    }

    protected int readLength() {
        byte[] lenBuf = new byte[4];
        this.underlyingTransport.readAll(lenBuf, 0, lenBuf.length);
        return EncodingUtils.decodeBigEndian(lenBuf);
    }

    protected void writeLength(int length) {
        byte[] lenBuf = new byte[4];
        TFramedTransport.encodeFrameSize(length, lenBuf);
        this.underlyingTransport.write(lenBuf);
    }

    @Override
    public void close() {
        this.underlyingTransport.close();
        try {
            this.sasl.dispose();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
    }

    @Override
    public boolean isOpen() {
        return this.underlyingTransport.isOpen() && this.sasl != null && this.sasl.isComplete();
    }

    @Override
    public int read(byte[] buf, int off, int len) {
        if (!this.isOpen()) {
            throw new TTransportException("SASL authentication not complete");
        }
        int got = this.readBuffer.read(buf, off, len);
        if (got > 0) {
            return got;
        }
        try {
            this.readFrame();
        }
        catch (SaslException e2) {
            throw new TTransportException(e2);
        }
        return this.readBuffer.read(buf, off, len);
    }

    private void readFrame() {
        int dataLength = this.readLength();
        if (dataLength < 0) {
            throw new TTransportException("Read a negative frame size (" + dataLength + ")!");
        }
        byte[] buff = new byte[dataLength];
        LOGGER.debug("{}: reading data length: {}", (Object)this.getRole(), (Object)dataLength);
        this.underlyingTransport.readAll(buff, 0, dataLength);
        if (this.shouldWrap) {
            buff = this.sasl.unwrap(buff, 0, buff.length);
            LOGGER.debug("data length after unwrap: {}", (Object)buff.length);
        }
        this.readBuffer.reset(buff);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (!this.isOpen()) {
            throw new TTransportException("SASL authentication not complete");
        }
        this.writeBuffer.write(buf, off, len);
    }

    @Override
    public void flush() {
        byte[] buf = this.writeBuffer.get();
        int dataLength = this.writeBuffer.len();
        this.writeBuffer.reset();
        if (this.shouldWrap) {
            LOGGER.debug("data length before wrap: {}", (Object)dataLength);
            try {
                buf = this.sasl.wrap(buf, 0, dataLength);
            }
            catch (SaslException e2) {
                throw new TTransportException(e2);
            }
            dataLength = buf.length;
        }
        LOGGER.debug("writing data length: {}", (Object)dataLength);
        this.writeLength(dataLength);
        this.underlyingTransport.write(buf, 0, dataLength);
        this.underlyingTransport.flush();
    }
}

