/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSaslServerTransport$TSaslServerDefinition;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class TSaslServerTransport$Factory
extends TTransportFactory {
    private static Map<TTransport, WeakReference<TSaslServerTransport>> transportMap = Collections.synchronizedMap(new WeakHashMap());
    private Map<String, TSaslServerTransport$TSaslServerDefinition> serverDefinitionMap = new HashMap<String, TSaslServerTransport$TSaslServerDefinition>();

    public TSaslServerTransport$Factory() {
    }

    public TSaslServerTransport$Factory(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
        this.addServerDefinition(mechanism, protocol, serverName, props, cbh);
    }

    public void addServerDefinition(String mechanism, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh) {
        this.serverDefinitionMap.put(mechanism, new TSaslServerTransport$TSaslServerDefinition(mechanism, protocol, serverName, props, cbh));
    }

    @Override
    public TTransport getTransport(TTransport base) {
        WeakReference<TSaslServerTransport> ret = transportMap.get(base);
        if (ret == null || ret.get() == null) {
            TSaslServerTransport.access$000().debug("transport map does not contain key", (Object)base);
            ret = new WeakReference<TSaslServerTransport>(new TSaslServerTransport(this.serverDefinitionMap, base));
            try {
                ((TSaslServerTransport)ret.get()).open();
            }
            catch (TTransportException e2) {
                TSaslServerTransport.access$000().debug("failed to open server transport", e2);
                throw new RuntimeException(e2);
            }
            transportMap.put(base, ret);
        } else {
            TSaslServerTransport.access$000().debug("transport map does contain key {}", (Object)base);
        }
        return (TTransport)ret.get();
    }
}

