/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class TSSLTransportFactory$TSSLTransportParameters {
    protected String protocol = "TLS";
    protected String keyStore;
    protected String keyPass;
    protected String keyManagerType = KeyManagerFactory.getDefaultAlgorithm();
    protected String keyStoreType = "JKS";
    protected String trustStore;
    protected String trustPass;
    protected String trustManagerType = TrustManagerFactory.getDefaultAlgorithm();
    protected String trustStoreType = "JKS";
    protected String[] cipherSuites;
    protected boolean clientAuth = false;
    protected boolean isKeyStoreSet = false;
    protected boolean isTrustStoreSet = false;

    public TSSLTransportFactory$TSSLTransportParameters() {
    }

    public TSSLTransportFactory$TSSLTransportParameters(String protocol, String[] cipherSuites) {
        this(protocol, cipherSuites, false);
    }

    public TSSLTransportFactory$TSSLTransportParameters(String protocol, String[] cipherSuites, boolean clientAuth) {
        if (protocol != null) {
            this.protocol = protocol;
        }
        this.cipherSuites = cipherSuites != null ? Arrays.copyOf(cipherSuites, cipherSuites.length) : null;
        this.clientAuth = clientAuth;
    }

    public void setKeyStore(String keyStore, String keyPass, String keyManagerType, String keyStoreType) {
        this.keyStore = keyStore;
        this.keyPass = keyPass;
        if (keyManagerType != null) {
            this.keyManagerType = keyManagerType;
        }
        if (keyStoreType != null) {
            this.keyStoreType = keyStoreType;
        }
        this.isKeyStoreSet = true;
    }

    public void setKeyStore(String keyStore, String keyPass) {
        this.setKeyStore(keyStore, keyPass, null, null);
    }

    public void setTrustStore(String trustStore, String trustPass, String trustManagerType, String trustStoreType) {
        this.trustStore = trustStore;
        this.trustPass = trustPass;
        if (trustManagerType != null) {
            this.trustManagerType = trustManagerType;
        }
        if (trustStoreType != null) {
            this.trustStoreType = trustStoreType;
        }
        this.isTrustStoreSet = true;
    }

    public void setTrustStore(String trustStore, String trustPass) {
        this.setTrustStore(trustStore, trustPass, null, null);
    }

    public void requireClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }
}

