/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TIOStreamTransport
extends TTransport {
    private static final YA LOGGER = YB.a(TIOStreamTransport.class.getName());
    protected InputStream inputStream_ = null;
    protected OutputStream outputStream_ = null;

    protected TIOStreamTransport() {
    }

    public TIOStreamTransport(InputStream is2) {
        this.inputStream_ = is2;
    }

    public TIOStreamTransport(OutputStream os2) {
        this.outputStream_ = os2;
    }

    public TIOStreamTransport(InputStream is2, OutputStream os2) {
        this.inputStream_ = is2;
        this.outputStream_ = os2;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        if (this.inputStream_ != null) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iox) {
                LOGGER.warn("Error closing input stream.", iox);
            }
            this.inputStream_ = null;
        }
        if (this.outputStream_ != null) {
            try {
                this.outputStream_.close();
            }
            catch (IOException iox) {
                LOGGER.warn("Error closing output stream.", iox);
            }
            this.outputStream_ = null;
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) {
        int bytesRead;
        if (this.inputStream_ == null) {
            throw new TTransportException(1, "Cannot read from null inputStream");
        }
        try {
            bytesRead = this.inputStream_.read(buf, off, len);
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
        if (bytesRead < 0) {
            throw new TTransportException(4);
        }
        return bytesRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (this.outputStream_ == null) {
            throw new TTransportException(1, "Cannot write to null outputStream");
        }
        try {
            this.outputStream_.write(buf, off, len);
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
    }

    @Override
    public void flush() {
        if (this.outputStream_ == null) {
            throw new TTransportException(1, "Cannot flush null outputStream");
        }
        try {
            this.outputStream_.flush();
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
    }
}

