/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.thrift.transport.TFileTransport$ChunkState;
import org.apache.thrift.transport.TFileTransport$Event;
import org.apache.thrift.transport.TFileTransport$TailPolicy;
import org.apache.thrift.transport.TFileTransport$TruncableBufferedInputStream;
import org.apache.thrift.transport.TSeekableFile;
import org.apache.thrift.transport.TStandardFile;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TFileTransport
extends TTransport {
    TFileTransport$TailPolicy currentPolicy_ = TFileTransport$TailPolicy.NOWAIT;
    protected TSeekableFile inputFile_ = null;
    protected OutputStream outputStream_ = null;
    TFileTransport$Event currentEvent_ = null;
    InputStream inputStream_ = null;
    TFileTransport$ChunkState cs = null;
    private boolean readOnly_ = false;

    public TFileTransport$TailPolicy getTailPolicy() {
        return this.currentPolicy_;
    }

    public TFileTransport$TailPolicy setTailPolicy(TFileTransport$TailPolicy policy) {
        TFileTransport$TailPolicy old = this.currentPolicy_;
        this.currentPolicy_ = policy;
        return old;
    }

    private InputStream createInputStream() {
        InputStream is2;
        try {
            if (this.inputStream_ != null) {
                ((TFileTransport$TruncableBufferedInputStream)this.inputStream_).trunc();
                is2 = this.inputStream_;
            } else {
                is2 = new TFileTransport$TruncableBufferedInputStream(this.inputFile_.getInputStream());
            }
        }
        catch (IOException iox) {
            System.err.println("createInputStream: " + iox.getMessage());
            throw new TTransportException(iox.getMessage(), (Throwable)iox);
        }
        return is2;
    }

    private int tailRead(InputStream is2, byte[] buf, int off, int len, TFileTransport$TailPolicy tp2) {
        int orig_len = len;
        try {
            int retries = 0;
            while (len > 0) {
                int cnt = is2.read(buf, off, len);
                if (cnt > 0) {
                    off += cnt;
                    len -= cnt;
                    retries = 0;
                    this.cs.skip(cnt);
                    continue;
                }
                if (cnt == -1) {
                    if (tp2.retries_ != -1 && tp2.retries_ < ++retries) {
                        return orig_len - len;
                    }
                    if (tp2.timeout_ <= 0) continue;
                    try {
                        Thread.sleep(tp2.timeout_);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new TTransportException("Unexpected return from InputStream.read = " + cnt);
            }
        }
        catch (IOException iox) {
            throw new TTransportException(iox.getMessage(), (Throwable)iox);
        }
        return orig_len - len;
    }

    private boolean performRecovery() {
        int numChunks = this.getNumChunks();
        int curChunk = this.cs.getChunkNum();
        if (curChunk >= numChunks - 1) {
            return false;
        }
        this.seekToChunk(curChunk + 1);
        return true;
    }

    private boolean readEvent() {
        byte[] buf;
        int nread;
        int esize;
        byte[] ebytes = new byte[4];
        do {
            int nrequested;
            if ((nrequested = this.cs.getRemaining()) < 4 && (nread = this.tailRead(this.inputStream_, ebytes, 0, nrequested, this.currentPolicy_)) != nrequested) {
                return false;
            }
            nread = this.tailRead(this.inputStream_, ebytes, 0, 4, this.currentPolicy_);
            if (nread != 4) {
                return false;
            }
            esize = 0;
            for (int i2 = 3; i2 >= 0; --i2) {
                int val = 0xFF & ebytes[i2];
                esize |= val << i2 * 8;
            }
            if (esize <= this.cs.getRemaining()) continue;
            throw new TTransportException("FileTransport error: bad event size");
        } while (esize == 0);
        if (this.currentEvent_.getSize() < esize) {
            this.currentEvent_ = new TFileTransport$Event(new byte[esize]);
        }
        if ((nread = this.tailRead(this.inputStream_, buf = this.currentEvent_.getBuf(), 0, esize, this.currentPolicy_)) != esize) {
            return false;
        }
        this.currentEvent_.setAvailable(esize);
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.inputStream_ != null && (this.readOnly_ || this.outputStream_ != null);
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            throw new TTransportException(2);
        }
        try {
            this.inputStream_ = this.createInputStream();
            this.cs = new TFileTransport$ChunkState();
            this.currentEvent_ = new TFileTransport$Event(new byte[256]);
            if (!this.readOnly_) {
                this.outputStream_ = new BufferedOutputStream(this.inputFile_.getOutputStream(), 8192);
            }
        }
        catch (IOException iox) {
            throw new TTransportException(1, (Throwable)iox);
        }
    }

    @Override
    public void close() {
        if (this.inputFile_ != null) {
            try {
                this.inputFile_.close();
            }
            catch (IOException iox) {
                System.err.println("WARNING: Error closing input file: " + iox.getMessage());
            }
            this.inputFile_ = null;
        }
        if (this.outputStream_ != null) {
            try {
                this.outputStream_.close();
            }
            catch (IOException iox) {
                System.err.println("WARNING: Error closing output stream: " + iox.getMessage());
            }
            this.outputStream_ = null;
        }
    }

    public TFileTransport(String path, boolean readOnly) {
        this.inputFile_ = new TStandardFile(path);
        this.readOnly_ = readOnly;
    }

    public TFileTransport(TSeekableFile inputFile, boolean readOnly) {
        this.inputFile_ = inputFile;
        this.readOnly_ = readOnly;
    }

    @Override
    public int readAll(byte[] buf, int off, int len) {
        int got;
        int ret = 0;
        for (got = 0; got < len; got += ret) {
            ret = this.read(buf, off + got, len - got);
            if (ret < 0) {
                throw new TTransportException("Error in reading from file");
            }
            if (ret != 0) continue;
            throw new TTransportException(4, "End of File reached");
        }
        return got;
    }

    @Override
    public int read(byte[] buf, int off, int len) {
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before reading");
        }
        if (this.currentEvent_.getRemaining() == 0 && !this.readEvent()) {
            return 0;
        }
        int nread = this.currentEvent_.emit(buf, off, len);
        return nread;
    }

    public int getNumChunks() {
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before getNumChunks");
        }
        try {
            long len = this.inputFile_.length();
            if (len == 0L) {
                return 0;
            }
            return (int)(len / (long)this.cs.getChunkSize()) + 1;
        }
        catch (IOException iox) {
            throw new TTransportException(iox.getMessage(), (Throwable)iox);
        }
    }

    public int getCurChunk() {
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before getCurChunk");
        }
        return this.cs.getChunkNum();
    }

    public void seekToChunk(int chunk) {
        boolean seekToEnd;
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before seeking");
        }
        int numChunks = this.getNumChunks();
        if (numChunks == 0) {
            return;
        }
        if (chunk < 0) {
            chunk += numChunks;
        }
        if (chunk < 0) {
            chunk = 0;
        }
        long eofOffset = 0L;
        boolean bl2 = seekToEnd = chunk >= numChunks;
        if (seekToEnd) {
            --chunk;
            try {
                eofOffset = this.inputFile_.length();
            }
            catch (IOException iox) {
                throw new TTransportException(iox.getMessage(), (Throwable)iox);
            }
        }
        if ((long)(chunk * this.cs.getChunkSize()) != this.cs.getOffset()) {
            try {
                this.inputFile_.seek((long)chunk * (long)this.cs.getChunkSize());
            }
            catch (IOException iox) {
                System.err.println("createInputStream: " + iox.getMessage());
                throw new TTransportException("Seek to chunk " + chunk + " " + iox.getMessage(), (Throwable)iox);
            }
            this.cs.seek((long)chunk * (long)this.cs.getChunkSize());
            this.currentEvent_.setAvailable(0);
            this.inputStream_ = this.createInputStream();
        }
        if (seekToEnd) {
            TFileTransport$TailPolicy old = this.setTailPolicy(TFileTransport$TailPolicy.WAIT_FOREVER);
            while (this.cs.getOffset() < eofOffset) {
                this.readEvent();
            }
            this.currentEvent_.setAvailable(0);
            this.setTailPolicy(old);
        }
    }

    public void seekToEnd() {
        if (!this.isOpen()) {
            throw new TTransportException(1, "Must open before seeking");
        }
        this.seekToChunk(this.getNumChunks());
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        throw new TTransportException("Not Supported");
    }

    @Override
    public void flush() {
        throw new TTransportException("Not Supported");
    }

    public static void main(String[] args) {
        int num_chunks = 10;
        if (args.length < 1 || args[0].equals("--help") || args[0].equals("-h") || args[0].equals("-?")) {
            TFileTransport.printUsage();
        }
        if (args.length > 1) {
            try {
                num_chunks = Integer.parseInt(args[1]);
            }
            catch (Exception e2) {
                System.err.println("Cannot parse " + args[1]);
                TFileTransport.printUsage();
            }
        }
        TFileTransport t2 = new TFileTransport(args[0], true);
        t2.open();
        System.out.println("NumChunks=" + t2.getNumChunks());
        Random r2 = new Random();
        for (int j2 = 0; j2 < num_chunks; ++j2) {
            byte[] buf = new byte[4096];
            int cnum = r2.nextInt(t2.getNumChunks() - 1);
            System.out.println("Reading chunk " + cnum);
            t2.seekToChunk(cnum);
            for (int i2 = 0; i2 < 4096; ++i2) {
                t2.read(buf, 0, 4096);
            }
        }
    }

    private static void printUsage() {
        System.err.println("Usage: TFileTransport <filename> [num_chunks]");
        System.err.println("       (Opens and reads num_chunks chunks from file randomly)");
        System.exit(1);
    }
}

