/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.AbstractNonblockingServer$FrameBuffer;
import org.apache.thrift.server.Invocation;
import org.apache.thrift.server.TThreadedSelectorServer$AcceptThread;
import org.apache.thrift.server.TThreadedSelectorServer$Args;
import org.apache.thrift.server.TThreadedSelectorServer$SelectorThread;
import org.apache.thrift.server.TThreadedSelectorServer$SelectorThreadLoadBalancer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingTransport;

public class TThreadedSelectorServer
extends AbstractNonblockingServer {
    private static final YA LOGGER = YB.a(TThreadedSelectorServer.class.getName());
    private TThreadedSelectorServer$AcceptThread acceptThread;
    private final Set<TThreadedSelectorServer$SelectorThread> selectorThreads = new HashSet<TThreadedSelectorServer$SelectorThread>();
    private final ExecutorService invoker;
    private final TThreadedSelectorServer$Args args;

    public TThreadedSelectorServer(TThreadedSelectorServer$Args args) {
        super(args);
        args.validate();
        this.invoker = TThreadedSelectorServer$Args.access$000(args) == null ? TThreadedSelectorServer.createDefaultExecutor(args) : TThreadedSelectorServer$Args.access$000(args);
        this.args = args;
    }

    @Override
    protected boolean startThreads() {
        try {
            for (int i2 = 0; i2 < this.args.selectorThreads; ++i2) {
                this.selectorThreads.add(new TThreadedSelectorServer$SelectorThread(this, TThreadedSelectorServer$Args.access$100(this.args)));
            }
            this.acceptThread = new TThreadedSelectorServer$AcceptThread(this, (TNonblockingServerTransport)this.serverTransport_, this.createSelectorThreadLoadBalancer(this.selectorThreads));
            for (TThreadedSelectorServer$SelectorThread thread : this.selectorThreads) {
                thread.start();
            }
            this.acceptThread.start();
            return true;
        }
        catch (IOException e2) {
            LOGGER.error("Failed to start threads!", e2);
            return false;
        }
    }

    @Override
    protected void waitForShutdown() {
        try {
            this.joinThreads();
        }
        catch (InterruptedException e2) {
            LOGGER.error("Interrupted while joining threads!", e2);
        }
        this.gracefullyShutdownInvokerPool();
    }

    protected void joinThreads() {
        this.acceptThread.join();
        for (TThreadedSelectorServer$SelectorThread thread : this.selectorThreads) {
            thread.join();
        }
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        this.stopListening();
        if (this.acceptThread != null) {
            this.acceptThread.wakeupSelector();
        }
        if (this.selectorThreads != null) {
            for (TThreadedSelectorServer$SelectorThread thread : this.selectorThreads) {
                if (thread == null) continue;
                thread.wakeupSelector();
            }
        }
    }

    protected void gracefullyShutdownInvokerPool() {
        long newnow;
        this.invoker.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = TThreadedSelectorServer$Args.access$300(this.args).toMillis(TThreadedSelectorServer$Args.access$200(this.args)); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.invoker.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix2) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
    }

    @Override
    protected boolean requestInvoke(AbstractNonblockingServer$FrameBuffer frameBuffer) {
        Runnable invocation = this.getRunnable(frameBuffer);
        if (this.invoker != null) {
            try {
                this.invoker.execute(invocation);
                return true;
            }
            catch (RejectedExecutionException rx2) {
                LOGGER.warn("ExecutorService rejected execution!", rx2);
                return false;
            }
        }
        invocation.run();
        return true;
    }

    protected Runnable getRunnable(AbstractNonblockingServer$FrameBuffer frameBuffer) {
        return new Invocation(frameBuffer);
    }

    protected static ExecutorService createDefaultExecutor(TThreadedSelectorServer$Args options) {
        return TThreadedSelectorServer$Args.access$400(options) > 0 ? Executors.newFixedThreadPool(TThreadedSelectorServer$Args.access$400(options)) : null;
    }

    private static BlockingQueue<TNonblockingTransport> createDefaultAcceptQueue(int queueSize) {
        if (queueSize == 0) {
            return new LinkedBlockingQueue<TNonblockingTransport>();
        }
        return new ArrayBlockingQueue<TNonblockingTransport>(queueSize);
    }

    protected TThreadedSelectorServer$SelectorThreadLoadBalancer createSelectorThreadLoadBalancer(Collection<? extends TThreadedSelectorServer$SelectorThread> threads) {
        return new TThreadedSelectorServer$SelectorThreadLoadBalancer(threads);
    }

    static /* synthetic */ YA access$500() {
        return LOGGER;
    }

    static /* synthetic */ TThreadedSelectorServer$Args access$600(TThreadedSelectorServer x0) {
        return x0.args;
    }

    static /* synthetic */ ExecutorService access$800(TThreadedSelectorServer x0) {
        return x0.invoker;
    }

    static /* synthetic */ BlockingQueue access$1000(int x0) {
        return TThreadedSelectorServer.createDefaultAcceptQueue(x0);
    }
}

