/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.thrift.server.AbstractNonblockingServer$AbstractSelectThread;
import org.apache.thrift.server.AbstractNonblockingServer$AsyncFrameBuffer;
import org.apache.thrift.server.AbstractNonblockingServer$FrameBuffer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingTransport;

public class TThreadedSelectorServer$SelectorThread
extends AbstractNonblockingServer$AbstractSelectThread {
    private final BlockingQueue<TNonblockingTransport> acceptedQueue;
    private int SELECTOR_AUTO_REBUILD_THRESHOLD;
    private long MONITOR_PERIOD;
    private int jvmBug;
    final /* synthetic */ TThreadedSelectorServer this$0;

    public TThreadedSelectorServer$SelectorThread(TThreadedSelectorServer this$0) {
        this(this$0, new LinkedBlockingQueue<TNonblockingTransport>());
    }

    public TThreadedSelectorServer$SelectorThread(TThreadedSelectorServer this$0, int maxPendingAccepts) {
        this(this$0, TThreadedSelectorServer.access$1000(maxPendingAccepts));
    }

    public TThreadedSelectorServer$SelectorThread(TThreadedSelectorServer this$0, BlockingQueue<TNonblockingTransport> acceptedQueue) {
        this.this$0 = this$0;
        super(this$0);
        this.SELECTOR_AUTO_REBUILD_THRESHOLD = 512;
        this.MONITOR_PERIOD = 1000L;
        this.jvmBug = 0;
        this.acceptedQueue = acceptedQueue;
    }

    public boolean addAcceptedConnection(TNonblockingTransport accepted) {
        try {
            this.acceptedQueue.put(accepted);
        }
        catch (InterruptedException e2) {
            TThreadedSelectorServer.access$500().warn("Interrupted while adding accepted connection!", e2);
            return false;
        }
        this.selector.wakeup();
        return true;
    }

    @Override
    public void run() {
        try {
            while (!this.this$0.stopped_) {
                this.select();
                this.processAcceptedConnections();
                this.processInterestChanges();
            }
            for (SelectionKey selectionKey : this.selector.keys()) {
                this.cleanupSelectionKey(selectionKey);
            }
        }
        catch (Throwable t2) {
            TThreadedSelectorServer.access$500().error("run() on SelectorThread exiting due to uncaught error", t2);
        }
        finally {
            try {
                this.selector.close();
            }
            catch (IOException e2) {
                TThreadedSelectorServer.access$500().error("Got an IOException while closing selector!", e2);
            }
            this.this$0.stop();
        }
    }

    private void select() {
        try {
            this.doSelect();
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            while (!this.this$0.stopped_ && selectedKeys.hasNext()) {
                SelectionKey key = selectedKeys.next();
                selectedKeys.remove();
                if (!key.isValid()) {
                    this.cleanupSelectionKey(key);
                    continue;
                }
                if (key.isReadable()) {
                    this.handleRead(key);
                    continue;
                }
                if (key.isWritable()) {
                    this.handleWrite(key);
                    continue;
                }
                TThreadedSelectorServer.access$500().warn("Unexpected state in select! " + key.interestOps());
            }
        }
        catch (IOException e2) {
            TThreadedSelectorServer.access$500().warn("Got an IOException while selecting!", e2);
        }
    }

    private void doSelect() {
        long beforeSelect = System.currentTimeMillis();
        int selectedNums = this.selector.select();
        long afterSelect = System.currentTimeMillis();
        this.jvmBug = selectedNums == 0 ? ++this.jvmBug : 0;
        long selectedTime = afterSelect - beforeSelect;
        if (selectedTime >= this.MONITOR_PERIOD) {
            this.jvmBug = 0;
        } else if (this.jvmBug > this.SELECTOR_AUTO_REBUILD_THRESHOLD) {
            TThreadedSelectorServer.access$500().warn("In {} ms happen {} times jvm bug; rebuilding selector.", (Object)this.MONITOR_PERIOD, (Object)this.jvmBug);
            this.rebuildSelector();
            this.selector.selectNow();
            this.jvmBug = 0;
        }
    }

    private synchronized void rebuildSelector() {
        Selector oldSelector = this.selector;
        if (oldSelector == null) {
            return;
        }
        Selector newSelector = null;
        try {
            newSelector = Selector.open();
            TThreadedSelectorServer.access$500().warn("Created new Selector.");
        }
        catch (IOException e2) {
            TThreadedSelectorServer.access$500().error("Create new Selector error.", e2);
        }
        for (SelectionKey key : oldSelector.selectedKeys()) {
            if (!key.isValid() && key.readyOps() == 0) continue;
            SelectableChannel channel = key.channel();
            Object attachment = key.attachment();
            try {
                if (attachment == null) {
                    channel.register(newSelector, key.readyOps());
                    continue;
                }
                channel.register(newSelector, key.readyOps(), attachment);
            }
            catch (ClosedChannelException e3) {
                TThreadedSelectorServer.access$500().error("Register new selector key error.", e3);
            }
        }
        this.selector = newSelector;
        try {
            oldSelector.close();
        }
        catch (IOException e4) {
            TThreadedSelectorServer.access$500().error("Close old selector error.", e4);
        }
        TThreadedSelectorServer.access$500().warn("Replace new selector success.");
    }

    private void processAcceptedConnections() {
        TNonblockingTransport accepted;
        while (!this.this$0.stopped_ && (accepted = (TNonblockingTransport)this.acceptedQueue.poll()) != null) {
            this.registerAccepted(accepted);
        }
    }

    protected AbstractNonblockingServer$FrameBuffer createFrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey, AbstractNonblockingServer$AbstractSelectThread selectThread) {
        return this.this$0.processorFactory_.isAsyncProcessor() ? new AbstractNonblockingServer$AsyncFrameBuffer(this.this$0, trans, selectionKey, selectThread) : new AbstractNonblockingServer$FrameBuffer(this.this$0, trans, selectionKey, selectThread);
    }

    private void registerAccepted(TNonblockingTransport accepted) {
        SelectionKey clientKey = null;
        try {
            clientKey = accepted.registerSelector(this.selector, 1);
            AbstractNonblockingServer$FrameBuffer frameBuffer = this.createFrameBuffer(accepted, clientKey, this);
            clientKey.attach(frameBuffer);
        }
        catch (IOException e2) {
            TThreadedSelectorServer.access$500().warn("Failed to register accepted connection to selector!", e2);
            if (clientKey != null) {
                this.cleanupSelectionKey(clientKey);
            }
            accepted.close();
        }
    }
}

