/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer$Args;
import org.apache.thrift.server.TThreadPoolServer$WorkerProcess;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TThreadPoolServer
extends TServer {
    private static final YA LOGGER = YB.a(TThreadPoolServer.class.getName());
    private ExecutorService executorService_;
    private final TimeUnit stopTimeoutUnit;
    private final long stopTimeoutVal;
    private final TimeUnit requestTimeoutUnit;
    private final long requestTimeout;
    private final long beBackoffSlotInMillis;
    private Random random = new Random(System.currentTimeMillis());

    public TThreadPoolServer(TThreadPoolServer$Args args) {
        super(args);
        this.stopTimeoutUnit = args.stopTimeoutUnit;
        this.stopTimeoutVal = args.stopTimeoutVal;
        this.requestTimeoutUnit = args.requestTimeoutUnit;
        this.requestTimeout = args.requestTimeout;
        this.beBackoffSlotInMillis = args.beBackoffSlotLengthUnit.toMillis(args.beBackoffSlotLength);
        this.executorService_ = args.executorService != null ? args.executorService : TThreadPoolServer.createDefaultExecutorService(args);
    }

    private static ExecutorService createDefaultExecutorService(TThreadPoolServer$Args args) {
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new ThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, args.stopTimeoutVal, args.stopTimeoutUnit, executorQueue);
    }

    @Override
    public void serve() {
        long newnow;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", ttx);
            return;
        }
        if (this.eventHandler_ != null) {
            this.eventHandler_.preServe();
        }
        this.stopped_ = false;
        this.setServing(true);
        int failureCount = 0;
        block10: while (!this.stopped_) {
            try {
                TTransport client = this.serverTransport_.accept();
                TThreadPoolServer$WorkerProcess wp2 = new TThreadPoolServer$WorkerProcess(this, client, null);
                int retryCount = 0;
                long remainTimeInMillis = this.requestTimeoutUnit.toMillis(this.requestTimeout);
                while (true) {
                    try {
                        this.executorService_.execute(wp2);
                        continue block10;
                    }
                    catch (Throwable t2) {
                        if (t2 instanceof RejectedExecutionException) {
                            ++retryCount;
                            try {
                                if (remainTimeInMillis > 0L) {
                                    long sleepTimeInMillis = (long)(this.random.nextDouble() * (double)(1L << Math.min(retryCount, 20))) * this.beBackoffSlotInMillis;
                                    sleepTimeInMillis = Math.min(sleepTimeInMillis, remainTimeInMillis);
                                    TimeUnit.MILLISECONDS.sleep(sleepTimeInMillis);
                                    remainTimeInMillis -= sleepTimeInMillis;
                                    continue;
                                }
                                client.close();
                                wp2 = null;
                                LOGGER.warn("Task has been rejected by ExecutorService " + retryCount + " times till timedout, reason: " + t2);
                            }
                            catch (InterruptedException e2) {
                                LOGGER.warn("Interrupted while waiting to place client on executor queue.");
                                Thread.currentThread().interrupt();
                            }
                            continue block10;
                        }
                        if (t2 instanceof Error) {
                            LOGGER.error("ExecutorService threw error: " + t2, t2);
                            throw (Error)t2;
                        }
                        LOGGER.warn("ExecutorService threw error: " + t2, t2);
                    }
                    break;
                }
            }
            catch (TTransportException ttx) {
                if (this.stopped_) continue;
                ++failureCount;
                LOGGER.warn("Transport error occurred during acceptance of message.", ttx);
            }
        }
        this.executorService_.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = this.stopTimeoutUnit.toMillis(this.stopTimeoutVal); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.executorService_.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix2) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
        this.setServing(false);
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }

    static /* synthetic */ YA access$100() {
        return LOGGER;
    }
}

