/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import org.apache.thrift.server.AbstractNonblockingServer$AbstractSelectThread;
import org.apache.thrift.server.AbstractNonblockingServer$AsyncFrameBuffer;
import org.apache.thrift.server.AbstractNonblockingServer$FrameBuffer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransportException;

public class TNonblockingServer$SelectAcceptThread
extends AbstractNonblockingServer$AbstractSelectThread {
    private final TNonblockingServerTransport serverTransport;
    final /* synthetic */ TNonblockingServer this$0;

    public TNonblockingServer$SelectAcceptThread(TNonblockingServer this$0, TNonblockingServerTransport serverTransport) {
        this.this$0 = this$0;
        super(this$0);
        this.serverTransport = serverTransport;
        serverTransport.registerSelector(this.selector);
    }

    public boolean isStopped() {
        return this.this$0.stopped_;
    }

    @Override
    public void run() {
        try {
            if (this.this$0.eventHandler_ != null) {
                this.this$0.eventHandler_.preServe();
            }
            while (!this.this$0.stopped_) {
                this.select();
                this.processInterestChanges();
            }
            for (SelectionKey selectionKey : this.selector.keys()) {
                this.cleanupSelectionKey(selectionKey);
            }
        }
        catch (Throwable t2) {
            this.this$0.LOGGER.error("run() exiting due to uncaught error", t2);
        }
        finally {
            try {
                this.selector.close();
            }
            catch (IOException e2) {
                this.this$0.LOGGER.error("Got an IOException while closing selector!", e2);
            }
            this.this$0.stopped_ = true;
        }
    }

    private void select() {
        try {
            this.selector.select();
            Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
            while (!this.this$0.stopped_ && selectedKeys.hasNext()) {
                SelectionKey key = selectedKeys.next();
                selectedKeys.remove();
                if (!key.isValid()) {
                    this.cleanupSelectionKey(key);
                    continue;
                }
                if (key.isAcceptable()) {
                    this.handleAccept();
                    continue;
                }
                if (key.isReadable()) {
                    this.handleRead(key);
                    continue;
                }
                if (key.isWritable()) {
                    this.handleWrite(key);
                    continue;
                }
                this.this$0.LOGGER.warn("Unexpected state in select! " + key.interestOps());
            }
        }
        catch (IOException e2) {
            this.this$0.LOGGER.warn("Got an IOException while selecting!", e2);
        }
    }

    protected AbstractNonblockingServer$FrameBuffer createFrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey, AbstractNonblockingServer$AbstractSelectThread selectThread) {
        return this.this$0.processorFactory_.isAsyncProcessor() ? new AbstractNonblockingServer$AsyncFrameBuffer(this.this$0, trans, selectionKey, selectThread) : new AbstractNonblockingServer$FrameBuffer(this.this$0, trans, selectionKey, selectThread);
    }

    private void handleAccept() {
        block3: {
            SelectionKey clientKey = null;
            TNonblockingTransport client = null;
            try {
                client = (TNonblockingTransport)this.serverTransport.accept();
                clientKey = client.registerSelector(this.selector, 1);
                AbstractNonblockingServer$FrameBuffer frameBuffer = this.createFrameBuffer(client, clientKey, this);
                clientKey.attach(frameBuffer);
            }
            catch (TTransportException tte) {
                this.this$0.LOGGER.warn("Exception trying to accept!", tte);
                tte.printStackTrace();
                if (clientKey != null) {
                    this.cleanupSelectionKey(clientKey);
                }
                if (client == null) break block3;
                client.close();
            }
        }
    }
}

