/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.server.AbstractNonblockingServer$FrameBuffer;
import org.apache.thrift.server.Invocation;
import org.apache.thrift.server.THsHaServer$Args;
import org.apache.thrift.server.TNonblockingServer;

public class THsHaServer
extends TNonblockingServer {
    private final ExecutorService invoker;
    private final THsHaServer$Args args;

    public THsHaServer(THsHaServer$Args args) {
        super(args);
        this.invoker = THsHaServer$Args.access$000(args) == null ? THsHaServer.createInvokerPool(args) : THsHaServer$Args.access$000(args);
        this.args = args;
    }

    @Override
    protected void waitForShutdown() {
        this.joinSelector();
        this.gracefullyShutdownInvokerPool();
    }

    protected static ExecutorService createInvokerPool(THsHaServer$Args options) {
        int minWorkerThreads = options.minWorkerThreads;
        int maxWorkerThreads = options.maxWorkerThreads;
        int stopTimeoutVal = THsHaServer$Args.access$100(options);
        TimeUnit stopTimeoutUnit = THsHaServer$Args.access$200(options);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor invoker = new ThreadPoolExecutor(minWorkerThreads, maxWorkerThreads, stopTimeoutVal, stopTimeoutUnit, queue);
        return invoker;
    }

    protected ExecutorService getInvoker() {
        return this.invoker;
    }

    protected void gracefullyShutdownInvokerPool() {
        long newnow;
        this.invoker.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = THsHaServer$Args.access$200(this.args).toMillis(THsHaServer$Args.access$100(this.args)); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.invoker.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix2) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
    }

    @Override
    protected boolean requestInvoke(AbstractNonblockingServer$FrameBuffer frameBuffer) {
        try {
            Runnable invocation = this.getRunnable(frameBuffer);
            this.invoker.execute(invocation);
            return true;
        }
        catch (RejectedExecutionException rx2) {
            this.LOGGER.warn("ExecutorService rejected execution!", rx2);
            return false;
        }
    }

    protected Runnable getRunnable(AbstractNonblockingServer$FrameBuffer frameBuffer) {
        return new Invocation(frameBuffer);
    }
}

