/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.protocol;

import java.util.BitSet;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TTransport;

public final class TTupleProtocol
extends TCompactProtocol {
    public TTupleProtocol(TTransport transport) {
        super(transport);
    }

    @Override
    public Class<? extends IScheme> getScheme() {
        return TupleScheme.class;
    }

    public void writeBitSet(BitSet bs2, int vectorWidth) {
        byte[] bytes;
        for (byte b2 : bytes = TTupleProtocol.toByteArray(bs2, vectorWidth)) {
            this.writeByte(b2);
        }
    }

    public BitSet readBitSet(int i2) {
        int length = (int)Math.ceil((double)i2 / 8.0);
        byte[] bytes = new byte[length];
        for (int j2 = 0; j2 < length; ++j2) {
            bytes[j2] = this.readByte();
        }
        BitSet bs2 = TTupleProtocol.fromByteArray(bytes);
        return bs2;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i2 = 0; i2 < bytes.length * 8; ++i2) {
            if ((bytes[bytes.length - i2 / 8 - 1] & 1 << i2 % 8) <= 0) continue;
            bits.set(i2);
        }
        return bits;
    }

    public static byte[] toByteArray(BitSet bits, int vectorWidth) {
        byte[] bytes = new byte[(int)Math.ceil((double)vectorWidth / 8.0)];
        for (int i2 = 0; i2 < bits.length(); ++i2) {
            if (!bits.get(i2)) continue;
            int n2 = bytes.length - i2 / 8 - 1;
            bytes[n2] = (byte)(bytes[n2] | 1 << i2 % 8);
        }
        return bytes;
    }
}

