/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.protocol;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Stack;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TSimpleJSONProtocol$CollectionMapKeyException;
import org.apache.thrift.protocol.TSimpleJSONProtocol$Context;
import org.apache.thrift.protocol.TSimpleJSONProtocol$ListContext;
import org.apache.thrift.protocol.TSimpleJSONProtocol$MapContext;
import org.apache.thrift.protocol.TSimpleJSONProtocol$StructContext;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TTransport;

public class TSimpleJSONProtocol
extends TProtocol {
    private static final byte[] COMMA = new byte[]{44};
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] LBRACE = new byte[]{123};
    private static final byte[] RBRACE = new byte[]{125};
    private static final byte[] LBRACKET = new byte[]{91};
    private static final byte[] RBRACKET = new byte[]{93};
    private static final char QUOTE = '\"';
    private static final TStruct ANONYMOUS_STRUCT = new TStruct();
    private static final TField ANONYMOUS_FIELD = new TField();
    private static final TMessage EMPTY_MESSAGE = new TMessage();
    private static final TSet EMPTY_SET = new TSet();
    private static final TList EMPTY_LIST = new TList();
    private static final TMap EMPTY_MAP = new TMap();
    private static final String LIST = "list";
    private static final String SET = "set";
    private static final String MAP = "map";
    protected final TSimpleJSONProtocol$Context BASE_CONTEXT = new TSimpleJSONProtocol$Context(this);
    protected Stack<TSimpleJSONProtocol$Context> writeContextStack_ = new Stack();
    protected TSimpleJSONProtocol$Context writeContext_ = this.BASE_CONTEXT;

    protected void pushWriteContext(TSimpleJSONProtocol$Context c2) {
        this.writeContextStack_.push(this.writeContext_);
        this.writeContext_ = c2;
    }

    protected void popWriteContext() {
        this.writeContext_ = this.writeContextStack_.pop();
    }

    protected void resetWriteContext() {
        while (!this.writeContextStack_.isEmpty()) {
            this.popWriteContext();
        }
    }

    protected void assertContextIsNotMapKey(String invalidKeyType) {
        if (this.writeContext_.isMapKey()) {
            throw new TSimpleJSONProtocol$CollectionMapKeyException("Cannot serialize a map with keys that are of type " + invalidKeyType);
        }
    }

    public TSimpleJSONProtocol(TTransport trans) {
        super(trans);
    }

    @Override
    public void writeMessageBegin(TMessage message) {
        this.resetWriteContext();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new TSimpleJSONProtocol$ListContext(this));
        this.writeString(message.name);
        this.writeByte(message.type);
        this.writeI32(message.seqid);
    }

    @Override
    public void writeMessageEnd() {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeStructBegin(TStruct struct) {
        this.writeContext_.write();
        this.trans_.write(LBRACE);
        this.pushWriteContext(new TSimpleJSONProtocol$StructContext(this));
    }

    @Override
    public void writeStructEnd() {
        this.popWriteContext();
        this.trans_.write(RBRACE);
    }

    @Override
    public void writeFieldBegin(TField field) {
        this.writeString(field.name);
    }

    @Override
    public void writeFieldEnd() {
    }

    @Override
    public void writeFieldStop() {
    }

    @Override
    public void writeMapBegin(TMap map) {
        this.assertContextIsNotMapKey(MAP);
        this.writeContext_.write();
        this.trans_.write(LBRACE);
        this.pushWriteContext(new TSimpleJSONProtocol$MapContext(this));
    }

    @Override
    public void writeMapEnd() {
        this.popWriteContext();
        this.trans_.write(RBRACE);
    }

    @Override
    public void writeListBegin(TList list) {
        this.assertContextIsNotMapKey(LIST);
        this.writeContext_.write();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new TSimpleJSONProtocol$ListContext(this));
    }

    @Override
    public void writeListEnd() {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeSetBegin(TSet set) {
        this.assertContextIsNotMapKey(SET);
        this.writeContext_.write();
        this.trans_.write(LBRACKET);
        this.pushWriteContext(new TSimpleJSONProtocol$ListContext(this));
    }

    @Override
    public void writeSetEnd() {
        this.popWriteContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeBool(boolean b2) {
        this.writeByte(b2 ? (byte)1 : 0);
    }

    @Override
    public void writeByte(byte b2) {
        this.writeI32(b2);
    }

    @Override
    public void writeI16(short i16) {
        this.writeI32(i16);
    }

    @Override
    public void writeI32(int i32) {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Integer.toString(i32));
        } else {
            this.writeContext_.write();
            this._writeStringData(Integer.toString(i32));
        }
    }

    public void _writeStringData(String s2) {
        try {
            byte[] b2 = s2.getBytes("UTF-8");
            this.trans_.write(b2);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public void writeI64(long i64) {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Long.toString(i64));
        } else {
            this.writeContext_.write();
            this._writeStringData(Long.toString(i64));
        }
    }

    @Override
    public void writeDouble(double dub) {
        if (this.writeContext_.isMapKey()) {
            this.writeString(Double.toString(dub));
        } else {
            this.writeContext_.write();
            this._writeStringData(Double.toString(dub));
        }
    }

    @Override
    public void writeString(String str) {
        this.writeContext_.write();
        int length = str.length();
        StringBuffer escape = new StringBuffer(length + 16);
        escape.append('\"');
        block8: for (int i2 = 0; i2 < length; ++i2) {
            char c2 = str.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c2);
                    continue block8;
                }
                case '\b': {
                    escape.append('\\');
                    escape.append('b');
                    continue block8;
                }
                case '\f': {
                    escape.append('\\');
                    escape.append('f');
                    continue block8;
                }
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block8;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block8;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block8;
                }
                default: {
                    if (c2 < ' ') {
                        String hex = Integer.toHexString(c2);
                        escape.append('\\');
                        escape.append('u');
                        for (int j2 = 4; j2 > hex.length(); --j2) {
                            escape.append('0');
                        }
                        escape.append(hex);
                        continue block8;
                    }
                    escape.append(c2);
                }
            }
        }
        escape.append('\"');
        this._writeStringData(escape.toString());
    }

    @Override
    public void writeBinary(ByteBuffer bin) {
        try {
            this.writeString(new String(bin.array(), bin.position() + bin.arrayOffset(), bin.limit() - bin.position() - bin.arrayOffset(), "UTF-8"));
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public TMessage readMessageBegin() {
        return EMPTY_MESSAGE;
    }

    @Override
    public void readMessageEnd() {
    }

    @Override
    public TStruct readStructBegin() {
        return ANONYMOUS_STRUCT;
    }

    @Override
    public void readStructEnd() {
    }

    @Override
    public TField readFieldBegin() {
        return ANONYMOUS_FIELD;
    }

    @Override
    public void readFieldEnd() {
    }

    @Override
    public TMap readMapBegin() {
        return EMPTY_MAP;
    }

    @Override
    public void readMapEnd() {
    }

    @Override
    public TList readListBegin() {
        return EMPTY_LIST;
    }

    @Override
    public void readListEnd() {
    }

    @Override
    public TSet readSetBegin() {
        return EMPTY_SET;
    }

    @Override
    public void readSetEnd() {
    }

    @Override
    public boolean readBool() {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() {
        return 0;
    }

    @Override
    public short readI16() {
        return 0;
    }

    @Override
    public int readI32() {
        return 0;
    }

    @Override
    public long readI64() {
        return 0L;
    }

    @Override
    public double readDouble() {
        return 0.0;
    }

    @Override
    public String readString() {
        return "";
    }

    public String readStringBody(int size) {
        return "";
    }

    @Override
    public ByteBuffer readBinary() {
        return ByteBuffer.wrap(new byte[0]);
    }

    static /* synthetic */ byte[] access$000() {
        return COMMA;
    }

    static /* synthetic */ byte[] access$100() {
        return COLON;
    }
}

