/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.protocol;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBase64Utils;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TJSONProtocol$JSONBaseContext;
import org.apache.thrift.protocol.TJSONProtocol$JSONListContext;
import org.apache.thrift.protocol.TJSONProtocol$JSONPairContext;
import org.apache.thrift.protocol.TJSONProtocol$LookaheadReader;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TTransport;

public class TJSONProtocol
extends TProtocol {
    private static final byte[] COMMA = new byte[]{44};
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] LBRACE = new byte[]{123};
    private static final byte[] RBRACE = new byte[]{125};
    private static final byte[] LBRACKET = new byte[]{91};
    private static final byte[] RBRACKET = new byte[]{93};
    private static final byte[] QUOTE = new byte[]{34};
    private static final byte[] BACKSLASH = new byte[]{92};
    private static final byte[] ZERO = new byte[]{48};
    private static final byte[] ESCSEQ = new byte[]{92, 117, 48, 48};
    private static final long VERSION = 1L;
    private static final byte[] JSON_CHAR_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 98, 116, 110, 0, 102, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 34, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final String ESCAPE_CHARS = "\"\\/bfnrt";
    private static final byte[] ESCAPE_CHAR_VALS = new byte[]{34, 92, 47, 8, 12, 10, 13, 9};
    private static final int DEF_STRING_SIZE = 16;
    private static final byte[] NAME_BOOL = new byte[]{116, 102};
    private static final byte[] NAME_BYTE = new byte[]{105, 56};
    private static final byte[] NAME_I16 = new byte[]{105, 49, 54};
    private static final byte[] NAME_I32 = new byte[]{105, 51, 50};
    private static final byte[] NAME_I64 = new byte[]{105, 54, 52};
    private static final byte[] NAME_DOUBLE = new byte[]{100, 98, 108};
    private static final byte[] NAME_STRUCT = new byte[]{114, 101, 99};
    private static final byte[] NAME_STRING = new byte[]{115, 116, 114};
    private static final byte[] NAME_MAP = new byte[]{109, 97, 112};
    private static final byte[] NAME_LIST = new byte[]{108, 115, 116};
    private static final byte[] NAME_SET = new byte[]{115, 101, 116};
    private static final TStruct ANONYMOUS_STRUCT = new TStruct();
    private Stack<TJSONProtocol$JSONBaseContext> contextStack_ = new Stack();
    private TJSONProtocol$JSONBaseContext context_ = new TJSONProtocol$JSONBaseContext(this);
    private TJSONProtocol$LookaheadReader reader_ = new TJSONProtocol$LookaheadReader(this);
    private boolean fieldNamesAsString_ = false;
    private byte[] tmpbuf_ = new byte[4];

    private static final byte[] getTypeNameForTypeID(byte typeID) {
        switch (typeID) {
            case 2: {
                return NAME_BOOL;
            }
            case 3: {
                return NAME_BYTE;
            }
            case 6: {
                return NAME_I16;
            }
            case 8: {
                return NAME_I32;
            }
            case 10: {
                return NAME_I64;
            }
            case 4: {
                return NAME_DOUBLE;
            }
            case 11: {
                return NAME_STRING;
            }
            case 12: {
                return NAME_STRUCT;
            }
            case 13: {
                return NAME_MAP;
            }
            case 14: {
                return NAME_SET;
            }
            case 15: {
                return NAME_LIST;
            }
        }
        throw new TProtocolException(5, "Unrecognized type");
    }

    private static final byte getTypeIDForTypeName(byte[] name) {
        int result = 0;
        if (name.length > 1) {
            switch (name[0]) {
                case 100: {
                    result = 4;
                    break;
                }
                case 105: {
                    switch (name[1]) {
                        case 56: {
                            result = 3;
                            break;
                        }
                        case 49: {
                            result = 6;
                            break;
                        }
                        case 51: {
                            result = 8;
                            break;
                        }
                        case 54: {
                            result = 10;
                        }
                    }
                    break;
                }
                case 108: {
                    result = 15;
                    break;
                }
                case 109: {
                    result = 13;
                    break;
                }
                case 114: {
                    result = 12;
                    break;
                }
                case 115: {
                    if (name[1] == 116) {
                        result = 11;
                        break;
                    }
                    if (name[1] != 101) break;
                    result = 14;
                    break;
                }
                case 116: {
                    result = 2;
                }
            }
        }
        if (result == 0) {
            throw new TProtocolException(5, "Unrecognized type");
        }
        return (byte)result;
    }

    private void pushContext(TJSONProtocol$JSONBaseContext c2) {
        this.contextStack_.push(this.context_);
        this.context_ = c2;
    }

    private void popContext() {
        this.context_ = this.contextStack_.pop();
    }

    private void resetContext() {
        while (!this.contextStack_.isEmpty()) {
            this.popContext();
        }
    }

    public TJSONProtocol(TTransport trans) {
        super(trans);
    }

    public TJSONProtocol(TTransport trans, boolean fieldNamesAsString) {
        super(trans);
        this.fieldNamesAsString_ = fieldNamesAsString;
    }

    @Override
    public void reset() {
        this.contextStack_.clear();
        this.context_ = new TJSONProtocol$JSONBaseContext(this);
        this.reader_ = new TJSONProtocol$LookaheadReader(this);
    }

    protected void readJSONSyntaxChar(byte[] b2) {
        byte ch2 = this.reader_.read();
        if (ch2 != b2[0]) {
            throw new TProtocolException(1, "Unexpected character:" + (char)ch2);
        }
    }

    private static final byte hexVal(byte ch2) {
        if (ch2 >= 48 && ch2 <= 57) {
            return (byte)((char)ch2 - 48);
        }
        if (ch2 >= 97 && ch2 <= 102) {
            return (byte)((char)ch2 - 97 + 10);
        }
        throw new TProtocolException(1, "Expected hex character");
    }

    private static final byte hexChar(byte val) {
        if ((val = (byte)(val & 0xF)) < 10) {
            return (byte)((char)val + 48);
        }
        return (byte)((char)(val - 10) + 97);
    }

    private void writeJSONString(byte[] b2) {
        this.context_.write();
        this.trans_.write(QUOTE);
        int len = b2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if ((b2[i2] & 0xFF) >= 48) {
                if (b2[i2] == BACKSLASH[0]) {
                    this.trans_.write(BACKSLASH);
                    this.trans_.write(BACKSLASH);
                    continue;
                }
                this.trans_.write(b2, i2, 1);
                continue;
            }
            this.tmpbuf_[0] = JSON_CHAR_TABLE[b2[i2]];
            if (this.tmpbuf_[0] == 1) {
                this.trans_.write(b2, i2, 1);
                continue;
            }
            if (this.tmpbuf_[0] > 1) {
                this.trans_.write(BACKSLASH);
                this.trans_.write(this.tmpbuf_, 0, 1);
                continue;
            }
            this.trans_.write(ESCSEQ);
            this.tmpbuf_[0] = TJSONProtocol.hexChar((byte)(b2[i2] >> 4));
            this.tmpbuf_[1] = TJSONProtocol.hexChar(b2[i2]);
            this.trans_.write(this.tmpbuf_, 0, 2);
        }
        this.trans_.write(QUOTE);
    }

    private void writeJSONInteger(long num) {
        this.context_.write();
        String str = Long.toString(num);
        boolean escapeNum = this.context_.escapeNum();
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
        try {
            byte[] buf = str.getBytes("UTF-8");
            this.trans_.write(buf);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
    }

    private void writeJSONDouble(double num) {
        boolean escapeNum;
        this.context_.write();
        String str = Double.toString(num);
        boolean special = false;
        switch (str.charAt(0)) {
            case 'I': 
            case 'N': {
                special = true;
                break;
            }
            case '-': {
                if (str.charAt(1) != 'I') break;
                special = true;
                break;
            }
        }
        boolean bl2 = escapeNum = special || this.context_.escapeNum();
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
        try {
            byte[] b2 = str.getBytes("UTF-8");
            this.trans_.write(b2, 0, b2.length);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        if (escapeNum) {
            this.trans_.write(QUOTE);
        }
    }

    private void writeJSONBase64(byte[] b2, int offset, int length) {
        int len;
        this.context_.write();
        this.trans_.write(QUOTE);
        int off = offset;
        for (len = length; len >= 3; len -= 3) {
            TBase64Utils.encode(b2, off, 3, this.tmpbuf_, 0);
            this.trans_.write(this.tmpbuf_, 0, 4);
            off += 3;
        }
        if (len > 0) {
            TBase64Utils.encode(b2, off, len, this.tmpbuf_, 0);
            this.trans_.write(this.tmpbuf_, 0, len + 1);
        }
        this.trans_.write(QUOTE);
    }

    private void writeJSONObjectStart() {
        this.context_.write();
        this.trans_.write(LBRACE);
        this.pushContext(new TJSONProtocol$JSONPairContext(this));
    }

    private void writeJSONObjectEnd() {
        this.popContext();
        this.trans_.write(RBRACE);
    }

    private void writeJSONArrayStart() {
        this.context_.write();
        this.trans_.write(LBRACKET);
        this.pushContext(new TJSONProtocol$JSONListContext(this));
    }

    private void writeJSONArrayEnd() {
        this.popContext();
        this.trans_.write(RBRACKET);
    }

    @Override
    public void writeMessageBegin(TMessage message) {
        this.resetContext();
        this.writeJSONArrayStart();
        this.writeJSONInteger(1L);
        try {
            byte[] b2 = message.name.getBytes("UTF-8");
            this.writeJSONString(b2);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        this.writeJSONInteger(message.type);
        this.writeJSONInteger(message.seqid);
    }

    @Override
    public void writeMessageEnd() {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeStructBegin(TStruct struct) {
        this.writeJSONObjectStart();
    }

    @Override
    public void writeStructEnd() {
        this.writeJSONObjectEnd();
    }

    @Override
    public void writeFieldBegin(TField field) {
        if (this.fieldNamesAsString_) {
            this.writeString(field.name);
        } else {
            this.writeJSONInteger(field.id);
        }
        this.writeJSONObjectStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(field.type));
    }

    @Override
    public void writeFieldEnd() {
        this.writeJSONObjectEnd();
    }

    @Override
    public void writeFieldStop() {
    }

    @Override
    public void writeMapBegin(TMap map) {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(map.keyType));
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(map.valueType));
        this.writeJSONInteger(map.size);
        this.writeJSONObjectStart();
    }

    @Override
    public void writeMapEnd() {
        this.writeJSONObjectEnd();
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeListBegin(TList list) {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(list.elemType));
        this.writeJSONInteger(list.size);
    }

    @Override
    public void writeListEnd() {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeSetBegin(TSet set) {
        this.writeJSONArrayStart();
        this.writeJSONString(TJSONProtocol.getTypeNameForTypeID(set.elemType));
        this.writeJSONInteger(set.size);
    }

    @Override
    public void writeSetEnd() {
        this.writeJSONArrayEnd();
    }

    @Override
    public void writeBool(boolean b2) {
        this.writeJSONInteger(b2 ? 1L : 0L);
    }

    @Override
    public void writeByte(byte b2) {
        this.writeJSONInteger(b2);
    }

    @Override
    public void writeI16(short i16) {
        this.writeJSONInteger(i16);
    }

    @Override
    public void writeI32(int i32) {
        this.writeJSONInteger(i32);
    }

    @Override
    public void writeI64(long i64) {
        this.writeJSONInteger(i64);
    }

    @Override
    public void writeDouble(double dub) {
        this.writeJSONDouble(dub);
    }

    @Override
    public void writeString(String str) {
        try {
            byte[] b2 = str.getBytes("UTF-8");
            this.writeJSONString(b2);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public void writeBinary(ByteBuffer bin) {
        this.writeJSONBase64(bin.array(), bin.position() + bin.arrayOffset(), bin.limit() - bin.position() - bin.arrayOffset());
    }

    private TByteArrayOutputStream readJSONString(boolean skipContext) {
        byte ch2;
        TByteArrayOutputStream arr = new TByteArrayOutputStream(16);
        ArrayList<Character> codeunits = new ArrayList<Character>();
        if (!skipContext) {
            this.context_.read();
        }
        this.readJSONSyntaxChar(QUOTE);
        while ((ch2 = this.reader_.read()) != QUOTE[0]) {
            if (ch2 == ESCSEQ[0]) {
                ch2 = this.reader_.read();
                if (ch2 == ESCSEQ[1]) {
                    this.trans_.readAll(this.tmpbuf_, 0, 4);
                    short cu2 = (short)(((short)TJSONProtocol.hexVal(this.tmpbuf_[0]) << 12) + ((short)TJSONProtocol.hexVal(this.tmpbuf_[1]) << 8) + ((short)TJSONProtocol.hexVal(this.tmpbuf_[2]) << 4) + (short)TJSONProtocol.hexVal(this.tmpbuf_[3]));
                    try {
                        if (Character.isHighSurrogate((char)cu2)) {
                            if (codeunits.size() > 0) {
                                throw new TProtocolException(1, "Expected low surrogate char");
                            }
                            codeunits.add(Character.valueOf((char)cu2));
                            continue;
                        }
                        if (Character.isLowSurrogate((char)cu2)) {
                            if (codeunits.size() == 0) {
                                throw new TProtocolException(1, "Expected high surrogate char");
                            }
                            codeunits.add(Character.valueOf((char)cu2));
                            arr.write(new String(new int[]{((Character)codeunits.get(0)).charValue(), ((Character)codeunits.get(1)).charValue()}, 0, 2).getBytes("UTF-8"));
                            codeunits.clear();
                            continue;
                        }
                        arr.write(new String(new int[]{cu2}, 0, 1).getBytes("UTF-8"));
                        continue;
                    }
                    catch (UnsupportedEncodingException ex2) {
                        throw new TProtocolException(5, "JVM does not support UTF-8");
                    }
                    catch (IOException ex3) {
                        throw new TProtocolException(1, "Invalid unicode sequence");
                    }
                }
                int off = ESCAPE_CHARS.indexOf(ch2);
                if (off == -1) {
                    throw new TProtocolException(1, "Expected control char");
                }
                ch2 = ESCAPE_CHAR_VALS[off];
            }
            arr.write(ch2);
        }
        return arr;
    }

    private boolean isJSONNumeric(byte b2) {
        switch (b2) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 69: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    private String readJSONNumericChars() {
        byte ch2;
        StringBuilder strbld = new StringBuilder();
        while (this.isJSONNumeric(ch2 = this.reader_.peek())) {
            strbld.append((char)this.reader_.read());
        }
        return strbld.toString();
    }

    private long readJSONInteger() {
        this.context_.read();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        String str = this.readJSONNumericChars();
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException ex2) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    private double readJSONDouble() {
        this.context_.read();
        if (this.reader_.peek() == QUOTE[0]) {
            TByteArrayOutputStream arr = this.readJSONString(true);
            try {
                double dub = Double.valueOf(arr.toString("UTF-8"));
                if (!(this.context_.escapeNum() || Double.isNaN(dub) || Double.isInfinite(dub))) {
                    throw new TProtocolException(1, "Numeric data unexpectedly quoted");
                }
                return dub;
            }
            catch (UnsupportedEncodingException ex2) {
                throw new TException("JVM DOES NOT SUPPORT UTF-8");
            }
        }
        if (this.context_.escapeNum()) {
            this.readJSONSyntaxChar(QUOTE);
        }
        try {
            return Double.valueOf(this.readJSONNumericChars());
        }
        catch (NumberFormatException ex3) {
            throw new TProtocolException(1, "Bad data encounted in numeric data");
        }
    }

    private byte[] readJSONBase64() {
        TByteArrayOutputStream arr = this.readJSONString(false);
        byte[] b2 = arr.get();
        int len = arr.len();
        int off = 0;
        int size = 0;
        int bound = len >= 2 ? len - 2 : 0;
        for (int i2 = len - 1; i2 >= bound && b2[i2] == 61; --i2) {
            --len;
        }
        while (len >= 4) {
            TBase64Utils.decode(b2, off, 4, b2, size);
            off += 4;
            len -= 4;
            size += 3;
        }
        if (len > 1) {
            TBase64Utils.decode(b2, off, len, b2, size);
            size += len - 1;
        }
        byte[] result = new byte[size];
        System.arraycopy(b2, 0, result, 0, size);
        return result;
    }

    private void readJSONObjectStart() {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACE);
        this.pushContext(new TJSONProtocol$JSONPairContext(this));
    }

    private void readJSONObjectEnd() {
        this.readJSONSyntaxChar(RBRACE);
        this.popContext();
    }

    private void readJSONArrayStart() {
        this.context_.read();
        this.readJSONSyntaxChar(LBRACKET);
        this.pushContext(new TJSONProtocol$JSONListContext(this));
    }

    private void readJSONArrayEnd() {
        this.readJSONSyntaxChar(RBRACKET);
        this.popContext();
    }

    @Override
    public TMessage readMessageBegin() {
        String name;
        this.resetContext();
        this.readJSONArrayStart();
        if (this.readJSONInteger() != 1L) {
            throw new TProtocolException(4, "Message contained bad version.");
        }
        try {
            name = this.readJSONString(false).toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex2) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
        byte type = (byte)this.readJSONInteger();
        int seqid = (int)this.readJSONInteger();
        return new TMessage(name, type, seqid);
    }

    @Override
    public void readMessageEnd() {
        this.readJSONArrayEnd();
    }

    @Override
    public TStruct readStructBegin() {
        this.readJSONObjectStart();
        return ANONYMOUS_STRUCT;
    }

    @Override
    public void readStructEnd() {
        this.readJSONObjectEnd();
    }

    @Override
    public TField readFieldBegin() {
        byte type;
        byte ch2 = this.reader_.peek();
        short id2 = 0;
        if (ch2 == RBRACE[0]) {
            type = 0;
        } else {
            id2 = (short)this.readJSONInteger();
            this.readJSONObjectStart();
            type = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        }
        return new TField("", type, id2);
    }

    @Override
    public void readFieldEnd() {
        this.readJSONObjectEnd();
    }

    @Override
    public TMap readMapBegin() {
        this.readJSONArrayStart();
        byte keyType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        byte valueType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        int size = (int)this.readJSONInteger();
        this.readJSONObjectStart();
        return new TMap(keyType, valueType, size);
    }

    @Override
    public void readMapEnd() {
        this.readJSONObjectEnd();
        this.readJSONArrayEnd();
    }

    @Override
    public TList readListBegin() {
        this.readJSONArrayStart();
        byte elemType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        int size = (int)this.readJSONInteger();
        return new TList(elemType, size);
    }

    @Override
    public void readListEnd() {
        this.readJSONArrayEnd();
    }

    @Override
    public TSet readSetBegin() {
        this.readJSONArrayStart();
        byte elemType = TJSONProtocol.getTypeIDForTypeName(this.readJSONString(false).get());
        int size = (int)this.readJSONInteger();
        return new TSet(elemType, size);
    }

    @Override
    public void readSetEnd() {
        this.readJSONArrayEnd();
    }

    @Override
    public boolean readBool() {
        return this.readJSONInteger() != 0L;
    }

    @Override
    public byte readByte() {
        return (byte)this.readJSONInteger();
    }

    @Override
    public short readI16() {
        return (short)this.readJSONInteger();
    }

    @Override
    public int readI32() {
        return (int)this.readJSONInteger();
    }

    @Override
    public long readI64() {
        return this.readJSONInteger();
    }

    @Override
    public double readDouble() {
        return this.readJSONDouble();
    }

    @Override
    public String readString() {
        try {
            return this.readJSONString(false).toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex2) {
            throw new TException("JVM DOES NOT SUPPORT UTF-8");
        }
    }

    @Override
    public ByteBuffer readBinary() {
        return ByteBuffer.wrap(this.readJSONBase64());
    }

    static /* synthetic */ byte[] access$000() {
        return COMMA;
    }

    static /* synthetic */ byte[] access$100() {
        return COLON;
    }
}

