/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.protocol;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.thrift.ShortStack;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TTransport;

public class TCompactProtocol
extends TProtocol {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(EMPTY_BYTES);
    private static final long NO_LENGTH_LIMIT = -1L;
    private static final TStruct ANONYMOUS_STRUCT = new TStruct("");
    private static final TField TSTOP = new TField("", 0, 0);
    private static final byte[] ttypeToCompactType = new byte[16];
    private static final byte PROTOCOL_ID = -126;
    private static final byte VERSION = 1;
    private static final byte VERSION_MASK = 31;
    private static final byte TYPE_MASK = -32;
    private static final byte TYPE_BITS = 7;
    private static final int TYPE_SHIFT_AMOUNT = 5;
    private ShortStack lastField_ = new ShortStack(15);
    private short lastFieldId_ = 0;
    private TField booleanField_ = null;
    private Boolean boolValue_ = null;
    private final long stringLengthLimit_;
    private final long containerLengthLimit_;
    private final byte[] temp = new byte[10];

    public TCompactProtocol(TTransport transport, long stringLengthLimit, long containerLengthLimit) {
        super(transport);
        this.stringLengthLimit_ = stringLengthLimit;
        this.containerLengthLimit_ = containerLengthLimit;
    }

    @Deprecated
    public TCompactProtocol(TTransport transport, long stringLengthLimit) {
        this(transport, stringLengthLimit, -1L);
    }

    public TCompactProtocol(TTransport transport) {
        this(transport, -1L, -1L);
    }

    @Override
    public void reset() {
        this.lastField_.clear();
        this.lastFieldId_ = 0;
    }

    @Override
    public void writeMessageBegin(TMessage message) {
        this.writeByteDirect((byte)-126);
        this.writeByteDirect(1 | message.type << 5 & 0xFFFFFFE0);
        this.writeVarint32(message.seqid);
        this.writeString(message.name);
    }

    @Override
    public void writeStructBegin(TStruct struct) {
        this.lastField_.push(this.lastFieldId_);
        this.lastFieldId_ = 0;
    }

    @Override
    public void writeStructEnd() {
        this.lastFieldId_ = this.lastField_.pop();
    }

    @Override
    public void writeFieldBegin(TField field) {
        if (field.type == 2) {
            this.booleanField_ = field;
        } else {
            this.writeFieldBeginInternal(field, (byte)-1);
        }
    }

    private void writeFieldBeginInternal(TField field, byte typeOverride) {
        byte typeToWrite;
        byte by2 = typeToWrite = typeOverride == -1 ? this.getCompactType(field.type) : typeOverride;
        if (field.id > this.lastFieldId_ && field.id - this.lastFieldId_ <= 15) {
            this.writeByteDirect(field.id - this.lastFieldId_ << 4 | typeToWrite);
        } else {
            this.writeByteDirect(typeToWrite);
            this.writeI16(field.id);
        }
        this.lastFieldId_ = field.id;
    }

    @Override
    public void writeFieldStop() {
        this.writeByteDirect((byte)0);
    }

    @Override
    public void writeMapBegin(TMap map) {
        if (map.size == 0) {
            this.writeByteDirect(0);
        } else {
            this.writeVarint32(map.size);
            this.writeByteDirect(this.getCompactType(map.keyType) << 4 | this.getCompactType(map.valueType));
        }
    }

    @Override
    public void writeListBegin(TList list) {
        this.writeCollectionBegin(list.elemType, list.size);
    }

    @Override
    public void writeSetBegin(TSet set) {
        this.writeCollectionBegin(set.elemType, set.size);
    }

    @Override
    public void writeBool(boolean b2) {
        if (this.booleanField_ != null) {
            this.writeFieldBeginInternal(this.booleanField_, b2 ? (byte)1 : 2);
            this.booleanField_ = null;
        } else {
            this.writeByteDirect(b2 ? (byte)1 : 2);
        }
    }

    @Override
    public void writeByte(byte b2) {
        this.writeByteDirect(b2);
    }

    @Override
    public void writeI16(short i16) {
        this.writeVarint32(this.intToZigZag(i16));
    }

    @Override
    public void writeI32(int i32) {
        this.writeVarint32(this.intToZigZag(i32));
    }

    @Override
    public void writeI64(long i64) {
        this.writeVarint64(this.longToZigzag(i64));
    }

    @Override
    public void writeDouble(double dub) {
        this.fixedLongToBytes(Double.doubleToLongBits(dub), this.temp, 0);
        this.trans_.write(this.temp, 0, 8);
    }

    @Override
    public void writeString(String str) {
        try {
            byte[] bytes = str.getBytes("UTF-8");
            this.writeBinary(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e2) {
            throw new TException("UTF-8 not supported!");
        }
    }

    @Override
    public void writeBinary(ByteBuffer bin) {
        int length = bin.limit() - bin.position();
        this.writeBinary(bin.array(), bin.position() + bin.arrayOffset(), length);
    }

    private void writeBinary(byte[] buf, int offset, int length) {
        this.writeVarint32(length);
        this.trans_.write(buf, offset, length);
    }

    @Override
    public void writeMessageEnd() {
    }

    @Override
    public void writeMapEnd() {
    }

    @Override
    public void writeListEnd() {
    }

    @Override
    public void writeSetEnd() {
    }

    @Override
    public void writeFieldEnd() {
    }

    protected void writeCollectionBegin(byte elemType, int size) {
        if (size <= 14) {
            this.writeByteDirect(size << 4 | this.getCompactType(elemType));
        } else {
            this.writeByteDirect(0xF0 | this.getCompactType(elemType));
            this.writeVarint32(size);
        }
    }

    private void writeVarint32(int n2) {
        int idx = 0;
        while (true) {
            if ((n2 & 0xFFFFFF80) == 0) break;
            this.temp[idx++] = (byte)(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
        this.temp[idx++] = (byte)n2;
        this.trans_.write(this.temp, 0, idx);
    }

    private void writeVarint64(long n2) {
        int idx = 0;
        while (true) {
            if ((n2 & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.temp[idx++] = (byte)(n2 & 0x7FL | 0x80L);
            n2 >>>= 7;
        }
        this.temp[idx++] = (byte)n2;
        this.trans_.write(this.temp, 0, idx);
    }

    private long longToZigzag(long l2) {
        return l2 << 1 ^ l2 >> 63;
    }

    private int intToZigZag(int n2) {
        return n2 << 1 ^ n2 >> 31;
    }

    private void fixedLongToBytes(long n2, byte[] buf, int off) {
        buf[off + 0] = (byte)(n2 & 0xFFL);
        buf[off + 1] = (byte)(n2 >> 8 & 0xFFL);
        buf[off + 2] = (byte)(n2 >> 16 & 0xFFL);
        buf[off + 3] = (byte)(n2 >> 24 & 0xFFL);
        buf[off + 4] = (byte)(n2 >> 32 & 0xFFL);
        buf[off + 5] = (byte)(n2 >> 40 & 0xFFL);
        buf[off + 6] = (byte)(n2 >> 48 & 0xFFL);
        buf[off + 7] = (byte)(n2 >> 56 & 0xFFL);
    }

    private void writeByteDirect(byte b2) {
        this.temp[0] = b2;
        this.trans_.write(this.temp, 0, 1);
    }

    private void writeByteDirect(int n2) {
        this.writeByteDirect((byte)n2);
    }

    @Override
    public TMessage readMessageBegin() {
        byte protocolId = this.readByte();
        if (protocolId != -126) {
            throw new TProtocolException("Expected protocol id " + Integer.toHexString(-126) + " but got " + Integer.toHexString(protocolId));
        }
        byte versionAndType = this.readByte();
        byte version = (byte)(versionAndType & 0x1F);
        if (version != 1) {
            throw new TProtocolException("Expected version 1 but got " + version);
        }
        byte type = (byte)(versionAndType >> 5 & 7);
        int seqid = this.readVarint32();
        String messageName = this.readString();
        return new TMessage(messageName, type, seqid);
    }

    @Override
    public TStruct readStructBegin() {
        this.lastField_.push(this.lastFieldId_);
        this.lastFieldId_ = 0;
        return ANONYMOUS_STRUCT;
    }

    @Override
    public void readStructEnd() {
        this.lastFieldId_ = this.lastField_.pop();
    }

    @Override
    public TField readFieldBegin() {
        byte type = this.readByte();
        if (type == 0) {
            return TSTOP;
        }
        short modifier = (short)((type & 0xF0) >> 4);
        short fieldId = modifier == 0 ? this.readI16() : (short)(this.lastFieldId_ + modifier);
        TField field = new TField("", this.getTType((byte)(type & 0xF)), fieldId);
        if (this.isBoolType(type)) {
            this.boolValue_ = (byte)(type & 0xF) == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        this.lastFieldId_ = field.id;
        return field;
    }

    @Override
    public TMap readMapBegin() {
        int size = this.readVarint32();
        this.checkContainerReadLength(size);
        byte keyAndValueType = size == 0 ? (byte)0 : this.readByte();
        return new TMap(this.getTType((byte)(keyAndValueType >> 4)), this.getTType((byte)(keyAndValueType & 0xF)), size);
    }

    @Override
    public TList readListBegin() {
        byte size_and_type = this.readByte();
        int size = size_and_type >> 4 & 0xF;
        if (size == 15) {
            size = this.readVarint32();
        }
        this.checkContainerReadLength(size);
        byte type = this.getTType(size_and_type);
        return new TList(type, size);
    }

    @Override
    public TSet readSetBegin() {
        return new TSet(this.readListBegin());
    }

    @Override
    public boolean readBool() {
        if (this.boolValue_ != null) {
            boolean result = this.boolValue_;
            this.boolValue_ = null;
            return result;
        }
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() {
        byte b2;
        if (this.trans_.getBytesRemainingInBuffer() > 0) {
            b2 = this.trans_.getBuffer()[this.trans_.getBufferPosition()];
            this.trans_.consumeBuffer(1);
        } else {
            this.trans_.readAll(this.temp, 0, 1);
            b2 = this.temp[0];
        }
        return b2;
    }

    @Override
    public short readI16() {
        return (short)this.zigzagToInt(this.readVarint32());
    }

    @Override
    public int readI32() {
        return this.zigzagToInt(this.readVarint32());
    }

    @Override
    public long readI64() {
        return this.zigzagToLong(this.readVarint64());
    }

    @Override
    public double readDouble() {
        this.trans_.readAll(this.temp, 0, 8);
        return Double.longBitsToDouble(this.bytesToLong(this.temp));
    }

    @Override
    public String readString() {
        int length = this.readVarint32();
        this.checkStringReadLength(length);
        if (length == 0) {
            return "";
        }
        try {
            if (this.trans_.getBytesRemainingInBuffer() >= length) {
                String str = new String(this.trans_.getBuffer(), this.trans_.getBufferPosition(), length, "UTF-8");
                this.trans_.consumeBuffer(length);
                return str;
            }
            return new String(this.readBinary(length), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new TException("UTF-8 not supported!");
        }
    }

    @Override
    public ByteBuffer readBinary() {
        int length = this.readVarint32();
        this.checkStringReadLength(length);
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        if (this.trans_.getBytesRemainingInBuffer() >= length) {
            ByteBuffer bb2 = ByteBuffer.wrap(this.trans_.getBuffer(), this.trans_.getBufferPosition(), length);
            this.trans_.consumeBuffer(length);
            return bb2;
        }
        byte[] buf = new byte[length];
        this.trans_.readAll(buf, 0, length);
        return ByteBuffer.wrap(buf);
    }

    private byte[] readBinary(int length) {
        if (length == 0) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        this.trans_.readAll(buf, 0, length);
        return buf;
    }

    private void checkStringReadLength(int length) {
        if (length < 0) {
            throw new TProtocolException(2, "Negative length: " + length);
        }
        if (this.stringLengthLimit_ != -1L && (long)length > this.stringLengthLimit_) {
            throw new TProtocolException(3, "Length exceeded max allowed: " + length);
        }
    }

    private void checkContainerReadLength(int length) {
        if (length < 0) {
            throw new TProtocolException(2, "Negative length: " + length);
        }
        if (this.containerLengthLimit_ != -1L && (long)length > this.containerLengthLimit_) {
            throw new TProtocolException(3, "Length exceeded max allowed: " + length);
        }
    }

    @Override
    public void readMessageEnd() {
    }

    @Override
    public void readFieldEnd() {
    }

    @Override
    public void readMapEnd() {
    }

    @Override
    public void readListEnd() {
    }

    @Override
    public void readSetEnd() {
    }

    private int readVarint32() {
        int result = 0;
        int shift = 0;
        if (this.trans_.getBytesRemainingInBuffer() >= 5) {
            byte[] buf = this.trans_.getBuffer();
            int pos = this.trans_.getBufferPosition();
            int off = 0;
            while (true) {
                byte b2 = buf[pos + off];
                result |= (b2 & 0x7F) << shift;
                if ((b2 & 0x80) != 128) break;
                shift += 7;
                ++off;
            }
            this.trans_.consumeBuffer(off + 1);
        } else {
            while (true) {
                byte b3 = this.readByte();
                result |= (b3 & 0x7F) << shift;
                if ((b3 & 0x80) != 128) break;
                shift += 7;
            }
        }
        return result;
    }

    private long readVarint64() {
        int shift = 0;
        long result = 0L;
        if (this.trans_.getBytesRemainingInBuffer() >= 10) {
            byte[] buf = this.trans_.getBuffer();
            int pos = this.trans_.getBufferPosition();
            int off = 0;
            while (true) {
                byte b2 = buf[pos + off];
                result |= (long)(b2 & 0x7F) << shift;
                if ((b2 & 0x80) != 128) break;
                shift += 7;
                ++off;
            }
            this.trans_.consumeBuffer(off + 1);
        } else {
            while (true) {
                byte b3 = this.readByte();
                result |= (long)(b3 & 0x7F) << shift;
                if ((b3 & 0x80) != 128) break;
                shift += 7;
            }
        }
        return result;
    }

    private int zigzagToInt(int n2) {
        return n2 >>> 1 ^ -(n2 & 1);
    }

    private long zigzagToLong(long n2) {
        return n2 >>> 1 ^ -(n2 & 1L);
    }

    private long bytesToLong(byte[] bytes) {
        return ((long)bytes[7] & 0xFFL) << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[0] & 0xFFL;
    }

    private boolean isBoolType(byte b2) {
        int lowerNibble = b2 & 0xF;
        return lowerNibble == 1 || lowerNibble == 2;
    }

    private byte getTType(byte type) {
        switch ((byte)(type & 0xF)) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 15;
            }
            case 10: {
                return 14;
            }
            case 11: {
                return 13;
            }
            case 12: {
                return 12;
            }
        }
        throw new TProtocolException("don't know what type: " + (byte)(type & 0xF));
    }

    private byte getCompactType(byte ttype) {
        return ttypeToCompactType[ttype];
    }

    static {
        TCompactProtocol.ttypeToCompactType[0] = 0;
        TCompactProtocol.ttypeToCompactType[2] = 1;
        TCompactProtocol.ttypeToCompactType[3] = 3;
        TCompactProtocol.ttypeToCompactType[6] = 4;
        TCompactProtocol.ttypeToCompactType[8] = 5;
        TCompactProtocol.ttypeToCompactType[10] = 6;
        TCompactProtocol.ttypeToCompactType[4] = 7;
        TCompactProtocol.ttypeToCompactType[11] = 8;
        TCompactProtocol.ttypeToCompactType[15] = 9;
        TCompactProtocol.ttypeToCompactType[14] = 10;
        TCompactProtocol.ttypeToCompactType[13] = 11;
        TCompactProtocol.ttypeToCompactType[12] = 12;
    }
}

