/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.async;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import org.apache.thrift.async.TAsyncClient;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.async.TAsyncClientManager$TAsyncMethodCallTimeoutComparator;
import org.apache.thrift.async.TAsyncMethodCall;

class TAsyncClientManager$SelectThread
extends Thread {
    private final Selector selector;
    private volatile boolean running = true;
    private final TreeSet<TAsyncMethodCall> timeoutWatchSet = new TreeSet<TAsyncMethodCall>(new TAsyncClientManager$TAsyncMethodCallTimeoutComparator());
    final /* synthetic */ TAsyncClientManager this$0;

    public TAsyncClientManager$SelectThread(TAsyncClientManager tAsyncClientManager) {
        this.this$0 = tAsyncClientManager;
        this.selector = SelectorProvider.provider().openSelector();
        this.setName("TAsyncClientManager#SelectorThread " + this.getId());
        this.setDaemon(true);
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void finish() {
        this.running = false;
        this.selector.wakeup();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                try {
                    if (this.timeoutWatchSet.size() == 0) {
                        this.selector.select();
                    } else {
                        long nextTimeout = this.timeoutWatchSet.first().getTimeoutTimestamp();
                        long selectTime = nextTimeout - System.currentTimeMillis();
                        if (selectTime > 0L) {
                            this.selector.select(selectTime);
                        } else {
                            this.selector.selectNow();
                        }
                    }
                }
                catch (IOException e2) {
                    TAsyncClientManager.access$100().error("Caught IOException in TAsyncClientManager!", e2);
                }
                this.transitionMethods();
                this.timeoutMethods();
                this.startPendingMethods();
            }
            catch (Exception exception) {
                TAsyncClientManager.access$100().error("Ignoring uncaught exception in SelectThread", exception);
            }
        }
        try {
            this.selector.close();
        }
        catch (IOException ex2) {
            TAsyncClientManager.access$100().warn("Could not close selector. This may result in leaked resources!", ex2);
        }
    }

    private void transitionMethods() {
        try {
            Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
            while (keys.hasNext()) {
                SelectionKey key = keys.next();
                keys.remove();
                if (!key.isValid()) continue;
                TAsyncMethodCall methodCall = (TAsyncMethodCall)key.attachment();
                methodCall.transition(key);
                if (!methodCall.isFinished() && !methodCall.getClient().hasError()) continue;
                this.timeoutWatchSet.remove(methodCall);
            }
        }
        catch (ClosedSelectorException e2) {
            TAsyncClientManager.access$100().error("Caught ClosedSelectorException in TAsyncClientManager!", e2);
        }
    }

    private void timeoutMethods() {
        TAsyncMethodCall methodCall;
        Iterator<TAsyncMethodCall> iterator = this.timeoutWatchSet.iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext() && currentTime >= (methodCall = iterator.next()).getTimeoutTimestamp()) {
            iterator.remove();
            methodCall.onError(new TimeoutException("Operation " + methodCall.getClass() + " timed out after " + (currentTime - methodCall.getStartTime()) + " ms."));
        }
    }

    private void startPendingMethods() {
        TAsyncMethodCall methodCall;
        while ((methodCall = (TAsyncMethodCall)TAsyncClientManager.access$200(this.this$0).poll()) != null) {
            try {
                methodCall.start(this.selector);
                TAsyncClient client = methodCall.getClient();
                if (!client.hasTimeout() || client.hasError()) continue;
                this.timeoutWatchSet.add(methodCall);
            }
            catch (Exception exception) {
                TAsyncClientManager.access$100().warn("Caught exception in TAsyncClientManager!", exception);
                methodCall.onError(exception);
            }
        }
    }
}

