/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion$TUnionStandardSchemeFactory;
import org.apache.thrift.TUnion$TUnionTupleSchemeFactory;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;

public abstract class TUnion<T extends TUnion<T, F>, F extends TFieldIdEnum>
implements TBase<T, F> {
    protected Object value_;
    protected F setField_;
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();

    protected TUnion() {
        this.setField_ = null;
        this.value_ = null;
    }

    protected TUnion(F setField, Object value) {
        this.setFieldValue(setField, value);
    }

    protected TUnion(TUnion<T, F> other) {
        if (!other.getClass().equals(this.getClass())) {
            throw new ClassCastException();
        }
        this.setField_ = other.setField_;
        this.value_ = TUnion.deepCopyObject(other.value_);
    }

    private static Object deepCopyObject(Object o2) {
        if (o2 instanceof TBase) {
            return ((TBase)o2).deepCopy();
        }
        if (o2 instanceof ByteBuffer) {
            return TBaseHelper.copyBinary((ByteBuffer)o2);
        }
        if (o2 instanceof List) {
            return TUnion.deepCopyList((List)o2);
        }
        if (o2 instanceof Set) {
            return TUnion.deepCopySet((Set)o2);
        }
        if (o2 instanceof Map) {
            return TUnion.deepCopyMap((Map)o2);
        }
        return o2;
    }

    private static Map deepCopyMap(Map<Object, Object> map) {
        HashMap<Object, Object> copy = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            copy.put(TUnion.deepCopyObject(entry.getKey()), TUnion.deepCopyObject(entry.getValue()));
        }
        return copy;
    }

    private static Set deepCopySet(Set set) {
        HashSet<Object> copy = new HashSet<Object>();
        for (Object o2 : set) {
            copy.add(TUnion.deepCopyObject(o2));
        }
        return copy;
    }

    private static List deepCopyList(List list) {
        ArrayList<Object> copy = new ArrayList<Object>(list.size());
        for (Object o2 : list) {
            copy.add(TUnion.deepCopyObject(o2));
        }
        return copy;
    }

    public F getSetField() {
        return this.setField_;
    }

    public Object getFieldValue() {
        return this.value_;
    }

    @Override
    public Object getFieldValue(F fieldId) {
        if (fieldId != this.setField_) {
            throw new IllegalArgumentException("Cannot get the value of field " + fieldId + " because union's set field is " + this.setField_);
        }
        return this.getFieldValue();
    }

    @Override
    public Object getFieldValue(int fieldId) {
        return this.getFieldValue(this.enumForId((short)fieldId));
    }

    public boolean isSet() {
        return this.setField_ != null;
    }

    @Override
    public boolean isSet(F fieldId) {
        return this.setField_ == fieldId;
    }

    @Override
    public boolean isSet(int fieldId) {
        return this.isSet(this.enumForId((short)fieldId));
    }

    @Override
    public void read(TProtocol iprot) {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TUnion)this);
    }

    @Override
    public void setFieldValue(F fieldId, Object value) {
        this.checkType(fieldId, value);
        this.setField_ = fieldId;
        this.value_ = value;
    }

    @Override
    public void setFieldValue(int fieldId, Object value) {
        this.setFieldValue(this.enumForId((short)fieldId), value);
    }

    @Override
    public void write(TProtocol oprot) {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TUnion)this);
    }

    protected abstract void checkType(F var1, Object var2);

    protected abstract Object standardSchemeReadValue(TProtocol var1, TField var2);

    protected abstract void standardSchemeWriteValue(TProtocol var1);

    protected abstract Object tupleSchemeReadValue(TProtocol var1, short var2);

    protected abstract void tupleSchemeWriteValue(TProtocol var1);

    protected abstract TStruct getStructDesc();

    protected abstract TField getFieldDesc(F var1);

    protected abstract F enumForId(short var1);

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("<");
        sb2.append(this.getClass().getSimpleName());
        sb2.append(" ");
        if (this.getSetField() != null) {
            Object v2 = this.getFieldValue();
            sb2.append(this.getFieldDesc(this.getSetField()).name);
            sb2.append(":");
            if (v2 instanceof ByteBuffer) {
                TBaseHelper.toString((ByteBuffer)v2, sb2);
            } else {
                sb2.append(v2.toString());
            }
        }
        sb2.append(">");
        return sb2.toString();
    }

    @Override
    public final void clear() {
        this.setField_ = null;
        this.value_ = null;
    }

    static {
        schemes.put(StandardScheme.class, new TUnion$TUnionStandardSchemeFactory(null));
        schemes.put(TupleScheme.class, new TUnion$TUnionTupleSchemeFactory());
    }
}

