/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.thrift.TNonblockingMultiFetchClient$MultiFetch;
import org.apache.thrift.TNonblockingMultiFetchStats;

public class TNonblockingMultiFetchClient {
    private static final YA LOGGER = YB.a(TNonblockingMultiFetchClient.class.getName());
    private int maxRecvBufBytesPerServer;
    private int fetchTimeoutSeconds;
    private ByteBuffer requestBuf;
    private ByteBuffer requestBufDuplication;
    private List<InetSocketAddress> servers;
    private TNonblockingMultiFetchStats stats;
    private ByteBuffer[] recvBuf;

    public TNonblockingMultiFetchClient(int maxRecvBufBytesPerServer, int fetchTimeoutSeconds, ByteBuffer requestBuf, List<InetSocketAddress> servers) {
        this.maxRecvBufBytesPerServer = maxRecvBufBytesPerServer;
        this.fetchTimeoutSeconds = fetchTimeoutSeconds;
        this.requestBuf = requestBuf;
        this.servers = servers;
        this.stats = new TNonblockingMultiFetchStats();
        this.recvBuf = null;
    }

    public synchronized int getMaxRecvBufBytesPerServer() {
        return this.maxRecvBufBytesPerServer;
    }

    public synchronized int getFetchTimeoutSeconds() {
        return this.fetchTimeoutSeconds;
    }

    public synchronized ByteBuffer getRequestBuf() {
        if (this.requestBuf == null) {
            return null;
        }
        if (this.requestBufDuplication == null) {
            this.requestBufDuplication = this.requestBuf.duplicate();
        }
        return this.requestBufDuplication;
    }

    public synchronized List<InetSocketAddress> getServerList() {
        if (this.servers == null) {
            return null;
        }
        return Collections.unmodifiableList(this.servers);
    }

    public synchronized TNonblockingMultiFetchStats getFetchStats() {
        return this.stats;
    }

    public synchronized ByteBuffer[] fetch() {
        this.recvBuf = null;
        this.stats.clear();
        if (this.servers == null || this.servers.size() == 0 || this.requestBuf == null || this.fetchTimeoutSeconds <= 0) {
            return this.recvBuf;
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        TNonblockingMultiFetchClient$MultiFetch multiFetch = new TNonblockingMultiFetchClient$MultiFetch(this);
        FutureTask<Object> task = new FutureTask<Object>(multiFetch, null);
        executor.execute(task);
        try {
            task.get(this.fetchTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie2) {
            task.cancel(true);
            LOGGER.error("interrupted during fetch: " + ie2.toString());
        }
        catch (ExecutionException ee2) {
            task.cancel(true);
            LOGGER.error("exception during fetch: " + ee2.toString());
        }
        catch (TimeoutException te2) {
            task.cancel(true);
            LOGGER.error("timeout for fetch: " + te2.toString());
        }
        executor.shutdownNow();
        multiFetch.close();
        return this.recvBuf;
    }

    static /* synthetic */ List access$100(TNonblockingMultiFetchClient x0) {
        return x0.servers;
    }

    static /* synthetic */ TNonblockingMultiFetchStats access$200(TNonblockingMultiFetchClient x0) {
        return x0.stats;
    }

    static /* synthetic */ ByteBuffer[] access$302(TNonblockingMultiFetchClient x0, ByteBuffer[] x1) {
        x0.recvBuf = x1;
        return x1;
    }

    static /* synthetic */ YA access$400() {
        return LOGGER;
    }

    static /* synthetic */ ByteBuffer access$500(TNonblockingMultiFetchClient x0) {
        return x0.requestBuf;
    }

    static /* synthetic */ ByteBuffer[] access$300(TNonblockingMultiFetchClient x0) {
        return x0.recvBuf;
    }

    static /* synthetic */ int access$600(TNonblockingMultiFetchClient x0) {
        return x0.maxRecvBufBytesPerServer;
    }
}

