/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.thrift.TNonblockingMultiFetchClient;

class TNonblockingMultiFetchClient$MultiFetch
implements Runnable {
    private Selector selector;
    final /* synthetic */ TNonblockingMultiFetchClient this$0;

    private TNonblockingMultiFetchClient$MultiFetch(TNonblockingMultiFetchClient tNonblockingMultiFetchClient) {
        this.this$0 = tNonblockingMultiFetchClient;
    }

    @Override
    public void run() {
        long t1 = System.currentTimeMillis();
        int numTotalServers = TNonblockingMultiFetchClient.access$100(this.this$0).size();
        TNonblockingMultiFetchClient.access$200(this.this$0).setNumTotalServers(numTotalServers);
        TNonblockingMultiFetchClient.access$302(this.this$0, new ByteBuffer[numTotalServers]);
        ByteBuffer[] sendBuf = new ByteBuffer[numTotalServers];
        long[] numBytesRead = new long[numTotalServers];
        int[] frameSize = new int[numTotalServers];
        boolean[] hasReadFrameSize = new boolean[numTotalServers];
        try {
            this.selector = Selector.open();
        }
        catch (IOException e2) {
            TNonblockingMultiFetchClient.access$400().error("selector opens error: " + e2.toString());
            return;
        }
        for (int i2 = 0; i2 < numTotalServers; ++i2) {
            sendBuf[i2] = TNonblockingMultiFetchClient.access$500(this.this$0).duplicate();
            TNonblockingMultiFetchClient.access$300((TNonblockingMultiFetchClient)this.this$0)[i2] = ByteBuffer.allocate(4);
            TNonblockingMultiFetchClient.access$200(this.this$0).incTotalRecvBufBytes(4);
            InetSocketAddress server = (InetSocketAddress)TNonblockingMultiFetchClient.access$100(this.this$0).get(i2);
            SocketChannel s2 = null;
            SelectionKey key = null;
            try {
                s2 = SocketChannel.open();
                s2.configureBlocking(false);
                s2.connect(server);
                key = s2.register(this.selector, s2.validOps());
                key.attach(i2);
                continue;
            }
            catch (Exception e3) {
                TNonblockingMultiFetchClient.access$200(this.this$0).incNumConnectErrorServers();
                String err = String.format("set up socket to server %s error: %s", server.toString(), e3.toString());
                TNonblockingMultiFetchClient.access$400().error(err);
                if (s2 != null) {
                    try {
                        s2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (key == null) continue;
                key.cancel();
            }
        }
        while (TNonblockingMultiFetchClient.access$200(this.this$0).getNumReadCompletedServers() + TNonblockingMultiFetchClient.access$200(this.this$0).getNumConnectErrorServers() < TNonblockingMultiFetchClient.access$200(this.this$0).getNumTotalServers()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                this.selector.select();
            }
            catch (Exception e4) {
                TNonblockingMultiFetchClient.access$400().error("selector selects error: " + e4.toString());
                continue;
            }
            Iterator<SelectionKey> it2 = this.selector.selectedKeys().iterator();
            while (it2.hasNext()) {
                SocketChannel sChannel;
                SelectionKey selKey = it2.next();
                it2.remove();
                int index = (Integer)selKey.attachment();
                if (selKey.isValid() && selKey.isConnectable()) {
                    try {
                        sChannel = (SocketChannel)selKey.channel();
                        sChannel.finishConnect();
                    }
                    catch (Exception e5) {
                        TNonblockingMultiFetchClient.access$200(this.this$0).incNumConnectErrorServers();
                        String err = String.format("socket %d connects to server %s error: %s", index, ((InetSocketAddress)TNonblockingMultiFetchClient.access$100(this.this$0).get(index)).toString(), e5.toString());
                        TNonblockingMultiFetchClient.access$400().error(err);
                    }
                }
                if (selKey.isValid() && selKey.isWritable() && sendBuf[index].hasRemaining()) {
                    try {
                        sChannel = (SocketChannel)selKey.channel();
                        sChannel.write(sendBuf[index]);
                    }
                    catch (Exception e6) {
                        String err = String.format("socket %d writes to server %s error: %s", index, ((InetSocketAddress)TNonblockingMultiFetchClient.access$100(this.this$0).get(index)).toString(), e6.toString());
                        TNonblockingMultiFetchClient.access$400().error(err);
                    }
                }
                if (!selKey.isValid() || !selKey.isReadable()) continue;
                try {
                    sChannel = (SocketChannel)selKey.channel();
                    int bytesRead = sChannel.read(TNonblockingMultiFetchClient.access$300(this.this$0)[index]);
                    if (bytesRead <= 0) continue;
                    int n2 = index;
                    numBytesRead[n2] = numBytesRead[n2] + (long)bytesRead;
                    if (!hasReadFrameSize[index] && TNonblockingMultiFetchClient.access$300(this.this$0)[index].remaining() == 0) {
                        frameSize[index] = TNonblockingMultiFetchClient.access$300(this.this$0)[index].getInt(0);
                        if (frameSize[index] <= 0) {
                            TNonblockingMultiFetchClient.access$200(this.this$0).incNumInvalidFrameSize();
                            String err = String.format("Read an invalid frame size %d from %s. Does the server use TFramedTransport? ", frameSize[index], ((InetSocketAddress)TNonblockingMultiFetchClient.access$100(this.this$0).get(index)).toString());
                            TNonblockingMultiFetchClient.access$400().error(err);
                            sChannel.close();
                            continue;
                        }
                        if (frameSize[index] + 4 > TNonblockingMultiFetchClient.access$200(this.this$0).getMaxResponseBytes()) {
                            TNonblockingMultiFetchClient.access$200(this.this$0).setMaxResponseBytes(frameSize[index] + 4);
                        }
                        if (frameSize[index] + 4 > TNonblockingMultiFetchClient.access$600(this.this$0)) {
                            TNonblockingMultiFetchClient.access$200(this.this$0).incNumOverflowedRecvBuf();
                            String err = String.format("Read frame size %d from %s, total buffer size would exceed limit %d", frameSize[index], ((InetSocketAddress)TNonblockingMultiFetchClient.access$100(this.this$0).get(index)).toString(), TNonblockingMultiFetchClient.access$600(this.this$0));
                            TNonblockingMultiFetchClient.access$400().error(err);
                            sChannel.close();
                            continue;
                        }
                        TNonblockingMultiFetchClient.access$300((TNonblockingMultiFetchClient)this.this$0)[index] = ByteBuffer.allocate(frameSize[index] + 4);
                        TNonblockingMultiFetchClient.access$300(this.this$0)[index].putInt(frameSize[index]);
                        TNonblockingMultiFetchClient.access$200(this.this$0).incTotalRecvBufBytes(frameSize[index]);
                        hasReadFrameSize[index] = true;
                    }
                    if (!hasReadFrameSize[index] || numBytesRead[index] < (long)(frameSize[index] + 4)) continue;
                    sChannel.close();
                    TNonblockingMultiFetchClient.access$200(this.this$0).incNumReadCompletedServers();
                    long t2 = System.currentTimeMillis();
                    TNonblockingMultiFetchClient.access$200(this.this$0).setReadTime(t2 - t1);
                }
                catch (Exception e7) {
                    String err = String.format("socket %d reads from server %s error: %s", index, ((InetSocketAddress)TNonblockingMultiFetchClient.access$100(this.this$0).get(index)).toString(), e7.toString());
                    TNonblockingMultiFetchClient.access$400().error(err);
                }
            }
        }
    }

    public void close() {
        try {
            if (this.selector.isOpen()) {
                for (SelectionKey selKey : this.selector.keys()) {
                    SocketChannel sChannel = (SocketChannel)selKey.channel();
                    sChannel.close();
                }
                this.selector.close();
            }
        }
        catch (IOException e2) {
            TNonblockingMultiFetchClient.access$400().error("free resource error: " + e2.toString());
        }
    }
}

