/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor$StoredMessageProtocol;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;

public class TMultiplexedProcessor
implements TProcessor {
    private final Map<String, TProcessor> SERVICE_PROCESSOR_MAP = new HashMap<String, TProcessor>();
    private TProcessor defaultProcessor;

    public void registerProcessor(String serviceName, TProcessor processor) {
        this.SERVICE_PROCESSOR_MAP.put(serviceName, processor);
    }

    public void registerDefault(TProcessor processor) {
        this.defaultProcessor = processor;
    }

    @Override
    public boolean process(TProtocol iprot, TProtocol oprot) {
        TMessage message = iprot.readMessageBegin();
        if (message.type != 1 && message.type != 4) {
            throw new TException("This should not have happened!?");
        }
        int index = message.name.indexOf(":");
        if (index < 0) {
            if (this.defaultProcessor != null) {
                return this.defaultProcessor.process(new TMultiplexedProcessor$StoredMessageProtocol(iprot, message), oprot);
            }
            throw new TException("Service name not found in message name: " + message.name + ".  Did you forget to use a TMultiplexProtocol in your client?");
        }
        String serviceName = message.name.substring(0, index);
        TProcessor actualProcessor = this.SERVICE_PROCESSOR_MAP.get(serviceName);
        if (actualProcessor == null) {
            throw new TException("Service name not found: " + serviceName + ".  Did you forget to call registerProcessor()?");
        }
        TMessage standardMessage = new TMessage(message.name.substring(serviceName.length() + ":".length()), message.type, message.seqid);
        return actualProcessor.process(new TMultiplexedProcessor$StoredMessageProtocol(iprot, standardMessage), oprot);
    }
}

