/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.protocol.TBinaryProtocol$Factory;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.transport.TMemoryInputTransport;

public class TDeserializer {
    private final TProtocol protocol_;
    private final TMemoryInputTransport trans_ = new TMemoryInputTransport();

    public TDeserializer() {
        this(new TBinaryProtocol$Factory());
    }

    public TDeserializer(TProtocolFactory protocolFactory) {
        this.protocol_ = protocolFactory.getProtocol(this.trans_);
    }

    public void deserialize(TBase base, byte[] bytes) {
        this.deserialize(base, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(TBase base, byte[] bytes, int offset, int length) {
        try {
            this.trans_.reset(bytes, offset, length);
            base.read(this.protocol_);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    public void deserialize(TBase base, String data, String charset) {
        try {
            this.deserialize(base, data.getBytes(charset));
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
        finally {
            this.protocol_.reset();
        }
    }

    public void partialDeserialize(TBase tb2, byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        try {
            if (this.locateField(bytes, fieldIdPathFirst, fieldIdPathRest) != null) {
                tb2.read(this.protocol_);
            }
        }
        catch (Exception e2) {
            throw new TException(e2);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    public Boolean partialDeserializeBool(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        return (Boolean)this.partialDeserializeField((byte)2, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Byte partialDeserializeByte(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        return (Byte)this.partialDeserializeField((byte)3, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Double partialDeserializeDouble(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        return (Double)this.partialDeserializeField((byte)4, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Short partialDeserializeI16(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        return (Short)this.partialDeserializeField((byte)6, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Integer partialDeserializeI32(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        return (Integer)this.partialDeserializeField((byte)8, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Long partialDeserializeI64(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        return (Long)this.partialDeserializeField((byte)10, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public String partialDeserializeString(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        return (String)this.partialDeserializeField((byte)11, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public ByteBuffer partialDeserializeByteArray(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        return (ByteBuffer)this.partialDeserializeField((byte)100, bytes, fieldIdPathFirst, fieldIdPathRest);
    }

    public Short partialDeserializeSetFieldIdInUnion(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        try {
            TField field = this.locateField(bytes, fieldIdPathFirst, fieldIdPathRest);
            if (field != null) {
                this.protocol_.readStructBegin();
                Short s2 = this.protocol_.readFieldBegin().id;
                return s2;
            }
            Short s3 = null;
            return s3;
        }
        catch (Exception e2) {
            throw new TException(e2);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    private Object partialDeserializeField(byte ttype, byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        try {
            TField field = this.locateField(bytes, fieldIdPathFirst, fieldIdPathRest);
            if (field != null) {
                switch (ttype) {
                    case 2: {
                        if (field.type != 2) break;
                        Boolean bl2 = this.protocol_.readBool();
                        return bl2;
                    }
                    case 3: {
                        if (field.type != 3) break;
                        Byte by2 = this.protocol_.readByte();
                        return by2;
                    }
                    case 4: {
                        if (field.type != 4) break;
                        Double d2 = this.protocol_.readDouble();
                        return d2;
                    }
                    case 6: {
                        if (field.type != 6) break;
                        Short s2 = this.protocol_.readI16();
                        return s2;
                    }
                    case 8: {
                        if (field.type != 8) break;
                        Integer n2 = this.protocol_.readI32();
                        return n2;
                    }
                    case 10: {
                        if (field.type != 10) break;
                        Long l2 = this.protocol_.readI64();
                        return l2;
                    }
                    case 11: {
                        if (field.type != 11) break;
                        String string = this.protocol_.readString();
                        return string;
                    }
                    case 100: {
                        if (field.type != 11) break;
                        ByteBuffer byteBuffer = this.protocol_.readBinary();
                        return byteBuffer;
                    }
                }
            }
            Object var6_15 = null;
            return var6_15;
        }
        catch (Exception e2) {
            throw new TException(e2);
        }
        finally {
            this.trans_.clear();
            this.protocol_.reset();
        }
    }

    private TField locateField(byte[] bytes, TFieldIdEnum fieldIdPathFirst, TFieldIdEnum ... fieldIdPathRest) {
        this.trans_.reset(bytes);
        TFieldIdEnum[] fieldIdPath = new TFieldIdEnum[fieldIdPathRest.length + 1];
        fieldIdPath[0] = fieldIdPathFirst;
        for (int i2 = 0; i2 < fieldIdPathRest.length; ++i2) {
            fieldIdPath[i2 + 1] = fieldIdPathRest[i2];
        }
        int curPathIndex = 0;
        TField field = null;
        this.protocol_.readStructBegin();
        while (curPathIndex < fieldIdPath.length) {
            field = this.protocol_.readFieldBegin();
            if (field.type == 0 || field.id > fieldIdPath[curPathIndex].getThriftFieldId()) {
                return null;
            }
            if (field.id != fieldIdPath[curPathIndex].getThriftFieldId()) {
                TProtocolUtil.skip(this.protocol_, field.type);
                this.protocol_.readFieldEnd();
                continue;
            }
            if (++curPathIndex >= fieldIdPath.length) continue;
            this.protocol_.readStructBegin();
        }
        return field;
    }

    public void fromString(TBase base, String data) {
        this.deserialize(base, data.getBytes());
    }
}

