/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.thrift.TBaseHelper$NestedStructureComparator;

public final class TBaseHelper {
    private static final Comparator comparator = new TBaseHelper$NestedStructureComparator();

    private TBaseHelper() {
    }

    public static int compareTo(Object o1, Object o2) {
        if (o1 instanceof Comparable) {
            return TBaseHelper.compareTo((Comparable)o1, (Comparable)o2);
        }
        if (o1 instanceof List) {
            return TBaseHelper.compareTo((List)o1, (List)o2);
        }
        if (o1 instanceof Set) {
            return TBaseHelper.compareTo((Set)o1, (Set)o2);
        }
        if (o1 instanceof Map) {
            return TBaseHelper.compareTo((Map)o1, (Map)o2);
        }
        if (o1 instanceof byte[]) {
            return TBaseHelper.compareTo((byte[])o1, (byte[])o2);
        }
        throw new IllegalArgumentException("Cannot compare objects of type " + o1.getClass());
    }

    public static int compareTo(boolean a2, boolean b2) {
        return Boolean.valueOf(a2).compareTo(b2);
    }

    public static int compareTo(byte a2, byte b2) {
        if (a2 < b2) {
            return -1;
        }
        if (b2 < a2) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(short a2, short b2) {
        if (a2 < b2) {
            return -1;
        }
        if (b2 < a2) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(int a2, int b2) {
        if (a2 < b2) {
            return -1;
        }
        if (b2 < a2) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(long a2, long b2) {
        if (a2 < b2) {
            return -1;
        }
        if (b2 < a2) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(double a2, double b2) {
        if (a2 < b2) {
            return -1;
        }
        if (b2 < a2) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(String a2, String b2) {
        return a2.compareTo(b2);
    }

    public static int compareTo(byte[] a2, byte[] b2) {
        int sizeCompare = TBaseHelper.compareTo(a2.length, b2.length);
        if (sizeCompare != 0) {
            return sizeCompare;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int byteCompare = TBaseHelper.compareTo(a2[i2], b2[i2]);
            if (byteCompare == 0) continue;
            return byteCompare;
        }
        return 0;
    }

    public static int compareTo(Comparable a2, Comparable b2) {
        return a2.compareTo(b2);
    }

    public static int compareTo(List a2, List b2) {
        int lastComparison = TBaseHelper.compareTo(a2.size(), b2.size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        for (int i2 = 0; i2 < a2.size(); ++i2) {
            lastComparison = comparator.compare(a2.get(i2), b2.get(i2));
            if (lastComparison == 0) continue;
            return lastComparison;
        }
        return 0;
    }

    public static int compareTo(Set a2, Set b2) {
        int lastComparison = TBaseHelper.compareTo(a2.size(), b2.size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        TreeSet sortedA = new TreeSet(comparator);
        sortedA.addAll(a2);
        TreeSet sortedB = new TreeSet(comparator);
        sortedB.addAll(b2);
        Iterator iterA = sortedA.iterator();
        Iterator iterB = sortedB.iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            lastComparison = comparator.compare(iterA.next(), iterB.next());
            if (lastComparison == 0) continue;
            return lastComparison;
        }
        return 0;
    }

    public static int compareTo(Map a2, Map b2) {
        int lastComparison = TBaseHelper.compareTo(a2.size(), b2.size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        TreeMap sortedA = new TreeMap(comparator);
        sortedA.putAll(a2);
        Iterator iterA = sortedA.entrySet().iterator();
        TreeMap sortedB = new TreeMap(comparator);
        sortedB.putAll(b2);
        Iterator iterB = sortedB.entrySet().iterator();
        while (iterA.hasNext() && iterB.hasNext()) {
            Map.Entry entryA = iterA.next();
            Map.Entry entryB = iterB.next();
            lastComparison = comparator.compare(entryA.getKey(), entryB.getKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            lastComparison = comparator.compare(entryA.getValue(), entryB.getValue());
            if (lastComparison == 0) continue;
            return lastComparison;
        }
        return 0;
    }

    public static void toString(Collection<ByteBuffer> bbs, StringBuilder sb2) {
        Iterator<ByteBuffer> it2 = bbs.iterator();
        if (it2.hasNext()) {
            sb2.append("[");
            while (true) {
                ByteBuffer bb2 = it2.next();
                TBaseHelper.toString(bb2, sb2);
                if (!it2.hasNext()) {
                    sb2.append("]");
                    return;
                }
                sb2.append(", ");
            }
        }
        sb2.append("[]");
    }

    public static void toString(ByteBuffer bb2, StringBuilder sb2) {
        byte[] buf = bb2.array();
        int arrayOffset = bb2.arrayOffset();
        int offset = arrayOffset + bb2.position();
        int origLimit = arrayOffset + bb2.limit();
        int limit = origLimit - offset > 128 ? offset + 128 : origLimit;
        for (int i2 = offset; i2 < limit; ++i2) {
            if (i2 > offset) {
                sb2.append(" ");
            }
            sb2.append(TBaseHelper.paddedByteString(buf[i2]));
        }
        if (origLimit != limit) {
            sb2.append("...");
        }
    }

    public static String paddedByteString(byte b2) {
        int extended = (b2 | 0x100) & 0x1FF;
        return Integer.toHexString(extended).toUpperCase().substring(1);
    }

    public static byte[] byteBufferToByteArray(ByteBuffer byteBuffer) {
        if (TBaseHelper.wrapsFullArray(byteBuffer)) {
            return byteBuffer.array();
        }
        byte[] target = new byte[byteBuffer.remaining()];
        TBaseHelper.byteBufferToByteArray(byteBuffer, target, 0);
        return target;
    }

    public static boolean wrapsFullArray(ByteBuffer byteBuffer) {
        return byteBuffer.hasArray() && byteBuffer.position() == 0 && byteBuffer.arrayOffset() == 0 && byteBuffer.remaining() == byteBuffer.capacity();
    }

    public static int byteBufferToByteArray(ByteBuffer byteBuffer, byte[] target, int offset) {
        int remaining = byteBuffer.remaining();
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), target, offset, remaining);
        return remaining;
    }

    public static ByteBuffer rightSize(ByteBuffer in2) {
        if (in2 == null) {
            return null;
        }
        if (TBaseHelper.wrapsFullArray(in2)) {
            return in2;
        }
        return ByteBuffer.wrap(TBaseHelper.byteBufferToByteArray(in2));
    }

    public static ByteBuffer copyBinary(ByteBuffer orig) {
        if (orig == null) {
            return null;
        }
        ByteBuffer copy = ByteBuffer.wrap(new byte[orig.remaining()]);
        if (orig.hasArray()) {
            System.arraycopy(orig.array(), orig.arrayOffset() + orig.position(), copy.array(), 0, orig.remaining());
        } else {
            orig.slice().get(copy.array());
        }
        return copy;
    }

    public static byte[] copyBinary(byte[] orig) {
        if (orig == null) {
            return null;
        }
        byte[] copy = new byte[orig.length];
        System.arraycopy(orig, 0, copy, 0, orig.length);
        return copy;
    }

    public static int hashCode(long value) {
        int low = (int)value;
        int high = (int)(value >>> 32);
        return high * 127 + low;
    }

    public static int hashCode(double value) {
        return TBaseHelper.hashCode(Double.doubleToRawLongBits(value));
    }
}

