/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

public class EncodingUtils {
    public static final void encodeBigEndian(int integer, byte[] buf) {
        EncodingUtils.encodeBigEndian(integer, buf, 0);
    }

    public static final void encodeBigEndian(int integer, byte[] buf, int offset) {
        buf[offset] = (byte)(0xFF & integer >> 24);
        buf[offset + 1] = (byte)(0xFF & integer >> 16);
        buf[offset + 2] = (byte)(0xFF & integer >> 8);
        buf[offset + 3] = (byte)(0xFF & integer);
    }

    public static final int decodeBigEndian(byte[] buf) {
        return EncodingUtils.decodeBigEndian(buf, 0);
    }

    public static final int decodeBigEndian(byte[] buf, int offset) {
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    public static final boolean testBit(byte v2, int position) {
        return EncodingUtils.testBit((int)v2, position);
    }

    public static final boolean testBit(short v2, int position) {
        return EncodingUtils.testBit((int)v2, position);
    }

    public static final boolean testBit(int v2, int position) {
        return (v2 & 1 << position) != 0;
    }

    public static final boolean testBit(long v2, int position) {
        return (v2 & 1L << position) != 0L;
    }

    public static final byte clearBit(byte v2, int position) {
        return (byte)EncodingUtils.clearBit((int)v2, position);
    }

    public static final short clearBit(short v2, int position) {
        return (short)EncodingUtils.clearBit((int)v2, position);
    }

    public static final int clearBit(int v2, int position) {
        return v2 & ~(1 << position);
    }

    public static final long clearBit(long v2, int position) {
        return v2 & (1L << position ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static final byte setBit(byte v2, int position, boolean value) {
        return (byte)EncodingUtils.setBit((int)v2, position, value);
    }

    public static final short setBit(short v2, int position, boolean value) {
        return (short)EncodingUtils.setBit((int)v2, position, value);
    }

    public static final int setBit(int v2, int position, boolean value) {
        if (value) {
            return v2 | 1 << position;
        }
        return EncodingUtils.clearBit(v2, position);
    }

    public static final long setBit(long v2, int position, boolean value) {
        if (value) {
            return v2 | 1L << position;
        }
        return EncodingUtils.clearBit(v2, position);
    }
}

