/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.util.Args;

@NotThreadSafe
public class IdentityOutputStream
extends OutputStream {
    private final SessionOutputBuffer out;
    private boolean closed = false;

    public IdentityOutputStream(SessionOutputBuffer out) {
        this.out = Args.notNull(out, "Session output buffer");
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.out.flush();
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void write(byte[] b2, int off, int len) {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.out.write(b2, off, len);
    }

    @Override
    public void write(byte[] b2) {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(int b2) {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.out.write(b2);
    }
}

