/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;
import org.apache.http.impl.conn.IdleConnectionHandler$TimeValues;

@Deprecated
public class IdleConnectionHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<HttpConnection, IdleConnectionHandler$TimeValues> connectionToTimes = new HashMap<HttpConnection, IdleConnectionHandler$TimeValues>();

    public void add(HttpConnection connection, long validDuration, TimeUnit unit) {
        long timeAdded = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding connection at: " + timeAdded);
        }
        this.connectionToTimes.put(connection, new IdleConnectionHandler$TimeValues(timeAdded, validDuration, unit));
    }

    public boolean remove(HttpConnection connection) {
        IdleConnectionHandler$TimeValues times = this.connectionToTimes.remove(connection);
        if (times == null) {
            this.log.warn("Removing a connection that never existed!");
            return true;
        }
        return System.currentTimeMillis() <= IdleConnectionHandler$TimeValues.access$000(times);
    }

    public void removeAll() {
        this.connectionToTimes.clear();
    }

    public void closeIdleConnections(long idleTime) {
        long idleTimeout = System.currentTimeMillis() - idleTime;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking for connections, idle timeout: " + idleTimeout);
        }
        for (Map.Entry<HttpConnection, IdleConnectionHandler$TimeValues> entry : this.connectionToTimes.entrySet()) {
            HttpConnection conn = entry.getKey();
            IdleConnectionHandler$TimeValues times = entry.getValue();
            long connectionTime = IdleConnectionHandler$TimeValues.access$100(times);
            if (connectionTime > idleTimeout) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Closing idle connection, connection time: " + connectionTime);
            }
            try {
                conn.close();
            }
            catch (IOException ex2) {
                this.log.debug("I/O error closing connection", ex2);
            }
        }
    }

    public void closeExpiredConnections() {
        long now = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking for expired connections, now: " + now);
        }
        for (Map.Entry<HttpConnection, IdleConnectionHandler$TimeValues> entry : this.connectionToTimes.entrySet()) {
            HttpConnection conn = entry.getKey();
            IdleConnectionHandler$TimeValues times = entry.getValue();
            if (IdleConnectionHandler$TimeValues.access$000(times) > now) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Closing connection, expired @: " + IdleConnectionHandler$TimeValues.access$000(times));
            }
            try {
                conn.close();
            }
            catch (IOException ex2) {
                this.log.debug("I/O error closing connection", ex2);
            }
        }
    }
}

