/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.apache.http.impl.auth.NTLMEngineImpl$MD4;

public class NTLMEngineImpl$CipherGen {
    protected final String domain;
    protected final String user;
    protected final String password;
    protected final byte[] challenge;
    protected final String target;
    protected final byte[] targetInformation;
    protected byte[] clientChallenge;
    protected byte[] clientChallenge2;
    protected byte[] secondaryKey;
    protected byte[] timestamp;
    protected byte[] lmHash = null;
    protected byte[] lmResponse = null;
    protected byte[] ntlmHash = null;
    protected byte[] ntlmResponse = null;
    protected byte[] ntlmv2Hash = null;
    protected byte[] lmv2Hash = null;
    protected byte[] lmv2Response = null;
    protected byte[] ntlmv2Blob = null;
    protected byte[] ntlmv2Response = null;
    protected byte[] ntlm2SessionResponse = null;
    protected byte[] lm2SessionResponse = null;
    protected byte[] lmUserSessionKey = null;
    protected byte[] ntlmUserSessionKey = null;
    protected byte[] ntlmv2UserSessionKey = null;
    protected byte[] ntlm2SessionResponseUserSessionKey = null;
    protected byte[] lanManagerSessionKey = null;

    public NTLMEngineImpl$CipherGen(String domain, String user, String password, byte[] challenge, String target, byte[] targetInformation, byte[] clientChallenge, byte[] clientChallenge2, byte[] secondaryKey, byte[] timestamp) {
        this.domain = domain;
        this.target = target;
        this.user = user;
        this.password = password;
        this.challenge = challenge;
        this.targetInformation = targetInformation;
        this.clientChallenge = clientChallenge;
        this.clientChallenge2 = clientChallenge2;
        this.secondaryKey = secondaryKey;
        this.timestamp = timestamp;
    }

    public NTLMEngineImpl$CipherGen(String domain, String user, String password, byte[] challenge, String target, byte[] targetInformation) {
        this(domain, user, password, challenge, target, targetInformation, null, null, null, null);
    }

    public byte[] getClientChallenge() {
        if (this.clientChallenge == null) {
            this.clientChallenge = NTLMEngineImpl.access$000();
        }
        return this.clientChallenge;
    }

    public byte[] getClientChallenge2() {
        if (this.clientChallenge2 == null) {
            this.clientChallenge2 = NTLMEngineImpl.access$000();
        }
        return this.clientChallenge2;
    }

    public byte[] getSecondaryKey() {
        if (this.secondaryKey == null) {
            this.secondaryKey = NTLMEngineImpl.access$100();
        }
        return this.secondaryKey;
    }

    public byte[] getLMHash() {
        if (this.lmHash == null) {
            this.lmHash = NTLMEngineImpl.access$200(this.password);
        }
        return this.lmHash;
    }

    public byte[] getLMResponse() {
        if (this.lmResponse == null) {
            this.lmResponse = NTLMEngineImpl.access$300(this.getLMHash(), this.challenge);
        }
        return this.lmResponse;
    }

    public byte[] getNTLMHash() {
        if (this.ntlmHash == null) {
            this.ntlmHash = NTLMEngineImpl.access$400(this.password);
        }
        return this.ntlmHash;
    }

    public byte[] getNTLMResponse() {
        if (this.ntlmResponse == null) {
            this.ntlmResponse = NTLMEngineImpl.access$300(this.getNTLMHash(), this.challenge);
        }
        return this.ntlmResponse;
    }

    public byte[] getLMv2Hash() {
        if (this.lmv2Hash == null) {
            this.lmv2Hash = NTLMEngineImpl.access$500(this.domain, this.user, this.getNTLMHash());
        }
        return this.lmv2Hash;
    }

    public byte[] getNTLMv2Hash() {
        if (this.ntlmv2Hash == null) {
            this.ntlmv2Hash = NTLMEngineImpl.access$600(this.domain, this.user, this.getNTLMHash());
        }
        return this.ntlmv2Hash;
    }

    public byte[] getTimestamp() {
        if (this.timestamp == null) {
            long time = System.currentTimeMillis();
            time += 11644473600000L;
            time *= 10000L;
            this.timestamp = new byte[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                this.timestamp[i2] = (byte)time;
                time >>>= 8;
            }
        }
        return this.timestamp;
    }

    public byte[] getNTLMv2Blob() {
        if (this.ntlmv2Blob == null) {
            this.ntlmv2Blob = NTLMEngineImpl.access$700(this.getClientChallenge2(), this.targetInformation, this.getTimestamp());
        }
        return this.ntlmv2Blob;
    }

    public byte[] getNTLMv2Response() {
        if (this.ntlmv2Response == null) {
            this.ntlmv2Response = NTLMEngineImpl.access$800(this.getNTLMv2Hash(), this.challenge, this.getNTLMv2Blob());
        }
        return this.ntlmv2Response;
    }

    public byte[] getLMv2Response() {
        if (this.lmv2Response == null) {
            this.lmv2Response = NTLMEngineImpl.access$800(this.getLMv2Hash(), this.challenge, this.getClientChallenge());
        }
        return this.lmv2Response;
    }

    public byte[] getNTLM2SessionResponse() {
        if (this.ntlm2SessionResponse == null) {
            this.ntlm2SessionResponse = NTLMEngineImpl.ntlm2SessionResponse(this.getNTLMHash(), this.challenge, this.getClientChallenge());
        }
        return this.ntlm2SessionResponse;
    }

    public byte[] getLM2SessionResponse() {
        if (this.lm2SessionResponse == null) {
            byte[] clntChallenge = this.getClientChallenge();
            this.lm2SessionResponse = new byte[24];
            System.arraycopy(clntChallenge, 0, this.lm2SessionResponse, 0, clntChallenge.length);
            Arrays.fill(this.lm2SessionResponse, clntChallenge.length, this.lm2SessionResponse.length, (byte)0);
        }
        return this.lm2SessionResponse;
    }

    public byte[] getLMUserSessionKey() {
        if (this.lmUserSessionKey == null) {
            this.lmUserSessionKey = new byte[16];
            System.arraycopy(this.getLMHash(), 0, this.lmUserSessionKey, 0, 8);
            Arrays.fill(this.lmUserSessionKey, 8, 16, (byte)0);
        }
        return this.lmUserSessionKey;
    }

    public byte[] getNTLMUserSessionKey() {
        if (this.ntlmUserSessionKey == null) {
            NTLMEngineImpl$MD4 md4 = new NTLMEngineImpl$MD4();
            md4.update(this.getNTLMHash());
            this.ntlmUserSessionKey = md4.getOutput();
        }
        return this.ntlmUserSessionKey;
    }

    public byte[] getNTLMv2UserSessionKey() {
        if (this.ntlmv2UserSessionKey == null) {
            byte[] ntlmv2hash = this.getNTLMv2Hash();
            byte[] truncatedResponse = new byte[16];
            System.arraycopy(this.getNTLMv2Response(), 0, truncatedResponse, 0, 16);
            this.ntlmv2UserSessionKey = NTLMEngineImpl.hmacMD5(truncatedResponse, ntlmv2hash);
        }
        return this.ntlmv2UserSessionKey;
    }

    public byte[] getNTLM2SessionResponseUserSessionKey() {
        if (this.ntlm2SessionResponseUserSessionKey == null) {
            byte[] ntlm2SessionResponseNonce = this.getLM2SessionResponse();
            byte[] sessionNonce = new byte[this.challenge.length + ntlm2SessionResponseNonce.length];
            System.arraycopy(this.challenge, 0, sessionNonce, 0, this.challenge.length);
            System.arraycopy(ntlm2SessionResponseNonce, 0, sessionNonce, this.challenge.length, ntlm2SessionResponseNonce.length);
            this.ntlm2SessionResponseUserSessionKey = NTLMEngineImpl.hmacMD5(sessionNonce, this.getNTLMUserSessionKey());
        }
        return this.ntlm2SessionResponseUserSessionKey;
    }

    public byte[] getLanManagerSessionKey() {
        if (this.lanManagerSessionKey == null) {
            try {
                byte[] keyBytes = new byte[14];
                System.arraycopy(this.getLMHash(), 0, keyBytes, 0, 8);
                Arrays.fill(keyBytes, 8, keyBytes.length, (byte)-67);
                Key lowKey = NTLMEngineImpl.access$900(keyBytes, 0);
                Key highKey = NTLMEngineImpl.access$900(keyBytes, 7);
                byte[] truncatedResponse = new byte[8];
                System.arraycopy(this.getLMResponse(), 0, truncatedResponse, 0, truncatedResponse.length);
                Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
                des.init(1, lowKey);
                byte[] lowPart = des.doFinal(truncatedResponse);
                des = Cipher.getInstance("DES/ECB/NoPadding");
                des.init(1, highKey);
                byte[] highPart = des.doFinal(truncatedResponse);
                this.lanManagerSessionKey = new byte[16];
                System.arraycopy(lowPart, 0, this.lanManagerSessionKey, 0, lowPart.length);
                System.arraycopy(highPart, 0, this.lanManagerSessionKey, lowPart.length, highPart.length);
            }
            catch (Exception e2) {
                throw new NTLMEngineException(e2.getMessage(), e2);
            }
        }
        return this.lanManagerSessionKey;
    }
}

